/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pdb.PdbInfoCodeView;
import ghidra.app.util.bin.format.pdb.PdbInfoDotNet;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.app.util.bin.format.pe.debug.DebugCodeViewSymbolTable;
import ghidra.app.util.bin.format.pe.debug.DebugDirectory;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DebugCodeView
implements StructConverter {
    private DebugDirectory debugDir;
    private DebugCodeViewSymbolTable symbolTable;
    private PdbInfoCodeView pdbInfo;
    private PdbInfoDotNet dotNetPdbInfo;

    static DebugCodeView createDebugCodeView(FactoryBundledWithBinaryReader reader, DebugDirectory debugDir, OffsetValidator validator) throws IOException {
        DebugCodeView debugCodeView = (DebugCodeView)reader.getFactory().create(DebugCodeView.class, new Object[0]);
        debugCodeView.initDebugCodeView(reader, debugDir, validator);
        return debugCodeView;
    }

    private void initDebugCodeView(FactoryBundledWithBinaryReader reader, DebugDirectory debugDir, OffsetValidator validator) throws IOException {
        this.debugDir = debugDir;
        int ptr = debugDir.getPointerToRawData();
        if (!validator.checkPointer(ptr)) {
            Msg.error((Object)this, (Object)("Invalid pointer " + Long.toHexString(ptr)));
            return;
        }
        this.dotNetPdbInfo = PdbInfoDotNet.isMatch(reader, ptr) ? PdbInfoDotNet.read(reader, ptr) : null;
        PdbInfoCodeView pdbInfoCodeView = this.pdbInfo = PdbInfoCodeView.isMatch(reader, ptr) ? PdbInfoCodeView.read(reader, ptr) : null;
        if (DebugCodeViewSymbolTable.isMatch(reader, ptr)) {
            this.symbolTable = DebugCodeViewSymbolTable.createDebugCodeViewSymbolTable(reader, debugDir.getSizeOfData(), debugDir.getPointerToRawData(), ptr);
        }
    }

    public DebugDirectory getDebugDirectory() {
        return this.debugDir;
    }

    public DebugCodeViewSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public PdbInfoCodeView getPdbInfo() {
        return this.pdbInfo;
    }

    public PdbInfoDotNet getDotNetPdbInfo() {
        return this.dotNetPdbInfo;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType es = new StructureDataType("DebugCodeView", 0);
        es.add(WORD, "Signature", null);
        es.add(WORD, "Version", null);
        if (this.symbolTable != null) {
            DataType dt = this.symbolTable.toDataType();
            es.add(dt, "CodeViewSymbolTable", null);
        } else {
            ArrayDataType dt = new ArrayDataType(BYTE, this.debugDir.getSizeOfData() - 4, 1);
            es.add((DataType)dt, "<<unknown>>", null);
        }
        es.setCategoryPath(new CategoryPath("/PE"));
        return es;
    }
}

