/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.C;

import ghidra.app.util.cparser.C.CParserConstants;
import ghidra.app.util.cparser.C.CParserTokenManager;
import ghidra.app.util.cparser.C.CompositeHandler;
import ghidra.app.util.cparser.C.Declaration;
import ghidra.app.util.cparser.C.ParseException;
import ghidra.app.util.cparser.C.SimpleCharStream;
import ghidra.app.util.cparser.C.Token;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.SignedByteDataType;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class CParser
implements CParserConstants {
    private Map<String, DataType> types = new HashMap<String, DataType>();
    private Map<String, DataType> structs = new HashMap<String, DataType>();
    private Map<String, DataType> functions = new HashMap<String, DataType>();
    private Map<String, DataType> enums = new HashMap<String, DataType>();
    private Map<String, DataType> declarations = new HashMap<String, DataType>();
    private Map<String, DataType> internalTypes = new HashMap<String, DataType>();
    private DataType lastDataType = null;
    private boolean storeNewDT = true;
    private String possiblyUndefinedType = null;
    DataTypeManager dtMgr = null;
    private DataTypeManager[] subDTMgrs = new DataTypeManager[0];
    private int cnt = 1;
    private int func_cnt = 1;
    private String headerFileName = null;
    private int headerFileLine = 1;
    private int headerFileLineOffset = 0;
    private String currentCategoryName = "";
    private static final String ANONYMOUS_STRUCT_PREFIX = "_struct_";
    private static final String ANONYMOUS_UNION_PREFIX = "_union_";
    private static final String ANONYMOUS_FUNC_PREFIX = "_func_";
    private Stack<Boolean> typedefParsingStack = new Stack();
    private Stack<DataType> dataTypeStack = new Stack();
    private int packSize = 0;
    Stack<Integer> packStack = new Stack();
    Stack<String> packStackID = new Stack();
    public CParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[153];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private final JJCalls[] jj_2_rtns = new JJCalls[48];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private CategoryPath getCurrentCategoryPath() {
        return this.getCategory(this.currentCategoryName);
    }

    private CategoryPath getCategory(String catName) {
        CategoryPath rootCat = CategoryPath.ROOT;
        if (catName == null || catName.length() == 0) {
            return rootCat;
        }
        CategoryPath cat = new CategoryPath(rootCat, new String[]{catName});
        return cat;
    }

    private String getFileName(String path) {
        int slashpos = path.lastIndexOf(47);
        if (slashpos < 0) {
            slashpos = path.lastIndexOf(92);
        }
        if (slashpos < 0) {
            return path;
        }
        return path.substring(slashpos + 1);
    }

    private boolean isType(String type) {
        return this.getType(type) != null;
    }

    private DataType addTypedef(String type, DataType dt) {
        if (type == null || dt == null) {
            System.err.println("Problem with type " + type + " : " + dt);
            return dt;
        }
        if (type.equals(dt.getName()) && (dt instanceof Composite || dt instanceof Enum)) {
            return dt;
        }
        if (dt instanceof Composite && (dt.getName().startsWith(ANONYMOUS_STRUCT_PREFIX) || dt.getName().startsWith(ANONYMOUS_UNION_PREFIX))) {
            try {
                dt = this.renameDef(this.structs, dt, type);
                this.addDef(this.structs, type, dt);
                return dt;
            }
            catch (InvalidNameException invalidNameException) {
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
        dt = new TypedefDataType(CategoryPath.ROOT, type, dt, this.dtMgr);
        dt = this.addDef(this.types, type, dt);
        return dt;
    }

    private DataType getType(String type) {
        DataType dt;
        DataType obj = this.structs.get(type);
        if (obj instanceof DataType) {
            return obj;
        }
        obj = this.types.get(type);
        if (obj instanceof DataType) {
            return obj;
        }
        obj = this.enums.get(type);
        if (obj instanceof DataType) {
            return obj;
        }
        if (this.typedefParsingStack.size() > 0 && (obj = this.functions.get(type)) instanceof DataType) {
            return obj;
        }
        if (!this.storeNewDT && (dt = this.findDataType(type)) != null) {
            return dt;
        }
        BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();
        DataType dt2 = this.findDataType((DataTypeManager)builtInMgr, type);
        if (dt2 != null) {
            return dt2;
        }
        this.possiblyUndefinedType = type;
        return null;
    }

    private DataType findDataType(String dataTypeString) {
        DataType dt = this.findDataType(this.dtMgr, dataTypeString);
        if (dt != null) {
            return dt;
        }
        for (int i = 0; i < this.subDTMgrs.length; ++i) {
            DataTypeManager dtm = this.subDTMgrs[i];
            dt = this.findDataType(dtm, dataTypeString);
            if (dt == null) continue;
            return dt;
        }
        return null;
    }

    private DataType findDataType(DataTypeManager dtm, String dataTypeString) {
        ArrayList list = new ArrayList();
        dtm.findDataTypes(dataTypeString, list);
        if (list.size() > 0) {
            return (DataType)list.get(0);
        }
        return null;
    }

    private List<DataType> findAllDataTypes(String dataTypeString) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        this.dtMgr.findDataTypes(dataTypeString, list);
        for (int i = 0; i < this.subDTMgrs.length; ++i) {
            DataTypeManager dtm = this.subDTMgrs[i];
            dtm.findDataTypes(dataTypeString, list);
        }
        return list;
    }

    private DataType addDef(Map<String, DataType> table, String name, DataType dt) {
        block2: {
            CategoryPath cat = this.getCurrentCategoryPath();
            try {
                dt.setCategoryPath(cat);
            }
            catch (DuplicateNameException e) {
                DataType existing = this.dtMgr.getDataType(cat, name);
                if (dt.isEquivalent(existing)) break block2;
                e.printStackTrace();
            }
        }
        this.lastDataType = dt = this.resolveDataType(table, name, dt);
        return dt;
    }

    private DataType resolveDataType(Map<String, DataType> table, String name, DataType dt) {
        DataType existingDT = table.get(name);
        if (existingDT != null && existingDT != dt && dt.isEquivalent(existingDT)) {
            return existingDT;
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.subDTMgrs.length; ++i) {
            this.subDTMgrs[i].findDataTypes(name, list);
            for (DataType dataType : list) {
                if (!dataType.isEquivalent(dt)) continue;
                table.put(name, dataType);
                return dataType;
            }
        }
        if (this.storeNewDT) {
            try {
                dt = this.dtMgr.addDataType(dt, DataTypeConflictHandler.REPLACE_HANDLER);
            }
            catch (Exception e) {
                System.err.println("Problem adding DataType " + dt.getDisplayName());
                System.err.println("    " + e.getMessage());
            }
        }
        table.put(name, dt);
        return dt;
    }

    private DataType resolveInternal(DataType datatype) {
        DataType existingDT = this.internalTypes.get(datatype.getName());
        if (existingDT != null) {
            return existingDT;
        }
        existingDT = datatype.copy(this.dtMgr);
        this.internalTypes.put(datatype.getName(), existingDT);
        return existingDT;
    }

    private DataType renameDef(Map<String, DataType> table, DataType dt, String newName) throws InvalidNameException, DuplicateNameException {
        table.remove(dt.getName());
        dt.setName(newName);
        table.put(newName, dt);
        return dt;
    }

    private DataType addDef(String subCategory, Map<String, DataType> table, String name, DataType dt) {
        block2: {
            CategoryPath subCat = this.getCurrentCategoryPath();
            subCat = new CategoryPath(subCat, new String[]{subCategory});
            try {
                dt.setCategoryPath(subCat);
            }
            catch (DuplicateNameException e) {
                DataType existing = this.dtMgr.getDataType(subCat, name);
                if (dt.isEquivalent(existing)) break block2;
                e.printStackTrace();
            }
        }
        this.lastDataType = dt = this.resolveDataType(table, name, dt);
        return dt;
    }

    private DataType getStructDef(String name) {
        DataType dt = this.getDef(this.structs, name);
        if (dt != null) {
            return dt;
        }
        if (!this.storeNewDT) {
            List<DataType> list = this.findAllDataTypes(name);
            for (int i = 0; i < list.size(); ++i) {
                dt = list.get(i);
                if (!(dt instanceof Composite)) continue;
                return dt;
            }
        }
        BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();
        ArrayList list = new ArrayList();
        builtInMgr.findDataTypes(name, list);
        for (int i = 0; i < list.size(); ++i) {
            dt = (DataType)list.get(i);
            if (!(dt instanceof Composite)) continue;
            return dt;
        }
        return null;
    }

    private DataType getEnumDef(String name) {
        DataType dt = this.getDef(this.enums, name);
        if (dt != null) {
            return dt;
        }
        if (!this.storeNewDT) {
            List<DataType> list = this.findAllDataTypes(name);
            for (int i = 0; i < list.size(); ++i) {
                dt = list.get(i);
                if (!(dt instanceof Enum)) continue;
                return dt;
            }
        }
        BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();
        ArrayList list = new ArrayList();
        builtInMgr.findDataTypes(name, list);
        for (int i = 0; i < list.size(); ++i) {
            dt = (DataType)list.get(i);
            if (!(dt instanceof Enum)) continue;
            return dt;
        }
        return null;
    }

    private DataType getDef(Map<String, DataType> table, String name) {
        DataType obj = table.get(name);
        if (!(obj instanceof DataType)) {
            return null;
        }
        return obj;
    }

    private void printTypes() {
        System.out.println("**************   TYPES   ********************");
        this.printTable(this.types);
        System.out.println("**************   FUNCTIONS  *****************");
        this.printTable(this.functions);
        System.out.println("**************   DECLS      *****************");
        this.printTable(this.declarations);
        System.out.println("**************   ENUMS      *****************");
        this.printTable(this.enums);
        System.out.println("**************   STRUCTS    *****************");
        this.printTable(this.structs);
    }

    private FunctionDefinitionDataType newAnonymousFunction(FunctionDefinitionDataType currentFuncDT) {
        if (currentFuncDT != null) {
            return currentFuncDT;
        }
        return new FunctionDefinitionDataType(CategoryPath.ROOT, ANONYMOUS_FUNC_PREFIX + this.func_cnt++, this.dtMgr);
    }

    private void checkReturnDataType(DataType retDT) throws ParseException {
        if (retDT == null) {
            return;
        }
        DataType dt = retDT;
        int len = dt.getLength();
        if (len == 0 && dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (len <= 0 && !dt.isEquivalent(DataType.VOID)) {
            throw new ParseException("'" + retDT.getName() + "' is not fixed length.  Function return must be fixed length data type or void.");
        }
    }

    private int getConstantValue(Object obj, int defaultValue) {
        int value = defaultValue;
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Integer) {
            value = (Integer)obj;
        } else if (obj instanceof Long) {
            value = (int)((Long)obj).longValue();
        } else if (obj instanceof Character) {
            value = ((Character)obj).charValue();
        }
        return value;
    }

    private void pushPack(Token iD, int packingSize) {
        this.packStack.push(packingSize);
        String name = "";
        if (iD != null) {
            name = iD.image;
        }
        this.packStackID.push(name);
    }

    private int popPack(Token iD) {
        String ID;
        if (this.packStack.size() == 0) {
            return this.packSize;
        }
        String name = "";
        if (iD != null) {
            name = iD.image;
        }
        int popVal = this.packSize;
        do {
            ID = this.packStackID.pop();
            popVal = this.packStack.pop();
        } while (!name.equals(ID) && this.packStack.size() > 0);
        return popVal;
    }

    private void printTable(Map<String, DataType> table) {
        for (String name : table.keySet()) {
            DataType dt = table.get(name);
            String dataTypeName = "- unknown -";
            String mnemonic = "";
            if (dt != null) {
                dataTypeName = dt.getName();
                mnemonic = dt.getMnemonic(null);
            }
            System.out.println(name + " = " + dataTypeName + " : " + mnemonic);
        }
    }

    Object computeBinaryValue(Object obj1, Token operation, Object obj2) {
        if (!(obj1 instanceof Long) || !(obj2 instanceof Long)) {
            return null;
        }
        Long val1 = (Long)obj1;
        Long val2 = (Long)obj2;
        switch (operation.image) {
            case "<<": {
                return val1 << (int)val2.longValue();
            }
            case ">>": {
                return val1 >> (int)val2.longValue();
            }
            case "+": {
                return val1 + val2;
            }
            case "-": {
                return val1 - val2;
            }
            case "*": {
                return val1 * val2;
            }
            case "/": {
                return val1 / val2;
            }
            case "%": {
                return val1 % val2;
            }
            case "|": {
                return val1 | val2;
            }
            case "&": {
                return val1 & val2;
            }
            case "^": {
                return val1 ^ val2;
            }
            case "==": {
                return val1 == val2 ? 1 : 0;
            }
            case "!=": {
                return val1 != val2 ? 1 : 0;
            }
            case "<": {
                return val1 < val2 ? 1 : 0;
            }
            case ">": {
                return val1 > val2 ? 1 : 0;
            }
            case "<=": {
                return val1 <= val2 ? 1 : 0;
            }
            case ">=": {
                return val1 >= val2 ? 1 : 0;
            }
            case "&&": {
                return val1 != 0L && val2 != 0L ? 1 : 0;
            }
            case "||": {
                return val1 != 0L || val2 != 0L ? 1 : 0;
            }
        }
        return null;
    }

    Object computeUnaryValue(Object obj, Token operation) {
        if (!(obj instanceof Long)) {
            return null;
        }
        Long val = (Long)obj;
        switch (operation.image) {
            case "+": {
                return val;
            }
            case "-": {
                return -val.longValue();
            }
            case "~": {
                return val ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case "!": {
                return val != 0L ? 0 : 1;
            }
        }
        return null;
    }

    Object computeTernaryValue(Object objTest, Object objTrue, Object objFalse) {
        if (!(objTest instanceof Long)) {
            return null;
        }
        Long testValue = (Long)objTest;
        return testValue != 0L ? objTrue : objFalse;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dtMgr;
    }

    public DataType getLastDataType() {
        return this.lastDataType;
    }

    public Map<String, DataType> getDeclarations() {
        return this.declarations;
    }

    public Map<String, DataType> getEnums() {
        return this.enums;
    }

    public Map<String, DataType> getFunctions() {
        return this.functions;
    }

    public Map<String, DataType> getStructs() {
        return this.structs;
    }

    public Map<String, DataType> getTypes() {
        return this.types;
    }

    public DataType parse(String str) throws ParseException {
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
        this.parse(is);
        if (this.lastDataType != null && this.dtMgr != null) {
            return this.lastDataType.clone(this.dtMgr);
        }
        return this.lastDataType;
    }

    public void parse(InputStream fis) throws ParseException {
        this.ReInit(fis);
        int transactionID = -1;
        try {
            transactionID = this.dtMgr.startTransaction("Parsing");
            this.TranslationUnit();
        }
        catch (ParseException e) {
            if (this.headerFileName == null) {
                throw e;
            }
            long endLine = e.currentToken != null ? e.currentToken.endLine : 0;
            long subLinenum = endLine - (long)this.headerFileLineOffset + (long)this.headerFileLine;
            Object parseMessage = "C Parser:  Encountered errors during parse.\n";
            if (this.headerFileName != null) {
                parseMessage = (String)parseMessage + "         in " + this.headerFileName + " near line " + subLinenum + "\n";
            }
            parseMessage = (String)parseMessage + "Error: " + e.getMessage() + "\n";
            parseMessage = (String)parseMessage + "         near token: " + e.currentToken + "\n";
            parseMessage = (String)parseMessage + "Possibly Undefined : " + this.possiblyUndefinedType + "\n";
            parseMessage = (String)parseMessage + "         Last Valid Datatype: " + (this.lastDataType == null ? "- none -" : this.lastDataType.getDisplayName()) + "\n";
            parseMessage = (String)parseMessage + "         Check around CParserPlugin.out around line: " + this.jj_input_stream.getBeginLine() + "\n";
            ParseException parseException = new ParseException((String)parseMessage);
            parseException.currentToken = e.currentToken;
            throw parseException;
        }
        catch (Error e) {
            if (this.headerFileName == null) {
                throw e;
            }
            Object parseMessage = "C Parser:  Problem Parsing.\n";
            if (this.headerFileName != null) {
                parseMessage = (String)parseMessage + "          in " + this.headerFileName + " near line " + this.headerFileLine + "\n";
            }
            parseMessage = (String)parseMessage + "         Last Valid Datatype: " + (this.lastDataType == null ? "- none -" : this.lastDataType.getDisplayName()) + "\n";
            parseMessage = (String)parseMessage + "         Check around CParserPlugin.out around line: " + this.jj_input_stream.getBeginLine() + "\n";
            Msg.warn((Object)this, (Object)e, (Throwable)e);
            ParseException parseException = new ParseException((String)parseMessage);
            if (this.token != null) {
                parseException.currentToken = this.token;
            }
            throw parseException;
        }
        catch (Exception e) {
            Object parseMessage = "C Parser:  Problem Parsing.\n";
            if (this.headerFileName != null) {
                parseMessage = (String)parseMessage + "          in " + this.headerFileName + " near line " + this.headerFileLine + "\n";
            }
            parseMessage = (String)parseMessage + "         Last Valid Datatype: " + (this.lastDataType == null ? "- none -" : this.lastDataType.getDisplayName()) + "\n";
            parseMessage = (String)parseMessage + "         Check around CParserPlugin.out around line: " + this.jj_input_stream.getBeginLine() + "\n";
            Msg.warn((Object)this, (Object)e, (Throwable)e);
            throw new ParseException((String)parseMessage);
        }
        finally {
            this.dtMgr.endTransaction(transactionID, true);
        }
    }

    public CParser() {
        this(System.in);
        this.dtMgr = new StandAloneDataTypeManager("parsed");
    }

    public CParser(DataTypeManager dtmgr) {
        this(dtmgr, false, null);
    }

    public CParser(DataTypeManager dtmgr, boolean storeDataType, DataTypeManager[] subDTMgrs) {
        this(System.in);
        this.dtMgr = dtmgr;
        if (subDTMgrs == null) {
            subDTMgrs = new DataTypeManager[]{};
        }
        this.subDTMgrs = subDTMgrs;
        this.storeNewDT = storeDataType;
    }

    public static void main(String[] args) {
        CParser parser = new CParser();
        try {
            if (args.length == 0) {
                System.out.println("C Parser:  Reading from standard input . . .");
                parser.parse(System.in);
            } else if (args.length == 1) {
                System.out.println("C Parser:  Reading from file " + args[0] + " . . .");
                try {
                    parser.parse(new FileInputStream(args[0]));
                }
                catch (FileNotFoundException e) {
                    System.out.println("C Parser:  File " + args[0] + " not found.");
                    return;
                }
            } else {
                System.out.println("C Parser:  Usage is one of:");
                System.out.println("         java CParser < inputfile");
                System.out.println("OR");
                System.out.println("         java CParser inputfile");
                return;
            }
            System.out.println("C Parser:  Java program parsed successfully.");
        }
        catch (ParseException e) {
            System.out.println("C Parser:  Encountered errors during parse.");
        }
    }

    public final void TranslationUnit() throws ParseException {
        do {
            this.ExternalDeclaration();
        } while (this.jj_2_1(1));
    }

    public final void ExternalDeclaration() throws ParseException {
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.FunctionDefinition();
        } else if (this.jj_2_3(1)) {
            this.Declaration();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 39: {
                    this.PragmaSpec();
                    break;
                }
                case 76: 
                case 77: {
                    this.LineDef();
                    break;
                }
                case 135: {
                    this.jj_consume_token(135);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.typedefParsingStack.clear();
    }

    public final void LineDef() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token lineTok = this.jj_consume_token(91);
        Token fileTok = this.jj_consume_token(90);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                block10: while (true) {
                    this.jj_consume_token(10);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: {
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[2] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.headerFileName = fileTok.image.substring(1, fileTok.image.length() - 1);
        this.headerFileLine = Integer.parseInt(lineTok.image);
        this.headerFileLineOffset = lineTok.beginLine;
        this.currentCategoryName = this.getFileName(this.headerFileName);
    }

    public final DataType ObjcDef() throws ParseException {
        Token nameTok;
        block13: {
            nameTok = this.jj_consume_token(119);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 118: 
                    case 119: 
                    case 133: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 119: {
                        this.jj_consume_token(119);
                        continue block12;
                    }
                    case 118: {
                        this.jj_consume_token(118);
                        continue block12;
                    }
                    case 133: {
                        this.jj_consume_token(133);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 134: {
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.addTypedef(nameTok.image, this.resolveInternal((DataType)VoidDataType.dataType));
    }

    public final void FunctionDefinition() throws ParseException {
        Declaration retDT = new Declaration();
        Declaration dec = null;
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            retDT = this.DeclarationSpecifiers(retDT);
        }
        this.typedefParsingStack.push(Boolean.FALSE);
        dec = this.Declarator(retDT, null);
        if (this.jj_2_5(1)) {
            this.DeclarationList();
        }
        this.typedefParsingStack.pop();
        this.CompoundStatement();
        if (dec.getDataType() instanceof FunctionDefinition) {
            this.addDef("functions", this.functions, dec.getName(), dec.getDataType());
        }
    }

    public final Declaration Declaration() throws ParseException {
        Declaration dec = new Declaration();
        DataType dt = null;
        if (this.jj_2_6(1)) {
            dec = this.DeclarationSpecifiers(dec);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 31: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 67: 
                case 68: 
                case 73: 
                case 78: 
                case 136: 
                case 146: 
                case 147: {
                    this.InitDeclaratorList(dec);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                }
            }
            this.jj_consume_token(135);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 74: 
                case 75: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 74: {
                            this.jj_consume_token(74);
                            break;
                        }
                        case 75: {
                            this.jj_consume_token(75);
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    dt = this.ObjcDef();
                    dec.setDataType(dt);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return dec;
    }

    public final void DeclarationList() throws ParseException {
        do {
            this.Declaration();
        } while (this.jj_2_7(Integer.MAX_VALUE));
    }

    public final Declaration DeclarationSpecifiers(Declaration specDT) throws ParseException {
        Declaration typeDT = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: 
            case 22: 
            case 28: 
            case 31: 
            case 63: {
                specDT = this.StorageClassSpecifier(specDT);
                if (!this.jj_2_8(1)) break;
                specDT = this.DeclarationSpecifiers(specDT);
                break;
            }
            case 21: 
            case 24: 
            case 32: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 64: 
            case 65: 
            case 70: {
                specDT = this.BuiltInDeclarationSpecifier(specDT);
                if (!this.jj_2_9(Integer.MAX_VALUE)) break;
                specDT = this.TypeQualifierList(specDT);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                if (this.jj_2_12(1)) {
                    specDT = this.TypeSpecifier(specDT);
                    if (!this.jj_2_10(Integer.MAX_VALUE) || specDT.getDataType() != null) break;
                    specDT = this.DeclarationSpecifiers(specDT);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: 
                    case 31: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 73: {
                        specDT = this.TypeQualifier(specDT);
                        if (!this.jj_2_11(Integer.MAX_VALUE)) break block0;
                        specDT = this.DeclarationSpecifiers(specDT);
                        break block0;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 73: {
                specDT = this.TypeQualifier(specDT);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        if (specDT == null) {
            specDT = new Declaration(typeDT);
        }
        return specDT;
    }

    public final Declaration StorageClassSpecifier(Declaration specDT) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        break block0;
                    }
                }
                this.jj_la1[13] = this.jj_gen;
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                this.typedefParsingStack.push(Boolean.TRUE);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return specDT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Declaration BuiltInTypeSpecifier(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                dec.setDataType(this.resolveInternal((DataType)VoidDataType.dataType));
                return dec;
            }
            case 65: {
                this.jj_consume_token(65);
                DataType dt = dec.getDataType();
                if (dt != null) {
                    if (dt == this.resolveInternal((DataType)UnsignedIntegerDataType.dataType)) {
                        dt = this.resolveInternal((DataType)UnsignedCharDataType.dataType);
                    } else {
                        if (dt != this.resolveInternal((DataType)IntegerDataType.dataType)) throw new ParseException("Bad datatype " + dt + " char");
                        dt = this.resolveInternal((DataType)CharDataType.dataType);
                    }
                } else {
                    dt = this.resolveInternal((DataType)CharDataType.dataType);
                }
                dec.setDataType(dt);
                return dec;
            }
            case 61: {
                this.jj_consume_token(61);
                dec.setDataType(this.resolveInternal((DataType)WideCharDataType.dataType));
                return dec;
            }
            case 50: {
                this.jj_consume_token(50);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)ShortDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)UnsignedIntegerDataType.dataType)) {
                    dt = this.resolveInternal((DataType)UnsignedShortDataType.dataType);
                } else {
                    if (dt != this.resolveInternal((DataType)IntegerDataType.dataType)) throw new ParseException("Bad datatype " + dt + " short");
                    dt = this.resolveInternal((DataType)ShortDataType.dataType);
                }
                dec.setDataType(dt);
                if (!this.jj_2_13(Integer.MAX_VALUE)) return dec;
                return this.BuiltInDeclarationSpecifier(dec);
            }
            case 70: {
                this.jj_consume_token(70);
                DataType dt = dec.getDataType();
                if (dt != null) return dec;
                dec.setDataType(this.resolveInternal((DataType)IntegerDataType.dataType));
                return dec;
            }
            case 53: {
                this.jj_consume_token(53);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)LongDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)UnsignedIntegerDataType.dataType)) {
                    dt = this.resolveInternal((DataType)UnsignedLongDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)IntegerDataType.dataType)) {
                    dt = this.resolveInternal((DataType)LongDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)LongDataType.dataType)) {
                    dt = this.resolveInternal((DataType)LongLongDataType.dataType);
                } else {
                    if (dt != this.resolveInternal((DataType)UnsignedLongDataType.dataType)) throw new ParseException("Bad datatype " + dt + " long");
                    dt = this.resolveInternal((DataType)UnsignedLongLongDataType.dataType);
                }
                dec.setDataType(dt);
                if (!this.jj_2_14(Integer.MAX_VALUE)) return dec;
                return this.BuiltInDeclarationSpecifier(dec);
            }
            case 49: {
                this.jj_consume_token(49);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)FloatDataType.dataType);
                } else {
                    if (dt != this.resolveInternal((DataType)LongDataType.dataType)) throw new ParseException("Bad datatype " + dt + " long");
                    dt = this.resolveInternal((DataType)DoubleDataType.dataType);
                }
                dec.setDataType(dt);
                return dec;
            }
            case 24: {
                this.jj_consume_token(24);
                dec.setDataType(this.resolveInternal((DataType)DoubleDataType.dataType));
                return dec;
            }
            case 32: {
                this.jj_consume_token(32);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)IntegerDataType.dataType);
                }
                dec.setDataType(dt);
                if (!this.jj_2_15(Integer.MAX_VALUE)) return dec;
                return this.BuiltInDeclarationSpecifier(dec);
            }
            case 21: {
                this.jj_consume_token(21);
                DataType dt = dec.getDataType();
                if (dt == null) {
                    dt = this.resolveInternal((DataType)UnsignedIntegerDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)ShortDataType.dataType)) {
                    dt = this.resolveInternal((DataType)UnsignedShortDataType.dataType);
                } else if (dt == this.resolveInternal((DataType)LongDataType.dataType)) {
                    dt = this.resolveInternal((DataType)UnsignedLongDataType.dataType);
                } else {
                    if (dt != this.resolveInternal((DataType)LongLongDataType.dataType)) throw new ParseException("Bad datatype " + dt + " unsigned");
                    dt = this.resolveInternal((DataType)UnsignedLongLongDataType.dataType);
                }
                dec.setDataType(dt);
                if (!this.jj_2_16(Integer.MAX_VALUE)) return dec;
                return this.BuiltInDeclarationSpecifier(dec);
            }
            case 54: {
                this.jj_consume_token(54);
                dec.setDataType(this.resolveInternal((DataType)SignedByteDataType.dataType));
                return dec;
            }
            case 55: {
                this.jj_consume_token(55);
                dec.setDataType(this.resolveInternal((DataType)ShortDataType.dataType));
                return dec;
            }
            case 56: {
                this.jj_consume_token(56);
                dec.setDataType(this.resolveInternal((DataType)IntegerDataType.dataType));
                return dec;
            }
            case 57: {
                this.jj_consume_token(57);
                dec.setDataType(this.resolveInternal((DataType)LongLongDataType.dataType));
                return dec;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Declaration BuiltInDeclarationSpecifier(Declaration dec) throws ParseException {
        Object dt = null;
        dec = this.BuiltInTypeSpecifier(dec);
        return dec;
    }

    public final Declaration TypeSpecifier(Declaration dec) throws ParseException {
        DataType dt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 35: {
                dt = this.StructOrUnionSpecifier();
                break;
            }
            case 62: {
                dt = this.EnumSpecifier();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                if (this.isType(this.getToken((int)1).image)) {
                    dt = this.TypedefName();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        dec.setDataType(dt);
        return dec;
    }

    public final Declaration TypeQualifier(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                dec.setQualifier(36);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                dec.setQualifier(37);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                dec.setQualifier(41);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                dec.setQualifier(42);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 38: 
            case 40: 
            case 43: 
            case 46: {
                this.DeclSpec();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return dec;
    }

    public final void AttributeSpec() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                this.jj_consume_token(136);
                this.SubIdent();
                this.jj_consume_token(137);
                break;
            }
            case 46: {
                this.AsmStatement();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void AttributeSpecList() throws ParseException {
        block3: while (true) {
            this.AttributeSpec();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: 
                case 46: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[19] = this.jj_gen;
    }

    public final void SubIdent() throws ParseException {
        Declaration dt = new Declaration();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 136: {
                this.jj_consume_token(136);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 31: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 73: 
                    case 78: 
                    case 136: {
                        this.SubIdent();
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                    }
                }
                this.jj_consume_token(137);
                break;
            }
            case 19: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 73: 
            case 78: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 78: {
                        this.jj_consume_token(78);
                        break;
                    }
                    case 19: 
                    case 31: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 73: {
                        this.TypeQualifier(dt);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: {
                        this.jj_consume_token(136);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 14: 
                            case 16: 
                            case 17: 
                            case 19: 
                            case 31: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 67: 
                            case 68: 
                            case 73: 
                            case 78: 
                            case 136: {
                                this.SubIdent();
                                break;
                            }
                            default: {
                                this.jj_la1[22] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(137);
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 138: {
                        this.jj_consume_token(138);
                        this.SubIdent();
                        break block0;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 17: {
                this.Constant();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 138: {
                        this.jj_consume_token(138);
                        this.SubIdent();
                        break block0;
                    }
                }
                this.jj_la1[25] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DeclSpec() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: 
            case 40: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 38: {
                        this.jj_consume_token(38);
                        break;
                    }
                    case 40: {
                        this.jj_consume_token(40);
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(136);
                this.DeclSpecifier();
                this.jj_consume_token(137);
                break;
            }
            case 43: 
            case 46: {
                this.AttributeSpecList();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DeclSpecifier() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 136: {
                this.jj_consume_token(136);
                this.DeclSpecifier();
                this.jj_consume_token(137);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: {
                        this.jj_consume_token(136);
                        this.DeclConstant();
                        block10: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 10: 
                                case 17: 
                                case 78: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[29] = this.jj_gen;
                                    break block10;
                                }
                            }
                            this.DeclConstant();
                        }
                        this.jj_consume_token(137);
                        break block0;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DeclConstant() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 139: {
                        this.jj_consume_token(139);
                        this.jj_consume_token(10);
                        break block0;
                    }
                }
                this.jj_la1[32] = this.jj_gen;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 140: {
                            break;
                        }
                        default: {
                            this.jj_la1[33] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(140);
                    this.jj_consume_token(78);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 136: {
                            this.jj_consume_token(136);
                            this.jj_consume_token(137);
                            break;
                        }
                        default: {
                            this.jj_la1[34] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(17);
                }
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PragmaSpec() throws ParseException {
        this.jj_consume_token(39);
        this.PragmaSpecifier();
    }

    /*
     * Unable to fully structure code
     */
    public final void PragmaSpecifier() throws ParseException {
        block40: {
            block39: {
                ds1 = null;
                ds2 = null;
                ds3 = null;
                if (!this.jj_2_17(3)) break block39;
                this.jj_consume_token(103);
                this.PragmaSpecifier();
                this.jj_consume_token(104);
                break block40;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 100: {
                    id = this.jj_consume_token(100);
                    block33: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 100: 
                            case 108: 
                            case 112: {
                                break;
                            }
                            default: {
                                this.jj_la1[36] = this.jj_gen;
                                ** GOTO lbl39
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 100: {
                                this.jj_consume_token(100);
                                continue block33;
                            }
                            case 108: {
                                this.jj_consume_token(108);
                                continue block33;
                            }
                            case 112: {
                                this.jj_consume_token(112);
                                continue block33;
                            }
                        }
                        break;
                    }
                    this.jj_la1[37] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
lbl39:
                    // 1 sources

                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 103: {
                            this.jj_consume_token(103);
                            block16 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 100: 
                                case 108: 
                                case 112: {
                                    ds1 = this.PragmaConstant();
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 107: {
                                            this.jj_consume_token(107);
                                            ds2 = this.PragmaConstant();
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 107: {
                                                    this.jj_consume_token(107);
                                                    ds3 = this.PragmaConstant();
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 107: {
                                                            block34: while (true) {
                                                                this.jj_consume_token(107);
                                                                this.PragmaConstant();
                                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                                    case 107: {
                                                                        continue block34;
                                                                    }
                                                                }
                                                                break;
                                                            }
                                                            this.jj_la1[38] = this.jj_gen;
                                                            break block16;
                                                        }
                                                    }
                                                    this.jj_la1[39] = this.jj_gen;
                                                    break block16;
                                                }
                                            }
                                            this.jj_la1[40] = this.jj_gen;
                                            break block16;
                                        }
                                    }
                                    this.jj_la1[41] = this.jj_gen;
                                    break;
                                }
                                default: {
                                    this.jj_la1[42] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(104);
                            break;
                        }
                        default: {
                            this.jj_la1[43] = this.jj_gen;
                        }
                    }
                    if (id.image.equals("pack") && ds1 != null) {
                        newPackVal = ds1;
                        ID = ds2;
                        if (ds1.image.equals("pop")) {
                            this.packSize = this.popPack(ID);
                            newPackVal = null;
                        } else if (ds1.image.equals("push") && ds2 != null) {
                            try {
                                ival = Integer.parseInt(ds2.image);
                                newPackVal = ds2;
                                ID = null;
                            }
                            catch (NumberFormatException exc) {
                                newPackVal = ds3;
                                ID = ds2;
                            }
                            this.pushPack(ID, this.packSize);
                        }
                        if (newPackVal == null) break;
                        ival = this.packSize;
                        try {
                            ival = Integer.parseInt(newPackVal.image);
                        }
                        catch (NumberFormatException var8_9) {
                            // empty catch block
                        }
                        this.packSize = ival;
                        break;
                    }
                    if (!id.image.equals("pack")) break;
                    this.packSize = 0;
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final Token PragmaConstant() throws ParseException {
        Token val = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 108: {
                val = this.jj_consume_token(108);
                break;
            }
            case 100: {
                val = this.jj_consume_token(100);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 106: {
                        this.jj_consume_token(106);
                        block21: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 108: {
                                    this.jj_consume_token(108);
                                    break;
                                }
                                case 100: {
                                    this.jj_consume_token(100);
                                    break;
                                }
                                default: {
                                    this.jj_la1[45] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 100: 
                                case 108: {
                                    continue block21;
                                }
                            }
                            break;
                        }
                        this.jj_la1[46] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                break;
            }
            case 112: {
                val = this.jj_consume_token(112);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 105: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(105);
                    this.jj_consume_token(100);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 103: {
                            this.jj_consume_token(103);
                            this.jj_consume_token(104);
                            break;
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(112);
                }
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final void StaticAssert() throws ParseException {
        this.jj_consume_token(48);
        this.jj_consume_token(136);
        this.ConstantExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        this.jj_consume_token(137);
    }

    public final DataType StructOrUnionSpecifier() throws ParseException {
        this.typedefParsingStack.push(Boolean.FALSE);
        Token sname = null;
        Token t = null;
        Composite comp = this.StructOrUnion();
        if (this.jj_2_19(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    t = this.jj_consume_token(78);
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                }
            }
            this.jj_consume_token(141);
            if (this.jj_2_18(1)) {
                this.StructDeclarationList(comp);
            }
            this.jj_consume_token(142);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: 
                case 46: {
                    this.AttributeSpecList();
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    sname = this.jj_consume_token(78);
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        try {
            if (t != null) {
                DataType dt = this.getStructDef(t.image);
                if (dt != null && dt instanceof Structure && comp instanceof Structure && dt.getDataTypeManager() == this.getDataTypeManager()) {
                    Structure dtcomp = (Structure)dt;
                    dtcomp.replaceWith((DataType)comp);
                    comp = dtcomp;
                } else {
                    comp.setName(t.image);
                    comp = (Composite)this.addDef(this.structs, t.image, (DataType)comp);
                }
            } else if (sname != null) {
                DataType dt = this.getStructDef(sname.image);
                if (dt instanceof Composite) {
                    comp = (Composite)dt;
                }
                if (dt == null) {
                    comp.setName(sname.image);
                    comp = (Composite)this.addDef(this.structs, sname.image, (DataType)comp);
                }
            }
        }
        catch (InvalidNameException e) {
            e.printStackTrace();
        }
        catch (DuplicateNameException e) {
            e.printStackTrace();
        }
        this.typedefParsingStack.pop();
        return comp;
    }

    /*
     * Unable to fully structure code
     */
    public final Composite StructOrUnion() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 38: 
                        case 39: 
                        case 40: 
                        case 43: 
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[55] = this.jj_gen;
                            ** GOTO lbl23
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 38: 
                        case 40: 
                        case 43: 
                        case 46: {
                            this.DeclSpec();
                            continue block16;
                        }
                        case 39: {
                            this.PragmaSpec();
                            continue block16;
                        }
                    }
                    break;
                }
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
lbl23:
                // 1 sources

                comp = new StructureDataType(CategoryPath.ROOT, "_struct_" + this.cnt++, 0, this.dtMgr);
                if (this.packSize > 0) {
                    comp.setExplicitPackingValue(this.packSize);
                    break;
                }
                comp.setPackingEnabled(true);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 38: 
                        case 40: 
                        case 43: 
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.DeclSpec();
                }
                comp = new UnionDataType(CategoryPath.ROOT, "_union_" + this.cnt++, this.dtMgr);
                if (this.packSize > 0) {
                    comp.setExplicitPackingValue(this.packSize);
                    break;
                }
                comp.setPackingEnabled(true);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            comp.setCategoryPath(this.getCurrentCategoryPath());
        }
        catch (DuplicateNameException var2_2) {
            // empty catch block
        }
        return comp;
    }

    public final void StructDeclarationList(Composite comp) throws ParseException {
        CompositeHandler compositeHandler = new CompositeHandler(comp);
        do {
            this.StructDeclaration(comp, compositeHandler);
        } while (this.jj_2_20(1));
    }

    public final void InitDeclaratorList(Declaration dt) throws ParseException {
        Declaration initialDT = new Declaration(dt);
        this.InitDeclarator(dt);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            dt = new Declaration(initialDT);
            this.InitDeclarator(dt);
        }
        if (!this.typedefParsingStack.empty() && this.typedefParsingStack.peek().booleanValue()) {
            this.typedefParsingStack.pop();
        }
    }

    public final void InitDeclarator(Declaration dt) throws ParseException {
        Declaration dec = this.Declarator(dt, null);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                this.Initializer();
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        if (!this.typedefParsingStack.empty() && this.typedefParsingStack.peek().booleanValue()) {
            this.addTypedef(dec.getName(), dec.getDataType());
        } else if (dt.getDataType() instanceof FunctionDefinition) {
            this.addDef("functions", this.functions, dec.getName(), dec.getDataType());
        }
    }

    public final void StructDeclaration(Composite comp, CompositeHandler compositeHandler) throws ParseException {
        Declaration dt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: 
            case 77: {
                this.LineDef();
                break;
            }
            case 39: {
                this.PragmaSpec();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                if (this.jj_2_22(1)) {
                    if (this.jj_2_21(1)) {
                        dt = this.SpecifierQualifierList();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: 
                        case 31: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 67: 
                        case 68: 
                        case 73: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 136: 
                        case 139: 
                        case 146: 
                        case 147: {
                            this.StructDeclaratorList(dt, comp, compositeHandler);
                            dt = null;
                            break;
                        }
                        default: {
                            this.jj_la1[61] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 43: 
                        case 46: {
                            this.AttributeSpecList();
                            break;
                        }
                        default: {
                            this.jj_la1[62] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(135);
                    if (dt == null) break;
                    if (dt.getDataType().getLength() > 0) {
                        comp.add(dt.getDataType(), "", null);
                        break;
                    }
                    System.err.println("BAD data type struct size  " + dt);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Declaration SpecifierQualifierList() throws ParseException {
        Declaration dt = new Declaration();
        Declaration sdt = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 24: 
            case 32: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 64: 
            case 65: 
            case 70: {
                dt = this.BuiltInDeclarationSpecifier(dt);
                if (!this.jj_2_23(Integer.MAX_VALUE)) break;
                dt = this.TypeQualifierList(dt);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                if (this.jj_2_26(1)) {
                    dt = this.TypeSpecifier(dt);
                    if (!this.jj_2_24(Integer.MAX_VALUE) || dt != null) break;
                    sdt = this.SpecifierQualifierList();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: 
                    case 31: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 73: {
                        dt = this.TypeQualifier(dt);
                        if (!this.jj_2_25(Integer.MAX_VALUE)) break block0;
                        sdt = this.SpecifierQualifierList();
                        break block0;
                    }
                    default: {
                        this.jj_la1[65] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        if (sdt == null) {
            this.dataTypeStack.push(dt.getDataType());
            return dt;
        }
        return sdt;
    }

    public final void StructDeclaratorList(Declaration dt, Composite comp, CompositeHandler compositeHandler) throws ParseException {
        this.StructDeclarator(dt, comp, compositeHandler);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            this.StructDeclarator(dt, comp, compositeHandler);
        }
    }

    public final void StructDeclarator(Declaration dt, Composite comp, CompositeHandler compositeHandler) throws ParseException {
        Declaration dec = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: 
            case 77: {
                this.LineDef();
                break;
            }
            case 19: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 73: 
            case 78: 
            case 136: 
            case 139: 
            case 146: 
            case 147: {
                if (this.jj_2_27(3)) {
                    dec = this.Declarator(dt, (DataType)comp);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 139: {
                            this.jj_consume_token(139);
                            Object bitSizeObj = this.ConstantExpression();
                            Integer bitSize = this.getConstantValue(bitSizeObj, -1);
                            dec.setBitFieldSize(bitSize);
                            break;
                        }
                        default: {
                            this.jj_la1[67] = this.jj_gen;
                            break;
                        }
                    }
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 139: {
                            this.jj_consume_token(139);
                            Object bitSizeObj = this.ConstantExpression();
                            Integer bitSize = this.getConstantValue(bitSizeObj, -1);
                            dec = new Declaration(dt);
                            dec.setBitFieldSize(bitSize);
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                try {
                    compositeHandler.add(dec);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Bad structure size " + dec.getName() + "  length=" + dec.getDataType().getLength());
                    System.err.println("    In file " + this.headerFileName);
                    System.err.println("    Near " + this.lastDataType.getName());
                }
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final DataType EnumSpecifier() throws ParseException {
        DataType dt;
        Token t = null;
        this.jj_consume_token(62);
        if (this.jj_2_28(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    t = this.jj_consume_token(78);
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                }
            }
            this.jj_consume_token(141);
            ArrayList<EnumMember> list = this.EnumeratorList();
            this.jj_consume_token(142);
            String enumName = t != null ? t.image : "enum_" + this.cnt++;
            EnumDataType enuum = new EnumDataType(CategoryPath.ROOT, enumName, 4, this.dtMgr);
            for (EnumMember member : list) {
                try {
                    enuum.add(member.name, member.value);
                }
                catch (IllegalArgumentException exc) {
                    System.err.println("duplicate enum value: " + enumName + " : " + member.name + " : " + member.value);
                    System.err.println("    In file " + this.headerFileName);
                    System.err.println("    Near " + this.lastDataType.getName());
                }
            }
            dt = enuum;
            dt = this.addDef(this.enums, enumName, (DataType)enuum);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    t = this.jj_consume_token(78);
                    dt = this.getEnumDef(t.image);
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return dt;
    }

    public final ArrayList<EnumMember> EnumeratorList() throws ParseException {
        ArrayList<EnumMember> list;
        block11: {
            int value = 0;
            list = new ArrayList<EnumMember>();
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 76: 
                    case 77: 
                    case 78: {
                        break;
                    }
                    default: {
                        this.jj_la1[72] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 76: 
                    case 77: {
                        this.LineDef();
                        continue block10;
                    }
                    case 10: 
                    case 78: {
                        value = this.Enumerator(list, value);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 138: {
                                this.jj_consume_token(138);
                                break;
                            }
                            default: {
                                this.jj_la1[73] = this.jj_gen;
                            }
                        }
                        ++value;
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[74] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return list;
    }

    public final int Enumerator(ArrayList<EnumMember> list, int value) throws ParseException {
        Token t = null;
        Object obj = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 78: {
                t = this.jj_consume_token(78);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 143: {
                        this.jj_consume_token(143);
                        obj = this.ConstantExpression();
                        break;
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                    }
                }
                Integer evalue = this.getConstantValue(obj, value);
                if (evalue != null) {
                    value = evalue;
                }
                list.add(new EnumMember(t.image, value));
                return value;
            }
            case 10: {
                t = this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 143: {
                        this.jj_consume_token(143);
                        obj = this.ConstantExpression();
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                    }
                }
                Integer evalue = this.getConstantValue(obj, value);
                if (evalue != null) {
                    value = evalue;
                }
                return value;
            }
        }
        this.jj_la1[77] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Declaration Declarator(Declaration dt, DataType container) throws ParseException {
        Declaration dec = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 73: {
                dt = this.TypeQualifierList(dt);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 146: 
            case 147: {
                dt = this.Pointer(dt);
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
            }
        }
        dec = this.DirectDeclarator(dt, container);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: 
            case 46: {
                this.AttributeSpecList();
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        return dec;
    }

    public final Declaration DirectDeclarator(Declaration dt, DataType container) throws ParseException {
        FunctionDefinitionDataType funcDT;
        Declaration funcDec;
        Declaration dec;
        block36: {
            dec = null;
            funcDec = null;
            funcDT = null;
            Object obj = null;
            ArrayList<Integer> list = new ArrayList<Integer>();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    Token t = this.jj_consume_token(78);
                    dec = new Declaration(dt, t.image);
                    break;
                }
                case 136: {
                    this.jj_consume_token(136);
                    funcDT = this.newAnonymousFunction(funcDT);
                    dec = this.Declarator(new Declaration((DataType)funcDT), null);
                    this.jj_consume_token(137);
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.lastDataType = dec.getDataType();
            block26: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 144: {
                        break;
                    }
                    default: {
                        this.jj_la1[82] = this.jj_gen;
                        break block26;
                    }
                }
                this.jj_consume_token(144);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 78: 
                    case 136: 
                    case 146: 
                    case 147: 
                    case 150: 
                    case 151: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: {
                        obj = this.ConditionalExpression();
                        break;
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                    }
                }
                this.jj_consume_token(145);
                Integer size = this.getConstantValue(obj, 0);
                if (size == null) {
                    System.out.println("BAD ARRAY SIZE! " + obj);
                    size = 0;
                }
                list.add(0, size);
                dec.setDataType(dt.getDataType());
                Iterator iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block26;
                    Integer iSize = (Integer)iterator.next();
                    DataType decDt = dec.getDataType();
                    dec.setDataType((DataType)new ArrayDataType(decDt, iSize.intValue(), decDt.getLength()));
                }
                break;
            }
            block28: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: {
                        break;
                    }
                    default: {
                        this.jj_la1[84] = this.jj_gen;
                        break block36;
                    }
                }
                if (this.jj_2_29(3)) {
                    this.jj_consume_token(136);
                    funcDT = this.newAnonymousFunction(funcDT);
                    funcDec = this.ParameterTypeList(funcDT, dt.getDataType());
                    this.jj_consume_token(137);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: {
                        this.jj_consume_token(136);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 78: {
                                funcDT = this.newAnonymousFunction(funcDT);
                                this.IdentifierList(funcDT, dt.getDataType());
                                break;
                            }
                            default: {
                                this.jj_la1[85] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(137);
                        funcDT = this.newAnonymousFunction(funcDT);
                        funcDec = new Declaration((DataType)funcDT, "__paramIDList__");
                        continue block28;
                    }
                }
                break;
            }
            this.jj_la1[86] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (funcDec != null) {
            try {
                if (container == null) {
                    funcDT.setName(dec.getName());
                }
                funcDec.setName(dec.getName());
                if (dec.getDataType() != null) {
                    funcDec.setDataType(dec.getDataType());
                }
            }
            catch (InvalidNameException e) {
                throw new ParseException("duplicate name " + dec.getName());
            }
            DataType retDT = dt.getDataType();
            this.checkReturnDataType(retDT);
            funcDT.setReturnType(retDT);
            switch (dt.getQualifier()) {
                case 37: {
                    funcDT.setGenericCallingConvention(GenericCallingConvention.cdecl);
                    break;
                }
                case 41: {
                    funcDT.setGenericCallingConvention(GenericCallingConvention.stdcall);
                    break;
                }
                case 42: {
                    funcDT.setGenericCallingConvention(GenericCallingConvention.fastcall);
                }
            }
            dec = funcDec;
            DataType newDT = this.addDef("functions", this.functions, dec.getName(), (DataType)funcDT);
            DataType repDT = dec.getDataType();
            while (repDT != null && repDT instanceof Pointer) {
                PointerDataType ptDT = (PointerDataType)repDT;
                if (ptDT.getDataType() instanceof FunctionDefinition) {
                    ptDT.dataTypeReplaced(ptDT.getDataType(), newDT);
                    newDT = repDT;
                    break;
                }
                repDT = ptDT.getDataType();
            }
            dec.setDataType(newDT);
        }
        return dec;
    }

    public final Declaration Pointer(Declaration dec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 146: {
                this.jj_consume_token(146);
                break;
            }
            case 147: {
                this.jj_consume_token(147);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 73: {
                dec = this.TypeQualifierList(dec);
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 146: 
            case 147: {
                dec = this.Pointer(dec);
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
            }
        }
        dec.setDataType((DataType)this.dtMgr.getPointer(dec.getDataType()));
        return dec;
    }

    public final Declaration TypeQualifierList(Declaration dec) throws ParseException {
        block3: while (true) {
            dec = this.TypeQualifier(dec);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 31: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 67: 
                case 68: 
                case 73: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[90] = this.jj_gen;
        return dec;
    }

    public final Declaration ParameterTypeList(FunctionDefinitionDataType funcDT, DataType retDT) throws ParseException {
        Token varargs = null;
        ArrayList<Declaration> list = this.ParameterList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                varargs = this.jj_consume_token(148);
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
            }
        }
        this.checkReturnDataType(retDT);
        if (funcDT == null) {
            funcDT = new FunctionDefinitionDataType(CategoryPath.ROOT, ANONYMOUS_FUNC_PREFIX, this.dtMgr);
        }
        funcDT.setVarArgs(varargs != null);
        ParameterDefinition[] variables = new ParameterDefinition[list.size()];
        for (int i = 0; i < variables.length; ++i) {
            Declaration dec = list.get(i);
            DataType varDT = dec.getDataType();
            if (variables.length == 1 && varDT instanceof VoidDataType) {
                variables = new ParameterDefinition[]{};
                break;
            }
            variables[i] = new ParameterDefinitionImpl(dec.getName(), dec.getDataType(), null);
        }
        funcDT.setReturnType(retDT);
        funcDT.setArguments(variables);
        return new Declaration((DataType)funcDT);
    }

    public final ArrayList<Declaration> ParameterList() throws ParseException {
        ArrayList<Declaration> list = new ArrayList<Declaration>();
        this.ParameterDeclaration(list);
        while (this.jj_2_30(2)) {
            this.jj_consume_token(138);
            this.ParameterDeclaration(list);
        }
        return list;
    }

    public final void ParameterDeclaration(ArrayList<Declaration> list) throws ParseException {
        DataType decDT;
        Declaration dt = new Declaration();
        Declaration dec = new Declaration();
        dt = this.DeclarationSpecifiers(dec);
        if (this.jj_2_31(Integer.MAX_VALUE)) {
            dec = this.Declarator(dt, null);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 136: 
                case 144: 
                case 146: 
                case 147: {
                    dec = this.AbstractDeclarator(dt);
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                }
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                this.jj_consume_token(10);
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
            }
        }
        if (dec == null) {
            dec = new Declaration(dt);
        }
        if ((decDT = dec.getDataType()) != null) {
            if (!(decDT.getLength() >= 0 || decDT instanceof FunctionDefinition || decDT instanceof TypeDef && ((TypeDef)decDT).getDataType() instanceof FunctionDefinition)) {
                throw new ParseException("'" + decDT.getName() + "' is not fixed length.  Function parameters must use fixed length data type.");
            }
            list.add(dec);
        }
    }

    public final void IdentifierList(FunctionDefinitionDataType funcDT, DataType retDT) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        Token t = this.jj_consume_token(78);
        list.add(t.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            t = this.jj_consume_token(78);
            list.add(t.image);
        }
        this.checkReturnDataType(retDT);
        ParameterDefinition[] variables = new ParameterDefinition[list.size()];
        for (int i = 0; i < variables.length; ++i) {
            variables[i] = new ParameterDefinitionImpl((String)list.get(i), null, null);
        }
        funcDT.setReturnType(retDT);
        funcDT.setArguments(variables);
    }

    public final void Initializer() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 25: 
            case 78: 
            case 136: 
            case 146: 
            case 147: 
            case 150: 
            case 151: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                this.AssignmentExpression();
                break;
            }
            case 141: {
                this.jj_consume_token(141);
                this.InitializerList();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 138: {
                        this.jj_consume_token(138);
                        break;
                    }
                    default: {
                        this.jj_la1[95] = this.jj_gen;
                    }
                }
                this.jj_consume_token(142);
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void InitializerList() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 144: 
            case 149: {
                this.Designation();
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        this.Initializer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                this.InitializerList();
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
            }
        }
    }

    public final void Designation() throws ParseException {
        this.DesignatorList();
        this.jj_consume_token(143);
    }

    public final void DesignatorList() throws ParseException {
        this.Designator();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 144: 
            case 149: {
                this.DesignatorList();
                break;
            }
            default: {
                this.jj_la1[99] = this.jj_gen;
            }
        }
    }

    public final void Designator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 144: {
                this.jj_consume_token(144);
                this.ConstantExpression();
                this.jj_consume_token(145);
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                this.jj_consume_token(78);
                break;
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Declaration TypeName() throws ParseException {
        Declaration dec = null;
        dec = this.SpecifierQualifierList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 136: 
            case 144: 
            case 146: 
            case 147: {
                dec = this.AbstractDeclarator(new Declaration(dec));
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
            }
        }
        return dec;
    }

    public final Declaration AbstractDeclarator(Declaration dt) throws ParseException {
        Declaration dec = null;
        if (this.jj_2_32(3)) {
            dec = this.DirectAbstractDeclarator(dt);
            return new Declaration(dec, dt.getDataType());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 146: 
            case 147: {
                dt = this.Pointer(dt);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: 
                    case 144: {
                        dec = this.DirectAbstractDeclarator(dt);
                        return new Declaration(dec, dt.getDataType());
                    }
                }
                this.jj_la1[102] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new Declaration(dt);
    }

    public final Declaration DirectAbstractDeclarator(Declaration dt) throws ParseException {
        Declaration dec;
        block25: {
            dec = null;
            if (this.jj_2_34(2)) {
                this.jj_consume_token(136);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: 
                    case 31: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 73: {
                        this.TypeQualifier(dt);
                        break;
                    }
                    default: {
                        this.jj_la1[104] = this.jj_gen;
                    }
                }
                dec = this.AbstractDeclarator(dt);
                this.jj_consume_token(137);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 144: {
                        this.jj_consume_token(144);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 14: 
                            case 16: 
                            case 17: 
                            case 25: 
                            case 78: 
                            case 136: 
                            case 146: 
                            case 147: 
                            case 150: 
                            case 151: 
                            case 177: 
                            case 178: 
                            case 179: 
                            case 180: {
                                this.ConstantExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[105] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(145);
                        break;
                    }
                    case 136: {
                        this.jj_consume_token(136);
                        if (this.jj_2_33(1)) {
                            dec = this.ParameterTypeList(null, dt.getDataType());
                        }
                        this.jj_consume_token(137);
                        break;
                    }
                    default: {
                        this.jj_la1[106] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: 
                    case 144: {
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                        break block25;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 144: {
                        this.jj_consume_token(144);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 14: 
                            case 16: 
                            case 17: 
                            case 25: 
                            case 78: 
                            case 136: 
                            case 146: 
                            case 147: 
                            case 150: 
                            case 151: 
                            case 177: 
                            case 178: 
                            case 179: 
                            case 180: {
                                this.ConstantExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[108] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(145);
                        continue block20;
                    }
                    case 136: {
                        this.jj_consume_token(136);
                        if (this.jj_2_35(1)) {
                            dec = this.ParameterTypeList(null, dec.getDataType());
                        }
                        this.jj_consume_token(137);
                        continue block20;
                    }
                }
                break;
            }
            this.jj_la1[109] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return dec;
    }

    public final DataType TypedefName() throws ParseException {
        Token t = this.jj_consume_token(78);
        return this.getType(t.image);
    }

    public final void Statement() throws ParseException {
        if (this.jj_2_36(2)) {
            this.AsmStatement();
        } else if (this.jj_2_37(3)) {
            this.DeclarationList();
        } else if (this.jj_2_38(2)) {
            this.LabeledStatement();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 14: 
                case 16: 
                case 17: 
                case 25: 
                case 78: 
                case 135: 
                case 136: 
                case 146: 
                case 147: 
                case 150: 
                case 151: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    this.ExpressionStatement();
                    break;
                }
                case 141: {
                    this.CompoundStatement();
                    break;
                }
                case 26: 
                case 71: {
                    this.SelectionStatement();
                    break;
                }
                case 33: 
                case 69: 
                case 72: {
                    this.IterationStatement();
                    break;
                }
                case 18: 
                case 27: 
                case 34: 
                case 66: {
                    this.JumpStatement();
                    break;
                }
                case 46: {
                    this.AsmStatement();
                    break;
                }
                case 39: {
                    this.PragmaSpec();
                    break;
                }
                case 48: {
                    this.StaticAssert();
                    break;
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void LabeledStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 78: {
                this.jj_consume_token(78);
                this.jj_consume_token(139);
                this.Statement();
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                this.ConstantExpression();
                this.jj_consume_token(139);
                this.Statement();
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(139);
                this.Statement();
                break;
            }
            default: {
                this.jj_la1[111] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ExpressionStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 25: 
            case 78: 
            case 136: 
            case 146: 
            case 147: 
            case 150: 
            case 151: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                this.Expression();
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
            }
        }
        this.jj_consume_token(135);
    }

    public final void CompoundStatement() throws ParseException {
        this.jj_consume_token(141);
        if (this.jj_2_39(1)) {
            this.StatementList();
        }
        this.jj_consume_token(142);
    }

    public final void StatementList() throws ParseException {
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: 
                case 77: {
                    this.LineDef();
                    break;
                }
                default: {
                    this.jj_la1[113] = this.jj_gen;
                    if (this.jj_2_40(1)) {
                        this.Statement();
                        break;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        } while (this.jj_2_41(1));
    }

    public final void AsmStatement() throws ParseException {
        Declaration dec = new Declaration();
        this.jj_consume_token(46);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 73: {
                this.TypeQualifier(dec);
                break;
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
            }
        }
        this.AsmLine();
    }

    public final void AsmLine() throws ParseException {
        Declaration dec = new Declaration();
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    this.jj_consume_token(78);
                    break;
                }
                case 17: {
                    this.jj_consume_token(17);
                    break;
                }
                case 10: {
                    this.jj_consume_token(10);
                    break;
                }
                case 43: {
                    this.jj_consume_token(43);
                    break;
                }
                case 21: 
                case 24: 
                case 32: 
                case 49: 
                case 50: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 61: 
                case 64: 
                case 65: 
                case 70: {
                    this.BuiltInTypeSpecifier(dec);
                    break;
                }
                case 140: {
                    this.jj_consume_token(140);
                    break;
                }
                case 150: {
                    this.jj_consume_token(150);
                    break;
                }
                case 151: {
                    this.jj_consume_token(151);
                    break;
                }
                case 138: {
                    this.jj_consume_token(138);
                    break;
                }
                case 139: {
                    this.jj_consume_token(139);
                    break;
                }
                case 146: {
                    this.jj_consume_token(146);
                    break;
                }
                case 144: {
                    this.jj_consume_token(144);
                    this.AsmLine();
                    this.jj_consume_token(145);
                    break;
                }
                case 136: {
                    this.jj_consume_token(136);
                    this.AsmLine();
                    this.jj_consume_token(137);
                    break;
                }
                case 141: {
                    this.jj_consume_token(141);
                    this.AsmLine();
                    this.jj_consume_token(142);
                    break;
                }
                default: {
                    this.jj_la1[115] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 17: 
                case 21: 
                case 24: 
                case 32: 
                case 43: 
                case 49: 
                case 50: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 61: 
                case 64: 
                case 65: 
                case 70: 
                case 78: 
                case 136: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 144: 
                case 146: 
                case 150: 
                case 151: {
                    continue block19;
                }
            }
            break;
        }
        this.jj_la1[116] = this.jj_gen;
    }

    public final void SelectionStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: {
                this.jj_consume_token(71);
                this.jj_consume_token(136);
                this.Expression();
                this.jj_consume_token(137);
                this.Statement();
                if (!this.jj_2_42(2)) break;
                this.jj_consume_token(51);
                this.Statement();
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                this.jj_consume_token(136);
                this.Expression();
                this.jj_consume_token(137);
                this.Statement();
                break;
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void IterationStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                this.jj_consume_token(136);
                this.Expression();
                this.jj_consume_token(137);
                this.Statement();
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                this.Statement();
                this.jj_consume_token(33);
                this.jj_consume_token(136);
                this.Expression();
                this.jj_consume_token(137);
                this.jj_consume_token(135);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                this.jj_consume_token(136);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 78: 
                    case 136: 
                    case 146: 
                    case 147: 
                    case 150: 
                    case 151: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: {
                        this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[118] = this.jj_gen;
                    }
                }
                this.jj_consume_token(135);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 78: 
                    case 136: 
                    case 146: 
                    case 147: 
                    case 150: 
                    case 151: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: {
                        this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[119] = this.jj_gen;
                    }
                }
                this.jj_consume_token(135);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 78: 
                    case 136: 
                    case 146: 
                    case 147: 
                    case 150: 
                    case 151: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: {
                        this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[120] = this.jj_gen;
                    }
                }
                this.jj_consume_token(137);
                this.Statement();
                break;
            }
            default: {
                this.jj_la1[121] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void JumpStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(78);
                this.jj_consume_token(135);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                this.jj_consume_token(135);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                this.jj_consume_token(135);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 78: 
                    case 136: 
                    case 146: 
                    case 147: 
                    case 150: 
                    case 151: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: {
                        this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                    }
                }
                this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[123] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Object Expression() throws ParseException {
        Object obj = null;
        obj = this.AssignmentExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[124] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            obj = this.AssignmentExpression();
        }
        return obj;
    }

    public final Object AssignmentExpression() throws ParseException {
        Object obj = null;
        if (this.jj_2_43(Integer.MAX_VALUE)) {
            this.UnaryExpression();
            this.AssignmentOperator();
            obj = this.AssignmentExpression();
        } else if (this.jj_2_44(3)) {
            obj = this.ConditionalExpression();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return obj;
    }

    public final void AssignmentOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                break;
            }
            case 152: {
                this.jj_consume_token(152);
                break;
            }
            case 153: {
                this.jj_consume_token(153);
                break;
            }
            case 154: {
                this.jj_consume_token(154);
                break;
            }
            case 155: {
                this.jj_consume_token(155);
                break;
            }
            case 156: {
                this.jj_consume_token(156);
                break;
            }
            case 157: {
                this.jj_consume_token(157);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                break;
            }
            case 160: {
                this.jj_consume_token(160);
                break;
            }
            case 161: {
                this.jj_consume_token(161);
                break;
            }
            default: {
                this.jj_la1[125] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Object ConditionalExpression() throws ParseException {
        Object obj = null;
        Object objTrue = null;
        Object objFalse = null;
        obj = this.LogicalORExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 162: {
                this.jj_consume_token(162);
                objTrue = this.Expression();
                this.jj_consume_token(139);
                objFalse = this.ConditionalExpression();
                obj = this.computeTernaryValue(obj, objTrue, objFalse);
                break;
            }
            default: {
                this.jj_la1[126] = this.jj_gen;
            }
        }
        return obj;
    }

    public final Object ConstantExpression() throws ParseException {
        Object obj = null;
        obj = this.ConditionalExpression();
        return obj;
    }

    public final Object LogicalORExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.LogicalANDExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 163: {
                    break;
                }
                default: {
                    this.jj_la1[127] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(163);
            obj2 = this.LogicalANDExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object LogicalANDExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.InclusiveORExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 164: {
                    break;
                }
                default: {
                    this.jj_la1[128] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(164);
            obj2 = this.InclusiveORExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object InclusiveORExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.ExclusiveORExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 165: {
                    break;
                }
                default: {
                    this.jj_la1[129] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(165);
            obj2 = this.ExclusiveORExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object ExclusiveORExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.ANDExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 166: {
                    break;
                }
                default: {
                    this.jj_la1[130] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(166);
            obj2 = this.ANDExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object ANDExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.EqualityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 147: {
                    break;
                }
                default: {
                    this.jj_la1[131] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(147);
            obj2 = this.EqualityExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object EqualityExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.RelationalExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 167: 
                case 168: {
                    break;
                }
                default: {
                    this.jj_la1[132] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 167: {
                    op = this.jj_consume_token(167);
                    break;
                }
                case 168: {
                    op = this.jj_consume_token(168);
                    break;
                }
                default: {
                    this.jj_la1[133] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.RelationalExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object RelationalExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.ShiftExpression();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 169: 
                case 170: 
                case 171: 
                case 172: {
                    break;
                }
                default: {
                    this.jj_la1[134] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 169: {
                    op = this.jj_consume_token(169);
                    break;
                }
                case 170: {
                    op = this.jj_consume_token(170);
                    break;
                }
                case 171: {
                    op = this.jj_consume_token(171);
                    break;
                }
                case 172: {
                    op = this.jj_consume_token(172);
                    break;
                }
                default: {
                    this.jj_la1[135] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.ShiftExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object ShiftExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.AdditiveExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 173: 
                case 174: {
                    break;
                }
                default: {
                    this.jj_la1[136] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 173: {
                    op = this.jj_consume_token(173);
                    break;
                }
                case 174: {
                    op = this.jj_consume_token(174);
                    break;
                }
                default: {
                    this.jj_la1[137] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.AdditiveExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object AdditiveExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.MultiplicativeExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 150: 
                case 151: {
                    break;
                }
                default: {
                    this.jj_la1[138] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 150: {
                    op = this.jj_consume_token(150);
                    break;
                }
                case 151: {
                    op = this.jj_consume_token(151);
                    break;
                }
                default: {
                    this.jj_la1[139] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.MultiplicativeExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object MultiplicativeExpression() throws ParseException {
        Object obj = null;
        Object obj2 = null;
        Token op = null;
        obj = this.CastExpression();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 146: 
                case 175: 
                case 176: {
                    break;
                }
                default: {
                    this.jj_la1[140] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 146: {
                    op = this.jj_consume_token(146);
                    break;
                }
                case 175: {
                    op = this.jj_consume_token(175);
                    break;
                }
                case 176: {
                    op = this.jj_consume_token(176);
                    break;
                }
                default: {
                    this.jj_la1[141] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            obj2 = this.CastExpression();
            obj = this.computeBinaryValue(obj, op, obj2);
        }
        return obj;
    }

    public final Object CastExpression() throws ParseException {
        Object obj;
        block11: {
            block10: {
                obj = null;
                if (!this.jj_2_45(Integer.MAX_VALUE)) break block10;
                this.jj_consume_token(136);
                this.TypeName();
                this.jj_consume_token(137);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 78: 
                    case 136: 
                    case 146: 
                    case 147: 
                    case 150: 
                    case 151: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: {
                        obj = this.CastExpression();
                        break block11;
                    }
                    case 141: {
                        this.jj_consume_token(141);
                        this.InitializerList();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 138: {
                                this.jj_consume_token(138);
                                break;
                            }
                            default: {
                                this.jj_la1[142] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(142);
                        break block11;
                    }
                    default: {
                        this.jj_la1[143] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 14: 
                case 16: 
                case 17: 
                case 25: 
                case 78: 
                case 136: 
                case 146: 
                case 147: 
                case 150: 
                case 151: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    obj = this.UnaryExpression();
                    break;
                }
                default: {
                    this.jj_la1[144] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return obj;
    }

    public final Object UnaryExpression() throws ParseException {
        Object obj = null;
        Token op = null;
        Declaration dec = null;
        if (this.jj_2_47(3)) {
            obj = this.PostfixExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 146: 
                case 147: {
                    this.UnaryOperator();
                    this.CastExpression();
                    break;
                }
                case 177: {
                    this.jj_consume_token(177);
                    this.UnaryExpression();
                    break;
                }
                case 178: {
                    this.jj_consume_token(178);
                    this.UnaryExpression();
                    break;
                }
                case 150: {
                    this.jj_consume_token(150);
                    obj = this.CastExpression();
                    break;
                }
                case 151: {
                    op = this.jj_consume_token(151);
                    obj = this.CastExpression();
                    obj = this.computeUnaryValue(obj, op);
                    break;
                }
                case 179: {
                    op = this.jj_consume_token(179);
                    obj = this.CastExpression();
                    obj = this.computeUnaryValue(obj, op);
                    break;
                }
                case 180: {
                    op = this.jj_consume_token(180);
                    obj = this.CastExpression();
                    obj = this.computeUnaryValue(obj, op);
                    break;
                }
                case 25: {
                    this.jj_consume_token(25);
                    this.jj_consume_token(136);
                    if (this.jj_2_46(1)) {
                        dec = this.TypeName();
                    } else {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 14: 
                            case 16: 
                            case 17: 
                            case 25: 
                            case 78: 
                            case 136: 
                            case 146: 
                            case 147: 
                            case 150: 
                            case 151: 
                            case 177: 
                            case 178: 
                            case 179: 
                            case 180: {
                                obj = this.UnaryExpression();
                                break;
                            }
                            default: {
                                this.jj_la1[145] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    this.jj_consume_token(137);
                    if (obj != null && obj instanceof String) {
                        obj = (long)(((String)obj).length() - 1);
                        break;
                    }
                    if (dec != null) {
                        obj = (long)dec.getDataType().getLength();
                        break;
                    }
                    if (obj == null) break;
                    break;
                }
                default: {
                    this.jj_la1[146] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return obj;
    }

    public final void UnaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 147: {
                this.jj_consume_token(147);
                break;
            }
            case 146: {
                this.jj_consume_token(146);
                break;
            }
            default: {
                this.jj_la1[147] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Object PostfixExpression() throws ParseException {
        Object obj;
        block13: {
            obj = null;
            obj = this.PrimaryExpression();
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: 
                    case 144: 
                    case 149: 
                    case 177: 
                    case 178: 
                    case 181: {
                        break;
                    }
                    default: {
                        this.jj_la1[148] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 144: {
                        this.jj_consume_token(144);
                        this.Expression();
                        this.jj_consume_token(145);
                        continue block11;
                    }
                    case 136: {
                        this.jj_consume_token(136);
                        if (this.jj_2_48(Integer.MAX_VALUE)) {
                            this.ArgumentExpressionList();
                        }
                        this.jj_consume_token(137);
                        continue block11;
                    }
                    case 149: {
                        this.jj_consume_token(149);
                        this.jj_consume_token(78);
                        continue block11;
                    }
                    case 181: {
                        this.jj_consume_token(181);
                        this.jj_consume_token(78);
                        continue block11;
                    }
                    case 177: {
                        this.jj_consume_token(177);
                        continue block11;
                    }
                    case 178: {
                        this.jj_consume_token(178);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[149] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return obj;
    }

    public final Object PrimaryExpression() throws ParseException {
        Object obj = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 78: {
                obj = this.jj_consume_token(78);
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 17: {
                obj = this.Constant();
                break;
            }
            case 136: {
                this.jj_consume_token(136);
                obj = this.Expression();
                this.jj_consume_token(137);
                break;
            }
            default: {
                this.jj_la1[150] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return obj;
    }

    public final void ArgumentExpressionList() throws ParseException {
        this.AssignmentExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 138: {
                    break;
                }
                default: {
                    this.jj_la1[151] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(138);
            this.AssignmentExpression();
        }
    }

    public final Object Constant() throws ParseException {
        Object obj = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token t = this.jj_consume_token(10);
                String sval = t.image;
                if (sval.endsWith("ull") || sval.endsWith("ULL")) {
                    sval = sval.substring(0, sval.length() - 3);
                } else if (sval.endsWith("ll") || sval.endsWith("LL")) {
                    sval = sval.substring(0, sval.length() - 2);
                } else if (sval.endsWith("ul") || sval.endsWith("UL")) {
                    sval = sval.substring(0, sval.length() - 2);
                } else if (sval.endsWith("l") || sval.endsWith("L")) {
                    sval = sval.substring(0, sval.length() - 1);
                } else if (sval.endsWith("u") || sval.endsWith("U")) {
                    sval = sval.substring(0, sval.length() - 1);
                }
                if (sval.startsWith("0x") || sval.startsWith("0X")) {
                    BigInteger bigConst = new BigInteger(sval.substring(2), 16);
                    obj = bigConst.longValue();
                    break;
                }
                BigInteger bigConst = new BigInteger(sval);
                obj = bigConst.longValue();
                break;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                obj = new Double(t.image);
                break;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                if (t.image.length() == 1) {
                    obj = new Character(t.image.charAt(0));
                    break;
                }
                if (t.image.length() != 4) break;
                long cval = ((long)t.image.charAt(0) << 24) + ((long)t.image.charAt(1) << 16) + ((long)t.image.charAt(2) << 8) + (long)t.image.charAt(3);
                obj = cval;
                break;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                obj = t.image;
                break;
            }
            default: {
                this.jj_la1[152] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    private boolean jj_3R_271() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_278()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_275()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_279()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_156() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_210()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_294() {
        if (this.jj_3R_306()) {
            return true;
        }
        return this.jj_scan_token(143);
    }

    private boolean jj_3R_287() {
        return this.jj_3R_135();
    }

    private boolean jj_3R_275() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_287()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_288()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_14() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_276() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_155() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_209()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_208() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_154() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_267() {
        Token xsp;
        if (this.jj_scan_token(78)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_276());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_153() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3_13() {
        return this.jj_3R_46();
    }

    private boolean jj_3_31() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_252() {
        return this.jj_3R_61();
    }

    private boolean jj_3R_220() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_252()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_290() {
        if (this.jj_scan_token(143)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_207() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_219() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_152() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_208()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_58() {
        if (this.jj_3R_42()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_219()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_220()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_290()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_151() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3_30() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_58();
    }

    private boolean jj_3R_102() {
        Token xsp;
        if (this.jj_3R_58()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_30());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_150() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_207()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_215() {
        return this.jj_3R_168();
    }

    private boolean jj_3R_270() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_scan_token(148);
    }

    private boolean jj_3R_149() {
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_148() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_147() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_57() {
        if (this.jj_3R_102()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_270()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_147()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_148()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_149()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_150()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_151()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_152()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_153()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_154()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_155()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_156()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_157()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_158()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_159()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_160()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_214() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_84() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_203() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_44() {
        Token xsp;
        if (this.jj_3R_84()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_84());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_202() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_11() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_168() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(146)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(147)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_214()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_215()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_138() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(63)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(20)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(31)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_202()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_203()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_141() {
        return this.jj_3R_42();
    }

    private boolean jj_3_10() {
        return this.jj_3R_42();
    }

    private boolean jj_3_9() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_82() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_81() {
        if (this.jj_3R_106()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_141()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_140() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_139() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_282() {
        Token xsp;
        if (this.jj_scan_token(10)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(10));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_12() {
        if (this.jj_3R_45()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_140()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_99() {
        return this.jj_3R_90();
    }

    private boolean jj_3_8() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_142() {
        return this.jj_3R_204();
    }

    private boolean jj_3R_80() {
        if (this.jj_3R_46()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_139()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_79() {
        if (this.jj_3R_138()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_7() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_249() {
        return this.jj_3R_267();
    }

    private boolean jj_3R_217() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_249()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_79()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_80()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_12()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_81()) {
                        return true;
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_82()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_83() {
        return this.jj_3R_41();
    }

    private boolean jj_3_29() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_57()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_172() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_217()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_43() {
        Token xsp;
        if (this.jj_3R_83()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_83());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_78() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(74)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(75)) {
                return true;
            }
        }
        return this.jj_3R_143();
    }

    private boolean jj_3_6() {
        if (this.jj_3R_42()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_142()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(135);
    }

    private boolean jj_3R_216() {
        return this.jj_3R_69();
    }

    private boolean jj_3R_205() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(119)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(118)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(133)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_171() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_216()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(145);
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_78()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_76() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_97() {
        return this.jj_3R_168();
    }

    private boolean jj_3R_170() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_54()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_76()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_54()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_77();
    }

    private boolean jj_3R_169() {
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_143() {
        Token xsp;
        if (this.jj_scan_token(119)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_205());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(122)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(134)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_98() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_169()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_170()) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_171());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_172());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(76)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(77)) {
                return true;
            }
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_282()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_96() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_269() {
        if (this.jj_scan_token(143)) {
            return true;
        }
        return this.jj_3R_100();
    }

    private boolean jj_3_2() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_75() {
        return this.jj_3R_121();
    }

    private boolean jj_3R_263() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_74() {
        return this.jj_3R_137();
    }

    private boolean jj_3_3() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_73() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_96()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_97()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_98()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_99()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_262() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_268() {
        if (this.jj_scan_token(143)) {
            return true;
        }
        return this.jj_3R_100();
    }

    private boolean jj_3R_261() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_73()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_74()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_75()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(135)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_251() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_269()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_39();
    }

    private boolean jj_3R_218() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_250()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_251()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_250() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_268()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_136() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_135();
    }

    private boolean jj_3R_174() {
        if (this.jj_3R_218()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(138)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_101() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_173()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_174()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_173() {
        return this.jj_3R_121();
    }

    private boolean jj_3R_260() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_56() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_101());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_265() {
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_240() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_260()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_261()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_262()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_263()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_72() {
        Token xsp;
        if (this.jj_3R_135()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_136());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_48() {
        return this.jj_3R_72();
    }

    private boolean jj_3R_196() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_194()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_195() {
        return this.jj_3R_240();
    }

    private boolean jj_3_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(78)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(141)) {
            return true;
        }
        if (this.jj_3R_56()) {
            return true;
        }
        return this.jj_scan_token(142);
    }

    private boolean jj_3R_55() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_100();
    }

    private boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(78)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_195()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_196()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_289() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_164();
    }

    private boolean jj_3R_241() {
        return this.jj_3R_72();
    }

    private boolean jj_3R_200() {
        if (this.jj_scan_token(181)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_145() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_265()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_199() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_198() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_241()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_134() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_197()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_198()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_199()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_200()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(177)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(178)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_197() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        if (this.jj_3R_194()) {
            return true;
        }
        return this.jj_scan_token(145);
    }

    private boolean jj_3R_191() {
        return this.jj_3R_67();
    }

    private boolean jj_3R_248() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_100();
    }

    private boolean jj_3R_71() {
        Token xsp;
        if (this.jj_3R_133()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_134());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_27() {
        if (this.jj_3R_54()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_55()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_25() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_213() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_248()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_24() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_189() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(147)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(146)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_46() {
        return this.jj_3R_70();
    }

    private boolean jj_3R_167() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_164() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_212()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_213()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_212() {
        return this.jj_3R_121();
    }

    private boolean jj_3_23() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_95() {
        Token xsp;
        if (this.jj_3R_164()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_289());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_166() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_129() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_191()) {
                return true;
            }
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_165() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_128() {
        if (this.jj_scan_token(180)) {
            return true;
        }
        return this.jj_3R_190();
    }

    private boolean jj_3R_94() {
        if (this.jj_3R_106()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_167()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_127() {
        if (this.jj_scan_token(179)) {
            return true;
        }
        return this.jj_3R_190();
    }

    private boolean jj_3R_126() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        return this.jj_3R_190();
    }

    private boolean jj_3R_124() {
        if (this.jj_scan_token(178)) {
            return true;
        }
        return this.jj_3R_67();
    }

    private boolean jj_3R_256() {
        return this.jj_3R_190();
    }

    private boolean jj_3_26() {
        if (this.jj_3R_45()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_166()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_125() {
        if (this.jj_scan_token(150)) {
            return true;
        }
        return this.jj_3R_190();
    }

    private boolean jj_3R_123() {
        if (this.jj_scan_token(177)) {
            return true;
        }
        return this.jj_3R_67();
    }

    private boolean jj_3R_122() {
        if (this.jj_3R_189()) {
            return true;
        }
        return this.jj_3R_190();
    }

    private boolean jj_3_47() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_257() {
        if (this.jj_scan_token(141)) {
            return true;
        }
        if (this.jj_3R_271()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(138)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(142);
    }

    private boolean jj_3R_93() {
        if (this.jj_3R_46()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_165()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_67() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_122()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_123()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_124()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_125()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_126()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_127()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_128()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_129()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_45() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_70()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_26()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_94()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_237() {
        return this.jj_3R_67();
    }

    private boolean jj_3R_52() {
        return this.jj_3R_95();
    }

    private boolean jj_3R_236() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_70()) {
            return true;
        }
        if (this.jj_scan_token(137)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_256()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_257()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_53() {
        return this.jj_3R_90();
    }

    private boolean jj_3R_266() {
        if (this.jj_scan_token(143)) {
            return true;
        }
        return this.jj_3R_275();
    }

    private boolean jj_3_21() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_190() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_236()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_237()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(135);
    }

    private boolean jj_3R_329() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(146)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(175)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(176)) {
                    return true;
                }
            }
        }
        return this.jj_3R_190();
    }

    private boolean jj_3R_92() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_325() {
        Token xsp;
        if (this.jj_3R_190()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_329());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_91() {
        return this.jj_3R_121();
    }

    private boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_91()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_92()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_22()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_326() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(150)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(151)) {
                return true;
            }
        }
        return this.jj_3R_325();
    }

    private boolean jj_3R_242() {
        if (this.jj_3R_54()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_266()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_315() {
        Token xsp;
        if (this.jj_3R_325()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_326());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_225() {
        if (this.jj_scan_token(141)) {
            return true;
        }
        if (this.jj_3R_109()) {
            return true;
        }
        return this.jj_scan_token(142);
    }

    private boolean jj_3R_243() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_242();
    }

    private boolean jj_3R_316() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(173)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(174)) {
                return true;
            }
        }
        return this.jj_3R_315();
    }

    private boolean jj_3R_204() {
        Token xsp;
        if (this.jj_3R_242()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_243());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_307() {
        Token xsp;
        if (this.jj_3R_315()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_316());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_20() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_48() {
        Token xsp;
        if (this.jj_3_20()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_20());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_281() {
        if (this.jj_scan_token(147)) {
            return true;
        }
        return this.jj_3R_280();
    }

    private boolean jj_3R_299() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_284() {
        return this.jj_3R_221();
    }

    private boolean jj_3R_308() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(169)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(170)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(171)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(172)) {
                        return true;
                    }
                }
            }
        }
        return this.jj_3R_307();
    }

    private boolean jj_3R_295() {
        Token xsp;
        if (this.jj_3R_307()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_308());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_224() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_109()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_245() {
        Token xsp;
        if (this.jj_scan_token(35)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_284());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_298() {
        return this.jj_3R_221();
    }

    private boolean jj_3R_283() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_298()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_299()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_296() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(167)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(168)) {
                return true;
            }
        }
        return this.jj_3R_295();
    }

    private boolean jj_3R_273() {
        if (this.jj_scan_token(166)) {
            return true;
        }
        return this.jj_3R_272();
    }

    private boolean jj_3R_49() {
        return this.jj_3R_90();
    }

    private boolean jj_3R_259() {
        if (this.jj_scan_token(165)) {
            return true;
        }
        return this.jj_3R_258();
    }

    private boolean jj_3R_280() {
        Token xsp;
        if (this.jj_3R_295()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_296());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_244() {
        Token xsp;
        if (this.jj_scan_token(30)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_283());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_239() {
        if (this.jj_scan_token(164)) {
            return true;
        }
        return this.jj_3R_238();
    }

    private boolean jj_3R_272() {
        Token xsp;
        if (this.jj_3R_280()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_281());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_223() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        if (this.jj_3R_109()) {
            return true;
        }
        return this.jj_scan_token(145);
    }

    private boolean jj_3R_206() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_244()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_245()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_193() {
        if (this.jj_scan_token(163)) {
            return true;
        }
        return this.jj_3R_192();
    }

    private boolean jj_3R_258() {
        Token xsp;
        if (this.jj_3R_272()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_273());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_238() {
        Token xsp;
        if (this.jj_3R_258()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_259());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_18() {
        return this.jj_3R_48();
    }

    private boolean jj_3R_342() {
        if (this.jj_scan_token(107)) {
            return true;
        }
        return this.jj_3R_332();
    }

    private boolean jj_3R_320() {
        return this.jj_3R_194();
    }

    private boolean jj_3R_339() {
        Token xsp;
        if (this.jj_3R_342()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_342());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_309() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_131() {
        if (this.jj_scan_token(162)) {
            return true;
        }
        if (this.jj_3R_194()) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_69();
    }

    private boolean jj_3R_192() {
        Token xsp;
        if (this.jj_3R_238()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_239());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_341() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        return this.jj_scan_token(104);
    }

    private boolean jj_3R_235() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_320()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(135);
    }

    private boolean jj_3R_130() {
        Token xsp;
        if (this.jj_3R_192()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_193());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_319() {
        return this.jj_3R_194();
    }

    private boolean jj_3_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(78)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(141)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_18()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(142)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_100() {
        return this.jj_3R_69();
    }

    private boolean jj_3R_234() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_scan_token(135);
    }

    private boolean jj_3R_340() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(108)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(100)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_264() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_135();
    }

    private boolean jj_3R_69() {
        if (this.jj_3R_130()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_338() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        if (this.jj_scan_token(100)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_341()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(112);
    }

    private boolean jj_3R_144() {
        if (this.jj_3R_206()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(78)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_318() {
        return this.jj_3R_194();
    }

    private boolean jj_3R_336() {
        if (this.jj_scan_token(107)) {
            return true;
        }
        if (this.jj_3R_332()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_339()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_222() {
        return this.jj_3R_88();
    }

    private boolean jj_3R_337() {
        Token xsp;
        if (this.jj_scan_token(106)) {
            return true;
        }
        if (this.jj_3R_340()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_340());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(143)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(152)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(153)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(154)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(155)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(156)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(157)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(158)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(159)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(160)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(161)) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_43() {
        if (this.jj_3R_67()) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_233() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(135);
    }

    private boolean jj_3_44() {
        return this.jj_3R_69();
    }

    private boolean jj_3R_188() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_309()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_201() {
        if (this.jj_3R_67()) {
            return true;
        }
        if (this.jj_3R_68()) {
            return true;
        }
        return this.jj_3R_135();
    }

    private boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_201()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_44()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_317() {
        return this.jj_3R_194();
    }

    private boolean jj_3R_335() {
        Token xsp;
        if (this.jj_scan_token(112)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_338());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_334() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_337()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_194() {
        Token xsp;
        if (this.jj_3R_135()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_264());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_112() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_65();
    }

    private boolean jj_3R_332() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(108)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_334()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_335()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_231() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_317()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(135)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_318()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(135)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_319()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(137)) {
            return true;
        }
        return this.jj_3R_65();
    }

    private boolean jj_3R_232() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_scan_token(135);
    }

    private boolean jj_3R_187() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_232()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_233()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_234()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_235()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_230() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_3R_65()) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_194()) {
            return true;
        }
        if (this.jj_scan_token(137)) {
            return true;
        }
        return this.jj_scan_token(135);
    }

    private boolean jj_3R_229() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_194()) {
            return true;
        }
        if (this.jj_scan_token(137)) {
            return true;
        }
        return this.jj_3R_65();
    }

    private boolean jj_3R_333() {
        if (this.jj_scan_token(107)) {
            return true;
        }
        if (this.jj_3R_332()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_336()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_42() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_3R_65();
    }

    private boolean jj_3R_228() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_194()) {
            return true;
        }
        if (this.jj_scan_token(137)) {
            return true;
        }
        return this.jj_3R_65();
    }

    private boolean jj_3R_186() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_229()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_230()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_231()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_227() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_194()) {
            return true;
        }
        if (this.jj_scan_token(137)) {
            return true;
        }
        if (this.jj_3R_65()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_42()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_185() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_227()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_228()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_161() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(100)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(108)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(112)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_331() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_330() {
        if (this.jj_3R_332()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_333()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_311() {
        return this.jj_3R_310();
    }

    private boolean jj_3R_183() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(78)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(17)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(10)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(43)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_222()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(140)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(150)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(151)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(138)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(139)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(146)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_223()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_224()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_225()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_162() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_330()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(104);
    }

    private boolean jj_3R_109() {
        Token xsp;
        if (this.jj_3R_183()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_183());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_108() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_111() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_65();
    }

    private boolean jj_3R_89() {
        Token xsp;
        if (this.jj_scan_token(100)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_161());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_162()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_328() {
        if (this.jj_scan_token(140)) {
            return true;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_331()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_327() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        return this.jj_scan_token(104);
    }

    private boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_89()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_62() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_109();
    }

    private boolean jj_3_40() {
        return this.jj_3R_65();
    }

    private boolean jj_3R_66() {
        return this.jj_3R_121();
    }

    private boolean jj_3_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_64() {
        Token xsp;
        if (this.jj_3_41()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_41());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_300() {
        Token xsp;
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_310()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_311());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_303() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_312()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3_39() {
        return this.jj_3R_64();
    }

    private boolean jj_3R_137() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_3R_47();
    }

    private boolean jj_3R_322() {
        Token xsp;
        if (this.jj_scan_token(17)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_328());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_77() {
        if (this.jj_scan_token(141)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_39()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(142);
    }

    private boolean jj_3R_321() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_327()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_310() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_321()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_322()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_226() {
        return this.jj_3R_194();
    }

    private boolean jj_3R_184() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_226()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(135);
    }

    private boolean jj_3R_286() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_300()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_120() {
        return this.jj_3R_188();
    }

    private boolean jj_3R_110() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_3R_65();
    }

    private boolean jj_3R_312() {
        return this.jj_3R_277();
    }

    private boolean jj_3R_119() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_63() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_110()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_111()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_112()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_35() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_305() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_277();
    }

    private boolean jj_3R_304() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_277();
    }

    private boolean jj_3R_285() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_274()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_274() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_285()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_286()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_118() {
        return this.jj_3R_62();
    }

    private boolean jj_3R_302() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_117() {
        return this.jj_3R_187();
    }

    private boolean jj_3R_116() {
        return this.jj_3R_186();
    }

    private boolean jj_3R_177() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_255() {
        return this.jj_3R_90();
    }

    private boolean jj_3R_115() {
        return this.jj_3R_185();
    }

    private boolean jj_3R_221() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_254()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_255()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_254() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(38)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(40)) {
                return true;
            }
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_274()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_114() {
        return this.jj_3R_77();
    }

    private boolean jj_3R_113() {
        return this.jj_3R_184();
    }

    private boolean jj_3R_301() {
        return this.jj_3R_277();
    }

    private boolean jj_3R_293() {
        if (this.jj_3R_240()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_305()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_38() {
        return this.jj_3R_63();
    }

    private boolean jj_3_37() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_292() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(78)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_302()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_303()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_304()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_291() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_301()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3_36() {
        return this.jj_3R_62();
    }

    private boolean jj_3R_163() {
        return this.jj_3R_211();
    }

    private boolean jj_3R_277() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_291()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_292()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_293()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_90() {
        Token xsp;
        if (this.jj_3R_163()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_163());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_37()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_38()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_113()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_114()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_115()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_116()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_117()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_118()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_119()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_120()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_247() {
        return this.jj_3R_62();
    }

    private boolean jj_3R_211() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_246()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_247()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_246() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_3R_277()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_297() {
        return this.jj_3R_100();
    }

    private boolean jj_3R_182() {
        return this.jj_3R_221();
    }

    private boolean jj_3R_146() {
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_105() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_176()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_177()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_176() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_297()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(145);
    }

    private boolean jj_3_33() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_175() {
        return this.jj_3R_100();
    }

    private boolean jj_3R_181() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_180() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_253() {
        return this.jj_3R_59();
    }

    private boolean jj_3R_60() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_104() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_33()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_179() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_103() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_175()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(145);
    }

    private boolean jj_3R_132() {
        return this.jj_3R_61();
    }

    private boolean jj_3_34() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_61()) {
            return true;
        }
        return this.jj_scan_token(137);
    }

    private boolean jj_3R_106() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_178()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_179()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(67)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(68)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_180()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_181()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(60)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(58)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(59)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(47)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(73)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(45)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(44)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(31)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_182()) {
                                                                        return true;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_178() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_87() {
        return this.jj_3R_146();
    }

    private boolean jj_3R_86() {
        return this.jj_3R_145();
    }

    private boolean jj_3R_85() {
        return this.jj_3R_144();
    }

    private boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_103()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_104()) {
                    return true;
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_105());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_107() {
        if (this.jj_3R_168()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_253()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_32() {
        return this.jj_3R_59();
    }

    private boolean jj_3_16() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_86()) {
                this.jj_scanpos = xsp;
                this.jj_lookingAhead = true;
                this.jj_semLA = this.isType(this.getToken((int)1).image);
                this.jj_lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_87()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_279() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_3R_271();
    }

    private boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_107()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_210() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_46() {
        return this.jj_3R_88();
    }

    private boolean jj_3R_160() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_159() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_70() {
        if (this.jj_3R_51()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_132()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_288() {
        if (this.jj_scan_token(141)) {
            return true;
        }
        if (this.jj_3R_271()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(138)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(142);
    }

    private boolean jj_3_15() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_158() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_314() {
        return this.jj_3R_306();
    }

    private boolean jj_3R_157() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_209() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_324() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_323() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_scan_token(145);
    }

    private boolean jj_3R_313() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_323()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_324()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_306() {
        if (this.jj_3R_313()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_314()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_278() {
        return this.jj_3R_294();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 1024, 1024, 0, 0, 0, -2146959360, 0, 0, -1854930944, -2146959360, -2146959360, 131072, -1873805312, 0x1200000, 0x40000000, -2146959360, 0, 0, -2146745344, -2146959360, -2146745344, 0, 0, 0, -2146745344, 0, 0, 132096, 0, 0, 0, 0, 0, 132096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, -2146959360, 0, 0, 0x1200000, -2146959360, 0, 0, 0, -2146959360, 0, 0, 1024, 0, 1024, 0, 0, 1024, -2146959360, 0, 0, 0, 0, 33768448, 0, 0, 0, 0, -2146959360, 0, -2146959360, 0, 0, 0, 0, 0, 33768448, 0, 0, 0, 0, 0, 0, 0, -2146959360, 33768448, 0, 0, 33768448, 0, 235357184, 0x800000, 33768448, 0, -2146959360, 19006464, 19006464, 0x4000000, 33768448, 33768448, 33768448, 0, 33768448, 0x8040000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33768448, 33768448, 33768448, 0x2000000, 0, 0, 0, 214016, 0, 214016};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{128, 0, 0, 0, 0, 0, 0, 469827440, 0, 0, -1545207807, 469827440, 469827440, 0, Integer.MIN_VALUE, 602275841, 0x40000008, 469827440, 18432, 18432, 469827440, 469827440, 469827440, 0, 0, 0, 469827440, 320, 18752, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18432, 0, 18880, 18880, 18752, 8, 0, 0, 469827440, 18432, 128, 602275841, 469827440, 0, 0, 0, 469827440, 0, 0, 0, 0, 0, 0, 0, 0, 469827440, 0, 18432, 0, 0, 0, 0, 0, 0, 0, 469827440, 0, 469827440, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 469827440, 0, 0, 0, 0, 0, 82054, 0x100000, 0, 0, 469827440, 602277889, 602277889, 0, 0, 0, 0, 2, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{12288, 12288, 0, 0, 0, 0, 0, 16920, 3072, 3072, 67, 536, 536, 0, 0, 67, 0, 536, 0, 0, 16920, 16920, 16920, 0, 0, 0, 16920, 0, 0, 16384, 0, 16384, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 16384, 0, 0, 0, 0, 0, 0, 29208, 0, 12288, 67, 536, 0, 0, 0, 29208, 16384, 16384, 28672, 0, 28672, 0, 0, 16384, 536, 0, 0, 16384, 0, 16384, 0, 16384, 0, 0, 536, 0, 536, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 536, 16384, 0, 0, 16384, 0, 16804, 16384, 16384, 12288, 536, 16451, 16451, 128, 16384, 16384, 16384, 288, 16384, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 16384, 16384, 0, 0, 0, 0, 16384, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0xC00000, 0xC00000, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69648, 69648, 2048, 2048, 2048, 2048, 69648, 128, 16, 4112, 4112, 1024, 512, 128, 69648, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{128, 0, 0, 0, 32, 32, 64, 786688, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 256, 256, 1024, 1024, 256, 0, 0, 0, 256, 256, 2048, 4096, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 1024, 32768, 788736, 0, 0, 0, 0, 1024, 2048, 2048, 788736, 0, 0, 0, 1024, 0, 32768, 32768, 0, 0, 786432, 0, 256, 65536, 0xCC0100, 256, 0, 256, 786432, 0, 786432, 0, 1024, 852224, 32768, 1024, 1024, 13377792, 0x210000, 1024, 0x210000, 0x210000, 852224, 65792, 786432, 0, 0xCC0100, 65792, 65792, 0xCC0100, 65792, 13377920, 0, 0xCC0100, 0, 0, 12926208, 12926208, 0, 0xCC0100, 0xCC0100, 0xCC0100, 0, 0xCC0100, 0, 1024, -16744448, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 0xC00000, 0xC00000, 262144, 262144, 1024, 13377792, 0xCC0100, 0xCC0100, 0xCC0000, 786432, 0x210100, 0x210100, 256, 1024, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1E0000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1E0000, 0, 0, 0, 0, 0, 0, 0, 0, 0x1E0000, 0, 0, 0x1E0000, 0, 0x1E0000, 0, 0x1E0000, 0, 0, 0, 0, 0, 0x1E0000, 0x1E0000, 0x1E0000, 0, 0x1E0000, 0, 0, 3, 4, 8, 16, 32, 64, 0, 384, 384, 7680, 7680, 24576, 24576, 0, 0, 98304, 98304, 0, 0x1E0000, 0x1E0000, 0x1E0000, 0x1E0000, 0, 0x260000, 0x260000, 0, 0, 0};
    }

    public CParser(InputStream stream) {
        this(stream, null);
    }

    public CParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 153; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 153; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 153; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 153; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CParser(CParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 153; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 153; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[182];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 153; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) == 0) continue;
                la1tokens[160 + j] = true;
            }
        }
        for (i = 0; i < 182; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 48; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        CParser.jj_la1_init_0();
        CParser.jj_la1_init_1();
        CParser.jj_la1_init_2();
        CParser.jj_la1_init_3();
        CParser.jj_la1_init_4();
        CParser.jj_la1_init_5();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private static class EnumMember {
        final String name;
        final long value;

        EnumMember(String name, long value) {
            this.name = name;
            this.value = value;
        }
    }
}

