/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.data.CreateStringCmd;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.task.TaskMonitor;

public class DemangledString
extends DemangledObject {
    private String string;
    private int length;
    private boolean unicode;

    public DemangledString(String mangled, String originalDemangled, String name, String string, int length, boolean unicode) {
        super(mangled, originalDemangled);
        this.setName(name);
        this.string = string;
        this.length = length;
        this.unicode = unicode;
    }

    @Override
    public String getSignature(boolean format) {
        StringBuilder buffer = new StringBuilder();
        if (this.specialPrefix != null) {
            buffer.append(this.specialPrefix);
        }
        buffer.append(this.string);
        return buffer.toString();
    }

    private static boolean hasLabel(Program program, Address address, String label) {
        SymbolTable symbolTable = program.getSymbolTable();
        for (Symbol s : symbolTable.getSymbols(address)) {
            if (!label.equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean applyTo(Program program, Address address, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        String label = this.buildStringLabel();
        if (DemangledString.hasLabel(program, address, label)) {
            return true;
        }
        if (!super.applyTo(program, address, options, monitor)) {
            return false;
        }
        Symbol s = program.getSymbolTable().getPrimarySymbol(address);
        if (s != null && s.getSymbolType() == SymbolType.FUNCTION) {
            Msg.error((Object)this, (Object)("Failed to demangled string at " + address + " due to existing function"));
            return false;
        }
        CreateStringCmd cmd = new CreateStringCmd(address, -1, this.isUnicode());
        cmd.applyTo((DomainObject)program);
        Symbol demangledSymbol = this.applyDemangledName(label, address, true, false, program);
        return demangledSymbol != null;
    }

    private String buildStringLabel() {
        if (this.specialPrefix != null) {
            return this.getName();
        }
        int len = this.string.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = this.string.charAt(i);
            if (StringUtilities.isDisplayable((int)c) && c != ' ') {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        String prefix = this.isUnicode() ? "u_" : "s_";
        return prefix + buf.toString();
    }

    public String getString() {
        return this.string;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUnicode() {
        return this.unicode;
    }
}

