/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.EmptyTextLine;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EnumDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private static final int MAX_LINE_COUNT = 15;
    private final Enum enumDataType;
    protected List<ValidatableLine> headerContent;
    protected List<ValidatableLine> bodyContent;
    protected TextLine footerLine;
    protected TextLine displayName;
    private static String truncatedHtmlData;

    private EnumDataTypeHTMLRepresentation(Enum enumDataType, List<ValidatableLine> headerLines, TextLine displayName, List<ValidatableLine> bodyContent, TextLine footerLine) {
        this.enumDataType = enumDataType;
        this.headerContent = headerLines;
        this.displayName = displayName;
        this.bodyContent = bodyContent;
        this.footerLine = footerLine;
        this.originalHTMLData = EnumDataTypeHTMLRepresentation.buildHTMLText(this.headerContent, displayName, bodyContent, footerLine, false);
        List<ValidatableLine> trimmedBodyContent = this.buildContent(true);
        truncatedHtmlData = EnumDataTypeHTMLRepresentation.buildHTMLText(this.headerContent, displayName, trimmedBodyContent, footerLine, true);
    }

    public EnumDataTypeHTMLRepresentation(Enum enumDataType) {
        this.enumDataType = enumDataType;
        this.headerContent = this.buildHeaderText((DataType)enumDataType);
        this.bodyContent = this.buildContent(false);
        this.footerLine = this.buildFooterText((DataType)enumDataType);
        this.displayName = new TextLine("enum " + enumDataType.getDisplayName());
        this.originalHTMLData = EnumDataTypeHTMLRepresentation.buildHTMLText(this.headerContent, this.displayName, this.bodyContent, this.footerLine, false);
        List<ValidatableLine> trimmedBodyContent = this.buildContent(true);
        truncatedHtmlData = EnumDataTypeHTMLRepresentation.buildHTMLText(this.headerContent, this.displayName, trimmedBodyContent, this.footerLine, true);
    }

    @Override
    public String getHTMLString() {
        return "<HTML>" + truncatedHtmlData + "</HTML>";
    }

    @Override
    public String getHTMLContentString() {
        return truncatedHtmlData;
    }

    @Override
    protected PlaceHolderLine createPlaceHolderLine(ValidatableLine oppositeLine) {
        if (!(oppositeLine instanceof TextLine)) {
            throw new AssertException("I didn't know you could pass me other types of lines?!");
        }
        TextLine textLine = (TextLine)oppositeLine;
        int stringLength = textLine.getText().length();
        return new EmptyTextLine(stringLength);
    }

    private List<ValidatableLine> buildContent(boolean trim) {
        long[] values = this.enumDataType.getValues();
        Arrays.sort(values);
        int n = this.enumDataType.getLength();
        ArrayList<ValidatableLine> list = new ArrayList<ValidatableLine>(values.length);
        for (long value : values) {
            String name = this.enumDataType.getName(value);
            if (trim) {
                name = StringUtilities.trimMiddle((String)name, (int)80);
            }
            String hexString = Long.toHexString(value);
            if (value < 0L) {
                int length = hexString.length();
                hexString = hexString.substring(length - n * 2);
            }
            String comment = this.enumDataType.getComment(name);
            if (trim && comment != null) {
                comment = StringUtilities.trim((String)comment, (int)80);
            }
            list.add(new TextLine(name + " = 0x" + hexString + "    " + comment));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static String buildHTMLText(List<ValidatableLine> headerLines, TextLine displayName, List<ValidatableLine> bodyLines, TextLine infoLine, boolean trim) {
        void var9_12;
        StringBuilder fullHtml = new StringBuilder();
        StringBuilder truncatedHtml = new StringBuilder();
        int lineCount = 0;
        for (TextLine textLine : headerLines) {
            String encodedHeaderLine = textLine.getText();
            String headerLine = EnumDataTypeHTMLRepresentation.wrapStringInColor(encodedHeaderLine, textLine.getTextColor());
            EnumDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, headerLine);
            ++lineCount;
        }
        EnumDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, "Length: ", infoLine.getText());
        EnumDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, "<BR>", "<BR>");
        String string = displayName.getText();
        if (trim) {
            String string2 = StringUtilities.trimMiddle((String)string, (int)80);
        }
        String string4 = HTMLUtilities.friendlyEncodeHTML((String)var9_12);
        string4 = EnumDataTypeHTMLRepresentation.wrapStringInColor(string4, displayName.getTextColor());
        EnumDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, "<TT>", string4, "</TT>", "&nbsp;", "{", "&nbsp;", "<BR>");
        ++lineCount;
        int length = bodyLines.size();
        int i = 0;
        while (i < length) {
            TextLine textLine = (TextLine)bodyLines.get(i);
            String text = textLine.getText();
            String encodedBodyLine = HTMLUtilities.friendlyEncodeHTML((String)text);
            text = EnumDataTypeHTMLRepresentation.wrapStringInColor(encodedBodyLine, textLine.getTextColor());
            StringBuilder lineBuffer = new StringBuilder();
            lineBuffer.append(TAB).append(text).append("&nbsp;");
            if (i < length - 1) {
                lineBuffer.append("<BR>");
            }
            String lineString = lineBuffer.toString();
            EnumDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount, lineString);
            ++i;
            ++lineCount;
        }
        if (lineCount >= 15) {
            truncatedHtml.append(TAB).append("...").append("<BR>");
        }
        StringBuilder trailingLines = new StringBuilder();
        trailingLines.append("<BR>").append("}").append("<BR>").append("</TT>");
        String trailingString = trailingLines.toString();
        fullHtml.append(trailingString);
        truncatedHtml.append(trailingString);
        if (trim) {
            return truncatedHtml.toString();
        }
        return fullHtml.toString();
    }

    private static void append(StringBuilder fullHtml, StringBuilder truncatedHtml, int lineCount, String ... content) {
        for (String string : content) {
            fullHtml.append(string);
        }
        EnumDataTypeHTMLRepresentation.maybeAppend(truncatedHtml, lineCount, content);
    }

    private static void maybeAppend(StringBuilder buffer, int lineCount, String ... content) {
        if (lineCount > 15) {
            return;
        }
        for (String string : content) {
            buffer.append(string);
        }
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof EnumDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        EnumDataTypeHTMLRepresentation enumRepresentation = (EnumDataTypeHTMLRepresentation)otherRepresentation;
        List<ValidatableLine> header = this.copyLines(this.headerContent);
        List<ValidatableLine> body = this.copyLines(this.bodyContent);
        TextLine diffDisplayName = new TextLine(this.displayName.getText());
        List<ValidatableLine> otherHeader = this.copyLines(enumRepresentation.headerContent);
        List<ValidatableLine> otherBody = this.copyLines(enumRepresentation.bodyContent);
        TextLine otherDiffDisplayName = new TextLine(enumRepresentation.displayName.getText());
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        DataTypeDiff bodyDiff = DataTypeDiffBuilder.diffBody(this.getDiffInput(body), this.getDiffInput(otherBody));
        this.diffTextLine(diffDisplayName, otherDiffDisplayName);
        return new HTMLDataTypeRepresentation[]{new EnumDataTypeHTMLRepresentation(this.enumDataType, headerDiff.getLeftLines(), diffDisplayName, bodyDiff.getLeftLines(), this.footerLine), new EnumDataTypeHTMLRepresentation(enumRepresentation.enumDataType, headerDiff.getRightLines(), otherDiffDisplayName, bodyDiff.getRightLines(), enumRepresentation.footerLine)};
    }
}

