/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.ValidatableLine;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.util.Objects;

public class TextLine
implements ValidatableLine {
    private String text;
    private Color textColor;
    private ValidatableLine validationLine;

    public TextLine(String text) {
        this.text = Objects.requireNonNull(text);
    }

    @Override
    public ValidatableLine copy() {
        return new TextLine(this.text);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isDiffColored() {
        return this.textColor != null;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    boolean matches(TextLine otherLine) {
        return this.text.equals(otherLine.text);
    }

    public String toString() {
        return this.text + this.colorStrig();
    }

    private String colorStrig() {
        return this.textColor == null ? "" : " " + this.textColor.toString();
    }

    @Override
    public boolean isValidated() {
        return this.validationLine != null;
    }

    @Override
    public boolean matches(ValidatableLine otherLine) {
        if (!(otherLine instanceof TextLine)) {
            throw new AssertException("TextLine can only be matched against other TextLine implementations.");
        }
        TextLine textLine = (TextLine)otherLine;
        return this.text.equals(textLine.getText());
    }

    @Override
    public void updateColor(ValidatableLine otherLine, Color invalidColor) {
        if (invalidColor == null) {
            throw new NullPointerException("Color cannot be null");
        }
        if (otherLine == null) {
            this.setTextColor(invalidColor);
            return;
        }
        if (!(otherLine instanceof TextLine)) {
            throw new AssertException("TextLine can only be matched against other TextLine implementations.");
        }
        TextLine textLine = (TextLine)otherLine;
        if (!this.matches(textLine)) {
            this.setTextColor(invalidColor);
            textLine.setTextColor(invalidColor);
        }
    }

    @Override
    public void setValidationLine(ValidatableLine line) {
        if (this.validationLine == line) {
            return;
        }
        this.validationLine = line;
        line.setValidationLine(this);
        this.updateColor(line, INVALID_COLOR);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.textColor == null ? 0 : this.textColor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextLine other = (TextLine)obj;
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return !(this.textColor == null ? other.textColor != null : !this.textColor.equals(other.textColor));
    }
}

