/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class DyldCacheProgramBuilder
extends MachoProgramBuilder {
    private boolean shouldProcessSymbols;
    private boolean shouldCreateDylibSections;
    private boolean shouldAddRelocationEntries;
    private boolean shouldCombineSplitFiles;

    protected DyldCacheProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, boolean shouldProcessSymbols, boolean shouldCreateDylibSections, boolean shouldAddRelocationEntries, boolean shouldCombineSplitFiles, MessageLog log, TaskMonitor monitor) {
        super(program, provider, fileBytes, log, monitor);
        this.shouldProcessSymbols = shouldProcessSymbols;
        this.shouldCreateDylibSections = shouldCreateDylibSections;
        this.shouldAddRelocationEntries = shouldAddRelocationEntries;
        this.shouldCombineSplitFiles = shouldCombineSplitFiles;
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, boolean shouldProcessSymbols, boolean shouldCreateDylibSections, boolean addRelocationEntries, boolean shouldCombineSplitFiles, MessageLog log, TaskMonitor monitor) throws Exception {
        DyldCacheProgramBuilder dyldCacheProgramBuilder = new DyldCacheProgramBuilder(program, provider, fileBytes, shouldProcessSymbols, shouldCreateDylibSections, addRelocationEntries, shouldCombineSplitFiles, log, monitor);
        dyldCacheProgramBuilder.build();
    }

    @Override
    protected void build() throws Exception {
        try (DyldCacheUtils.SplitDyldCache splitDyldCache = new DyldCacheUtils.SplitDyldCache(this.provider, this.shouldProcessSymbols, this.shouldCombineSplitFiles, this.log, this.monitor);){
            ByteProvider bp;
            DyldCacheHeader header;
            int i;
            this.setDyldCacheImageBase(splitDyldCache.getDyldCacheHeader(0));
            for (i = 0; i < splitDyldCache.size(); ++i) {
                header = splitDyldCache.getDyldCacheHeader(i);
                bp = splitDyldCache.getProvider(i);
                this.processDyldCacheMemoryBlocks(header, bp);
            }
            for (i = 0; i < splitDyldCache.size(); ++i) {
                header = splitDyldCache.getDyldCacheHeader(i);
                bp = splitDyldCache.getProvider(i);
                this.fixPageChains(header);
                this.markupHeaders(header);
                this.markupBranchIslands(header, bp);
                this.createSymbols(header);
                this.processDylibs(header, bp);
            }
        }
    }

    private void setDyldCacheImageBase(DyldCacheHeader dyldCacheHeader) throws Exception {
        this.monitor.setMessage("Setting image base...");
        this.monitor.initialize(1L);
        this.program.setImageBase(this.space.getAddress(dyldCacheHeader.getBaseAddress()), true);
        this.monitor.incrementProgress(1L);
    }

    private void processDyldCacheMemoryBlocks(DyldCacheHeader dyldCacheHeader, ByteProvider bp) throws Exception {
        List<DyldCacheMappingInfo> mappingInfos = dyldCacheHeader.getMappingInfos();
        this.monitor.setMessage("Processing DYLD mapped memory blocks...");
        this.monitor.initialize((long)mappingInfos.size());
        FileBytes fb = MemoryBlockUtils.createFileBytes(this.program, bp, this.monitor);
        long endOfMappedOffset = 0L;
        for (DyldCacheMappingInfo mappingInfo : mappingInfos) {
            long offset = mappingInfo.getFileOffset();
            long size = mappingInfo.getSize();
            MemoryBlockUtils.createInitializedBlock(this.program, false, "DYLD", this.space.getAddress(mappingInfo.getAddress()), fb, offset, size, "", "", mappingInfo.isRead(), mappingInfo.isWrite(), mappingInfo.isExecute(), this.log);
            if (offset + size > endOfMappedOffset) {
                endOfMappedOffset = offset + size;
            }
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
        if (endOfMappedOffset < bp.length()) {
            this.monitor.setMessage("Processing DYLD unmapped memory block...");
            MemoryBlockUtils.createInitializedBlock(this.program, true, "FILE", AddressSpace.OTHER_SPACE.getAddress(endOfMappedOffset), fb, endOfMappedOffset, bp.length() - endOfMappedOffset, "Useful bytes that don't get mapped into memory", "", false, false, false, this.log);
        }
    }

    private void markupHeaders(DyldCacheHeader dyldCacheHeader) throws Exception {
        this.monitor.setMessage("Marking up DYLD headers...");
        this.monitor.initialize(1L);
        dyldCacheHeader.parseFromMemory(this.program, this.space, this.log, this.monitor);
        dyldCacheHeader.markup(this.program, this.space, this.monitor, this.log);
        this.monitor.incrementProgress(1L);
    }

    private void markupBranchIslands(DyldCacheHeader dyldCacheHeader, ByteProvider bp) throws Exception {
        this.monitor.setMessage("Marking up DYLD branch islands...");
        this.monitor.initialize((long)dyldCacheHeader.getBranchPoolAddresses().size());
        for (Long addr : dyldCacheHeader.getBranchPoolAddresses()) {
            try {
                MachHeader header = MachHeader.createMachHeader((GenericFactory)MessageLogContinuesFactory.create((MessageLog)this.log), bp, addr - dyldCacheHeader.getBaseAddress());
                header.parse();
                super.markupHeaders(header, this.space.getAddress(addr.longValue()));
            }
            catch (MachException | IOException exception) {
                // empty catch block
            }
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
    }

    private void createSymbols(DyldCacheHeader dyldCacheHeader) throws Exception {
        DyldCacheLocalSymbolsInfo localSymbolsInfo = dyldCacheHeader.getLocalSymbolsInfo();
        if (localSymbolsInfo != null) {
            this.monitor.setMessage("Processing DYLD symbols...");
            this.monitor.initialize((long)localSymbolsInfo.getNList().size());
            for (NList nlist : localSymbolsInfo.getNList()) {
                if (!nlist.getString().trim().isEmpty()) {
                    try {
                        this.program.getSymbolTable().createLabel(this.space.getAddress(nlist.getValue()), SymbolUtilities.replaceInvalidChars((String)nlist.getString(), (boolean)true), this.program.getGlobalNamespace(), SourceType.IMPORTED);
                    }
                    catch (Exception e) {
                        this.log.appendMsg(e.getMessage() + " " + nlist.getString());
                    }
                }
                this.monitor.checkCanceled();
                this.monitor.incrementProgress(1L);
            }
        }
    }

    private void fixPageChains(DyldCacheHeader dyldCacheHeader) throws MemoryAccessException, CancelledException {
        List<DyldCacheSlideInfoCommon> slideInfos = dyldCacheHeader.getSlideInfos();
        for (DyldCacheSlideInfoCommon info : slideInfos) {
            int version = info.getVersion();
            this.log.appendMsg("Fixing page chains version: " + version);
            info.fixPageChains(this.program, dyldCacheHeader, this.shouldAddRelocationEntries, this.log, this.monitor);
        }
    }

    private void processDylibs(DyldCacheHeader dyldCacheHeader, ByteProvider bp) throws Exception {
        this.monitor.setMessage("Parsing DYLIB's...");
        TreeSet<DyldCacheMachoInfo> infoSet = new TreeSet<DyldCacheMachoInfo>((a, b) -> a.headerAddr.compareTo((Object)b.headerAddr));
        List<DyldCacheImage> mappedImages = dyldCacheHeader.getMappedImages();
        this.monitor.initialize((long)mappedImages.size());
        for (DyldCacheImage mappedImage : mappedImages) {
            infoSet.add(new DyldCacheMachoInfo(bp, mappedImage.getAddress() - dyldCacheHeader.getBaseAddress(), this.space.getAddress(mappedImage.getAddress()), mappedImage.getPath()));
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
        this.monitor.setMessage("Marking up DYLIB headers...");
        this.monitor.initialize((long)infoSet.size());
        for (DyldCacheMachoInfo info : infoSet) {
            info.markupHeaders();
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
        this.monitor.setMessage("Adding DYLIB's to program tree...");
        this.monitor.initialize((long)infoSet.size());
        Iterator iter = infoSet.iterator();
        if (iter.hasNext()) {
            DyldCacheMachoInfo curr = (DyldCacheMachoInfo)iter.next();
            do {
                DyldCacheMachoInfo next = iter.hasNext() ? (DyldCacheMachoInfo)iter.next() : null;
                try {
                    curr.addToProgramTree(dyldCacheHeader, next);
                }
                catch (DuplicateNameException exc) {
                    this.log.appendException((Throwable)exc);
                }
                curr = next;
                this.monitor.checkCanceled();
                this.monitor.incrementProgress(1L);
            } while (iter.hasNext());
        }
        this.monitor.setMessage("Processing DYLIB memory blocks...");
        this.monitor.initialize((long)infoSet.size());
        for (DyldCacheMachoInfo info : infoSet) {
            info.processMemoryBlocks();
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
        }
    }

    private class DyldCacheMachoInfo {
        private Address headerAddr;
        private MachHeader header;
        private String path;
        private String name;

        public DyldCacheMachoInfo(ByteProvider provider, long offset, Address headerAddr, String path) throws Exception {
            this.headerAddr = headerAddr;
            this.header = MachHeader.createMachHeader((GenericFactory)MessageLogContinuesFactory.create((MessageLog)DyldCacheProgramBuilder.this.log), provider, offset, false);
            this.header.parse();
            this.path = path;
            this.name = new File(path).getName();
        }

        public void processMemoryBlocks() throws Exception {
            DyldCacheProgramBuilder.this.processMemoryBlocks(this.header, this.name, DyldCacheProgramBuilder.this.shouldCreateDylibSections, false);
        }

        public void markupHeaders() throws Exception {
            DyldCacheProgramBuilder.this.markupHeaders(this.header, this.headerAddr);
            if (!this.name.isEmpty()) {
                DyldCacheProgramBuilder.this.listing.setComment(this.headerAddr, 3, this.path);
            }
        }

        public void addToProgramTree(DyldCacheHeader dyldCacheHeader, DyldCacheMachoInfo next) throws Exception {
            ProgramFragment fragment = DyldCacheProgramBuilder.this.listing.getDefaultRootModule().createFragment(this.path);
            if (next != null) {
                fragment.move(this.headerAddr, next.headerAddr.subtract(1L));
            } else {
                for (DyldCacheMappingInfo mappingInfo : dyldCacheHeader.getMappingInfos()) {
                    Address mappingAddr = DyldCacheProgramBuilder.this.space.getAddress(mappingInfo.getAddress());
                    if (this.headerAddr.compareTo((Object)mappingAddr) < 0 || this.headerAddr.compareTo((Object)mappingAddr.add(mappingInfo.getSize() - 1L)) > 0) continue;
                    fragment.move(this.headerAddr, mappingAddr.add(mappingInfo.getSize() - 1L));
                }
            }
        }
    }
}

