/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.elf.ElfDynamic;
import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfStringTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.app.util.bin.format.elf.GnuBuildIdSection;
import ghidra.app.util.bin.format.elf.GnuDebugLinkSection;
import ghidra.app.util.bin.format.elf.extend.ElfLoadAdapter;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandlerFactory;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.ElfLoaderOptionsFactory;
import ghidra.app.util.opinion.MemorySectionResolver;
import ghidra.docking.settings.Settings;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.register.AddressRangeObjectMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.datastruct.IndexRange;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.datastruct.RangeMap;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class ElfProgramBuilder
extends MemorySectionResolver
implements ElfLoadHelper {
    public static final String BLOCK_SOURCE_NAME = "Elf Loader";
    private static final String SEGMENT_NAME_PREFIX = "segment_";
    private static final String UNALLOCATED_NAME_PREFIX = "unallocated_";
    private static final String ELF_HEADER_BLOCK_NAME = "_elfHeader";
    private static final String ELF_PROGRAM_HEADERS_BLOCK_NAME = "_elfProgramHeaders";
    private static final String ELF_SECTION_HEADERS_BLOCK_NAME = "_elfSectionHeaders";
    private static final int DISCARDABLE_SEGMENT_SIZE = 255;
    private List<Option> options;
    private Long dataImageBase;
    private MessageLog log;
    private ElfHeader elf;
    private FileBytes fileBytes;
    private Listing listing;
    private Memory memory;
    private HashMap<ElfSymbol, Address> symbolMap = new HashMap();
    private static final Integer AVAILABLE_MEMORY = 1;
    private static final Integer ALLOCATED_MEMORY = 2;
    private AddressSet allocatedRegions = new AddressSet();
    private AddressRange externalBlockLimits;
    private Address lastExternalBlockEntryAddress;
    private Address nextExternalBlockEntryAddress;

    protected ElfProgramBuilder(ElfHeader elf, Program program, List<Option> options, MessageLog log) {
        super(program);
        this.elf = elf;
        this.options = options;
        this.log = log;
        this.memory = program.getMemory();
        this.listing = program.getListing();
    }

    @Override
    public ElfHeader getElfHeader() {
        return this.elf;
    }

    static void loadElf(ElfHeader elf, Program program, List<Option> options, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ElfProgramBuilder elfProgramBuilder = new ElfProgramBuilder(elf, program, options, log);
        elfProgramBuilder.load(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Completing ELF header parsing...");
        monitor.setCancelEnabled(false);
        this.elf.parse();
        monitor.setCancelEnabled(true);
        int id = this.program.startTransaction("Load ELF program");
        boolean success = false;
        try {
            this.addProgramProperties(monitor);
            this.setImageBase();
            this.program.setExecutableFormat("Executable and Linking Format (ELF)");
            ByteProvider byteProvider = this.elf.getReader().getByteProvider();
            try (InputStream fileIn = byteProvider.getInputStream(0L);){
                this.fileBytes = this.program.getMemory().createFileBytes(byteProvider.getName(), 0L, byteProvider.length(), fileIn, monitor);
            }
            this.adjustSegmentAndSectionFileAllocations(byteProvider);
            this.processProgramHeaders(monitor);
            this.processSectionHeaders(monitor);
            this.resolve(monitor);
            if (this.elf.e_shnum() == 0) {
                this.expandProgramHeaderBlocks(monitor);
            }
            if (this.memory.isEmpty()) {
                success = true;
                return;
            }
            this.markupElfHeader(monitor);
            this.markupProgramHeaders(monitor);
            this.markupSectionHeaders(monitor);
            this.markupDynamicTable(monitor);
            this.markupInterpreter(monitor);
            this.processStringTables(monitor);
            this.processSymbolTables(monitor);
            this.elf.getLoadAdapter().processElf(this, monitor);
            this.processEntryPoints(monitor);
            this.processRelocations(monitor);
            this.processImports(monitor);
            monitor.setMessage("Processing PLT/GOT ...");
            this.elf.getLoadAdapter().processGotPlt(this, monitor);
            this.markupHashTable(monitor);
            this.markupGnuHashTable(monitor);
            this.markupGnuBuildId(monitor);
            this.markupGnuDebugLink(monitor);
            this.processGNU(monitor);
            this.processGNU_readOnly(monitor);
            success = true;
        }
        finally {
            this.program.endTransaction(id, success);
        }
    }

    private void adjustSegmentAndSectionFileAllocations(ByteProvider byteProvider) throws IOException {
        int sectionHeaderSize;
        long offset;
        long size;
        RangeMap fileMap = new RangeMap();
        fileMap.paintRange(0L, byteProvider.length() - 1L, -1);
        ElfProgramHeader[] segments = this.elf.getProgramHeaders();
        ElfSectionHeader[] sections = this.elf.getSections();
        for (ElfProgramHeader elfProgramHeader : segments) {
            if (elfProgramHeader.getType() == 0) continue;
            size = elfProgramHeader.getFileSize();
            offset = elfProgramHeader.getOffset();
            if (size <= 0L) continue;
            fileMap.paintRange(offset, offset + size - 1L, -2);
        }
        for (StructConverter structConverter : sections) {
            if (((ElfSectionHeader)structConverter).getType() == 0 || ((ElfSectionHeader)structConverter).getType() == 8) continue;
            ((ElfSectionHeader)structConverter).getSize();
            ((ElfSectionHeader)structConverter).getOffset();
            size = ((ElfSectionHeader)structConverter).getSize();
            offset = ((ElfSectionHeader)structConverter).getOffset();
            if (size <= 0L) continue;
            fileMap.paintRange(offset, offset + size - 1L, -3);
        }
        int elfHeaderSize = this.elf.toDataType().getLength();
        fileMap.paintRange(0L, (long)(elfHeaderSize - 1), -4);
        int programHeaderSize = this.elf.e_phentsize() * this.elf.e_phnum();
        if (programHeaderSize != 0) {
            fileMap.paintRange(this.elf.e_phoff(), this.elf.e_phoff() + (long)programHeaderSize - 1L, -4);
        }
        if ((sectionHeaderSize = this.elf.e_shentsize() * this.elf.e_shnum()) != 0) {
            fileMap.paintRange(this.elf.e_shoff(), this.elf.e_shoff() + (long)sectionHeaderSize - 1L, -4);
        }
        IndexRangeIterator indexRangeIterator = fileMap.getIndexRangeIterator(0L);
        int unallocatedIndex = 0;
        while (indexRangeIterator.hasNext()) {
            long length;
            long start;
            IndexRange range = indexRangeIterator.next();
            int value = fileMap.getValue(range.getStart());
            if (value != -1 || this.isZeroFilledFileRegion(byteProvider, start = range.getStart(), length = range.getEnd() - start + 1L)) continue;
            String name = UNALLOCATED_NAME_PREFIX + unallocatedIndex++;
            try {
                this.addInitializedMemorySection(null, start, length, AddressSpace.OTHER_SPACE.getMinAddress(), name, false, false, false, null, false, false);
            }
            catch (AddressOverflowException addressOverflowException) {}
        }
    }

    private boolean isZeroFilledFileRegion(ByteProvider byteProvider, long start, long length) throws IOException {
        byte[] bytes;
        int bufSize = 16384;
        if (length < (long)bufSize) {
            bufSize = (int)length;
        }
        for (long remaining = length; remaining > 0L; remaining -= (long)bytes.length) {
            bytes = byteProvider.readBytes(start, Math.min(remaining, (long)bufSize));
            if (this.isZeroedArray(bytes, bytes.length)) continue;
            return false;
        }
        return true;
    }

    private boolean isZeroedArray(byte[] bytes, int len) {
        for (int i = 0; i < len; ++i) {
            if (bytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isDiscardableFillerSegment(MemoryLoadable loadable, String blockName, Address start, long fileOffset, long length) throws IOException {
        if (this.elf.e_shnum() == 0 || this.elf.e_phnum() == 0) {
            return false;
        }
        if (length > 255L || !blockName.startsWith(SEGMENT_NAME_PREFIX)) {
            return false;
        }
        if (this.elf.getLoadAdapter().hasFilteredLoadInputStream(this, loadable, start)) {
            try (InputStream dataInput = this.getInitializedBlockInputStream(loadable, start, fileOffset, length);){
                byte[] bytes = new byte[(int)length];
                boolean bl = dataInput.read(bytes) == bytes.length && this.isZeroedArray(bytes, bytes.length);
                return bl;
            }
        }
        byte[] bytes = new byte[(int)length];
        return this.fileBytes.getModifiedBytes(fileOffset, bytes) == bytes.length && this.isZeroedArray(bytes, bytes.length);
    }

    @Override
    public MessageLog getLog() {
        return this.log;
    }

    @Override
    public void log(String msg) {
        this.log.appendMsg(msg);
    }

    @Override
    public void log(Throwable t) {
        this.log.appendException(t);
    }

    private void setImageBase() {
        if (!ElfLoaderOptionsFactory.hasImageBaseOption(this.options)) {
            this.log("Using existing program image base of " + this.program.getImageBase());
            return;
        }
        try {
            AddressSpace defaultSpace = this.getDefaultAddressSpace();
            Address imageBase = null;
            String imageBaseStr = ElfLoaderOptionsFactory.getImageBaseOption(this.options);
            if (imageBaseStr == null) {
                imageBase = defaultSpace.getAddress(this.elf.getImageBase(), true);
            } else {
                long imageBaseOffset = NumericUtilities.parseHexLong((String)imageBaseStr);
                imageBase = defaultSpace.getAddress(imageBaseOffset, true);
            }
            this.program.setImageBase(imageBase, true);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Can't set image base.", (Throwable)e);
        }
    }

    private long getImageDataBase() {
        if (this.dataImageBase == null) {
            this.dataImageBase = 0L;
            String imageBaseStr = ElfLoaderOptionsFactory.getDataImageBaseOption(this.options);
            if (imageBaseStr != null) {
                this.dataImageBase = NumericUtilities.parseHexLong((String)imageBaseStr);
            }
        }
        return this.dataImageBase;
    }

    private void addProgramProperties(TaskMonitor monitor) throws CancelledException {
        ElfSymbolTable[] symbolTables;
        String elfFileType;
        monitor.checkCanceled();
        monitor.setMessage("Adding program properties...");
        Options props = this.program.getOptions("Program Information");
        props.setString("ELF Original Image Base", "0x" + Long.toHexString(this.elf.getImageBase()));
        props.setBoolean("ELF Prelinked", this.elf.isPreLinked());
        boolean isRelocatable = false;
        switch (this.elf.e_type()) {
            case 0: {
                elfFileType = "unspecified";
                break;
            }
            case 1: {
                elfFileType = "relocatable";
                isRelocatable = true;
                break;
            }
            case 2: {
                elfFileType = "executable";
                break;
            }
            case 3: {
                elfFileType = "shared object";
                isRelocatable = true;
                break;
            }
            case 4: {
                elfFileType = "core";
                isRelocatable = true;
                break;
            }
            default: {
                elfFileType = "unknown";
            }
        }
        props.setString("ELF File Type", elfFileType);
        props.setBoolean("Relocatable", isRelocatable);
        int fileIndex = 0;
        for (ElfSymbolTable symbolTable : symbolTables = this.elf.getSymbolTables()) {
            String[] files;
            monitor.checkCanceled();
            for (String file : files = symbolTable.getSourceFiles()) {
                monitor.checkCanceled();
                props.setString("ELF Source File [" + this.pad(fileIndex++) + "]", file);
            }
        }
        int libraryIndex = 0;
        ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
        if (dynamicTable != null) {
            String[] neededLibs;
            for (String neededLib : neededLibs = this.elf.getDynamicLibraryNames()) {
                monitor.checkCanceled();
                props.setString("ELF Required Library [" + this.pad(libraryIndex++) + "]", neededLib);
            }
        }
    }

    private AddressRange getMarkupMemoryRangeConstraint(Address addr) {
        MemoryBlock block = this.memory.getBlock(addr);
        if (block == null) {
            return null;
        }
        return new AddressRangeImpl(addr, block.getEnd());
    }

    private void processGNU(TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        Address versionTableAddr = null;
        ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
        if (dynamicTable != null) {
            try {
                long versionTableAddrOffset = dynamicTable.getDynamicValue(ElfDynamicType.DT_VERSYM);
                versionTableAddr = this.getDefaultAddress(versionTableAddrOffset);
            }
            catch (NotFoundException versionTableAddrOffset) {
                // empty catch block
            }
        }
        if (versionTableAddr == null) {
            ElfSectionHeader[] sections = this.elf.getSections(0x6FFFFFFF);
            if (sections.length == 0) {
                return;
            }
            versionTableAddr = this.findLoadAddress(sections[0], 0L);
        }
        if (versionTableAddr == null) {
            return;
        }
        AddressRange markupRange = this.getMarkupMemoryRangeConstraint(versionTableAddr);
        if (markupRange == null) {
            return;
        }
        WordDataType WORD = new WordDataType();
        ElfSymbolTable symtab = this.elf.getDynamicSymbolTable();
        if (symtab == null) {
            return;
        }
        ElfSymbol[] symbols = symtab.getSymbols();
        int maxCnt = Math.min((int)(markupRange.getLength() / 2L), symbols.length);
        Address nextAddr = versionTableAddr;
        for (int index = 0; index < maxCnt; ++index) {
            Data cu = null;
            try {
                cu = this.listing.createData(nextAddr, (DataType)WORD);
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {
            }
            catch (DataTypeConflictException dataTypeConflictException) {
                // empty catch block
            }
            if (cu == null) {
                cu = this.listing.getCodeUnitAt(nextAddr);
            }
            if (cu != null) {
                String comment = null;
                comment = symbols[index].getNameAsString();
                if (comment == null) {
                    comment = Long.toHexString(symbols[index].getValue());
                }
                cu.setComment(0, comment);
            }
            try {
                nextAddr = nextAddr.add(2L);
                continue;
            }
            catch (AddressOutOfBoundsException e) {
                break;
            }
        }
    }

    private void processGNU_readOnly(TaskMonitor monitor) {
        if (this.elf.e_shentsize() != 0) {
            return;
        }
        monitor.setMessage("Processing GNU Definitions");
        for (ElfProgramHeader roSegment : this.elf.getProgramHeaders(1685382482)) {
            ElfProgramHeader loadedSegment = this.elf.getProgramLoadHeaderContaining(roSegment.getVirtualAddress());
            if (loadedSegment == null) continue;
            for (AddressRange blockRange : this.getResolvedLoadAddresses(loadedSegment)) {
                MemoryBlock block = this.memory.getBlock(blockRange.getMinAddress());
                if (block == null) continue;
                this.log("Setting block " + block.getName() + " to read-only based upon PT_GNU_RELRO data");
                block.setWrite(false);
            }
        }
    }

    private void processEntryPoints(TaskMonitor monitor) throws CancelledException {
        Address entryAddr;
        monitor.checkCanceled();
        monitor.setMessage("Creating entry points...");
        long entry = this.elf.e_entry();
        if (entry != 0L && (entryAddr = this.createEntryFunction("entry", entry, monitor)) != null) {
            this.addElfHeaderReferenceMarkup(this.elf.getEntryComponentOrdinal(), entryAddr);
        }
        this.createDynamicEntryPoints(ElfDynamicType.DT_INIT, null, "_INIT_", monitor);
        this.createDynamicEntryPoints(ElfDynamicType.DT_INIT_ARRAY, ElfDynamicType.DT_INIT_ARRAYSZ, "_INIT_", monitor);
        this.createDynamicEntryPoints(ElfDynamicType.DT_PREINIT_ARRAY, ElfDynamicType.DT_PREINIT_ARRAYSZ, "_PREINIT_", monitor);
        this.createDynamicEntryPoints(ElfDynamicType.DT_FINI, null, "_FINI_", monitor);
        this.createDynamicEntryPoints(ElfDynamicType.DT_FINI_ARRAY, ElfDynamicType.DT_FINI_ARRAYSZ, "_FINI_", monitor);
    }

    private void createDynamicEntryPoints(ElfDynamicType dynamicEntryType, ElfDynamicType entryArraySizeType, String baseName, TaskMonitor monitor) {
        ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
        if (dynamicTable == null) {
            return;
        }
        try {
            Address addr;
            Data data;
            long entryAddrOffset = this.elf.adjustAddressForPrelink(dynamicTable.getDynamicValue(dynamicEntryType));
            if (entryArraySizeType == null) {
                this.createEntryFunction("_" + dynamicEntryType.name, entryAddrOffset, monitor);
                return;
            }
            DWordDataType dt = this.elf.is32Bit() ? DWordDataType.dataType : QWordDataType.dataType;
            Address entryArrayAddr = this.getDefaultAddress(entryAddrOffset);
            long arraySize = dynamicTable.getDynamicValue(entryArraySizeType);
            long elementCount = arraySize / (long)dt.getLength();
            int i = 0;
            while ((long)i < elementCount && (data = this.createData(addr = entryArrayAddr.add((long)(i * dt.getLength())), (DataType)dt)) != null) {
                Scalar value = (Scalar)data.getValue();
                if (value != null && (i == 0 || value.getValue() != 0L)) {
                    long funcAddrOffset = this.elf.adjustAddressForPrelink(value.getValue());
                    Address funcAddr = this.createEntryFunction(baseName + i, funcAddrOffset, monitor);
                    if (funcAddr != null) {
                        data.addOperandReference(0, funcAddr, RefType.DATA, SourceType.ANALYSIS);
                    }
                }
                ++i;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private Address createEntryFunction(String name, long entryAddr, TaskMonitor monitor) {
        Address entryAddress = this.getDefaultAddressSpace().getTruncatedAddress(entryAddr += this.getImageBaseWordAdjustmentOffset(), true);
        MemoryBlock block = this.memory.getBlock(entryAddress);
        if (block == null || !block.isExecute()) {
            return entryAddress;
        }
        entryAddress = this.elf.getLoadAdapter().creatingFunction(this, entryAddress);
        Function function = this.program.getFunctionManager().getFunctionAt(entryAddress);
        if (function != null) {
            this.program.getSymbolTable().addExternalEntryPoint(entryAddress);
            return entryAddress;
        }
        try {
            this.createOneByteFunction(name, entryAddress, true);
        }
        catch (Exception e) {
            this.log("Could not create symbol at entry point: " + this.getMessage(e));
        }
        return entryAddress;
    }

    private String getMessage(Exception e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.toString();
        }
        return msg;
    }

    private void markupInterpreter(TaskMonitor monitor) throws CancelledException {
        ElfSectionHeader interpSection;
        monitor.checkCanceled();
        monitor.setMessage("Processing interpreter...");
        Address interpStrAddr = null;
        ElfProgramHeader[] interpProgramHeaders = this.elf.getProgramHeaders(3);
        if (interpProgramHeaders.length != 0) {
            long offset = interpProgramHeaders[0].getOffset();
            if (offset == 0L) {
                Msg.warn((Object)this, (Object)"ELF PT_INTERP appears to have been stripped from binary");
                return;
            }
            interpStrAddr = this.findLoadAddress(interpProgramHeaders[0].getOffset(), 1L);
        }
        if (interpStrAddr == null && (interpSection = this.elf.getSection(".interp")) != null) {
            interpStrAddr = this.findLoadAddress(interpSection, 0L);
        }
        if (interpStrAddr == null) {
            return;
        }
        this.createData(interpStrAddr, (DataType)TerminatedStringDataType.dataType);
        this.listing.setComment(interpStrAddr, 0, "Initial Elf program interpreter");
    }

    private void processImports(TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        monitor.setMessage("Processing imports...");
        ExternalManager extManager = this.program.getExternalManager();
        ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
        if (dynamicTable != null) {
            String[] neededLibs;
            for (String neededLib : neededLibs = this.elf.getDynamicLibraryNames()) {
                try {
                    extManager.setExternalPath(neededLib, null, false);
                }
                catch (InvalidInputException e) {
                    this.log("Bad library name: " + neededLib);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRelocations(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Processing relocation tables...");
        ElfRelocationTable[] relocationTables = this.elf.getRelocationTables();
        if (relocationTables.length == 0) {
            return;
        }
        boolean processRelocations = ElfLoaderOptionsFactory.performRelocations(this.options);
        if (processRelocations && ElfRelocationHandlerFactory.getHandler(this.elf) == null) {
            this.log("ELF relocation handler extension not found!  Unable to process relocations.");
        }
        Address defaultBase = this.getDefaultAddress(this.elf.adjustAddressForPrelink(0L));
        AddressSpace defaultSpace = defaultBase.getAddressSpace();
        long defaultBaseOffset = defaultBase.getAddressableWordOffset();
        int totalCount = 0;
        for (ElfRelocationTable relocationTable : relocationTables) {
            totalCount += relocationTable.getRelocationCount();
        }
        monitor.initialize((long)totalCount);
        for (ElfRelocationTable relocationTable : relocationTables) {
            monitor.checkCanceled();
            Address relocTableAddr = null;
            ElfSectionHeader section = relocationTable.getTableSectionHeader();
            relocTableAddr = section != null ? this.findLoadAddress(section, 0L) : this.findLoadAddress(relocationTable.getFileOffset(), 1L);
            AddressSpace relocationSpace = defaultSpace;
            long baseOffset = defaultBaseOffset;
            ElfSectionHeader sectionToBeRelocated = relocationTable.getSectionToBeRelocated();
            if (sectionToBeRelocated != null) {
                Address sectionLoadAddr = this.findLoadAddress(sectionToBeRelocated, 0L);
                if (sectionLoadAddr == null) {
                    this.log("Failed to identify relocation base address for relocation table 0x" + relocationTable.getAddressOffset() + " [section: " + sectionToBeRelocated.getNameAsString() + "]");
                    monitor.incrementProgress((long)relocationTable.getRelocationCount());
                    continue;
                }
                relocationSpace = sectionLoadAddr.getAddressSpace();
                if (this.elf.isRelocatable()) {
                    baseOffset = sectionLoadAddr.getAddressableWordOffset();
                } else if (relocationSpace != defaultSpace) {
                    baseOffset = 0L;
                }
            }
            if (relocTableAddr != null) {
                this.markupRelocationTable(relocTableAddr, relocationTable, monitor);
            }
            ElfRelocationContext context = null;
            if (processRelocations) {
                context = ElfRelocationContext.getRelocationContext(this, relocationTable, this.symbolMap);
            }
            try {
                this.processRelocationTable(relocationTable, context, relocationSpace, baseOffset, monitor);
            }
            finally {
                if (context != null) {
                    context.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRelocationTable(ElfRelocationTable relocationTable, ElfRelocationContext context, AddressSpace relocationSpace, long baseWordOffset, TaskMonitor monitor) throws CancelledException {
        ElfSymbol[] symbols = relocationTable.getAssociatedSymbolTable().getSymbols();
        ElfRelocation[] relocs = relocationTable.getRelocations();
        boolean relrTypeUnknown = false;
        long relrRelocationType = 0L;
        if (relocationTable.isRelrTable() && context != null && (relrRelocationType = context.getRelrRelocationType()) == 0L) {
            relrTypeUnknown = true;
            this.log("Failed to process RELR relocations - extension does not define RELR type");
        }
        for (ElfRelocation reloc : relocs) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            int symbolIndex = reloc.getSymbolIndex();
            String symbolName = null;
            if (symbolIndex >= 0 && symbolIndex < symbols.length) {
                symbolName = symbols[symbolIndex].getNameAsString();
            }
            Address baseAddress = relocationSpace.getTruncatedAddress(baseWordOffset, true);
            Address relocAddr = context != null ? context.getRelocationAddress(baseAddress, reloc.getOffset()) : baseAddress.addWrap(reloc.getOffset());
            long[] values = new long[]{reloc.getSymbolIndex()};
            byte[] bytes = this.elf.is64Bit() ? new byte[8] : new byte[4];
            long type = reloc.getType();
            if (relrRelocationType != 0L) {
                type = relrRelocationType;
                reloc.setType(relrRelocationType);
            }
            try {
                MemoryBlock relocBlock = this.memory.getBlock(relocAddr);
                if (relocBlock == null) {
                    throw new MemoryAccessException("Block is non-existent");
                }
                if (!relocBlock.isInitialized()) {
                    try {
                        this.memory.convertToInitialized(relocBlock, (byte)0);
                    }
                    catch (Exception e) {
                        Msg.error((Object)this, (Object)"Unexpected Exception", (Throwable)e);
                        ElfRelocationHandler.markAsUninitializedMemory(this.program, relocAddr, type, reloc.getSymbolIndex(), symbolName, this.log);
                        this.program.getRelocationTable().add(relocAddr, reloc.getType(), values, bytes, symbolName);
                        continue;
                    }
                }
                this.memory.getBytes(relocAddr, bytes);
                if (context == null) continue;
                if (relrTypeUnknown) {
                    ElfRelocationHandler.markAsUnsupportedRelr(this.program, relocAddr);
                    continue;
                }
                context.processRelocation(reloc, relocAddr);
            }
            catch (MemoryAccessException e) {
                if (type == 0L) continue;
                this.log("Unable to perform relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") at " + relocAddr + " (Symbol = " + symbolName + ") - " + this.getMessage((Exception)((Object)e)));
            }
            finally {
                this.program.getRelocationTable().add(relocAddr, reloc.getType(), values, bytes, symbolName);
            }
        }
    }

    @Override
    public long getOriginalValue(Address addr, boolean signExtend) throws MemoryAccessException {
        byte[] bytes;
        int len = this.elf.is64Bit() ? 8 : 4;
        Relocation relocation = this.program.getRelocationTable().getRelocation(addr);
        if (relocation == null) {
            bytes = new byte[len];
            this.memory.getBytes(addr, bytes);
        } else {
            bytes = relocation.getBytes();
        }
        DataConverter dataConverter = DataConverter.getInstance((boolean)this.elf.isBigEndian());
        return signExtend ? dataConverter.getSignedValue(bytes, len) : dataConverter.getValue(bytes, len);
    }

    private void addElfHeaderReferenceMarkup(int componentOrdinal, Address refAddr) {
        Data data;
        Structure struct = (Structure)this.elf.toDataType();
        Address headerAddr = this.findLoadAddress(0L, (long)struct.getLength());
        if (headerAddr == null) {
            MemoryBlock block = this.memory.getBlock(ELF_HEADER_BLOCK_NAME);
            if (block == null) {
                return;
            }
            headerAddr = block.getStart();
        }
        if ((data = this.listing.getDefinedDataAt(headerAddr)) == null || !data.getDataType().isEquivalent((DataType)struct)) {
            return;
        }
        Data component = data.getComponent(componentOrdinal);
        if (component != null) {
            component.addOperandReference(0, refAddr, RefType.DATA, SourceType.IMPORTED);
        }
    }

    private void markupElfHeader(TaskMonitor monitor) {
        DataType dt = this.elf.toDataType();
        Address headerAddr = this.findLoadAddress(0L, (long)dt.getLength());
        try {
            if (headerAddr == null) {
                if (!ElfLoaderOptionsFactory.includeOtherBlocks(this.options)) {
                    return;
                }
                headerAddr = AddressSpace.OTHER_SPACE.getAddress(0L);
                MemoryBlock block = this.createInitializedBlock(null, true, ELF_HEADER_BLOCK_NAME, headerAddr, 0L, this.elf.e_ehsize(), "Elf File Header", false, false, false, monitor);
                headerAddr = block.getStart();
            }
            this.createData(headerAddr, dt);
        }
        catch (Exception e) {
            this.log("Failed to markup Elf header: " + this.getMessage(e));
        }
    }

    private void markupProgramHeaders(TaskMonitor monitor) {
        short headerCount = this.elf.e_phnum();
        int size = this.elf.e_phentsize() * headerCount;
        if (size == 0) {
            return;
        }
        Structure phStructDt = (Structure)this.elf.getProgramHeaders()[0].toDataType();
        phStructDt = phStructDt.clone((DataTypeManager)this.program.getDataTypeManager());
        ArrayDataType arrayDt = new ArrayDataType((DataType)phStructDt, (int)headerCount, size);
        Address headerAddr = this.findLoadAddress(this.elf.e_phoff(), (long)size);
        try {
            if (headerAddr == null) {
                if (!ElfLoaderOptionsFactory.includeOtherBlocks(this.options)) {
                    return;
                }
                headerAddr = AddressSpace.OTHER_SPACE.getAddress(0L);
                MemoryBlock block = this.createInitializedBlock(null, true, ELF_PROGRAM_HEADERS_BLOCK_NAME, headerAddr, this.elf.e_phoff(), arrayDt.getLength(), "Elf Program Headers", false, false, false, monitor);
                headerAddr = block.getStart();
            }
            this.addElfHeaderReferenceMarkup(this.elf.getPhoffComponentOrdinal(), headerAddr);
            Data array = this.createData(headerAddr, (DataType)arrayDt);
            ElfProgramHeader[] programHeaders = this.elf.getProgramHeaders();
            int vaddrFieldIndex = this.elf.is64Bit() ? 3 : 2;
            for (int i = 0; i < programHeaders.length; ++i) {
                Address segmentAddr;
                Data d = array.getComponent(i);
                d.setComment(0, programHeaders[i].getComment());
                if (programHeaders[i].getType() == 0 || programHeaders[i].getOffset() == 0L || (segmentAddr = this.findLoadAddress(programHeaders[i], 0L)) == null) continue;
                Data component = d.getComponent(vaddrFieldIndex);
                component.addOperandReference(0, segmentAddr, RefType.DATA, SourceType.IMPORTED);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("Failed to markup Elf program/segment headers: " + this.getMessage(e));
        }
    }

    private void markupSectionHeaders(TaskMonitor monitor) {
        short headerCount = this.elf.e_shnum();
        int size = this.elf.e_shentsize() * headerCount;
        if (size == 0) {
            return;
        }
        Structure shStructDt = (Structure)this.elf.getSections()[0].toDataType();
        shStructDt = shStructDt.clone((DataTypeManager)this.program.getDataTypeManager());
        ArrayDataType arrayDt = new ArrayDataType((DataType)shStructDt, (int)this.elf.e_shnum(), (int)this.elf.e_shentsize());
        Address headerAddr = this.findLoadAddress(this.elf.e_shoff(), (long)size);
        try {
            if (headerAddr == null) {
                if (!ElfLoaderOptionsFactory.includeOtherBlocks(this.options)) {
                    return;
                }
                headerAddr = AddressSpace.OTHER_SPACE.getAddress(0L);
                MemoryBlock block = this.createInitializedBlock(null, true, ELF_SECTION_HEADERS_BLOCK_NAME, headerAddr, this.elf.e_shoff(), arrayDt.getLength(), "Elf Section Headers", false, false, false, monitor);
                headerAddr = block.getStart();
            }
            this.addElfHeaderReferenceMarkup(this.elf.getShoffComponentOrdinal(), headerAddr);
            Data array = this.createData(headerAddr, (DataType)arrayDt);
            ElfSectionHeader[] sections = this.elf.getSections();
            for (int i = 0; i < sections.length; ++i) {
                Data d = array.getComponent(i);
                Object comment = sections[i].getNameAsString();
                String type = sections[i].getTypeAsString();
                if (type != null) {
                    comment = (String)comment + " - " + type;
                }
                d.setComment(0, (String)comment);
                Address sectionAddr = this.findLoadAddress(sections[i], 0L);
                if (sectionAddr == null) continue;
                Data component = d.getComponent(3);
                component.addOperandReference(0, sectionAddr, RefType.DATA, SourceType.IMPORTED);
            }
        }
        catch (Exception e) {
            this.log("Failed to markup Elf section headers: " + this.getMessage(e));
        }
    }

    private void markupRelocationTable(Address relocTableAddr, ElfRelocationTable relocTable, TaskMonitor monitor) {
        try {
            DataType dataType = relocTable.toDataType();
            if (dataType != null) {
                this.listing.createData(relocTableAddr, dataType);
            } else {
                this.listing.setComment(relocTableAddr, 1, "ELF Relocation Table (markup not yet supported)");
            }
        }
        catch (Exception e) {
            this.log("Failed to properly markup relocation table: " + this.getMessage(e));
        }
    }

    private AddressSpace getDefaultAddressSpace() {
        return this.program.getAddressFactory().getDefaultAddressSpace();
    }

    private AddressSpace getDefaultDataSpace() {
        return this.program.getLanguage().getDefaultDataSpace();
    }

    private AddressSpace getConstantSpace() {
        return this.program.getAddressFactory().getConstantSpace();
    }

    private void allocateUndefinedSymbolData(HashMap<Address, Integer> dataAllocationMap) {
        for (Address addr : dataAllocationMap.keySet()) {
            Integer symbolSize = dataAllocationMap.get(addr);
            if (symbolSize == null) continue;
            try {
                this.createUndefined(addr, symbolSize);
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {}
        }
    }

    @Override
    public AddressRange allocateLinkageBlock(int alignment, int size, String purpose) {
        ElfLoadAdapter loadAdapter = this.elf.getLoadAdapter();
        AddressSpace space = this.getDefaultAddressSpace();
        AddressRangeObjectMap map = new AddressRangeObjectMap();
        map.setObject(space.getAddress((long)alignment, true), space.getMaxAddress(), (Object)AVAILABLE_MEMORY);
        for (AddressRange range : this.allocatedRegions.getAddressRanges()) {
            map.setObject(range.getMinAddress(), range.getMaxAddress(), (Object)ALLOCATED_MEMORY);
        }
        for (MemoryBlock block : this.memory.getBlocks()) {
            Address blockStart = block.getStart().getPhysicalAddress();
            if (!space.equals(blockStart.getAddressSpace())) continue;
            Address blockEnd = block.getEnd().getPhysicalAddress();
            if ("EXTERNAL".equals(block.getName())) {
                try {
                    blockEnd = blockEnd.addNoWrap((long)loadAdapter.getExternalBlockReserveSize());
                }
                catch (AddressOverflowException e) {
                    blockEnd = space.getMaxAddress();
                }
            }
            map.setObject(blockStart, block.getEnd().getPhysicalAddress(), (Object)ALLOCATED_MEMORY);
        }
        AddressRange maxRange = null;
        BigInteger maxRangeLength = null;
        BigInteger preferredRangeSize = BigInteger.valueOf(size <= 0 ? (long)loadAdapter.getPreferredExternalBlockSize() : (long)size);
        AddressRange lastBigUnallocatedRange = null;
        AddressRangeIterator rangeIterator = map.getAddressRangeIterator();
        while (rangeIterator.hasNext()) {
            Address addr;
            Address alignedAddress;
            long alignAdjust;
            AddressRange range = (AddressRange)rangeIterator.next();
            Integer value = (Integer)map.getObject(range.getMinAddress());
            if (!AVAILABLE_MEMORY.equals(value)) continue;
            BigInteger rangeLength = range.getBigLength();
            if (maxRangeLength == null || maxRangeLength.compareTo(rangeLength) < 0) {
                maxRange = range;
                maxRangeLength = rangeLength;
            }
            if ((rangeLength = rangeLength.subtract(BigInteger.valueOf(alignAdjust = (alignedAddress = (addr = range.getMinAddress()).getNewAddress(NumericUtilities.getUnsignedAlignedValue((long)addr.getOffset(), (long)alignment))).subtract(addr)))).compareTo(preferredRangeSize) < 0) continue;
            lastBigUnallocatedRange = range;
        }
        if (maxRange == null || size > 0 && maxRange.getLength() > 0L && maxRange.getLength() < (long)size) {
            Msg.error((Object)this, (Object)("ELF unable to find unallocated memory required for " + purpose + ": " + this.program.getName()));
            return null;
        }
        AddressRange freeRange = maxRange;
        if (lastBigUnallocatedRange != null && lastBigUnallocatedRange.getMinAddress().compareTo((Object)maxRange.getMinAddress()) > 0) {
            freeRange = lastBigUnallocatedRange;
        }
        Address addr = freeRange.getMinAddress();
        Address alignedAddress = addr.getNewAddress(NumericUtilities.getUnsignedAlignedValue((long)addr.getOffset(), (long)alignment));
        AddressRangeImpl range = new AddressRangeImpl(alignedAddress, freeRange.getMaxAddress());
        if (size > 0) {
            long rangeLen = range.getLength();
            if (rangeLen < 0L || rangeLen > (long)size) {
                range = new AddressRangeImpl(range.getMinAddress(), range.getMinAddress().add((long)(size - 1)));
            }
            this.allocatedRegions.add((AddressRange)range);
        }
        return range;
    }

    private Address getNextExternalBlockEntryAddress(int entrySize) {
        Address addr;
        block6: {
            if (this.nextExternalBlockEntryAddress == null) {
                int alignment = this.elf.getLoadAdapter().getLinkageBlockAlignment();
                this.externalBlockLimits = this.allocateLinkageBlock(alignment, -1, "EXTERNAL block");
                Address address = this.nextExternalBlockEntryAddress = this.externalBlockLimits != null ? this.externalBlockLimits.getMinAddress() : Address.NO_ADDRESS;
            }
            if ((addr = this.nextExternalBlockEntryAddress) != Address.NO_ADDRESS) {
                try {
                    Address lastAddr = this.nextExternalBlockEntryAddress.addNoWrap((long)(entrySize - 1));
                    if (this.externalBlockLimits.contains(lastAddr)) {
                        this.lastExternalBlockEntryAddress = lastAddr;
                        this.nextExternalBlockEntryAddress = this.lastExternalBlockEntryAddress.addNoWrap(1L);
                        if (!this.externalBlockLimits.contains(this.nextExternalBlockEntryAddress)) {
                            this.nextExternalBlockEntryAddress = Address.NO_ADDRESS;
                        }
                        break block6;
                    }
                    this.nextExternalBlockEntryAddress = Address.NO_ADDRESS;
                    return Address.NO_ADDRESS;
                }
                catch (AddressOverflowException e) {
                    this.nextExternalBlockEntryAddress = Address.NO_ADDRESS;
                }
            }
        }
        return addr != Address.NO_ADDRESS ? addr : null;
    }

    private void createExternalBlock() {
        if (this.lastExternalBlockEntryAddress == null) {
            return;
        }
        Address externalBlockAddress = this.externalBlockLimits.getMinAddress();
        long size = this.lastExternalBlockEntryAddress.subtract(externalBlockAddress) + 1L;
        try {
            MemoryBlock block = this.memory.createUninitializedBlock("EXTERNAL", externalBlockAddress, size, false);
            block.setWrite(true);
            block.setSourceName(BLOCK_SOURCE_NAME);
            block.setComment("NOTE: This block is artificial and is used to make relocations work correctly");
        }
        catch (Exception e) {
            this.log("Error creating external memory block:  - " + this.getMessage(e));
        }
    }

    private void processSymbolTables(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Processing symbol tables...");
        HashMap<Address, Integer> dataAllocationMap = new HashMap<Address, Integer>();
        ElfSymbolTable[] symbolTables = this.elf.getSymbolTables();
        int totalCount = 0;
        for (ElfSymbolTable elfSymbolTable : symbolTables) {
            totalCount += elfSymbolTable.getSymbolCount();
        }
        monitor.initialize((long)totalCount);
        for (ElfSymbolTable elfSymbolTable : symbolTables) {
            monitor.checkCanceled();
            Address symbolTableAddr = null;
            ElfSectionHeader symbolTableSection = elfSymbolTable.getTableSectionHeader();
            symbolTableAddr = symbolTableSection != null ? this.findLoadAddress(symbolTableSection, 0L) : this.findLoadAddress(elfSymbolTable.getFileOffset(), elfSymbolTable.getLength());
            ElfSymbol[] symbols = elfSymbolTable.getSymbols();
            if (symbolTableAddr != null) {
                this.markupSymbolTable(symbolTableAddr, elfSymbolTable, monitor);
            }
            this.processSymbols(symbols, dataAllocationMap, monitor);
        }
        this.createExternalBlock();
        this.allocateUndefinedSymbolData(dataAllocationMap);
    }

    private void processSymbols(ElfSymbol[] symbols, HashMap<Address, Integer> dataAllocationMap, TaskMonitor monitor) throws CancelledException {
        for (ElfSymbol elfSymbol : symbols) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            try {
                long size;
                Address address = this.calculateSymbolAddress(elfSymbol);
                if (address == null) continue;
                String symName = elfSymbol.getNameAsString();
                boolean usingFakeExternal = false;
                if (address == Address.NO_ADDRESS) {
                    if (symName == null || this.processVersionedExternal(elfSymbol) || this.processDuplicateExternal(elfSymbol)) continue;
                    address = this.allocateExternalSymbol(elfSymbol);
                    usingFakeExternal = true;
                }
                if (elfSymbol.isObject() && address.isMemoryAddress() && (size = elfSymbol.getSize()) > 0L && size < Integer.MAX_VALUE) {
                    dataAllocationMap.put(address, (int)size);
                }
                this.evaluateElfSymbol(elfSymbol, address, usingFakeExternal);
            }
            catch (Exception e) {
                this.log("Error creating symbol: " + elfSymbol.getNameAsString() + " - " + this.getMessage(e));
            }
        }
    }

    private Address calculateSymbolAddress(ElfSymbol elfSymbol) {
        if (elfSymbol.getSymbolTableIndex() == 0) {
            return null;
        }
        if (elfSymbol.isFile()) {
            return null;
        }
        if (elfSymbol.isTLS()) {
            this.log("Unsupported Thread-Local Symbol not loaded: " + elfSymbol.getNameAsString());
            return null;
        }
        ElfLoadAdapter loadAdapter = this.elf.getLoadAdapter();
        try {
            Address address = this.elf.getLoadAdapter().calculateSymbolAddress(this, elfSymbol);
            if (address != null) {
                return address;
            }
        }
        catch (NoValueException e) {
            return null;
        }
        ElfSectionHeader[] elfSections = this.elf.getSections();
        short sectionIndex = elfSymbol.getSectionHeaderIndex();
        Address symSectionBase = null;
        AddressSpace defaultSpace = this.getDefaultAddressSpace();
        AddressSpace defaultDataSpace = this.getDefaultDataSpace();
        AddressSpace symbolSpace = defaultSpace;
        long symOffset = elfSymbol.getValue();
        boolean isAllocatedToSection = false;
        if (sectionIndex == 0) {
            Address regAddr = this.findMemoryRegister(elfSymbol);
            if (regAddr != null) {
                return regAddr;
            }
            symOffset = loadAdapter.getAdjustedMemoryOffset(symOffset, defaultSpace);
            symOffset += this.getImageBaseWordAdjustmentOffset();
        } else if (Short.compareUnsigned(sectionIndex, (short)-256) < 0) {
            isAllocatedToSection = true;
            int uSectionIndex = Short.toUnsignedInt(sectionIndex);
            if (uSectionIndex < elfSections.length) {
                ElfSectionHeader symSection = this.elf.getSections()[uSectionIndex];
                symSectionBase = this.findLoadAddress(symSection, 0L);
                if (symSectionBase == null) {
                    this.log("Unable to place symbol due to non-loaded section: " + elfSymbol.getNameAsString() + " - value=0x" + Long.toHexString(elfSymbol.getValue()) + ", section=" + symSection.getNameAsString());
                    return null;
                }
                symbolSpace = symSectionBase.getAddressSpace();
                if (this.elf.isRelocatable()) {
                    return symSectionBase.addWrapSpace(elfSymbol.getValue() * (long)symSectionBase.getAddressSpace().getAddressableUnitSize());
                }
            } else if (this.elf.isRelocatable()) {
                this.log("No Memory for symbol: " + elfSymbol.getNameAsString() + " - 0x" + Long.toHexString(elfSymbol.getValue()));
                return null;
            }
            AddressSpace space = symbolSpace.getPhysicalSpace();
            symOffset = loadAdapter.getAdjustedMemoryOffset(symOffset, space);
            if (space == defaultSpace) {
                symOffset = this.elf.adjustAddressForPrelink(symOffset) + this.getImageBaseWordAdjustmentOffset();
            } else if (space == defaultDataSpace) {
                symOffset += this.getImageDataBase();
            }
        } else if (sectionIndex == -15) {
            byte type = elfSymbol.getType();
            if (type == 4) {
                return null;
            }
            symbolSpace = defaultDataSpace;
            if (elfSymbol.isFunction()) {
                symbolSpace = defaultSpace;
            } else {
                Address regAddr = this.findMemoryRegister(elfSymbol);
                if (regAddr != null) {
                    return regAddr;
                }
            }
        } else {
            if (sectionIndex == -14) {
                return Address.NO_ADDRESS;
            }
            this.log("Unable to place symbol: " + elfSymbol.getNameAsString() + " - value=0x" + Long.toHexString(elfSymbol.getValue()) + ", section-index=0x" + Integer.toHexString(Short.toUnsignedInt(sectionIndex)));
            return null;
        }
        Address address = symbolSpace.getTruncatedAddress(symOffset, true);
        if (symbolSpace.isOverlaySpace() && address.getAddressSpace() != symbolSpace) {
            address = symbolSpace.getAddressInThisSpaceOnly(address.getOffset());
        }
        if (isAllocatedToSection || elfSymbol.isAbsolute()) {
            return address;
        }
        if (elfSymbol.isExternal()) {
            return Address.NO_ADDRESS;
        }
        if (!elfSymbol.isSection() && elfSymbol.getValue() == 0L) {
            return Address.NO_ADDRESS;
        }
        if (elfSymbol.getValue() == 1L) {
            return Address.NO_ADDRESS;
        }
        return address;
    }

    private Address findMemoryRegister(ElfSymbol elfSymbol) {
        String name = elfSymbol.getNameAsString();
        Address regAddr = this.getMemoryRegister(name, elfSymbol.getValue());
        if (regAddr == null) {
            name = StringUtils.stripStart((String)name, (String)"_");
            name = StringUtils.stripEnd((String)name, (String)"_");
            regAddr = this.getMemoryRegister(name, elfSymbol.getValue());
        }
        return regAddr;
    }

    private Address getMemoryRegister(String name, long value) {
        Register reg = this.program.getRegister(name);
        if (reg != null && reg.getAddress().isMemoryAddress()) {
            Address a = reg.getAddress();
            if (value == 0L || value == a.getAddressableWordOffset()) {
                return a;
            }
        }
        return null;
    }

    private Address allocateExternalSymbol(ElfSymbol elfSymbol) throws AddressOutOfBoundsException {
        long size = elfSymbol.getSize();
        int alignSize = this.elf.getLoadAdapter().getDefaultAlignment(this);
        size = elfSymbol.isObject() && size > 0L && size < Integer.MAX_VALUE ? NumericUtilities.getUnsignedAlignedValue((long)size, (long)alignSize) : (long)alignSize;
        Address address = this.getNextExternalBlockEntryAddress((int)size);
        if (address == null) {
            throw new AddressOutOfBoundsException("failed to allocate EXTERNAL block entry");
        }
        return address;
    }

    private boolean processDuplicateExternal(ElfSymbol elfSymbol) {
        if (this.lastExternalBlockEntryAddress == null) {
            return false;
        }
        String symName = elfSymbol.getNameAsString();
        Symbol s = this.findExternalBlockSymbol(symName, this.externalBlockLimits.getMinAddress(), this.lastExternalBlockEntryAddress);
        if (s != null) {
            this.setElfSymbolAddress(elfSymbol, s.getAddress());
            return true;
        }
        return false;
    }

    private boolean processVersionedExternal(ElfSymbol elfSymbol) {
        String realName;
        Symbol s;
        String symName = elfSymbol.getNameAsString();
        int index = symName.indexOf("@");
        if (index < 0) {
            return false;
        }
        if (this.lastExternalBlockEntryAddress == null) {
            return false;
        }
        int altIndex = symName.indexOf("@@");
        if (altIndex > 0) {
            index = altIndex;
        }
        if ((s = this.findExternalBlockSymbol(realName = symName.substring(0, index), this.externalBlockLimits.getMinAddress(), this.lastExternalBlockEntryAddress)) == null) {
            return false;
        }
        Address address = s.getAddress();
        Object comment = this.listing.getComment(1, address);
        comment = comment == null || ((String)comment).length() == 0 ? symName : (String)comment + "\n" + symName;
        this.listing.setComment(address, 1, (String)comment);
        this.setElfSymbolAddress(elfSymbol, address);
        return true;
    }

    private Symbol findExternalBlockSymbol(String name, Address extMin, Address extMax) {
        Symbol s;
        SymbolTable symbolTable = this.program.getSymbolTable();
        SymbolIterator symbols = symbolTable.getSymbols(name);
        for (Symbol symbol : symbols) {
            if (!this.isSymbolInRange(symbol, extMin, extMax)) continue;
            return symbol;
        }
        SymbolIterator symbolIter = symbolTable.getSymbolIterator(extMin, true);
        while (symbolIter.hasNext() && this.isSymbolInRange(s = symbolIter.next(), extMin, extMax)) {
            if (!name.equals(s.getName())) continue;
            return s;
        }
        return null;
    }

    private boolean isSymbolInRange(Symbol s, Address min, Address max) {
        Address symAddr = s.getAddress();
        return symAddr.compareTo((Object)min) >= 0 && symAddr.compareTo((Object)max) <= 0;
    }

    private void evaluateElfSymbol(ElfSymbol elfSymbol, Address address, boolean isFakeExternal) throws InvalidInputException {
        if (address.isMemoryAddress()) {
            address = this.elf.getLoadAdapter().evaluateElfSymbol(this, elfSymbol, address, isFakeExternal);
        }
        if (address != null) {
            this.setElfSymbolAddress(elfSymbol, address);
            if (address.isConstantAddress()) {
                try {
                    this.program.getEquateTable().createEquate(elfSymbol.getNameAsString(), address.getOffset());
                }
                catch (DuplicateNameException | InvalidInputException throwable) {
                    // empty catch block
                }
                return;
            }
            if (elfSymbol.isSection()) {
                return;
            }
            String name = elfSymbol.getNameAsString();
            if (name == null) {
                return;
            }
            try {
                Function f;
                Function existingFunction;
                boolean isPrimary;
                boolean bl = isPrimary = elfSymbol.getType() == 2 || elfSymbol.getType() == 1 || elfSymbol.getSize() != 0L;
                if (name.contains("@")) {
                    isPrimary = false;
                } else if (!isPrimary && (elfSymbol.isGlobal() || elfSymbol.isWeak())) {
                    Symbol existingSym = this.program.getSymbolTable().getPrimarySymbol(address);
                    isPrimary = existingSym == null;
                }
                this.createSymbol(address, name, isPrimary, elfSymbol.isAbsolute(), null);
                if ((elfSymbol.isGlobal() || elfSymbol.isWeak()) && !isFakeExternal) {
                    this.program.getSymbolTable().addExternalEntryPoint(address);
                }
                if (elfSymbol.getType() == 2 && (existingFunction = this.program.getFunctionManager().getFunctionAt(address)) == null && (f = this.createOneByteFunction(null, address, false)) != null && isFakeExternal && !f.isThunk()) {
                    ExternalLocation extLoc = this.program.getExternalManager().addExtFunction("<EXTERNAL>", name, null, SourceType.IMPORTED);
                    f.setThunkedFunction(extLoc.getFunction());
                    Symbol s = f.getSymbol();
                    if (s.getSource() != SourceType.DEFAULT) {
                        this.program.getSymbolTable().removeSymbolSpecial(f.getSymbol());
                    }
                }
            }
            catch (DuplicateNameException e) {
                throw new RuntimeException("Unexpected Exception", e);
            }
        }
    }

    @Override
    public void setElfSymbolAddress(ElfSymbol elfSymbol, Address address) {
        this.symbolMap.put(elfSymbol, address);
    }

    @Override
    public Address getElfSymbolAddress(ElfSymbol elfSymbol) {
        return this.symbolMap.get(elfSymbol);
    }

    @Override
    public void markAsCode(Address address) {
        AddressSetPropertyMap codeProp = this.program.getAddressSetPropertyMap("CodeMap");
        if (codeProp == null) {
            try {
                codeProp = this.program.createAddressSetPropertyMap("CodeMap");
            }
            catch (DuplicateNameException e) {
                codeProp = this.program.getAddressSetPropertyMap("CodeMap");
            }
        }
        if (codeProp != null) {
            codeProp.add(address, address);
        }
    }

    @Override
    public Function createOneByteFunction(String name, Address address, boolean isEntry) {
        Function function = null;
        try {
            FunctionManager functionMgr = this.program.getFunctionManager();
            function = functionMgr.getFunctionAt(address);
            if (function == null) {
                function = functionMgr.createFunction(null, address, (AddressSetView)new AddressSet(address), SourceType.IMPORTED);
            }
        }
        catch (Exception e) {
            this.log("Error while creating function at " + address + ": " + this.getMessage(e));
        }
        try {
            if (name != null) {
                this.createSymbol(address, name, true, false, null);
            }
            if (isEntry) {
                this.program.getSymbolTable().addExternalEntryPoint(address);
            }
        }
        catch (Exception e) {
            this.log("Error while creating symbol " + name + " at " + address + ": " + this.getMessage(e));
        }
        return function;
    }

    @Override
    public Function createExternalFunctionLinkage(String name, Address functionAddr, Address indirectPointerAddr) {
        Function f = this.program.getFunctionManager().getFunctionAt(functionAddr);
        if (f == null) {
            f = this.createOneByteFunction(null, functionAddr, false);
            if (f == null) {
                return null;
            }
        } else if (f.isThunk()) {
            return f;
        }
        ExternalLocation extLoc = null;
        try {
            extLoc = this.program.getExternalManager().addExtFunction("<EXTERNAL>", name, null, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            this.log.appendMsg("Failed to create external function '" + name + "': " + this.getMessage((Exception)((Object)e)));
            return null;
        }
        catch (DuplicateNameException e) {
            extLoc = this.program.getExternalManager().getUniqueExternalLocation("<EXTERNAL>", name);
        }
        if (indirectPointerAddr != null) {
            MemoryBlock block = this.memory.getBlock(indirectPointerAddr);
            if (block == null) {
                this.log.appendMsg("Indirect linkage memory not found at: " + indirectPointerAddr);
                return null;
            }
            try {
                if (!block.isInitialized()) {
                    this.memory.convertToInitialized(block, (byte)0);
                }
                if (this.program.getDefaultPointerSize() != (this.elf.is64Bit() ? 8 : 4)) {
                    this.log.appendMsg("Unsupported pointer size for indirect linkage at: " + indirectPointerAddr);
                    return null;
                }
                if (this.elf.is64Bit()) {
                    this.memory.setLong(indirectPointerAddr, functionAddr.getAddressableWordOffset());
                } else {
                    this.memory.setInt(indirectPointerAddr, (int)functionAddr.getAddressableWordOffset());
                }
            }
            catch (Exception e) {
                this.log.appendMsg("Failed to establish linkage to external function '" + name + "': " + this.getMessage(e));
                return null;
            }
            Data data = this.createData(indirectPointerAddr, (DataType)PointerDataType.dataType);
            MutabilitySettingsDefinition.DEF.setChoice((Settings)data, 2);
        }
        f.setThunkedFunction(extLoc.getFunction());
        if (indirectPointerAddr == null || !this.removeOldSymbol(indirectPointerAddr, name)) {
            this.removeOldSymbol(functionAddr, name);
        }
        return f;
    }

    private boolean removeOldSymbol(Address address, String name) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        Symbol[] symbols = symbolTable.getSymbols(address);
        if (symbols.length == 1 && name.equals(symbols[0].getName())) {
            symbolTable.removeSymbolSpecial(symbols[0]);
            return true;
        }
        return false;
    }

    @Override
    public Data createUndefinedData(Address address, int length) {
        try {
            Data d;
            if (length > 8) {
                length = 1;
            }
            if (length == 0) {
                length = 1;
            }
            if ((d = this.listing.getDefinedDataAt(address)) != null && d.getLength() == length) {
                return d;
            }
            this.listing.createData(address, Undefined.getUndefinedDataType((int)length));
        }
        catch (CodeUnitInsertionException e) {
            Msg.warn((Object)this, (Object)("ELF data markup conflict at " + address));
        }
        catch (DataTypeConflictException e) {
            throw new AssertException("unexpected", (Throwable)e);
        }
        return null;
    }

    @Override
    public Data createData(Address address, DataType dt) {
        try {
            Data d = this.listing.getDataAt(address);
            if (d == null || !dt.isEquivalent(d.getDataType())) {
                d = DataUtilities.createData((Program)this.program, (Address)address, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            }
            return d;
        }
        catch (CodeUnitInsertionException e) {
            Msg.warn((Object)this, (Object)("ELF data markup conflict at " + address));
        }
        catch (DataTypeConflictException e) {
            Msg.error((Object)this, (Object)("ELF data type markup conflict:" + this.getMessage((Exception)((Object)e))));
        }
        return null;
    }

    private void markupGnuBuildId(TaskMonitor monitor) {
        ElfSectionHeader sh = this.elf.getSection(".note.gnu.build-id");
        Address addr = this.findLoadAddress(sh, 0L);
        if (addr == null) {
            return;
        }
        try {
            this.listing.createData(addr, (DataType)new GnuBuildIdSection((DataTypeManager)this.program.getDataTypeManager(), sh.getSize()));
        }
        catch (Exception e) {
            this.log("Failed to properly markup Gnu Build-Id at " + addr + ": " + this.getMessage(e));
        }
    }

    private void markupGnuDebugLink(TaskMonitor monitor) {
        ElfSectionHeader sh = this.elf.getSection(".gnu_debuglink");
        Address addr = this.findLoadAddress(sh, 0L);
        if (addr == null) {
            return;
        }
        try {
            this.listing.createData(addr, (DataType)new GnuDebugLinkSection((DataTypeManager)this.program.getDataTypeManager(), sh.getSize()));
        }
        catch (Exception e) {
            this.log("Failed to properly markup Gnu DebugLink at " + addr + ": " + this.getMessage(e));
        }
    }

    private void markupHashTable(TaskMonitor monitor) {
        ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
        if (dynamicTable == null || !dynamicTable.containsDynamicValue(ElfDynamicType.DT_HASH)) {
            return;
        }
        DWordDataType dt = DWordDataType.dataType;
        Address hashTableAddr = null;
        try {
            long value = dynamicTable.getDynamicValue(ElfDynamicType.DT_HASH);
            if (value == 0L) {
                return;
            }
            Address addr = hashTableAddr = this.getDefaultAddress(this.elf.adjustAddressForPrelink(value));
            Data d = this.listing.createData(addr, (DataType)dt);
            d.setComment(0, "Hash Table - nbucket");
            long nbucket = d.getScalar(0).getUnsignedValue();
            addr = addr.add((long)d.getLength());
            d = this.listing.createData(addr, (DataType)dt);
            d.setComment(0, "Hash Table - nchain");
            long nchain = d.getScalar(0).getUnsignedValue();
            addr = addr.add((long)d.getLength());
            d = this.listing.createData(addr, (DataType)new ArrayDataType((DataType)dt, (int)nbucket, dt.getLength()));
            d.setComment(0, "Hash Table - buckets");
            addr = addr.add((long)d.getLength());
            d = this.listing.createData(addr, (DataType)new ArrayDataType((DataType)dt, (int)nchain, dt.getLength()));
            d.setComment(0, "Hash Table - chains");
        }
        catch (Exception e) {
            this.log("Failed to properly markup Hash table at " + hashTableAddr + ": " + this.getMessage(e));
            return;
        }
    }

    private void markupGnuHashTable(TaskMonitor monitor) {
        ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
        if (dynamicTable == null || !dynamicTable.containsDynamicValue(ElfDynamicType.DT_GNU_HASH)) {
            return;
        }
        DWordDataType dt = DWordDataType.dataType;
        Address hashTableAddr = null;
        try {
            long value = dynamicTable.getDynamicValue(ElfDynamicType.DT_GNU_HASH);
            if (value == 0L) {
                return;
            }
            Address addr = hashTableAddr = this.getDefaultAddress(this.elf.adjustAddressForPrelink(value));
            Data d = this.listing.createData(addr, (DataType)dt);
            d.setComment(0, "GNU Hash Table - nbucket");
            long nbucket = d.getScalar(0).getUnsignedValue();
            addr = addr.add((long)d.getLength());
            d = this.listing.createData(addr, (DataType)dt);
            d.setComment(0, "GNU Hash Table - symbase");
            long symbolBase = d.getScalar(0).getUnsignedValue();
            addr = addr.add((long)d.getLength());
            d = this.listing.createData(addr, (DataType)dt);
            d.setComment(0, "GNU Hash Table - bloom_size");
            long bloomSize = d.getScalar(0).getUnsignedValue();
            addr = addr.add((long)d.getLength());
            d = this.listing.createData(addr, (DataType)dt);
            d.setComment(0, "GNU Hash Table - bloom_shift");
            addr = addr.add((long)d.getLength());
            QWordDataType bloomDataType = this.elf.is64Bit() ? QWordDataType.dataType : DWordDataType.dataType;
            d = this.listing.createData(addr, (DataType)new ArrayDataType((DataType)bloomDataType, (int)bloomSize, bloomDataType.getLength()));
            d.setComment(0, "GNU Hash Table - bloom");
            addr = addr.add((long)d.getLength());
            d = this.listing.createData(addr, (DataType)new ArrayDataType((DataType)dt, (int)nbucket, dt.getLength()));
            d.setComment(0, "GNU Hash Table - chains");
            addr = addr.add((long)d.getLength());
            this.listing.setComment(addr, 0, "GNU Hash Table - chain");
            ElfSymbolTable dynamicSymbolTable = this.elf.getDynamicSymbolTable();
            if (dynamicSymbolTable == null) {
                Msg.error((Object)this, (Object)"Failed to markup GNU Hash Table chain data - missing dynamic symbol table");
                return;
            }
            int chainSize = dynamicSymbolTable.getSymbolCount() - (int)symbolBase;
            d = this.listing.createData(addr, (DataType)new ArrayDataType((DataType)dt, chainSize, dt.getLength()));
        }
        catch (Exception e) {
            this.log("Failed to properly markup GNU Hash table at " + hashTableAddr + ": " + this.getMessage(e));
            return;
        }
    }

    private void markupSymbolTable(Address symbolTableAddr, ElfSymbolTable symbolTable, TaskMonitor monitor) {
        Data array = null;
        try {
            array = this.listing.createData(symbolTableAddr, symbolTable.toDataType());
        }
        catch (Exception e) {
            this.log("Failed to properly markup symbol table at " + symbolTableAddr + ": " + this.getMessage(e));
            return;
        }
        ElfSymbol[] symbols = symbolTable.getSymbols();
        for (int i = 0; i < symbols.length; ++i) {
            Data structData;
            int stringOffset = symbols[i].getName();
            if (stringOffset == 0 || (structData = array.getComponent(i)) == null) continue;
            structData.setComment(0, symbols[i].getNameAsString());
        }
    }

    private void markupDynamicTable(TaskMonitor monitor) {
        Address dynamicTableAddress = null;
        try {
            ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
            if (dynamicTable == null) {
                return;
            }
            dynamicTableAddress = this.findLoadAddress(dynamicTable.getFileOffset(), 1L);
            if (dynamicTableAddress == null) {
                this.log("Failed to locate dynamic table at file offset 0x" + Long.toHexString(dynamicTable.getFileOffset()));
                return;
            }
            this.createSymbol(dynamicTableAddress, "_DYNAMIC", false, false, null);
            ElfDynamic[] dynamics = dynamicTable.getDynamics();
            DataType structArray = dynamicTable.toDataType();
            Data dynamicTableData = this.createData(dynamicTableAddress, structArray);
            if (dynamicTableData == null) {
                return;
            }
            for (int i = 0; i < dynamics.length; ++i) {
                String str;
                ElfStringTable dynamicStringTable;
                Data dynamicData = dynamicTableData.getComponent(i);
                if (dynamicData == null) {
                    return;
                }
                long value = dynamics[i].getValue();
                int tagType = dynamics[i].getTag();
                ElfDynamicType dynamicType = this.elf.getDynamicType(tagType);
                String comment = dynamicType != null ? dynamicType.name + " - " + dynamicType.description : "DT_0x" + StringUtilities.pad((String)Integer.toHexString(tagType), (char)'0', (int)8);
                dynamicData.setComment(0, comment);
                Data valueData = dynamicData.getComponent(1);
                if (dynamicType == null) continue;
                if (dynamicType.valueType == ElfDynamicType.ElfDynamicValueType.ADDRESS) {
                    this.addDynamicMemoryReference(dynamics[i], valueData, false, "_" + dynamicType.name);
                    continue;
                }
                if (dynamicType.valueType != ElfDynamicType.ElfDynamicValueType.STRING || (dynamicStringTable = this.elf.getDynamicStringTable()) == null || (str = dynamicStringTable.readString(this.elf.getReader(), value)) == null) continue;
                valueData.setComment(0, str);
            }
        }
        catch (Exception e) {
            this.log("Failed to process dynamic section: " + this.getMessage(e));
        }
    }

    private Address addDynamicMemoryReference(ElfDynamic elfDynamic, Data valueData, boolean definedMemoryOnly, String label) throws InvalidInputException {
        Scalar value = valueData.getScalar(0);
        if (value == null || value.getUnsignedValue() == 0L) {
            return null;
        }
        Address refAddr = this.getDefaultAddress(this.elf.adjustAddressForPrelink(value.getValue()));
        if (!definedMemoryOnly || this.memory.getBlock(refAddr) != null) {
            Symbol symbol;
            this.program.getReferenceManager().addMemoryReference(valueData.getAddress(), refAddr, RefType.DATA, SourceType.ANALYSIS, 0);
            if (label != null && ((symbol = this.program.getSymbolTable().getPrimarySymbol(refAddr)) == null || symbol.getSource() == SourceType.DEFAULT)) {
                this.createSymbol(refAddr, "_" + label, false, false, null);
            }
        }
        return refAddr;
    }

    private void processStringTables(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Processing string tables...");
        monitor.setShowProgressValue(false);
        ElfStringTable[] stringTables = this.elf.getStringTables();
        long totalLength = 0L;
        for (ElfStringTable stringTable : stringTables) {
            totalLength += stringTable.getLength();
        }
        monitor.initialize(totalLength);
        for (ElfStringTable stringTable : stringTables) {
            monitor.checkCanceled();
            Address stringTableAddr = null;
            ElfSectionHeader section = stringTable.getTableSectionHeader();
            stringTableAddr = section != null ? this.findLoadAddress(section, 0L) : this.findLoadAddress(stringTable.getFileOffset(), 1L);
            if (stringTableAddr == null) {
                monitor.incrementProgress(stringTable.getLength());
                continue;
            }
            AddressRange rangeConstraint = this.getMarkupMemoryRangeConstraint(stringTableAddr);
            if (rangeConstraint == null) {
                monitor.incrementProgress(stringTable.getLength());
                continue;
            }
            long tblLength = stringTable.getLength();
            long limit = Math.min(tblLength, rangeConstraint.getLength());
            if (limit < tblLength) {
                monitor.incrementProgress(tblLength - limit);
            }
            this.markupStringTable(stringTableAddr, limit, monitor);
        }
        monitor.setShowProgressValue(true);
    }

    private void markupStringTable(Address address, long tableBytesLength, TaskMonitor monitor) {
        MemoryBlock block = this.memory.getBlock(address);
        if (block == null || tableBytesLength <= 0L) {
            return;
        }
        try {
            Address end = address.addNoWrap(tableBytesLength - 1L);
            if (end.compareTo((Object)block.getEnd()) > 0) {
                end = block.getEnd();
            }
            address = address.addNoWrap(1L);
            while (!monitor.isCancelled() && address.compareTo((Object)end) < 0) {
                int length = this.createString(address);
                monitor.incrementProgress((long)length);
                address = address.addNoWrap((long)length);
            }
        }
        catch (AddressOverflowException | CodeUnitInsertionException e) {
            return;
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    private int createString(Address address) throws CodeUnitInsertionException, DataTypeConflictException {
        Data d = this.listing.getDataAt(address);
        if (d == null || !TerminatedStringDataType.dataType.isEquivalent(d.getDataType())) {
            d = this.listing.createData(address, (DataType)TerminatedStringDataType.dataType, -1);
        }
        return d.getLength();
    }

    @Override
    public Address getDefaultAddress(long addressableWordOffset) {
        return this.getDefaultAddressSpace().getTruncatedAddress(addressableWordOffset += this.getImageBaseWordAdjustmentOffset(), true);
    }

    private AddressSpace getSegmentAddressSpace(ElfProgramHeader elfProgramHeader) {
        if (elfProgramHeader.getType() != 1 && elfProgramHeader.getVirtualAddress() == 0L) {
            return AddressSpace.OTHER_SPACE;
        }
        return this.elf.getLoadAdapter().getPreferredSegmentAddressSpace(this, elfProgramHeader);
    }

    private Address getSegmentLoadAddress(ElfProgramHeader elfProgramHeader) {
        AddressSpace space = this.getSegmentAddressSpace(elfProgramHeader);
        if (!space.isLoadedMemorySpace()) {
            long addrWordOffset = elfProgramHeader.getVirtualAddress();
            return space.getTruncatedAddress(addrWordOffset, true);
        }
        return this.elf.getLoadAdapter().getPreferredSegmentAddress(this, elfProgramHeader);
    }

    private AddressSpace getSectionAddressSpace(ElfSectionHeader elfSectionHeader) {
        if (!elfSectionHeader.isAlloc()) {
            AddressSpace space = this.program.getAddressFactory().getAddressSpace(elfSectionHeader.getNameAsString());
            if (space == null) {
                space = AddressSpace.OTHER_SPACE;
            }
            return space;
        }
        return this.elf.getLoadAdapter().getPreferredSectionAddressSpace(this, elfSectionHeader);
    }

    private Address getSectionLoadAddress(ElfSectionHeader elfSectionHeader) {
        AddressSpace space = this.getSectionAddressSpace(elfSectionHeader);
        if (!space.isLoadedMemorySpace()) {
            long addrWordOffset = elfSectionHeader.getAddress();
            return space.getTruncatedAddress(addrWordOffset, true);
        }
        return this.elf.getLoadAdapter().getPreferredSectionAddress(this, elfSectionHeader);
    }

    @Override
    public Address findLoadAddress(MemoryLoadable section, long byteOffsetWithinSection) {
        if (section == null) {
            return null;
        }
        List<AddressRange> resolvedLoadAddresses = this.getResolvedLoadAddresses(section);
        if (resolvedLoadAddresses == null) {
            ElfSectionHeader s;
            if (section instanceof ElfProgramHeader) {
                ElfProgramHeader loadHeader;
                ElfProgramHeader programHeader = (ElfProgramHeader)section;
                long offsetAddr = programHeader.getVirtualAddress() + byteOffsetWithinSection;
                if (programHeader.getType() != 1 && (loadHeader = this.elf.getProgramLoadHeaderContaining(offsetAddr)) != null) {
                    return this.findLoadAddress(loadHeader, offsetAddr - loadHeader.getVirtualAddress());
                }
                ElfSectionHeader sectionHeader = this.elf.getSectionLoadHeaderContaining(offsetAddr);
                if (sectionHeader != null) {
                    return this.findLoadAddress(sectionHeader, offsetAddr - sectionHeader.getAddress());
                }
            } else if (section instanceof ElfSectionHeader && (s = (ElfSectionHeader)section).isAlloc()) {
                return this.getSectionLoadAddress(s);
            }
            return null;
        }
        long offset = byteOffsetWithinSection;
        AddressRange containingRange = null;
        for (AddressRange range : resolvedLoadAddresses) {
            long rangeLength = range.getLength();
            if (offset < rangeLength) {
                containingRange = range;
                break;
            }
            offset -= rangeLength;
        }
        if (containingRange == null) {
            if (!resolvedLoadAddresses.isEmpty()) {
                return resolvedLoadAddresses.get(0).getMinAddress().add(byteOffsetWithinSection).getPhysicalAddress();
            }
            return null;
        }
        return containingRange.getMinAddress().add(offset);
    }

    private Address findLoadAddress(long fileOffset, long headerSize) {
        long endOffset;
        long startOffset;
        long headerEndOffset = fileOffset + headerSize - 1L;
        Address headerAddr = null;
        for (ElfSectionHeader elfSectionHeader : this.elf.getSections()) {
            if (elfSectionHeader.getType() == 8 || (startOffset = elfSectionHeader.getOffset()) < 0L) continue;
            endOffset = startOffset + elfSectionHeader.getSize() - 1L;
            if (fileOffset < startOffset || headerEndOffset > endOffset || (headerAddr = this.findLoadAddress(elfSectionHeader, fileOffset - elfSectionHeader.getOffset())) == null) continue;
            return headerAddr;
        }
        for (StructConverter structConverter : this.elf.getProgramHeaders()) {
            if (((ElfProgramHeader)structConverter).getType() == 0 || (startOffset = ((ElfProgramHeader)structConverter).getOffset()) < 0L) continue;
            endOffset = startOffset + ((ElfProgramHeader)structConverter).getFileSize() - 1L;
            if (fileOffset < startOffset || headerEndOffset > endOffset || (headerAddr = this.findLoadAddress((MemoryLoadable)((Object)structConverter), fileOffset - ((ElfProgramHeader)structConverter).getOffset())) == null || ((ElfProgramHeader)structConverter).getType() != 1) continue;
            return headerAddr;
        }
        return headerAddr;
    }

    private void expandProgramHeaderBlocks(TaskMonitor monitor) throws CancelledException {
        ElfProgramHeader[] elfProgramHeaders = this.elf.getProgramHeaders();
        for (int i = 0; i < elfProgramHeaders.length; ++i) {
            AddressSpace space;
            Address expandStart;
            monitor.checkCanceled();
            ElfProgramHeader elfProgramHeader = elfProgramHeaders[i];
            if (elfProgramHeaders[i].getType() != 1) continue;
            MemoryBlock block = null;
            long segmentMemorySizeBytes = elfProgramHeader.getAdjustedMemorySize();
            if (segmentMemorySizeBytes <= 0L) continue;
            long loadSizeBytes = elfProgramHeader.getAdjustedLoadSize();
            if (loadSizeBytes == 0L) {
                expandStart = this.getSegmentLoadAddress(elfProgramHeader);
                space = expandStart.getAddressSpace();
            } else {
                List<AddressRange> resolvedLoadAddresses = this.getResolvedLoadAddresses(elfProgramHeader);
                AddressRange addressRange = resolvedLoadAddresses.get(resolvedLoadAddresses.size() - 1);
                Address endAddr = addressRange.getMaxAddress();
                space = endAddr.getAddressSpace();
                if (space.isOverlaySpace() || !(block = this.memory.getBlock(endAddr)).getEnd().equals((Object)endAddr)) continue;
                expandStart = endAddr.add(1L);
            }
            long fullSizeBytes = segmentMemorySizeBytes;
            if (expandStart == null || fullSizeBytes <= loadSizeBytes) continue;
            try {
                long expandSize = fullSizeBytes - loadSizeBytes;
                Address expandEnd = expandStart.addNoWrap(expandSize - 1L);
                AddressSet intersectRange = this.memory.intersectRange(expandStart, expandEnd);
                if (!intersectRange.isEmpty()) {
                    Address firstIntersectAddr = intersectRange.getFirstRange().getMinAddress();
                    if (expandStart.equals((Object)firstIntersectAddr)) continue;
                    expandEnd = firstIntersectAddr.previous();
                }
                if (block == null) {
                    String blockName = String.format("%s%d", SEGMENT_NAME_PREFIX, i);
                    MemoryBlock newBlock = this.memory.createInitializedBlock(blockName, expandStart, expandSize, (byte)0, monitor, false);
                    newBlock.setSourceName(BLOCK_SOURCE_NAME);
                    newBlock.setComment("Zero-initialized segment");
                    continue;
                }
                Address oldBlockEnd = block.getEnd();
                MemoryBlock expandBlock = this.memory.createInitializedBlock(block.getName() + ".expand", expandStart, expandSize, (byte)0, monitor, false);
                MemoryBlock extBlock = this.memory.join(block, expandBlock);
                extBlock.setComment(extBlock.getComment() + " (zero-extended)");
                this.joinProgramTreeFragments(oldBlockEnd, expandStart);
                continue;
            }
            catch (Exception e) {
                this.log("Failed to " + (block != null ? "expand" : "create") + " segment [" + i + "," + elfProgramHeader.getDescription() + "] at address " + expandStart.toString(true));
            }
        }
    }

    private void joinProgramTreeFragments(Address block1End, Address block2Start) {
        try {
            String[] treeNames;
            for (String treeName : treeNames = this.listing.getTreeNames()) {
                ProgramFragment frag1 = this.listing.getFragment(treeName, block1End);
                ProgramFragment frag2 = this.listing.getFragment(treeName, block2Start);
                frag1.move(frag2.getMinAddress(), frag2.getMaxAddress());
                for (ProgramModule module : frag2.getParents()) {
                    if (!frag2.isEmpty()) continue;
                    module.removeChild(frag2.getName());
                }
            }
        }
        catch (NotEmptyException | NotFoundException throwable) {
            // empty catch block
        }
    }

    private void processProgramHeaders(TaskMonitor monitor) throws CancelledException {
        if (this.elf.isRelocatable() && this.elf.e_phnum() != 0) {
            this.log("Ignoring unexpected program headers for relocatable ELF (e_phnum=" + this.elf.e_phnum() + ")");
            return;
        }
        monitor.setMessage("Processing program headers...");
        boolean includeOtherBlocks = ElfLoaderOptionsFactory.includeOtherBlocks(this.options);
        ElfProgramHeader[] elfProgramHeaders = this.elf.getProgramHeaders();
        for (int i = 0; i < elfProgramHeaders.length; ++i) {
            monitor.checkCanceled();
            ElfProgramHeader elfProgramHeader = elfProgramHeaders[i];
            if (elfProgramHeader.getType() == 0) continue;
            long fileOffset = elfProgramHeader.getOffset();
            if (elfProgramHeader.getType() != 1) {
                if (!includeOtherBlocks) continue;
                if (fileOffset < 0L || fileOffset >= this.fileBytes.getSize()) {
                    this.log("Skipping segment[" + i + ", " + elfProgramHeader.getDescription() + "] with invalid file offset");
                    continue;
                }
                if (this.elf.getProgramLoadHeaderContainingFileOffset(fileOffset) != null) continue;
                ElfSectionHeader section = this.elf.getSectionHeaderContainingFileRange(fileOffset, elfProgramHeader.getFileSize());
                if (section != null) {
                    this.log("Skipping segment[" + i + ", " + elfProgramHeader.getDescription() + "] included by section " + section.getNameAsString());
                    continue;
                }
            }
            if (fileOffset < 0L || fileOffset >= this.fileBytes.getSize()) {
                this.log("Skipping PT_LOAD segment[" + i + ", " + elfProgramHeader.getDescription() + "] with invalid file offset");
                continue;
            }
            this.processProgramHeader(elfProgramHeader, i);
        }
    }

    private void processProgramHeader(ElfProgramHeader elfProgramHeader, int segmentNumber) throws AddressOutOfBoundsException {
        boolean maintainExecuteBit;
        Address address = this.getSegmentLoadAddress(elfProgramHeader);
        AddressSpace space = address.getAddressSpace();
        long addr = elfProgramHeader.getVirtualAddress();
        long loadSizeBytes = elfProgramHeader.getAdjustedLoadSize();
        long fullSizeBytes = elfProgramHeader.getAdjustedMemorySize();
        boolean bl = maintainExecuteBit = this.elf.e_shnum() == 0;
        if (fullSizeBytes <= 0L) {
            this.log("Skipping zero-length segment [" + segmentNumber + "," + elfProgramHeader.getDescription() + "] at address " + address.toString(true));
            return;
        }
        if (!space.isValidRange(address.getOffset(), fullSizeBytes)) {
            this.log("Skipping unloadable segment [" + segmentNumber + "] at address " + address.toString(true) + " (size=" + fullSizeBytes + ")");
            return;
        }
        try {
            boolean isFragmentationOK = this.elf.e_shnum() != 0;
            Object comment = this.getSectionComment(addr, fullSizeBytes, space.getAddressableUnitSize(), elfProgramHeader.getDescription(), address.isLoadedMemoryAddress());
            if (!maintainExecuteBit && elfProgramHeader.isExecute()) {
                comment = (String)comment + " (disabled execute bit)";
            }
            String blockName = String.format("%s%d", SEGMENT_NAME_PREFIX, segmentNumber);
            if (loadSizeBytes != 0L) {
                this.addInitializedMemorySection(elfProgramHeader, elfProgramHeader.getOffset(), loadSizeBytes, address, blockName, elfProgramHeader.isRead(), elfProgramHeader.isWrite(), maintainExecuteBit ? elfProgramHeader.isExecute() : false, (String)comment, isFragmentationOK, elfProgramHeader.getType() == 1);
            }
        }
        catch (AddressOverflowException e) {
            this.log("Failed to load segment [" + segmentNumber + "]: " + this.getMessage((Exception)((Object)e)));
        }
    }

    private String getSectionComment(long addr, long byteSize, int addressableUnitSize, String description, boolean loaded) {
        StringBuilder buf = new StringBuilder();
        if (description != null) {
            buf.append(description);
            buf.append(' ');
        }
        if (loaded) {
            if (buf.length() != 0) {
                buf.append(' ');
            }
            BigInteger max = BigInteger.valueOf(addr).add(BigInteger.valueOf(byteSize / (long)addressableUnitSize)).subtract(BigInteger.ONE);
            buf.append(String.format("[0x%x - 0x%s]", addr, max.toString(16)));
        } else {
            buf.append("[not-loaded]");
        }
        return buf.toString();
    }

    @Override
    public long getImageBaseWordAdjustmentOffset() {
        long imageBase = this.program.getImageBase().getAddressableWordOffset();
        return imageBase - this.elf.getImageBase();
    }

    @Override
    public Long getGOTValue() {
        ElfHeader header = this.getElfHeader();
        ElfDynamicTable dynamic = header.getDynamicTable();
        if (dynamic != null && dynamic.containsDynamicValue(ElfDynamicType.DT_PLTGOT)) {
            try {
                return header.adjustAddressForPrelink(dynamic.getDynamicValue(ElfDynamicType.DT_PLTGOT)) + this.getImageBaseWordAdjustmentOffset();
            }
            catch (NotFoundException e) {
                throw new AssertException("unexpected", (Throwable)e);
            }
        }
        Symbol gotSym = SymbolUtilities.getLabelOrFunctionSymbol((Program)this.program, (String)"_GLOBAL_OFFSET_TABLE_", err -> this.log((String)err));
        if (gotSym != null) {
            return gotSym.getAddress().getAddressableWordOffset();
        }
        return null;
    }

    private long computeRelocationStartAddress(AddressSpace space, long baseOffset, TaskMonitor monitor) throws CancelledException {
        long testOffset;
        ElfSectionHeader[] sections;
        if (!this.elf.isRelocatable()) {
            return 0L;
        }
        long relocStartAddr = 0L;
        AddressSpace defaultSpace = this.getDefaultAddressSpace();
        for (ElfSectionHeader elfSectionToLoad : sections = this.elf.getSections()) {
            AddressSpace loadSpace;
            monitor.checkCanceled();
            long addr = elfSectionToLoad.getAddress();
            if (addr < 0L) {
                relocStartAddr = 0L;
                break;
            }
            if (!elfSectionToLoad.isAlloc() || addr == 0L || !(loadSpace = this.getSectionAddressSpace(elfSectionToLoad)).equals(space)) continue;
            long sectionByteLength = elfSectionToLoad.getAdjustedSize();
            long sectionLength = sectionByteLength / (long)space.getAddressableUnitSize();
            relocStartAddr = Math.max(relocStartAddr, addr + sectionLength);
        }
        if ((testOffset = relocStartAddr << 1) != defaultSpace.getTruncatedAddress(testOffset, true).getOffset()) {
            relocStartAddr = 0L;
        }
        return relocStartAddr + baseOffset;
    }

    private void processSectionHeaders(TaskMonitor monitor) throws CancelledException {
        ElfSectionHeader[] sections;
        monitor.setMessage("Processing section headers...");
        boolean includeOtherBlocks = ElfLoaderOptionsFactory.includeOtherBlocks(this.options);
        RelocatableImageBaseProvider relocatableImageBaseProvider = null;
        if (this.elf.isRelocatable()) {
            relocatableImageBaseProvider = new RelocatableImageBaseProvider(monitor);
        }
        for (ElfSectionHeader elfSectionToLoad : sections = this.elf.getSections()) {
            monitor.checkCanceled();
            int type = elfSectionToLoad.getType();
            if (type == 0 || !includeOtherBlocks && !elfSectionToLoad.isAlloc()) continue;
            long fileOffset = elfSectionToLoad.getOffset();
            if (type != 8 && (fileOffset < 0L || fileOffset >= this.fileBytes.getSize())) {
                this.log("Skipping section [" + elfSectionToLoad.getNameAsString() + "] with invalid file offset 0x" + Long.toHexString(fileOffset));
                continue;
            }
            long size = elfSectionToLoad.getSize();
            if (size <= 0L || type != 8 && size >= this.fileBytes.getSize()) {
                this.log("Skipping section [" + elfSectionToLoad.getNameAsString() + "] with invalid size 0x" + Long.toHexString(size));
                continue;
            }
            this.processSectionHeader(elfSectionToLoad, relocatableImageBaseProvider);
        }
    }

    private void processSectionHeader(ElfSectionHeader elfSectionToLoad, RelocatableImageBaseProvider relocatableImageBaseProvider) throws AddressOutOfBoundsException {
        AddressSpace space;
        ElfProgramHeader loadHeader;
        long addr = elfSectionToLoad.getAddress();
        long sectionByteLength = elfSectionToLoad.getAdjustedSize();
        long loadOffset = elfSectionToLoad.getOffset();
        Long nextRelocOffset = null;
        if (elfSectionToLoad.isAlloc() && this.elf.isRelocatable() && addr == 0L) {
            AddressSpace space2 = this.getSectionAddressSpace(elfSectionToLoad);
            long relocOffset = relocatableImageBaseProvider.getNextRelocatableOffset(space2);
            addr = NumericUtilities.getUnsignedAlignedValue((long)relocOffset, (long)elfSectionToLoad.getAddressAlignment());
            elfSectionToLoad.setAddress(addr);
            nextRelocOffset = addr + sectionByteLength / (long)space2.getAddressableUnitSize();
        }
        Address address = null;
        if (sectionByteLength == 0L && elfSectionToLoad.getType() == 1 && (loadHeader = this.elf.getProgramLoadHeaderContaining(addr)) != null) {
            Address segmentStart = this.getSegmentLoadAddress(loadHeader);
            AddressSpace segmentSpace = segmentStart.getAddressSpace();
            long loadSizeBytes = loadHeader.getAdjustedLoadSize();
            long fullSizeBytes = loadHeader.getAdjustedMemorySize() * (long)segmentSpace.getAddressableUnitSize();
            long segmentByteOffset = (addr - loadHeader.getVirtualAddress()) * (long)segmentSpace.getAddressableUnitSize();
            if (segmentByteOffset >= loadSizeBytes) {
                loadOffset = -1L;
                address = segmentStart.add(segmentByteOffset);
                sectionByteLength = fullSizeBytes - segmentByteOffset;
            }
        }
        if (sectionByteLength == 0L) {
            this.log("Skipping empty section [" + elfSectionToLoad.getNameAsString() + "]");
            return;
        }
        if (address == null) {
            address = this.getSectionLoadAddress(elfSectionToLoad);
        }
        if (!(space = address.getAddressSpace()).isValidRange(address.getOffset(), sectionByteLength)) {
            this.log("Skipping unloadable section [" + elfSectionToLoad.getNameAsString() + "] at address " + address.toString(true) + " (size=" + sectionByteLength + ")");
            return;
        }
        String blockName = elfSectionToLoad.getNameAsString();
        try {
            String comment;
            if (loadOffset == -1L || elfSectionToLoad.getType() == 8) {
                if (!elfSectionToLoad.isAlloc() && elfSectionToLoad.getType() != 1) {
                    return;
                }
                comment = this.getSectionComment(addr, sectionByteLength, space.getAddressableUnitSize(), elfSectionToLoad.getTypeAsString(), address.isLoadedMemoryAddress());
                this.addUninitializedMemorySection(elfSectionToLoad, sectionByteLength, address, blockName, true, elfSectionToLoad.isWritable(), elfSectionToLoad.isExecutable(), comment, false);
            } else {
                comment = this.getSectionComment(addr, sectionByteLength, space.getAddressableUnitSize(), elfSectionToLoad.getTypeAsString(), address.isLoadedMemoryAddress());
                this.addInitializedMemorySection(elfSectionToLoad, loadOffset, sectionByteLength, address, blockName, elfSectionToLoad.isAlloc(), elfSectionToLoad.isWritable(), elfSectionToLoad.isExecutable(), comment, false, elfSectionToLoad.isAlloc());
            }
        }
        catch (AddressOverflowException e) {
            this.log("Failed to load section [" + elfSectionToLoad.getNameAsString() + "]: " + this.getMessage((Exception)((Object)e)));
        }
        if (nextRelocOffset != null) {
            relocatableImageBaseProvider.setNextRelocatableOffset(space, nextRelocOffset);
        }
    }

    private String pad(int value) {
        return StringUtilities.pad((String)("" + value), (char)' ', (int)4);
    }

    private Data createUndefined(Address addr, int size) throws CodeUnitInsertionException {
        MemoryBlock block = this.memory.getBlock(addr);
        if (block == null) {
            return null;
        }
        DataType undefined = Undefined.getUndefinedDataType((int)size);
        return this.listing.createData(addr, undefined);
    }

    @Override
    public Symbol createSymbol(Address addr, String name, boolean isPrimary, boolean pinAbsolute, Namespace namespace) throws InvalidInputException {
        SymbolTable symbolTable = this.program.getSymbolTable();
        Symbol sym = symbolTable.createLabel(addr, name, namespace, SourceType.IMPORTED);
        if (isPrimary) {
            this.checkPrimary(sym);
        }
        if (pinAbsolute && !sym.isPinned()) {
            sym.setPinned(true);
        }
        return sym;
    }

    private Symbol checkPrimary(Symbol sym) {
        Symbol primarySymbol;
        if (sym == null || sym.isPrimary()) {
            return sym;
        }
        String name = sym.getName();
        Address addr = sym.getAddress();
        if (name.indexOf("@") > 0) {
            return sym;
        }
        if (name.startsWith("$")) {
            return sym;
        }
        if (!Character.isAlphabetic(name.codePointAt(0)) && (primarySymbol = this.program.getSymbolTable().getPrimarySymbol(addr)) != null && primarySymbol.getSource() != SourceType.DEFAULT && Character.isAlphabetic(primarySymbol.getName().codePointAt(0))) {
            return sym;
        }
        SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(addr, name, sym.getParentNamespace());
        if (cmd.applyTo((DomainObject)this.program)) {
            return this.program.getSymbolTable().getSymbol(name, addr, sym.getParentNamespace());
        }
        Msg.error((Object)this, (Object)cmd.getStatusMsg());
        return sym;
    }

    private InputStream getInitializedBlockInputStream(MemoryLoadable loadable, Address start, long fileOffset, long dataLength) throws IOException {
        InputStream dataInput = this.elf.getReader().getByteProvider().getInputStream(fileOffset);
        return this.elf.getLoadAdapter().getFilteredLoadInputStream(this, loadable, start, dataLength, dataInput);
    }

    private String formatFloat(float value, int maxDecimalPlaces) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumIntegerDigits(maxDecimalPlaces);
        float roundUpFactor = 1.0f / (10.0f * (float)maxDecimalPlaces);
        return format.format(value + roundUpFactor);
    }

    private long checkBlockLimit(String sectionName, long dataLength, boolean initialized) throws IOException {
        long available = 0x400000000L - this.program.getMemory().getNumAddresses();
        if (dataLength < 0L || dataLength > available) {
            String msg = "Failed to create memory blocks which exceed the fixed 16 GByte total memory size limit";
            this.log("ERROR: " + msg);
            throw new IOException(msg);
        }
        int maxSectionSizeGBytes = 16;
        long maxSectionSizeBytes = 0x400000000L;
        if (dataLength > maxSectionSizeBytes) {
            float sizeGB = (float)dataLength / 1.0737418E9f;
            String msg = "Truncating " + this.formatFloat(sizeGB, 1) + " GByte '" + sectionName + "' section to " + maxSectionSizeGBytes + " GByte fixed size limit";
            this.log("ERROR: " + msg);
            return maxSectionSizeBytes;
        }
        return dataLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MemoryBlock createInitializedBlock(MemoryLoadable loadable, boolean isOverlay, String name, Address start, long fileOffset, long dataLength, String comment, boolean r, boolean w, boolean x, TaskMonitor monitor) throws IOException, AddressOverflowException, CancelledException {
        MemoryBlock block;
        block15: {
            long revisedLength = this.checkBlockLimit(name, dataLength, true);
            if (this.isDiscardableFillerSegment(loadable, name, start, fileOffset, dataLength)) {
                Msg.debug((Object)this, (Object)("Discarding " + dataLength + "-byte alignment/filler " + name + " at " + start));
                return null;
            }
            if (start.isNonLoadedMemoryAddress()) {
                r = false;
                w = false;
                x = false;
            }
            Msg.debug((Object)this, (Object)("Loading block " + name + " at " + start + " from file offset " + fileOffset));
            long endOffset = fileOffset + revisedLength - 1L;
            if (endOffset >= this.fileBytes.getSize()) {
                revisedLength = this.fileBytes.getSize() - fileOffset;
                this.log("Truncating block load for " + name + " which exceeds file length");
            }
            Object blockComment = comment;
            if (dataLength != revisedLength) {
                blockComment = (String)blockComment + " (section truncated)";
            }
            block = null;
            try {
                if (this.elf.getLoadAdapter().hasFilteredLoadInputStream(this, loadable, start)) {
                    try (InputStream dataInput = this.getInitializedBlockInputStream(loadable, start, fileOffset, revisedLength);){
                        block = MemoryBlockUtils.createInitializedBlock(this.program, isOverlay, name, start, dataInput, revisedLength, (String)blockComment, BLOCK_SOURCE_NAME, r, w, x, this.log, monitor);
                        break block15;
                    }
                }
                block = MemoryBlockUtils.createInitializedBlock(this.program, isOverlay, name, start, this.fileBytes, fileOffset, revisedLength, (String)blockComment, BLOCK_SOURCE_NAME, r, w, x, this.log);
            }
            finally {
                if (block == null) {
                    Address end = start.addNoWrap(revisedLength - 1L);
                    Msg.error((Object)this, (Object)("Unexpected ELF memory bock load conflict when creating '" + name + "' at " + start.toString(true) + "-" + end.toString(true)));
                }
            }
        }
        return block;
    }

    @Override
    protected MemoryBlock createUninitializedBlock(MemoryLoadable loadable, boolean isOverlay, String name, Address start, long dataLength, String comment, boolean r, boolean w, boolean x) throws IOException, AddressOverflowException {
        long revisedLength = this.checkBlockLimit(name, dataLength, false);
        if (start.isNonLoadedMemoryAddress()) {
            r = false;
            w = false;
            x = false;
        }
        if (dataLength != revisedLength) {
            comment = (String)comment + " (section truncated)";
        }
        return MemoryBlockUtils.createUninitializedBlock(this.program, isOverlay, name, start, revisedLength, (String)comment, BLOCK_SOURCE_NAME, r, w, x, this.log);
    }

    private class RelocatableImageBaseProvider {
        Map<Integer, Long> nextRelocationOffsetMap = new HashMap<Integer, Long>();

        RelocatableImageBaseProvider(TaskMonitor monitor) throws CancelledException {
            AddressSpace defaultSpace = ElfProgramBuilder.this.getDefaultAddressSpace();
            AddressSpace defaultDataSpace = ElfProgramBuilder.this.getDefaultDataSpace();
            long baseOffset = ElfProgramBuilder.this.computeRelocationStartAddress(defaultSpace, ElfProgramBuilder.this.elf.getImageBase(), monitor);
            this.nextRelocationOffsetMap.put(defaultSpace.getUnique(), baseOffset);
            if (defaultDataSpace != defaultSpace) {
                baseOffset = ElfProgramBuilder.this.computeRelocationStartAddress(defaultDataSpace, ElfProgramBuilder.this.getImageDataBase(), monitor);
                this.nextRelocationOffsetMap.put(defaultDataSpace.getUnique(), baseOffset);
            }
        }

        void setNextRelocatableOffset(AddressSpace space, Long nextRelocOffset) {
            int unique = space.getUnique();
            this.nextRelocationOffsetMap.put(unique, nextRelocOffset);
        }

        long getNextRelocatableOffset(AddressSpace space) {
            int unique = space.getUnique();
            Long nextRelocOffset = this.nextRelocationOffsetMap.get(unique);
            return nextRelocOffset == null ? 0L : nextRelocOffset;
        }
    }
}

