/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.services.FileImporterService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TextEditorService;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileCache;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.FrontEndable;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.plugin.importer.ImporterDialog;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.importer.batch.BatchImportDialog;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Import External Files (NEW)", description="This plugin manages importing files, including those contained within firmware/filesystem images.", servicesRequired={TextEditorService.class}, servicesProvided={FileImporterService.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class ImporterPlugin
extends Plugin
implements FileImporterService,
FrontEndable,
ProjectListener {
    private static final String IMPORT_MENU_GROUP = "Import";
    static final String IMPORTER_PLUGIN_DESC = "This plugin manages importing files, including those contained within firmware/filesystem images.";
    private DockingAction importAction;
    private DockingAction importSelectionAction;
    private DockingAction addToProgramAction;
    private GhidraFileChooser chooser;
    private FrontEndService frontEndService;
    private DockingAction batchImportAction;

    public ImporterPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.frontEndService = (FrontEndService)this.tool.getService(FrontEndService.class);
        if (this.frontEndService != null) {
            this.frontEndService.addProjectListener((ProjectListener)this);
        }
        this.setupImportAction();
        this.setupImportSelectionAction();
        this.setupAddToProgramAction();
        this.setupBatchImportAction();
    }

    public void readConfigState(SaveState saveState) {
        super.readConfigState(saveState);
        String[] paths = saveState.getStrings("library search paths", null);
        if (paths != null) {
            LibrarySearchPathManager.setLibraryPaths(paths);
        }
    }

    public void writeConfigState(SaveState saveState) {
        super.writeConfigState(saveState);
        String[] paths = LibrarySearchPathManager.getLibraryPaths();
        saveState.putStrings("library search paths", paths);
    }

    protected void dispose() {
        super.dispose();
        if (this.importAction != null) {
            this.importAction.dispose();
        }
        if (this.importSelectionAction != null) {
            this.importSelectionAction.dispose();
        }
        if (this.addToProgramAction != null) {
            this.addToProgramAction.dispose();
        }
        if (this.frontEndService != null) {
            this.frontEndService.removeProjectListener((ProjectListener)this);
            this.frontEndService = null;
        }
        this.chooser = null;
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent pape = (ProgramActivatedPluginEvent)event;
            Program currentProgram = pape.getActiveProgram();
            this.importSelectionAction.setEnabled(currentProgram != null);
            this.addToProgramAction.setEnabled(currentProgram != null);
        }
    }

    @Override
    public void importFiles(DomainFolder destFolder, List<File> files) {
        BatchImportDialog.showAndImport(this.tool, null, this.files2FSRLs(files), destFolder, (ProgramManager)this.getTool().getService(ProgramManager.class));
    }

    private List<FSRL> files2FSRLs(List<File> files) {
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<FSRL> result = new ArrayList<FSRL>(files.size());
        for (File f : files) {
            result.add(FileSystemService.getInstance().getLocalFSRL(f));
        }
        return result;
    }

    @Override
    public void importFile(DomainFolder folder, File file) {
        FSRL fsrl = FileSystemService.getInstance().getLocalFSRL(file);
        ProgramManager manager = (ProgramManager)this.tool.getService(ProgramManager.class);
        ImporterUtilities.showImportDialog(this.tool, manager, fsrl, folder, null);
    }

    public void projectClosed(Project project) {
        if (this.importAction != null) {
            this.importAction.setEnabled(false);
        }
        if (this.importSelectionAction != null) {
            this.importSelectionAction.setEnabled(false);
        }
        if (this.addToProgramAction != null) {
            this.addToProgramAction.setEnabled(false);
        }
        ProgramMappingService.clear();
    }

    public void projectOpened(Project project) {
        if (this.importAction != null) {
            this.importAction.setEnabled(true);
        }
        if (this.importSelectionAction != null) {
            this.importSelectionAction.setEnabled(false);
        }
        if (this.addToProgramAction != null) {
            this.addToProgramAction.setEnabled(false);
        }
        ProgramMappingService.clear();
    }

    private void setupImportAction() {
        String title = "Import File";
        this.importAction = new DockingAction(title, this.getName()){

            public void actionPerformed(ActionContext context) {
                ImporterPlugin.this.doSingleImportAction(ImporterPlugin.getFolderFromContext(context));
            }
        };
        this.importAction.setMenuBarData(new MenuData(new String[]{"&File", title + "..."}, null, IMPORT_MENU_GROUP, -1, "1"));
        this.importAction.setKeyBindingData(new KeyBindingData(73, 0));
        this.importAction.setDescription(IMPORTER_PLUGIN_DESC);
        this.importAction.setEnabled(this.tool.getProject() != null);
        this.importAction.setHelpLocation(new HelpLocation("ImporterPlugin", "Import_File"));
        this.tool.addAction((DockingActionIf)this.importAction);
    }

    private void setupBatchImportAction() {
        String title = "Batch Import";
        this.batchImportAction = new DockingAction(title, this.getName()){

            public void actionPerformed(ActionContext context) {
                BatchImportDialog.showAndImport(ImporterPlugin.this.tool, null, null, ImporterPlugin.getFolderFromContext(context), (ProgramManager)ImporterPlugin.this.getTool().getService(ProgramManager.class));
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ImporterPlugin.this.tool.getProject() != null;
            }
        };
        this.batchImportAction.setMenuBarData(new MenuData(new String[]{"&File", title + "..."}, null, IMPORT_MENU_GROUP, -1, "2"));
        this.batchImportAction.setDescription(IMPORTER_PLUGIN_DESC);
        this.batchImportAction.setHelpLocation(new HelpLocation("ImporterPlugin", title));
        this.tool.addAction((DockingActionIf)this.batchImportAction);
    }

    private void setupImportSelectionAction() {
        String title = "Extract and Import";
        this.importSelectionAction = new DockingAction(title, this.getName()){

            public void actionPerformed(ActionContext context) {
                if (context instanceof ListingActionContext) {
                    ListingActionContext lac = (ListingActionContext)context;
                    ImporterPlugin.this.doImportSelectionAction(lac.getProgram(), lac.getSelection());
                }
            }

            public boolean isValidContext(ActionContext context) {
                if (context instanceof ListingActionContext) {
                    ProgramSelection selection = ((ListingActionContext)context).getNavigatable().getSelection();
                    return selection != null && selection.getNumAddressRanges() == 1;
                }
                return false;
            }
        };
        this.importSelectionAction.setPopupMenuData(new MenuData(new String[]{title + "..."}, null, IMPORT_MENU_GROUP, -1, "d"));
        this.importSelectionAction.setKeyBindingData(new KeyBindingData(73, 640));
        this.importSelectionAction.setDescription(IMPORTER_PLUGIN_DESC);
        this.importSelectionAction.setEnabled(this.tool.getProject() != null);
        this.tool.addAction((DockingActionIf)this.importSelectionAction);
    }

    private void setupAddToProgramAction() {
        String title = "Add To Program";
        this.addToProgramAction = new DockingAction(title, this.getName()){

            public void actionPerformed(ActionContext context) {
                ImporterPlugin.this.doAddToProgram();
            }
        };
        this.addToProgramAction.setMenuBarData(new MenuData(new String[]{"&File", title + "..."}, null, IMPORT_MENU_GROUP, -1, "zz"));
        this.addToProgramAction.setDescription(IMPORTER_PLUGIN_DESC);
        this.addToProgramAction.setEnabled(false);
        if (!(this.tool instanceof FrontEndTool)) {
            this.tool.addAction((DockingActionIf)this.addToProgramAction);
        }
    }

    private static DomainFolder getFolderFromContext(ActionContext context) {
        Object contextObj = context.getContextObject();
        if (contextObj instanceof DomainFolderNode) {
            DomainFolderNode node = (DomainFolderNode)contextObj;
            return node.getDomainFolder();
        }
        return AppInfo.getActiveProject().getProjectData().getRootFolder();
    }

    private void initializeChooser(String title, String buttonText, boolean multiSelect) {
        if (this.chooser == null) {
            this.chooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
            this.chooser.addFileFilter(ImporterUtilities.LOADABLE_FILES_FILTER);
            this.chooser.addFileFilter(ImporterUtilities.CONTAINER_FILES_FILTER);
            this.chooser.setSelectedFileFilter(GhidraFileFilter.ALL);
        }
        this.chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        this.chooser.setMultiSelectionEnabled(multiSelect);
        this.chooser.setTitle(title);
        this.chooser.setApproveButtonText(buttonText);
        String lastFile = Preferences.getProperty((String)"Importer.LastFile");
        if (lastFile != null) {
            this.chooser.setSelectedFile(new File(lastFile));
        }
    }

    private void doSingleImportAction(DomainFolder defaultFolder) {
        this.initializeChooser("Select File to Import", "Select File To Import", false);
        File file = this.chooser.getSelectedFile();
        if (this.chooser.wasCancelled()) {
            return;
        }
        if (file == null) {
            Msg.showInfo((Object)this, (Component)this.tool.getActiveWindow(), (String)"No file selected", (Object)"No file will be imported.");
        } else if (!file.exists()) {
            Msg.showInfo((Object)this, (Component)this.tool.getActiveWindow(), (String)"File Error", (Object)("File does not exist: " + file.getPath()));
        } else {
            this.importFile(defaultFolder, file);
        }
    }

    private void doAddToProgram() {
        this.initializeChooser("Add To Program", "Add To Program", false);
        File file = this.chooser.getSelectedFile();
        if (file == null) {
            Msg.showInfo(this.getClass(), null, (String)"No file selected", (Object)"No file will be imported.");
            return;
        }
        this.addToProgram(file);
    }

    private void addToProgram(File file) {
        if (file.length() == 0L) {
            Msg.showInfo((Object)this, null, (String)"Import File Failed", (Object)("File " + file.getName() + " is empty (0 bytes)."));
            return;
        }
        ProgramManager manager = (ProgramManager)this.tool.getService(ProgramManager.class);
        Program program = manager.getCurrentProgram();
        FSRL fsrl = FileSystemService.getInstance().getLocalFSRL(file);
        TaskLauncher.launchModal((String)"Show Add To Program Dialog", monitor -> ImporterUtilities.showAddToProgramDialog(fsrl, program, this.tool, monitor));
    }

    protected void doImportSelectionAction(Program program, ProgramSelection selection) {
        if (selection == null || selection.getNumAddressRanges() != 1) {
            return;
        }
        AddressRange range = selection.getFirstRange();
        if (range.getLength() >= Integer.MAX_VALUE) {
            Msg.showInfo(this.getClass(), (Component)this.tool.getActiveWindow(), (String)"Selection Too Large", (Object)"The selection is too large to extract.");
            return;
        }
        try {
            FileCache.FileCacheEntry tmpFile;
            Memory memory = program.getMemory();
            FileSystemService fsService = FileSystemService.getInstance();
            try (FileCache.FileCacheEntryBuilder tmpFileBuilder = fsService.createTempFile(range.getLength());){
                byte[] bytes = new byte[(int)range.getLength()];
                memory.getBytes(range.getMinAddress(), bytes);
                tmpFileBuilder.write(bytes);
                tmpFile = tmpFileBuilder.finish();
            }
            MemoryBlock block = memory.getBlock(range.getMinAddress());
            String rangeName = block.getName() + "[" + range.getMinAddress() + "," + range.getMaxAddress() + "]";
            ByteProvider bp = fsService.getNamedTempFile(tmpFile, program.getName() + " " + rangeName);
            LoaderMap loaderMap = LoaderService.getAllSupportedLoadSpecs(bp);
            ImporterDialog importerDialog = new ImporterDialog(this.tool, (ProgramManager)this.tool.getService(ProgramManager.class), loaderMap, bp, null);
            this.tool.showDialog((DialogComponentProvider)importerDialog);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"I/O Error Occurred", (Object)e.getMessage(), (Throwable)e);
        }
        catch (MemoryAccessException e) {
            Msg.showError((Object)this, null, (String)"Memory Access Error Occurred", (Object)e.getMessage(), (Throwable)e);
        }
    }
}

