/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.properties.UnsupportedMapDB;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.ProgramProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableSizeException;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.program.util.AddressIteratorConverter;
import ghidra.program.util.AddressTranslator;
import ghidra.program.util.DefaultAddressTranslator;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.FunctionMerge;
import ghidra.program.util.MultiAddressIterator;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.program.util.SymbolMerge;
import ghidra.util.Msg;
import ghidra.util.Saveable;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.PropertyVisitor;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProgramMerge
implements PropertyVisitor {
    public static String SYMBOL_CONFLICT_SUFFIX = "_conflict";
    private static final int PROGRESS_COUNTER_GRANULARITY = 129;
    private StringBuffer errorMsg;
    private StringBuffer infoMsg;
    private AddressTranslator originToResultTranslator;
    private Program resultProgram;
    private Program originProgram;
    private Listing resultListing;
    private Listing originListing;
    private CodeUnit resultCu;
    private String propertyName;
    private SymbolMerge symbolMerge;
    private FunctionMerge functionMerge;
    private LongLongHashtable conflictSymbolIDMap;
    private HashMap<String, DupEquate> dupEquates;

    public ProgramMerge(Program resultProgram, Program originProgram) {
        this.originToResultTranslator = new DefaultAddressTranslator(resultProgram, originProgram);
        this.init(resultProgram, originProgram);
    }

    public ProgramMerge(AddressTranslator originToResultTranslator) {
        this.originToResultTranslator = originToResultTranslator;
        this.init(originToResultTranslator.getDestinationProgram(), originToResultTranslator.getSourceProgram());
    }

    private void init(Program result, Program origin) {
        this.resultProgram = result;
        this.originProgram = origin;
        if (this.resultProgram == null || this.originProgram == null) {
            throw new IllegalArgumentException("program cannot be null.");
        }
        this.resultListing = this.resultProgram.getListing();
        this.originListing = this.originProgram.getListing();
        this.errorMsg = new StringBuffer();
        this.infoMsg = new StringBuffer();
        this.conflictSymbolIDMap = new LongLongHashtable();
        this.dupEquates = new HashMap();
        this.symbolMerge = new SymbolMerge(this.originToResultTranslator);
        this.functionMerge = new FunctionMerge(this.originToResultTranslator);
    }

    public Program getResultProgram() {
        return this.resultProgram;
    }

    public Program getOriginProgram() {
        return this.originProgram;
    }

    void clearMessages() {
        if (this.infoMsg.length() > 0) {
            this.infoMsg = new StringBuffer();
        }
        if (this.errorMsg.length() > 0) {
            this.errorMsg = new StringBuffer();
        }
    }

    public boolean hasErrorMessage() {
        return this.errorMsg.length() > 0;
    }

    public boolean hasInfoMessage() {
        return this.infoMsg.length() > 0;
    }

    public String getErrorMessage() {
        return this.errorMsg.toString();
    }

    public String getInfoMessage() {
        return this.infoMsg.toString();
    }

    public void clearErrorMessage() {
        this.errorMsg = new StringBuffer();
    }

    public void clearInfoMessage() {
        this.infoMsg = new StringBuffer();
    }

    void mergeProgramContext(AddressSetView originAddressSet, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't merge program context.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Applying Program Context...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        ProgramContext resultContext = this.resultProgram.getProgramContext();
        ProgramContext originContext = this.originProgram.getProgramContext();
        ArrayList originRegs = new ArrayList(originContext.getRegisters());
        Collections.sort(originRegs, (r1, r2) -> r2.getBitLength() - r1.getBitLength());
        AddressRangeIterator originRangeIter = originAddressSet.getAddressRanges();
        while (originRangeIter.hasNext() && !monitor.isCancelled()) {
            AddressRange originRange = (AddressRange)originRangeIter.next();
            AddressRange resultRange = this.originToResultTranslator.getAddressRange(originRange);
            monitor.setMessage("Applying Program Context: " + originRange.getMinAddress().toString(true));
            for (Register originReg : originRegs) {
                if (!originReg.isBaseRegister() || originReg.isProcessorContext()) continue;
                monitor.checkCanceled();
                try {
                    this.mergeProgramContext(resultContext, originContext, originReg, originRange, resultRange, monitor);
                }
                catch (ContextChangeException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void mergeProgramContext(ProgramContext resultContext, ProgramContext originContext, Register originReg, AddressRange originRange, AddressRange resultRange, TaskMonitor monitor) throws CancelledException, ContextChangeException {
        Register resultReg = resultContext.getRegister(originReg.getName());
        if (resultReg == null) {
            return;
        }
        AddressRangeIterator origValueIter = originContext.getRegisterValueAddressRanges(originReg, originRange.getMinAddress(), originRange.getMaxAddress());
        resultContext.remove(resultRange.getMinAddress(), resultRange.getMaxAddress(), resultReg);
        while (origValueIter.hasNext()) {
            monitor.checkCanceled();
            AddressRange origValueRange = (AddressRange)origValueIter.next();
            AddressRange resultValueRange = this.originToResultTranslator.getAddressRange(origValueRange);
            RegisterValue originValue = originContext.getRegisterValue(originReg, origValueRange.getMinAddress());
            if (originValue == null || !originValue.hasAnyValue()) continue;
            RegisterValue resultValue = new RegisterValue(resultReg, originValue.toBytes());
            resultContext.setRegisterValue(resultValueRange.getMinAddress(), resultValueRange.getMaxAddress(), resultValue);
        }
    }

    private void copyBytesInRanges(AddressSetView originAddressSet, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Memory toMem = this.resultProgram.getMemory();
        Memory fromMem = this.originProgram.getMemory();
        AddressRangeIterator iter = originAddressSet.getAddressRanges();
        while (iter.hasNext()) {
            monitor.checkCanceled();
            AddressRange fromRange = (AddressRange)iter.next();
            this.copyByteRange(toMem, fromMem, fromRange);
        }
    }

    private void copyByteRange(Memory toMem, Memory fromMem, AddressRange fromAddressRange) throws MemoryAccessException {
        int length = 0;
        Address fromWriteAddress = fromAddressRange.getMinAddress();
        for (long len = fromAddressRange.getLength(); len > 0L; len -= (long)length) {
            length = (int)Math.min(len, Integer.MAX_VALUE);
            byte[] bytes = new byte[length];
            fromMem.getBytes(fromWriteAddress, bytes);
            Address toWriteAddress = this.originToResultTranslator.getAddress(fromWriteAddress);
            toMem.setBytes(toWriteAddress, bytes);
            if (len <= (long)length) continue;
            fromWriteAddress = fromWriteAddress.add((long)length);
        }
    }

    public void mergeBytes(AddressSetView originAddressSet, boolean overwriteInstructions, TaskMonitor monitor) throws MemoryAccessException, CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't merge bytes.";
            throw new UnsupportedOperationException(message);
        }
        AddressSet originByteSet = originAddressSet.subtract((AddressSetView)ProgramMemoryUtil.getAddressSet(this.originProgram, false));
        if (originByteSet.isEmpty()) {
            return;
        }
        monitor.setMessage("Finding Instructions...   ");
        AddressSet resultByteSet = DiffUtility.getCompatibleAddressSet((AddressSetView)originByteSet, this.resultProgram);
        AddressSet resultInstructionSet = this.getInstructionSet(resultByteSet, this.resultListing);
        if (overwriteInstructions) {
            monitor.setMessage("Clearing Instructions...   ");
            AddressRangeIterator resultRangeIter = resultInstructionSet.getAddressRanges();
            int count = 0;
            while (resultRangeIter.hasNext()) {
                monitor.checkCanceled();
                AddressRange resultRange = (AddressRange)resultRangeIter.next();
                Address resultMin = resultRange.getMinAddress();
                Address resultMax = resultRange.getMaxAddress();
                this.resultListing.clearCodeUnits(resultMin, resultMax, false, monitor);
                if (count != 129) continue;
                monitor.setMessage("Clearing Instructions...   " + resultMin.toString(true));
                count = 0;
            }
        } else {
            AddressSet originInstructionSet = DiffUtility.getCompatibleAddressSet((AddressSetView)resultInstructionSet, this.originProgram);
            if ((originByteSet = originByteSet.subtract((AddressSetView)originInstructionSet)).isEmpty()) {
                return;
            }
        }
        Memory memory = this.resultProgram.getMemory();
        AddressSetView initializedAddressSet = memory.getLoadedAndInitializedAddressSet();
        AddressSet originInitializedAddressSet = DiffUtility.getCompatibleAddressSet(initializedAddressSet, this.originProgram);
        originByteSet = originByteSet.intersect((AddressSetView)originInitializedAddressSet);
        monitor.setMessage("Copying Bytes...   ");
        this.copyBytesInRanges((AddressSetView)originByteSet, monitor);
        if (overwriteInstructions) {
            Disassembler disassembler = Disassembler.getDisassembler((Program)this.resultProgram, (TaskMonitor)monitor, (DisassemblerMessageListener)DisassemblerMessageListener.IGNORE);
            monitor.setMessage("Restoring Instructions...   ");
            AddressRangeIterator rangeIter = resultInstructionSet.getAddressRanges();
            int count = 0;
            while (rangeIter.hasNext()) {
                monitor.checkCanceled();
                AddressRange range = (AddressRange)rangeIter.next();
                Address min = range.getMinAddress();
                Address max = range.getMaxAddress();
                disassembler.disassemble(min, (AddressSetView)new AddressSet(min, max), false);
                if (count != 129) continue;
                monitor.setMessage("Restoring Instructions...   " + min.toString(true));
                count = 0;
            }
        }
    }

    private AddressSet getInstructionSet(AddressSet byteAddressSet, Listing listing) {
        AddressSet instructionSet = new AddressSet();
        AddressRangeIterator rangeIter = byteAddressSet.getAddressRanges();
        while (rangeIter.hasNext()) {
            AddressRange range = (AddressRange)rangeIter.next();
            Address min = range.getMinAddress();
            Address max = range.getMaxAddress();
            Instruction instr = listing.getInstructionContaining(min);
            if (instr != null) {
                instructionSet.add((AddressRange)new AddressRangeImpl(instr.getMinAddress(), instr.getMaxAddress()));
            }
            InstructionIterator instIter = listing.getInstructions((AddressSetView)new AddressSet(min, max), true);
            while (instIter.hasNext()) {
                instr = instIter.next();
                instructionSet.add((AddressRange)new AddressRangeImpl(instr.getMinAddress(), instr.getMaxAddress()));
            }
        }
        return instructionSet;
    }

    public void mergeCodeUnits(AddressSetView originAddressSet, AddressSetView byteDiffs, boolean mergeDataBytes, TaskMonitor monitor) throws MemoryAccessException, CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't merge code units.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Applying Code Units...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        ProgramContext originContext = this.originProgram.getProgramContext();
        ProgramContext resultContext = this.resultProgram.getProgramContext();
        Register originContextReg = originContext.getBaseContextRegister();
        Register resultContextReg = resultContext.getBaseContextRegister();
        originAddressSet = SimpleDiffUtility.expandAddressSetToIncludeFullDelaySlots((Program)this.originProgram, (AddressSetView)originAddressSet);
        for (AddressRange originRange : originAddressSet.getAddressRanges()) {
            AddressSet rangeSet = new AddressSet(originRange);
            InstructionIterator instructions = this.originListing.getInstructions((AddressSetView)new AddressSet(originRange), true);
            for (Instruction instruction : instructions) {
                Address resultAddress;
                Instruction resultInstruction;
                if (this.shouldClearInstruction(instruction, resultInstruction = this.resultListing.getInstructionAt(resultAddress = this.originToResultTranslator.getAddress(instruction.getMinAddress())))) continue;
                rangeSet.delete(instruction.getMinAddress(), instruction.getMaxAddress());
            }
            for (AddressRange newOriginRange : rangeSet.getAddressRanges()) {
                AddressRange resultRange = this.originToResultTranslator.getAddressRange(newOriginRange);
                this.resultListing.clearCodeUnits(resultRange.getMinAddress(), resultRange.getMaxAddress(), false);
                try {
                    if (resultContextReg == Register.NO_CONTEXT) continue;
                    if (originContextReg != Register.NO_CONTEXT) {
                        this.mergeProgramContext(resultContext, originContext, originContext.getBaseContextRegister(), newOriginRange, resultRange, monitor);
                        continue;
                    }
                    resultContext.remove(resultRange.getMinAddress(), resultRange.getMaxAddress(), resultContextReg);
                }
                catch (ContextChangeException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        CodeUnitIterator originSourceCodeUnits = this.originListing.getCodeUnits(originAddressSet, true);
        long count = 0L;
        while (originSourceCodeUnits.hasNext() && !monitor.isCancelled()) {
            monitor.checkCanceled();
            CodeUnit originCodeUnit = originSourceCodeUnits.next();
            if (count == 129L) {
                monitor.setMessage("Applying Code Units...   " + originCodeUnit.getAddressString(true, false));
                count = 0L;
            }
            if (originCodeUnit instanceof Instruction) {
                Instruction originInstruction = (Instruction)originCodeUnit;
                Address resultAddress = this.originToResultTranslator.getAddress(originInstruction.getMinAddress());
                Instruction resultInstruction = this.resultListing.getInstructionAt(resultAddress);
                if (resultInstruction == null || !originInstruction.getPrototype().equals(resultInstruction.getPrototype())) {
                    this.performMergeInstruction(originInstruction, byteDiffs);
                } else {
                    this.copyInstructionAttributes(originInstruction, resultInstruction);
                }
            } else if (originCodeUnit instanceof Data) {
                try {
                    this.performMergeData((Data)originCodeUnit, byteDiffs, mergeDataBytes);
                }
                catch (CodeUnitInsertionException e) {
                    this.infoMsg.append("Diff/Merge can't apply data from " + originCodeUnit.getMinAddress() + ". " + e.getMessage());
                }
            }
            ++count;
        }
    }

    private boolean shouldClearInstruction(Instruction instruction, Instruction resultInstruction) {
        if (resultInstruction == null) {
            return true;
        }
        if (!ProgramDiff.equivalentInstructionPrototypes(instruction, resultInstruction)) {
            return true;
        }
        try {
            if (!Arrays.equals(instruction.getBytes(), resultInstruction.getBytes())) {
                return true;
            }
        }
        catch (MemoryAccessException e) {
            String message = "ProgramMerge couldn't get the underlying bytes when comparing instructions. instruction1 is at " + instruction.getAddress().toString(true) + ". instruction2 is at " + resultInstruction.getAddress().toString(true) + ".  " + e.getMessage();
            Msg.error((Object)this, (Object)message, (Throwable)e);
            return true;
        }
        return false;
    }

    private void performMergeInstruction(Instruction originInstruction, AddressSetView originByteDiffs) throws MemoryAccessException {
        Instruction newInst;
        boolean initializedBytes;
        int bytesLength;
        Address originMax;
        Address originMin = originInstruction.getMinAddress();
        Address resultMin = this.originToResultTranslator.getAddress(originMin);
        if (originInstruction.isInDelaySlot()) {
            Instruction resultInst = this.resultListing.getInstructionAt(resultMin);
            if (resultInst != null && resultInst.isInDelaySlot()) {
                this.copyInstructionAttributes(originInstruction, resultInst);
            }
            return;
        }
        if (originInstruction.getDelaySlotDepth() != 0) {
            originMax = SimpleDiffUtility.getEndOfDelaySlots((Instruction)originInstruction);
            bytesLength = (int)originMax.subtract(originMin);
        } else {
            originMax = originInstruction.getMaxAddress();
            bytesLength = originInstruction.getLength();
        }
        Address resultMax = this.originToResultTranslator.getAddress(originMax);
        MemoryBlock resultBlock = this.resultProgram.getMemory().getBlock(resultMin);
        boolean bl = initializedBytes = resultBlock != null ? resultBlock.isInitialized() : false;
        if (!initializedBytes) {
            this.infoMsg.append("Diff/Merge can't apply instruction from " + originMin + " to " + resultMin + " since it needs initialized memory");
            return;
        }
        if (this.bytesAreDifferent(originByteDiffs, originMin, resultMin, bytesLength)) {
            ProgramMemoryUtil.copyBytesInRanges(this.resultProgram, this.originProgram, resultMin, resultMax);
        }
        if ((newInst = originInstruction.getDelaySlotDepth() != 0 ? this.disassembleDelaySlottedInstruction(this.resultProgram, resultMin) : this.disassembleNonDelaySlotInstruction(this.resultProgram, resultMin)) == null) {
            return;
        }
        this.copyInstructionAttributes(originInstruction, newInst);
    }

    private void copyInstructionAttributes(Instruction originInstruction, Instruction targetInstruction) {
        FlowOverride targetFlowOverride;
        FlowOverride originFlowOverride;
        Address oldFallThrough = originInstruction.getFallThrough();
        Address newFallThrough = this.originToResultTranslator.getAddress(oldFallThrough);
        if (!SystemUtilities.isEqual((Object)targetInstruction.getFallThrough(), (Object)newFallThrough)) {
            if (originInstruction.isFallThroughOverridden()) {
                targetInstruction.setFallThrough(newFallThrough);
            } else {
                targetInstruction.clearFallThroughOverride();
            }
        }
        if ((originFlowOverride = originInstruction.getFlowOverride()) != (targetFlowOverride = targetInstruction.getFlowOverride())) {
            targetInstruction.setFlowOverride(originFlowOverride);
        }
    }

    private Instruction disassembleDelaySlottedInstruction(Program program, Address addr) {
        AddressSet restrictedSet = new AddressSet(addr);
        Disassembler disassembler = Disassembler.getDisassembler((Program)program, (TaskMonitor)TaskMonitorAdapter.DUMMY_MONITOR, null);
        disassembler.disassemble(addr, (AddressSetView)restrictedSet, false);
        return program.getListing().getInstructionAt(addr);
    }

    private Instruction disassembleNonDelaySlotInstruction(Program program, Address addr) {
        DisassemblerContextImpl context = new DisassemblerContextImpl(program.getProgramContext());
        context.flowStart(addr);
        try {
            InstructionPrototype proto = program.getLanguage().parse((MemBuffer)new DumbMemBufferImpl(program.getMemory(), addr), (ProcessorContext)context, false);
            return this.resultListing.createInstruction(addr, proto, (MemBuffer)new DumbMemBufferImpl(program.getMemory(), addr), (ProcessorContextView)new ProgramProcessorContext(program.getProgramContext(), addr));
        }
        catch (Exception e) {
            program.getBookmarkManager().setBookmark(addr, "Error", "Bad Instruction", "Diff/Merge applied bad instruction");
            return null;
        }
    }

    private boolean bytesAreDifferent(AddressSetView originByteDiffs, Address originMin, Address resultMin, int byteCnt) throws MemoryAccessException {
        if (originByteDiffs != null) {
            AddressSet resultByteDiffs = this.originToResultTranslator.getAddressSet(originByteDiffs);
            return resultByteDiffs.intersects((AddressSetView)new AddressSet(resultMin, resultMin.add((long)byteCnt)));
        }
        byte[] originBytes = new byte[byteCnt];
        this.originProgram.getMemory().getBytes(originMin, originBytes);
        byte[] resultBytes = new byte[byteCnt];
        this.resultProgram.getMemory().getBytes(resultMin, resultBytes);
        return !Arrays.equals(originBytes, resultBytes);
    }

    private void performMergeData(Data originData, AddressSetView originByteDiffs, boolean copyBytes) throws CodeUnitInsertionException, MemoryAccessException {
        Address originMin = originData.getMinAddress();
        Address originMax = originData.getMaxAddress();
        Address resultMin = this.originToResultTranslator.getAddress(originMin);
        Address resultMax = this.originToResultTranslator.getAddress(originMax);
        DataType dt = originData.getDataType();
        boolean hasNewData = false;
        if (copyBytes && this.bytesAreDifferent(originByteDiffs, originMin, resultMin, originData.getLength())) {
            ProgramMemoryUtil.copyBytesInRanges(this.resultProgram, this.originProgram, resultMin, resultMax);
        }
        if (!dt.equals(DataType.DEFAULT)) {
            this.resultListing.createData(resultMin, originData.getDataType(), originData.getLength());
            hasNewData = true;
        }
        if (hasNewData) {
            String[] settingNames;
            Data newData = this.resultListing.getDataAt(resultMin);
            for (String settingName : settingNames = originData.getNames()) {
                Object obj = originData.getValue(settingName);
                if (obj == null) continue;
                newData.setValue(settingName, obj);
            }
        }
    }

    public void mergeEquates(AddressSetView originAddressSet, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't merge equates.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Applying Equates...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        AddressIterator addresses = originAddressSet.getAddresses(true);
        long count = 0L;
        while (addresses.hasNext() && !monitor.isCancelled()) {
            monitor.checkCanceled();
            Address address = addresses.next();
            if (count == 129L) {
                monitor.setMessage("Applying Equates...   " + address.toString(true, false));
                count = 0L;
            }
            this.mergeEquates(address);
            ++count;
        }
    }

    public void mergeEquate(Address originAddress, int opIndex, long value) {
        Equate originEquate;
        EquateTable resultEquateTable = this.resultProgram.getEquateTable();
        EquateTable originEquateTable = this.originProgram.getEquateTable();
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        Equate resultEquate = resultEquateTable.getEquate(resultAddress, opIndex, value);
        if (SystemUtilities.isEqual((Object)resultEquate, (Object)(originEquate = originEquateTable.getEquate(originAddress, opIndex, value)))) {
            return;
        }
        if (resultEquate != null) {
            resultEquate.removeReference(resultAddress, opIndex);
            if (resultEquate.getReferenceCount() == 0) {
                resultEquateTable.removeEquate(resultEquate.getName());
            }
        }
        if (originEquate != null) {
            Equate uniqueEquate = this.getUniqueEquate(resultEquateTable, originEquate.getName(), value);
            uniqueEquate.addReference(resultAddress, opIndex);
        }
    }

    private Equate getUniqueEquate(EquateTable et, String name, long value) {
        for (int count = -1; count <= Integer.MAX_VALUE; ++count) {
            String newName = name + (count >= 0 ? SYMBOL_CONFLICT_SUFFIX : "") + (count > 0 ? Integer.toString(count) : "");
            Equate eq = et.getEquate(newName);
            if (eq == null) {
                try {
                    Equate equate = et.createEquate(newName, value);
                    if (!newName.equals(name)) {
                        this.saveDuplicateEquate(equate, name);
                    }
                    return equate;
                }
                catch (DuplicateNameException e) {
                    Equate equate = et.getEquate(newName);
                    if (equate == null || equate.getValue() != value) continue;
                    return equate;
                }
                catch (InvalidInputException e) {
                    throw new RuntimeException("Can't merge equate with name [" + name + "] and value [" + value + "].", e);
                }
            }
            if (eq.getValue() != value) continue;
            return eq;
        }
        throw new RuntimeException("Can't merge equate with name [" + name + "] and value [" + value + "].");
    }

    void mergeEquates(Address originAddress) {
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        if (resultAddress == null) {
            return;
        }
        EquateTable originEt = this.originProgram.getEquateTable();
        EquateTable resultEt = this.resultProgram.getEquateTable();
        for (int opIndex = 0; opIndex < 16; ++opIndex) {
            Equate resultEquate;
            List originList = originEt.getEquates(originAddress, opIndex);
            Equate originEquate = originList.size() > 0 ? (Equate)originList.get(originList.size() - 1) : null;
            List resultList = resultEt.getEquates(resultAddress, opIndex);
            Equate equate = resultEquate = resultList.size() > 0 ? (Equate)resultList.get(resultList.size() - 1) : null;
            if (originEquate == null && resultEquate == null || resultEquate != null && resultEquate.equals(originEquate)) continue;
            if (originEquate != null) {
                long value = originEquate.getValue();
                this.mergeEquate(resultAddress, opIndex, value);
                continue;
            }
            if (resultEquate == null) continue;
            resultEquate.removeReference(resultAddress, opIndex);
            if (resultEquate.getReferenceCount() != 0) continue;
            resultEt.removeEquate(resultEquate.getName());
        }
    }

    private void saveDuplicateEquate(Equate dupEquate, String desiredName) {
        this.dupEquates.put(dupEquate.getName(), new DupEquate(dupEquate, desiredName));
    }

    void reApplyDuplicateEquates() {
        for (String conflictName : this.dupEquates.keySet()) {
            DupEquate dupEquate = this.dupEquates.get(conflictName);
            Equate equate = dupEquate.equate;
            String desiredName = dupEquate.preferredName;
            try {
                equate.renameEquate(desiredName);
                this.dupEquates.remove(conflictName);
            }
            catch (DuplicateNameException e) {
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                this.errorMsg.append("InvalidInputException re-applying duplicate equates: " + e.getMessage() + "\n");
            }
        }
    }

    String getDuplicateEquatesInfo() {
        StringBuffer buf = new StringBuffer();
        for (String conflictName : this.dupEquates.keySet()) {
            DupEquate dupEquate = this.dupEquates.get(conflictName);
            Equate equate = dupEquate.equate;
            String desiredName = dupEquate.preferredName;
            String msg = "Equate '" + desiredName + "' with value of " + equate.getValue() + " renamed to '" + conflictName + "' due to merge conflict.\n";
            buf.append(msg);
        }
        return buf.toString();
    }

    void clearDuplicateEquates() {
        this.dupEquates.clear();
    }

    public void replaceReferences(AddressSetView originAddressSet, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        this.replaceReferences(originAddressSet, false, monitor);
    }

    public void replaceReferences(AddressSetView originAddressSet, boolean onlyKeepDefaults, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't replace references.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Replacing References...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        AddressSet resultAddressSet = this.originToResultTranslator.getAddressSet(originAddressSet);
        ReferenceManager originRM = this.originProgram.getReferenceManager();
        ReferenceManager resultRM = this.resultProgram.getReferenceManager();
        AddressIterator originIter = originRM.getReferenceSourceIterator(originAddressSet, true);
        AddressIterator resultIter = resultRM.getReferenceSourceIterator((AddressSetView)resultAddressSet, true);
        AddressIteratorConverter convertedResultIter = new AddressIteratorConverter(this.resultProgram, resultIter, this.originProgram);
        MultiAddressIterator originRefAddrIter = new MultiAddressIterator(new AddressIterator[]{convertedResultIter, originIter});
        long count = 0L;
        while (originRefAddrIter.hasNext() && !monitor.isCancelled()) {
            monitor.checkCanceled();
            Address originAddress = originRefAddrIter.next();
            if (count == 129L) {
                monitor.setMessage("Replacing References...   " + originAddress.toString(true));
                count = 0L;
            }
            this.replaceRefs(originAddress, onlyKeepDefaults);
            ++count;
        }
    }

    private void replaceRefs(Address originAddress, boolean defaultsOnly) {
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        ReferenceManager originalRM = this.originProgram.getReferenceManager();
        ReferenceManager resultRM = this.resultProgram.getReferenceManager();
        Reference[] originRefs = originalRM.getReferencesFrom(originAddress);
        Reference[] resultRefs = resultRM.getReferencesFrom(resultAddress);
        HashMap<Reference, Reference> originToResultMap = new HashMap<Reference, Reference>();
        for (Reference origRef : originRefs) {
            SourceType source = origRef.getSource();
            if (defaultsOnly && source != SourceType.DEFAULT) continue;
            Reference resultRef = DiffUtility.getReference(this.originToResultTranslator, origRef);
            originToResultMap.put(origRef, resultRef);
        }
        for (Reference resultRef : resultRefs) {
            if (resultRef.getReferenceType().isFallthrough() || originToResultMap.containsKey(resultRef)) continue;
            resultRM.delete(resultRef);
        }
        for (Reference originRef : originToResultMap.keySet()) {
            if (originRef.getReferenceType().isFallthrough()) continue;
            Reference resultRef = (Reference)originToResultMap.get(originRef);
            this.replaceReference(resultRef, originRef);
        }
    }

    public void mergeReferences(AddressSetView originAddressSet, boolean onlyKeepDefaults, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't merge references.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Merging References...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        AddressSet resultAddressSet = this.originToResultTranslator.getAddressSet(originAddressSet);
        ReferenceManager originRM = this.originProgram.getReferenceManager();
        ReferenceManager resultRM = this.resultProgram.getReferenceManager();
        AddressIterator originIter = originRM.getReferenceSourceIterator(originAddressSet, true);
        AddressIterator resultIter = resultRM.getReferenceSourceIterator((AddressSetView)resultAddressSet, true);
        AddressIteratorConverter convertedResultIter = new AddressIteratorConverter(this.resultProgram, resultIter, this.originProgram);
        MultiAddressIterator originRefAddrIter = new MultiAddressIterator(new AddressIterator[]{convertedResultIter, originIter});
        long count = 0L;
        while (originRefAddrIter.hasNext() && !monitor.isCancelled()) {
            monitor.checkCanceled();
            Address originAddress = originRefAddrIter.next();
            if (count == 129L) {
                monitor.setMessage("Merging References...   " + originAddress.toString(true));
                count = 0L;
            }
            this.mergeRefs(originAddress, onlyKeepDefaults);
            ++count;
        }
    }

    private void mergeRefs(Address originAddress, boolean defaultsOnly) {
        ReferenceManager originalRM = this.originProgram.getReferenceManager();
        Reference[] originRefs = originalRM.getReferencesFrom(originAddress);
        HashMap<Reference, Reference> originToResultMap = new HashMap<Reference, Reference>();
        for (Reference origRef : originRefs) {
            SourceType source = origRef.getSource();
            if (defaultsOnly && source != SourceType.DEFAULT) continue;
            Reference resultRef = DiffUtility.getReference(this.originToResultTranslator, origRef);
            originToResultMap.put(origRef, resultRef);
        }
        for (Reference originRef : originToResultMap.keySet()) {
            Reference resultRef = (Reference)originToResultMap.get(originRef);
            if (originRef.getReferenceType().isFallthrough()) continue;
            this.replaceReference(resultRef, originRef);
        }
    }

    private void replaceReferences(CodeUnit originCu, int opIndex) {
        Address resultAddress = this.originToResultTranslator.getAddress(originCu.getMinAddress());
        this.resultCu = this.resultListing.getCodeUnitAt(resultAddress);
        if (opIndex > this.resultCu.getNumOperands()) {
            return;
        }
        ReferenceManager resultRM = this.resultProgram.getReferenceManager();
        Reference[] resultRefs = resultRM.getReferencesFrom(this.resultCu.getMinAddress(), opIndex);
        Reference[] originRefs = this.originProgram.getReferenceManager().getReferencesFrom(originCu.getMinAddress(), opIndex);
        HashMap<Reference, Reference> resultsToKeep = new HashMap<Reference, Reference>();
        for (Reference originRef : originRefs) {
            Reference resultRef = DiffUtility.getReference(this.originToResultTranslator, originRef);
            resultsToKeep.put(originRef, resultRef);
        }
        for (Reference resultRef : resultRefs) {
            if (resultsToKeep.containsValue(resultRef)) continue;
            resultRM.delete(resultRef);
        }
        for (Reference originRef : resultsToKeep.keySet()) {
            Reference resultRef = (Reference)resultsToKeep.get(originRef);
            this.replaceReference(resultRef, originRef);
        }
    }

    public void replaceReferences(Address originAddress, int operandIndex) {
        CodeUnit fromCu = this.originListing.getCodeUnitAt(originAddress);
        this.replaceReferences(fromCu, operandIndex);
    }

    public Reference replaceReference(Reference resultRef, Reference originRef) {
        ReferenceManager rm = this.resultProgram.getReferenceManager();
        if (originRef != null) {
            if (originRef.isExternalReference()) {
                this.updateExternalLocation(this.resultProgram, (ExternalReference)originRef);
            }
            return this.addReference(originRef, -1L, true);
        }
        rm.delete(resultRef);
        return null;
    }

    private void updateExternalLocation(Program toPgm, ExternalReference fromRef) {
        ExternalLocation fromExtLoc = fromRef.getExternalLocation();
        Namespace fromNamespace = fromExtLoc.getParentNameSpace();
        String fromExtLabel = fromExtLoc.getLabel();
        Address fromExtAddr = fromExtLoc.getAddress();
        SourceType fromSourceType = fromExtLoc.getSource();
        ExternalManager toExtMgr = toPgm.getExternalManager();
        try {
            Program fromPgm = fromExtLoc.getSymbol().getProgram();
            Namespace toNamespace = DiffUtility.createNamespace(fromPgm, fromNamespace, toPgm);
            ExternalLocation toExternalLocation = SimpleDiffUtility.getMatchingExternalLocation((Program)fromPgm, (ExternalLocation)fromExtLoc, (Program)toPgm);
            if (toExternalLocation == null) {
                toExtMgr.addExtLocation(toNamespace, fromExtLabel, fromExtAddr, fromSourceType);
            } else {
                String toExtLabel = toExternalLocation.getLabel();
                toExternalLocation.setLocation(toExtLabel, fromExtAddr, fromExtLoc.getSource());
            }
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.errorMsg.append("InvalidInputException updating external location: " + e.getMessage() + "\n");
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.errorMsg.append("DuplicateNameException updating external location: " + e.getMessage() + "\n");
        }
    }

    public Reference replaceReference(Reference resultRef, Reference originRef, long toSymbolID) {
        ReferenceManager rm = this.resultProgram.getReferenceManager();
        if (resultRef != null) {
            rm.delete(resultRef);
        }
        if (originRef != null) {
            Address toAddress = this.originToResultTranslator.getAddress(originRef.getToAddress());
            Symbol resultToSymbol = this.resultProgram.getSymbolTable().getSymbol(toSymbolID);
            if (resultToSymbol != null && !resultToSymbol.getAddress().equals((Object)toAddress)) {
                resultToSymbol = null;
            }
            resultRef = DiffUtility.createReference(this.originProgram, originRef, this.resultProgram);
            if (resultToSymbol != null) {
                rm.setAssociation(resultToSymbol, resultRef);
            }
        } else {
            resultRef = null;
        }
        return resultRef;
    }

    public Reference addReference(Reference originRef, long toSymbolID, boolean replaceExtLoc) {
        ReferenceManager rm = this.resultProgram.getReferenceManager();
        Reference resultRef = null;
        if (originRef != null) {
            Symbol resultToSymbol = this.resultProgram.getSymbolTable().getSymbol(toSymbolID);
            if (originRef.isExternalReference()) {
                ExternalReference origExtRef = (ExternalReference)originRef;
                ExternalLocation origExtLoc = origExtRef.getExternalLocation();
                if (origExtLoc == null) {
                    return null;
                }
                ExternalLocation resultExtLoc = this.findExternalLocation(origExtLoc, resultToSymbol);
                if (replaceExtLoc && resultExtLoc != null) {
                    try {
                        String extLabel = origExtLoc.getLabel();
                        Address extAddr = origExtLoc.getAddress();
                        resultExtLoc.setLocation(extLabel, extAddr, origExtLoc.getSource());
                    }
                    catch (DuplicateNameException e) {
                        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                        this.errorMsg.append("DuplicateNameException adding reference: " + e.getMessage() + "\n");
                    }
                    catch (InvalidInputException e) {
                        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                        this.errorMsg.append("InvalidInputException adding reference: " + e.getMessage() + "\n");
                    }
                }
            }
            resultRef = DiffUtility.createReference(this.originProgram, originRef, this.resultProgram);
            if (resultToSymbol != null) {
                rm.setAssociation(resultToSymbol, resultRef);
            }
        }
        return resultRef;
    }

    private ExternalLocation findExternalLocation(ExternalLocation origExtLoc, Symbol resultToSymbol) {
        ExternalLocation toLocation;
        if (resultToSymbol != null && (toLocation = this.resultProgram.getExternalManager().getExternalLocation(resultToSymbol)) != null) {
            return toLocation;
        }
        try {
            return DiffUtility.createExtLocation(this.originProgram, origExtLoc, this.resultProgram);
        }
        catch (DuplicateNameException | InvalidInputException throwable) {
            return null;
        }
    }

    public void replaceFallThroughs(AddressSetView originAddressSet, TaskMonitor monitor) throws CancelledException {
        if (originAddressSet.isEmpty()) {
            return;
        }
        monitor.setMessage("Replacing Fallthroughs...");
        long max = originAddressSet.getNumAddresses();
        monitor.initialize(max);
        CodeUnitIterator cuIterator2 = this.originListing.getCodeUnits(originAddressSet, true);
        long count = 0L;
        while (cuIterator2.hasNext()) {
            monitor.checkCanceled();
            CodeUnit cu2 = cuIterator2.next();
            Address originMinAddress = cu2.getMinAddress();
            if (count == 129L) {
                monitor.setMessage("Replacing FallThroughs...   " + originMinAddress.toString(true));
                count = 0L;
            }
            this.replaceFallThrough(originMinAddress);
            monitor.setProgress(monitor.getProgress() + (long)cu2.getLength());
            ++count;
        }
        monitor.setProgress(max);
    }

    private void replaceFallThrough(Address originAddress) {
        Address originFallThrough;
        Address originFTCompatibleWithResult;
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        Instruction resultInstruction = this.resultListing.getInstructionAt(resultAddress);
        Instruction originInstruction = this.originListing.getInstructionAt(originAddress);
        if (originInstruction == null || resultInstruction == null) {
            return;
        }
        boolean resultOverridden = resultInstruction.isFallThroughOverridden();
        boolean originOverridden = originInstruction.isFallThroughOverridden();
        if (!resultOverridden && !originOverridden) {
            return;
        }
        Address resultFallThrough = resultInstruction.getFallThrough();
        if (SystemUtilities.isEqual((Object)resultFallThrough, (Object)(originFTCompatibleWithResult = this.originToResultTranslator.getAddress(originFallThrough = originInstruction.getFallThrough())))) {
            return;
        }
        if (!originOverridden) {
            resultInstruction.clearFallThroughOverride();
        } else {
            resultInstruction.setFallThrough(originFTCompatibleWithResult);
        }
    }

    public void mergeComment(AddressSet originAddressSet, int type, boolean both, TaskMonitor monitor) throws CancelledException {
        this.mergeCommentType((AddressSetView)originAddressSet, type, both ? 2 : 1, monitor);
    }

    public void mergeCommentType(AddressSetView originAddressSet, int type, int setting, TaskMonitor monitor) throws CancelledException {
        int cuCommentType;
        if (setting != 1 && setting != 2) {
            return;
        }
        String typeStr = "Unknown";
        switch (type) {
            case 32: {
                typeStr = "Plate";
                cuCommentType = 3;
                break;
            }
            case 64: {
                typeStr = "Pre";
                cuCommentType = 1;
                break;
            }
            case 128: {
                typeStr = "EOL";
                cuCommentType = 0;
                break;
            }
            case 256: {
                typeStr = "Repeatable";
                cuCommentType = 4;
                break;
            }
            case 512: {
                typeStr = "Post";
                cuCommentType = 2;
                break;
            }
            default: {
                throw new AssertException("Unrecognized comment type: " + type);
            }
        }
        monitor.setMessage("Applying " + typeStr + " comments...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        monitor.checkCanceled();
        boolean both = setting == 2;
        String prefix = both ? "Merging" : "Replacing";
        AddressIterator addrIter = originAddressSet.getAddresses(true);
        long count = 0L;
        while (addrIter.hasNext()) {
            monitor.checkCanceled();
            Address originAddress = addrIter.next();
            if (count == 129L) {
                monitor.setMessage(prefix + " " + typeStr + " comments...   " + originAddress.toString(true));
                count = 0L;
            }
            if (both) {
                this.mergeComments(cuCommentType, originAddress);
            } else {
                this.replaceComment(cuCommentType, originAddress);
            }
            ++count;
        }
    }

    public void mergeComments(int commentType, Address originAddress) {
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        String resultComment = this.resultListing.getComment(commentType, resultAddress);
        String origComment = this.originListing.getComment(commentType, originAddress);
        String newComment = StringUtilities.mergeStrings((String)resultComment, (String)origComment);
        this.resultListing.setComment(resultAddress, commentType, newComment);
    }

    public void replaceComment(int commentType, Address originAddress) {
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        String origComment = this.originListing.getComment(commentType, originAddress);
        this.resultListing.setComment(resultAddress, commentType, origComment);
    }

    public void applyFunctionTagChanges(AddressSetView originAddressSet, int setting, Set<FunctionTag> discardTags, Set<FunctionTag> keepTags, TaskMonitor monitor) throws CancelledException {
        if (setting != 1 && setting != 2) {
            return;
        }
        monitor.setMessage("Applying function tags...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        monitor.checkCanceled();
        AddressIterator addrIter = originAddressSet.getAddresses(true);
        long count = 0L;
        while (addrIter.hasNext()) {
            monitor.checkCanceled();
            Address originAddress = addrIter.next();
            if (count == 129L) {
                monitor.setMessage(setting + "  function tags...   " + originAddress.toString(true));
                count = 0L;
            }
            if (setting == 2) {
                this.mergeFunctionTags(originAddress, discardTags, keepTags);
            } else if (setting == 1) {
                this.replaceFunctionTags(originAddress);
            }
            ++count;
        }
    }

    private void mergeFunctionTags(Address originAddress, Set<FunctionTag> discardTags, Set<FunctionTag> keepTags) {
        Set<String> tagNames;
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        Function resultFunction = this.resultListing.getFunctionContaining(resultAddress);
        if (resultFunction == null) {
            return;
        }
        Set resultTags = resultFunction.getTags();
        Function originalFunction = this.originListing.getFunctionContaining(originAddress);
        if (originalFunction != null) {
            Set origTags = originalFunction.getTags();
            for (FunctionTag tag : origTags) {
                if (this.containsTag(resultTags, tag.getName())) continue;
                resultFunction.addTag(tag.getName());
            }
        }
        resultTags = this.resultListing.getFunctionContaining(resultAddress).getTags();
        if (discardTags != null) {
            tagNames = this.getTagNames(discardTags);
            for (FunctionTag tag : resultTags) {
                if (!tagNames.contains(tag.getName())) continue;
                resultFunction.removeTag(tag.getName());
                this.removeTagIfUnassigned(tag);
            }
        }
        if (keepTags != null) {
            tagNames = this.getTagNames(keepTags);
            for (String tagName : tagNames) {
                if (this.containsTag(resultTags, tagName)) continue;
                resultFunction.addTag(tagName);
            }
        }
    }

    private void removeTagIfUnassigned(FunctionTag tag) {
        FunctionManagerDB functionManagerDB = (FunctionManagerDB)this.resultProgram.getFunctionManager();
        FunctionTagManager functionTagManager = functionManagerDB.getFunctionTagManager();
        if (!functionTagManager.isTagAssigned(tag.getName())) {
            tag.delete();
        }
    }

    private boolean containsTag(Collection<FunctionTag> tags, String name) {
        for (FunctionTag tag : tags) {
            if (!tag.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getTagNames(Set<FunctionTag> tags) {
        HashSet<String> tagNames = new HashSet<String>();
        for (FunctionTag tag : tags) {
            tagNames.add(tag.getName());
        }
        return tagNames;
    }

    private Set<FunctionTag> getTagsAtAddress(Listing listing, Address addr) {
        Function function = listing.getFunctionContaining(addr);
        if (function == null) {
            return Collections.emptySet();
        }
        return function.getTags();
    }

    private void replaceFunctionTags(Address originAddress) {
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        Set<FunctionTag> originalTags = this.getTagsAtAddress(this.originListing, originAddress);
        Function resultFunction = this.resultListing.getFunctionContaining(resultAddress);
        if (resultFunction == null) {
            Msg.error((Object)this, (Object)("Error retrieving function at address: " + resultAddress));
            return;
        }
        Set currentResultTags = this.resultListing.getFunctionContaining(resultAddress).getTags();
        Iterator<Object> iter = currentResultTags.iterator();
        ArrayList<String> namesToDelete = new ArrayList<String>();
        while (iter.hasNext()) {
            FunctionTag tag = (FunctionTag)iter.next();
            namesToDelete.add(tag.getName());
        }
        for (String name : namesToDelete) {
            resultFunction.removeTag(name);
        }
        for (FunctionTag tag : originalTags) {
            resultFunction.addTag(tag.getName());
        }
    }

    void mergeLabels(AddressSetView originAddressSet, int setting, boolean replacePrimary, boolean replaceFunction, TaskMonitor monitor) throws CancelledException {
        this.symbolMerge.mergeLabels(originAddressSet, setting, replacePrimary, replaceFunction, this.conflictSymbolIDMap, monitor);
    }

    public void mergeLabels(AddressSetView originAddressSet, int setting, TaskMonitor monitor) throws CancelledException {
        this.mergeLabels(originAddressSet, setting, true, true, monitor);
    }

    public void replaceLabels(AddressSet originAddressSet, boolean replaceFunction, TaskMonitor monitor) throws CancelledException {
        this.mergeLabels((AddressSetView)originAddressSet, 1, true, replaceFunction, monitor);
    }

    void reApplyDuplicateSymbols() {
        long[] fromSymbolIDs;
        SymbolTable originSymTab = this.originProgram.getSymbolTable();
        SymbolTable resultSymTab = this.resultProgram.getSymbolTable();
        for (long fromSymbolID : fromSymbolIDs = this.conflictSymbolIDMap.getKeys()) {
            try {
                long toSymbolID = this.conflictSymbolIDMap.get(fromSymbolID);
                Symbol fromSymbol = originSymTab.getSymbol(fromSymbolID);
                Symbol toSymbol = resultSymTab.getSymbol(toSymbolID);
                try {
                    toSymbol.setName(fromSymbol.getName(), fromSymbol.getSource());
                    this.conflictSymbolIDMap.remove(fromSymbolID);
                }
                catch (DuplicateNameException e) {
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    this.errorMsg.append("InvalidInputException re-applying duplicate symbols: " + e.getMessage() + "\n");
                }
            }
            catch (NoValueException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                this.errorMsg.append("NoValueException re-applying duplicate symbols: " + e.getMessage() + "\n");
            }
        }
    }

    String getDuplicateSymbolsInfo() {
        long[] fromSymbolIDs;
        StringBuffer buf = new StringBuffer();
        SymbolTable origSymTab = this.originProgram.getSymbolTable();
        SymbolTable resultSymTab = this.resultProgram.getSymbolTable();
        for (long fromSymbolID : fromSymbolIDs = this.conflictSymbolIDMap.getKeys()) {
            try {
                long toSymbolID = this.conflictSymbolIDMap.get(fromSymbolID);
                Symbol fromSymbol = origSymTab.getSymbol(fromSymbolID);
                Symbol toSymbol = resultSymTab.getSymbol(toSymbolID);
                String msg = "Symbol '" + fromSymbol.getName(true) + "' renamed to '" + toSymbol.getName(true) + "' due to a merge conflict.\n";
                buf.append(msg);
            }
            catch (NoValueException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                this.errorMsg.append("NoValueException getting duplicate symbol info: " + e.getMessage() + "\n");
            }
        }
        return buf.toString();
    }

    void clearDuplicateSymbols() {
        this.conflictSymbolIDMap.removeAll();
    }

    static boolean overlapsOtherFunctions(Function fromFunc, Program toProgram) {
        Program fromProgram = fromFunc.getProgram();
        AddressSetView fromBody = fromFunc.getBody();
        AddressSet newBody = DiffUtility.getCompatibleAddressSet(fromBody, toProgram);
        Address fromEntryPoint = fromFunc.getEntryPoint();
        Address toEntryPoint = SimpleDiffUtility.getCompatibleAddress((Program)fromProgram, (Address)fromEntryPoint, (Program)toProgram);
        FunctionManager toFunctionManager = toProgram.getFunctionManager();
        Iterator overlapIter = toFunctionManager.getFunctionsOverlapping((AddressSetView)newBody);
        while (overlapIter.hasNext()) {
            Function func = (Function)overlapIter.next();
            Address overlapEntryPoint = func.getEntryPoint();
            if (overlapEntryPoint.equals((Object)toEntryPoint)) continue;
            return true;
        }
        return false;
    }

    static boolean overlapsOtherFunctions(AddressTranslator addressTranslator, Function fromFunc) throws UnsupportedOperationException {
        if (!addressTranslator.isOneForOneTranslator()) {
            String message = addressTranslator.getClass().getName() + " is not a one for one translator and can't determine function overlap.";
            throw new UnsupportedOperationException(message);
        }
        Program toProgram = addressTranslator.getDestinationProgram();
        AddressSetView fromBody = fromFunc.getBody();
        AddressSet newBody = addressTranslator.getAddressSet(fromBody);
        Address fromEntryPoint = fromFunc.getEntryPoint();
        Address toEntryPoint = addressTranslator.getAddress(fromEntryPoint);
        FunctionManager toFunctionManager = toProgram.getFunctionManager();
        Iterator overlapIter = toFunctionManager.getFunctionsOverlapping((AddressSetView)newBody);
        while (overlapIter.hasNext()) {
            Function func = (Function)overlapIter.next();
            Address overlapEntryPoint = func.getEntryPoint();
            if (overlapEntryPoint.equals((Object)toEntryPoint)) continue;
            return true;
        }
        return false;
    }

    public void replaceFunctionNames(AddressSetView originAddressSet, TaskMonitor monitor) throws CancelledException {
        if (originAddressSet.isEmpty()) {
            return;
        }
        this.functionMerge.replaceFunctionsNames(originAddressSet, monitor);
    }

    public void mergeFunctions(AddressSetView addrSet, TaskMonitor monitor) throws CancelledException {
        if (addrSet.isEmpty()) {
            return;
        }
        this.removeFunctionsNotInProgram2(addrSet, monitor);
        this.replaceFunctions(addrSet, monitor);
    }

    private void removeFunctionsNotInProgram2(AddressSetView addrSet2, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't remove functions not in program2.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Removing Functions...");
        AddressSet addrSet1 = this.originToResultTranslator.getAddressSet(addrSet2);
        FunctionManager funcMgr1 = this.resultProgram.getFunctionManager();
        FunctionManager funcMgr2 = this.originProgram.getFunctionManager();
        FunctionIterator funcIter1 = funcMgr1.getFunctions((AddressSetView)addrSet1, true);
        FunctionIterator funcIter2 = funcMgr2.getFunctions(addrSet2, true);
        FunctionAddressIterator iter1 = new FunctionAddressIterator(funcIter1);
        FunctionAddressIterator iter2 = new FunctionAddressIterator(funcIter2);
        HashSet<Address> resultsToKeep = new HashSet<Address>();
        while (iter2.hasNext()) {
            monitor.checkCanceled();
            Address addr2 = iter2.next();
            Address addr1 = this.originToResultTranslator.getAddress(addr2);
            resultsToKeep.add(addr1);
        }
        while (iter1.hasNext()) {
            monitor.checkCanceled();
            Address resultAddress = iter1.next();
            if (resultsToKeep.contains(resultAddress)) continue;
            monitor.setMessage("Removing Functions...   " + resultAddress.toString(true));
            funcMgr1.removeFunction(resultAddress);
        }
    }

    private void replaceFunctions(AddressSetView addrSet2, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't replace functions.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Replacing Functions...");
        AddressSet addrSet = this.originToResultTranslator.getAddressSet(addrSet2);
        FunctionManager resultFM = this.resultProgram.getFunctionManager();
        FunctionManager originFM = this.originProgram.getFunctionManager();
        FunctionIterator funcIter1 = resultFM.getFunctions((AddressSetView)addrSet, true);
        FunctionIterator funcIter2 = originFM.getFunctions(addrSet2, true);
        FunctionAddressIterator iter1 = new FunctionAddressIterator(funcIter1);
        FunctionAddressIterator iter2 = new FunctionAddressIterator(funcIter2);
        AddressIteratorConverter convertedIter2 = new AddressIteratorConverter(this.originProgram, iter2, this.resultProgram);
        MultiAddressIterator functionIter = new MultiAddressIterator(new AddressIterator[]{iter1, convertedIter2});
        AddressSet resultEntrySet = new AddressSet();
        while (functionIter.hasNext()) {
            monitor.checkCanceled();
            Address address = functionIter.next();
            resultEntrySet.addRange(address, address);
        }
        long totalAddresses = resultEntrySet.getNumAddresses();
        long granularity = totalAddresses / 129L + 1L;
        monitor.initialize(totalAddresses);
        AddressSet thunkSet = new AddressSet();
        AddressIterator it = resultEntrySet.getAddresses(true);
        int count = 0;
        while (it.hasNext()) {
            monitor.checkCanceled();
            Address address = it.next();
            if ((long)count % granularity == 0L) {
                monitor.setProgress((long)count);
                monitor.setMessage("Replacing Function " + (count + 1) + " of " + totalAddresses + ". Address = " + address.toString(true));
            }
            if (this.isThunkFunction(address)) {
                thunkSet.addRange(address, address);
            } else {
                this.replaceFunction(address, monitor);
            }
            ++count;
        }
        monitor.setProgress(totalAddresses);
        this.replaceThunks(thunkSet, monitor);
    }

    private void replaceThunks(AddressSet thunkSet, TaskMonitor monitor) throws CancelledException {
        long totalThunks = thunkSet.getNumAddresses();
        long granularity = totalThunks / 129L + 1L;
        monitor.initialize(totalThunks);
        AddressIterator thunkIter = thunkSet.getAddresses(true);
        int count = 0;
        while (thunkIter.hasNext()) {
            monitor.checkCanceled();
            Address address = thunkIter.next();
            if ((long)count % granularity == 0L) {
                monitor.setProgress((long)count);
                monitor.setMessage("Replacing Thunk Function " + (count + 1) + " of " + totalThunks + ". Address = " + address.toString(true));
            }
            this.replaceFunction(address, monitor);
            ++count;
        }
        monitor.setProgress(totalThunks);
    }

    private boolean isThunkFunction(Address originEntryPoint) {
        Function originFunction = this.originListing.getFunctionAt(originEntryPoint);
        return originFunction != null && originFunction.isThunk();
    }

    public Function mergeFunction(Address entry, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        return this.replaceFunction(entry, monitor);
    }

    public void mergeFunctionReturn(Address entry2) {
        Address entry = this.originToResultTranslator.getAddress(entry2);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(entry);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(entry2);
        if (f1 != null && f2 != null) {
            try {
                Parameter f1Return = f1.getReturn();
                Parameter f2Return = f2.getReturn();
                DataType dt1 = f1Return.getDataType();
                DataType dt2 = f2Return.getDataType();
                boolean storageMatches = f1Return.getVariableStorage().equals((Object)f2Return.getVariableStorage());
                if (this.sameDataType(dt1, dt2)) {
                    if (storageMatches) {
                        return;
                    }
                    dt2 = dt1;
                } else if (storageMatches) {
                    if (!f1.hasCustomVariableStorage()) {
                        dt2 = f2Return.getFormalDataType();
                    }
                    f1Return.setDataType(dt2, f2.getSignatureSource());
                    return;
                }
                try {
                    if (f2.hasCustomVariableStorage()) {
                        f1.setCustomVariableStorage(true);
                    } else if (!f1.hasCustomVariableStorage()) {
                        dt2 = f2Return.getFormalDataType();
                    }
                    f1Return.setDataType(dt2, f2Return.getVariableStorage(), true, f2.getSignatureSource());
                }
                catch (InvalidInputException e) {
                    f1Return.setDataType(dt2, VariableStorage.UNASSIGNED_STORAGE, false, SourceType.DEFAULT);
                    String msg = "Return storage forced to UNASSIGNED for " + f1.getName(true) + ":\n    " + e.getMessage();
                    Msg.error((Object)this, (Object)msg);
                    this.errorMsg.append(msg + "\n");
                }
            }
            catch (InvalidInputException e) {
                this.errorMsg.append("Failed to replace function return for " + f1.getName() + ": " + e.getMessage());
            }
        }
    }

    public void mergeFunctionName(Address entry2, TaskMonitor monitor) {
        Address entry = this.originToResultTranslator.getAddress(entry2);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(entry);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(entry2);
        if (f1 != null && f2 != null) {
            this.replaceFunctionName(f1, f2.getName(), f2.getSymbol().getSource());
        }
    }

    private boolean replaceFunctionName(Function function, String name, SourceType source) {
        if (function != null) {
            Address entry = function.getEntryPoint();
            String origName = function.getName();
            if (!SystemUtilities.isEqual((Object)origName, (Object)name)) {
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    String newName = i == 0 ? name : name + SYMBOL_CONFLICT_SUFFIX + i;
                    try {
                        function.setName(newName, source);
                        if (i > 0) {
                            this.infoMsg.append("Function '" + name + "' was merged as '" + newName + "' @ address " + entry.toString() + ".\n");
                        }
                        return true;
                    }
                    catch (DuplicateNameException e) {
                        continue;
                    }
                    catch (InvalidInputException e) {
                        this.errorMsg.append("Address = " + entry.toString() + ": " + e.getMessage() + "\n");
                        return false;
                    }
                }
                this.errorMsg.append("Function '" + origName + "' couldn't be renamed to '" + name + "' @ address " + entry.toString() + ".\n");
                return false;
            }
        }
        return false;
    }

    private boolean sameDataType(DataType dt1, DataType dt2) {
        return dt1 == null ? dt2 == null : dt1.isEquivalent(dt2);
    }

    public void replaceFunctionSignatureSource(Address originEntryPoint, TaskMonitor monitor) {
        SourceType originSignatureSource;
        SourceType resultSignatureSource;
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function resultFunction = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function originFunction = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (resultFunction != null && originFunction != null && (resultSignatureSource = resultFunction.getSignatureSource()) != (originSignatureSource = originFunction.getSignatureSource())) {
            resultFunction.setSignatureSource(originSignatureSource);
        }
    }

    public void mergeFunctionReturnAddressOffset(Address entry2, TaskMonitor monitor) {
        Address entry = this.originToResultTranslator.getAddress(entry2);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(entry);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(entry2);
        if (f1 != null && f2 != null) {
            int off2;
            StackFrame sf1 = f1.getStackFrame();
            StackFrame sf2 = f2.getStackFrame();
            int off1 = sf1.getReturnAddressOffset();
            if (off1 != (off2 = sf2.getReturnAddressOffset())) {
                sf1.setReturnAddressOffset(off2);
            }
        }
    }

    public void mergeFunctionLocalSize(Address entry2, TaskMonitor monitor) {
        Address entry = this.originToResultTranslator.getAddress(entry2);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(entry);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(entry2);
        if (f1 != null && f2 != null) {
            int ls2;
            StackFrame sf1 = f1.getStackFrame();
            StackFrame sf2 = f2.getStackFrame();
            int ls1 = sf1.getLocalSize();
            if (ls1 != (ls2 = sf2.getLocalSize())) {
                sf1.setLocalSize(ls2);
            }
        }
    }

    public void mergeFunctionStackPurgeSize(Address entry2, TaskMonitor monitor) {
        int sp2;
        int sp1;
        Address entry = this.originToResultTranslator.getAddress(entry2);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(entry);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(entry2);
        if (f1 != null && f2 != null && (sp1 = f1.getStackPurgeSize()) != (sp2 = f2.getStackPurgeSize())) {
            f1.setStackPurgeSize(f2.getStackPurgeSize());
        }
    }

    public void replaceFunctionVarArgs(Address entry2, TaskMonitor monitor) {
        boolean hasVarArgs2;
        boolean hasVarArgs1;
        Address entry = this.originToResultTranslator.getAddress(entry2);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(entry);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(entry2);
        if (f1 != null && f2 != null && (hasVarArgs1 = f1.hasVarArgs()) != (hasVarArgs2 = f2.hasVarArgs())) {
            f1.setVarArgs(hasVarArgs2);
        }
    }

    public void replaceFunctionCallingConvention(Address originEntryPoint, TaskMonitor monitor) {
        String name2;
        String name1;
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null && !(name1 = f1.getCallingConventionName()).equals(name2 = f2.getCallingConventionName())) {
            try {
                f1.setCallingConvention(name2);
            }
            catch (InvalidInputException e) {
                this.errorMsg.append("InvalidInputException replacing calling convention: " + e.getMessage() + "\n");
            }
        }
    }

    public void replaceFunctionInlineFlag(Address originEntryPoint, TaskMonitor monitor) {
        boolean isInline2;
        boolean isInline1;
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null && (isInline1 = f1.isInline()) != (isInline2 = f2.isInline())) {
            f1.setInline(isInline2);
        }
    }

    public void replaceFunctionNoReturnFlag(Address originEntryPoint, TaskMonitor monitor) {
        boolean hasNoReturn2;
        boolean hasNoReturn1;
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null && (hasNoReturn1 = f1.hasNoReturn()) != (hasNoReturn2 = f2.hasNoReturn())) {
            f1.setNoReturn(hasNoReturn2);
        }
    }

    public void replaceFunctionCustomStorageFlag(Address originEntryPoint, TaskMonitor monitor) {
        boolean hasCustomStorage2;
        boolean hasCustomStorage1;
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null && (hasCustomStorage1 = f1.hasCustomVariableStorage()) != (hasCustomStorage2 = f2.hasCustomVariableStorage())) {
            f1.setCustomVariableStorage(hasCustomStorage2);
        }
    }

    public void replaceFunctionParameters(Address originEntryPoint, TaskMonitor monitor) {
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function resultFunction = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function originFunction = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        this.replaceFunctionParameters(resultFunction, originFunction);
    }

    public void replaceFunctionParameters(Function toFunc, Function fromFunc) {
        if (toFunc == null || fromFunc == null) {
            return;
        }
        try {
            Parameter[] fromParams = fromFunc.getParameters();
            if (!this.resolveParamaterNameConflicts(toFunc, fromParams)) {
                return;
            }
            toFunc.updateFunction(toFunc.getCallingConventionName(), (Variable)fromFunc.getReturn(), fromFunc.hasCustomVariableStorage() ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, fromFunc.getSignatureSource(), (Variable[])fromParams);
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.errorMsg.append("Can't replace parameters for function " + toFunc.getName(true));
            this.errorMsg.append(e.getMessage() + "\n");
            return;
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.errorMsg.append("Can't replace return/parameters for function " + toFunc.getName(true));
            this.errorMsg.append(e.getMessage() + "\n");
            return;
        }
        boolean shouldHaveVarArgs = fromFunc.hasVarArgs();
        if (toFunc.hasVarArgs() != shouldHaveVarArgs) {
            toFunc.setVarArgs(shouldHaveVarArgs);
        }
    }

    public static String getUniqueName(SymbolTable symbolTable, String name, Address address, Namespace namespace1, Namespace namespace2, SymbolType type) {
        Object newName = name;
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            boolean canCreateSymbol1 = ProgramMerge.isUniqueSymbolName(symbolTable, namespace1, (String)newName, address, type);
            boolean canCreateSymbol2 = ProgramMerge.isUniqueSymbolName(symbolTable, namespace2, (String)newName, address, type);
            if (canCreateSymbol1 && canCreateSymbol2) {
                return newName;
            }
            newName = name + SYMBOL_CONFLICT_SUFFIX + i;
        }
        throw new AssertException("This is crazy!");
    }

    public static String getUniqueName(SymbolTable symbolTable, String name, Address address, Namespace namespace, SymbolType type) {
        Object newName = name;
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            boolean canCreateSymbol = ProgramMerge.isUniqueSymbolName(symbolTable, namespace, (String)newName, address, type);
            if (canCreateSymbol) {
                return newName;
            }
            newName = name + SYMBOL_CONFLICT_SUFFIX + i;
        }
        throw new AssertException("Couldn't get a unique symbol name for " + name);
    }

    private static boolean isUniqueSymbolName(SymbolTable symbolTable, Namespace namespace, String name, Address address, SymbolType type) {
        if (address.isExternalAddress()) {
            return false;
        }
        if (symbolTable.getSymbol(name, address, namespace) != null) {
            return false;
        }
        if (type.allowsDuplicates()) {
            return true;
        }
        List symbols = symbolTable.getSymbols(name, namespace);
        for (Symbol symbol : symbols) {
            if (symbol.getSymbolType().allowsDuplicates()) continue;
            return false;
        }
        return true;
    }

    private Function replaceFunction(Address originEntryPoint, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        Function newResultFunction;
        Function originFunction;
        Address resultEntryPoint;
        block29: {
            AddressSetView oldResultBody;
            boolean sameBody;
            if (!this.originToResultTranslator.isOneForOneTranslator()) {
                String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't replace a function.";
                throw new UnsupportedOperationException(message);
            }
            resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
            originFunction = this.originListing.getFunctionAt(originEntryPoint);
            Function resultFunction = this.resultListing.getFunctionAt(resultEntryPoint);
            if (originFunction == null) {
                if (resultFunction != null) {
                    this.resultListing.removeFunction(resultEntryPoint);
                }
                return null;
            }
            if (ProgramDiff.equivalentFunctions(originFunction, resultFunction, false)) {
                return resultFunction;
            }
            boolean isDefaultThunk = false;
            if (originFunction.isThunk()) {
                isDefaultThunk = originFunction.getSymbol().getSource() == SourceType.DEFAULT;
                Function thunkedFunction = originFunction.getThunkedFunction(false);
                Address thunkedEntryPoint = thunkedFunction.getEntryPoint();
                Address resultThunkedEntryPoint = this.originToResultTranslator.getAddress(thunkedEntryPoint);
                if (resultThunkedEntryPoint == null) {
                    this.errorMsg.append("Can't replace thunk function @ " + originEntryPoint + ". Can't determine equivalent thunked function entry point address for thunked function @ " + thunkedEntryPoint + ".\n");
                    return null;
                }
                Function resultThunkedFunction = this.resultListing.getFunctionAt(resultThunkedEntryPoint);
                if (resultThunkedFunction == null) {
                    this.errorMsg.append("Can't replace thunk function @ " + originEntryPoint + ". No function at pointed to address " + thunkedEntryPoint + ".\n");
                    return null;
                }
            }
            newResultFunction = resultFunction;
            AddressSetView originBody = originFunction.getBody();
            AddressSet newResultBody = this.originToResultTranslator.getAddressSet(originBody);
            if (ProgramMerge.overlapsOtherFunctions(this.originToResultTranslator, originFunction)) {
                this.errorMsg.append("Can't replace function @ " + originEntryPoint + ". It would overlap another function.\n");
                return null;
            }
            String originName = originFunction.getName();
            Namespace desiredToNamespace = this.resultProgram.getGlobalNamespace();
            if (!isDefaultThunk) {
                try {
                    desiredToNamespace = this.symbolMerge.resolveNamespace(originFunction.getParentNamespace(), this.conflictSymbolIDMap);
                }
                catch (DuplicateNameException e1) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                }
                catch (InvalidInputException e1) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                }
            }
            if (!(sameBody = newResultBody.equals((Object)(oldResultBody = resultFunction == null ? null : resultFunction.getBody())))) {
                try {
                    if (resultFunction != null) {
                        resultFunction.setBody((AddressSetView)newResultBody);
                        break block29;
                    }
                    try {
                        newResultFunction = this.resultListing.createFunction(originName, desiredToNamespace, originEntryPoint, (AddressSetView)newResultBody, originFunction.getSymbol().getSource());
                    }
                    catch (InvalidInputException e) {
                        String errorMessage = "Error creating function \"" + originName + "\" at " + originEntryPoint.toString(true) + ".\n  ";
                        this.errorMsg.append(errorMessage + e.getMessage());
                        return null;
                    }
                    catch (IllegalArgumentException e) {
                        String errorMessage = "Error creating function \"" + originName + "\" at " + originEntryPoint.toString(true) + ".\n  ";
                        this.errorMsg.append(errorMessage + e.getMessage());
                        return null;
                    }
                }
                catch (OverlappingFunctionException e) {
                    this.errorMsg.append("Address = " + resultEntryPoint + ": " + e.getMessage() + "\n");
                    return null;
                }
            }
        }
        if (newResultFunction == null) {
            return null;
        }
        if (originFunction.isThunk()) {
            Function originThunkedFunction = originFunction.getThunkedFunction(false);
            Function originThunkedFunctionInResult = DiffUtility.getFunction(originThunkedFunction, this.resultProgram);
            if (originThunkedFunctionInResult == null) {
                this.errorMsg.append("Thunked function not found at " + originThunkedFunction.getEntryPoint() + " for function at " + originFunction.getEntryPoint() + ".\n");
                return null;
            }
            Function currentThunkedFunction = newResultFunction.getThunkedFunction(false);
            if (currentThunkedFunction != originThunkedFunctionInResult) {
                newResultFunction.setThunkedFunction(originThunkedFunctionInResult);
            }
        } else if (newResultFunction.isThunk()) {
            newResultFunction.setThunkedFunction(null);
        }
        if (newResultFunction.isThunk()) {
            return newResultFunction;
        }
        try {
            newResultFunction.updateFunction(originFunction.getCallingConventionName(), (Variable)originFunction.getReturn(), originFunction.hasCustomVariableStorage() ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, originFunction.getSignatureSource(), (Variable[])originFunction.getParameters());
        }
        catch (DuplicateNameException e) {
            this.errorMsg.append("Address = " + resultEntryPoint + ": " + e.getMessage() + "\n");
        }
        catch (InvalidInputException e) {
            this.errorMsg.append("Address = " + resultEntryPoint + ": " + e.getMessage() + "\n");
        }
        StackFrame originFrame = originFunction.getStackFrame();
        StackFrame newToFrame = newResultFunction.getStackFrame();
        newToFrame.setLocalSize(originFrame.getLocalSize());
        newToFrame.setReturnAddressOffset(originFrame.getReturnAddressOffset());
        newResultFunction.setStackPurgeSize(originFunction.getStackPurgeSize());
        newResultFunction.setVarArgs(originFunction.hasVarArgs());
        newResultFunction.setInline(originFunction.isInline());
        newResultFunction.setNoReturn(originFunction.hasNoReturn());
        this.replaceLocals(newResultFunction, originFunction, monitor);
        newResultFunction.setSignatureSource(originFunction.getSignatureSource());
        return newResultFunction;
    }

    public Function replaceExternalFunction(Function toFunction, Function fromFunction, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!toFunction.isExternal()) {
            throw new IllegalArgumentException("The function being replaced is not an external.");
        }
        if (!fromFunction.isExternal()) {
            throw new IllegalArgumentException("The function being used as the source of information for a replace is not an external.");
        }
        StackFrame originFrame = fromFunction.getStackFrame();
        if (toFunction.hasCustomVariableStorage() != fromFunction.hasCustomVariableStorage()) {
            toFunction.setCustomVariableStorage(fromFunction.hasCustomVariableStorage());
        }
        try {
            toFunction.setCallingConvention(fromFunction.getCallingConventionName());
        }
        catch (InvalidInputException e) {
            this.errorMsg.append("Address = " + toFunction.getEntryPoint() + ": " + e.getMessage() + "\n");
        }
        StackFrame newToFrame = toFunction.getStackFrame();
        try {
            if (toFunction.hasCustomVariableStorage()) {
                Parameter returnVar = fromFunction.getReturn();
                toFunction.setReturn(fromFunction.getReturnType(), returnVar.getVariableStorage(), returnVar.getSource());
            } else {
                toFunction.setReturnType(fromFunction.getReturnType(), SourceType.ANALYSIS);
            }
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.errorMsg.append("InvalidInputException replacing external function: " + e.getMessage() + "\n");
        }
        if (newToFrame.getLocalSize() != originFrame.getLocalSize()) {
            newToFrame.setLocalSize(originFrame.getLocalSize());
        }
        toFunction.setStackPurgeSize(fromFunction.getStackPurgeSize());
        toFunction.setVarArgs(fromFunction.hasVarArgs());
        toFunction.setInline(fromFunction.isInline());
        toFunction.setNoReturn(fromFunction.hasNoReturn());
        toFunction.setSignatureSource(fromFunction.getSignatureSource());
        this.replaceVariables(toFunction, fromFunction, monitor);
        return toFunction;
    }

    private void replaceVariables(Function newFunc, Function fromFunc, TaskMonitor monitor) throws CancelledException {
        this.replaceFunctionParameters(newFunc, fromFunc);
        this.replaceLocals(newFunc, fromFunc, monitor);
    }

    private boolean resolveParamaterNameConflicts(Function toFunc, Parameter[] fromParams) {
        for (Parameter p : fromParams) {
            if (p.getSource() == SourceType.DEFAULT || this.resolveParameterNameConflict(toFunc, p.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean resolveParameterNameConflict(Function toFunc, String name) {
        SymbolTable toSymTab = toFunc.getProgram().getSymbolTable();
        Symbol nameSpaceSymbol = toSymTab.getLocalVariableSymbol(name, (Namespace)toFunc);
        if (nameSpaceSymbol != null && nameSpaceSymbol.getSymbolType() != SymbolType.PARAMETER && nameSpaceSymbol.getSource() != SourceType.DEFAULT) {
            if (this.renameVarUniquely(nameSpaceSymbol, nameSpaceSymbol.getSource()) == null) {
                this.errorMsg.append("Can't replace parameters due to name conflict: " + nameSpaceSymbol.getName(true) + "\n");
                return false;
            }
            String msg = "Renamed symbol '" + name + "' in function '" + toFunc.getName() + "' to '" + nameSpaceSymbol.getName() + "' due to conflict with parameter.\n";
            this.infoMsg.append(msg);
        }
        return true;
    }

    private void replaceLocals(Function toFunc, Function fromFunc, TaskMonitor monitor) throws CancelledException {
        Object[] fromLocals;
        Object[] oldLocals = toFunc.getLocalVariables();
        if (Arrays.equals(oldLocals, fromLocals = fromFunc.getLocalVariables())) {
            return;
        }
        for (Object local : oldLocals) {
            monitor.checkCanceled();
            Variable fromVar = DiffUtility.getVariable((Variable)local, fromFunc);
            if (fromVar != null) continue;
            toFunc.removeVariable((Variable)local);
        }
        for (Object fromLocal : fromLocals) {
            monitor.checkCanceled();
            this.replaceVariable(fromFunc, (Variable)fromLocal, toFunc);
        }
    }

    private Variable replaceVariable(Function fromFunc, Variable fromVar, Function toFunc) {
        if (fromVar instanceof Parameter) {
            throw new IllegalArgumentException("replaceVariable should not be used for parameters");
        }
        Program toPgm = toFunc.getProgram();
        Program fromPgm = fromFunc.getProgram();
        String name = fromVar.getName();
        SourceType source = fromVar.getSource();
        Variable toVar = DiffUtility.getVariable(fromVar, toFunc);
        if (toVar == null) {
            try {
                VariableUtilities.checkVariableConflict((Function)toFunc, (Variable)fromVar, (VariableStorage)fromVar.getVariableStorage(), (boolean)true);
            }
            catch (VariableSizeException e) {
                throw new RuntimeException("Unexpected Exception", e);
            }
        } else if (toVar.equals(fromVar)) {
            return toVar;
        }
        if (!(fromVar.getSource() == SourceType.DEFAULT || toVar != null && toVar.getName().equals(fromVar.getName()) || this.resolveLocalNameConflict(toFunc, fromVar.getName()))) {
            return null;
        }
        try {
            if (toVar != null) {
                toVar.setComment(fromVar.getComment());
                DataType fromDt = fromVar.getDataType();
                if (!fromDt.isEquivalent(toVar.getDataType())) {
                    toVar.setDataType(fromDt, fromVar.getVariableStorage(), true, fromFunc.getSignatureSource());
                }
                toVar.setName(name, source);
            } else {
                toVar = DiffUtility.createVariable(fromPgm, fromVar, toPgm);
            }
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.errorMsg.append("Can't replace variable " + fromVar.getSymbol().getName(true) + "\n");
            this.errorMsg.append(e.getMessage() + "\n");
            return null;
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.errorMsg.append("Can't replace variable " + fromVar.getSymbol().getName(true) + "\n");
            this.errorMsg.append(e.getMessage() + "\n");
            return null;
        }
        return toVar;
    }

    private boolean resolveLocalNameConflict(Function toFunc, String name) {
        SymbolTable toSymTab = toFunc.getProgram().getSymbolTable();
        Symbol nameSpaceSymbol = toSymTab.getVariableSymbol(name, toFunc);
        if (nameSpaceSymbol != null && nameSpaceSymbol.getSource() != SourceType.DEFAULT) {
            if (this.renameVarUniquely(nameSpaceSymbol, nameSpaceSymbol.getSource()) == null) {
                this.errorMsg.append("Can't replace variable due to name conflict: " + nameSpaceSymbol.getName(true) + "\n");
                return false;
            }
            String msg = "Renamed symbol '" + name + "' in function '" + toFunc.getName() + "' to '" + nameSpaceSymbol.getName() + "' due to conflict with local variable.\n";
            this.infoMsg.append(msg);
        }
        return true;
    }

    private String renameVarUniquely(Symbol namedSymbol, SourceType source) {
        String name = namedSymbol.getName();
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String newName = name + SYMBOL_CONFLICT_SUFFIX + i;
            try {
                namedSymbol.setName(newName, namedSymbol.getSource());
                return newName;
            }
            catch (DuplicateNameException e) {
                continue;
            }
            catch (InvalidInputException e) {
                break;
            }
        }
        return null;
    }

    private int getAdjustedResultOrdinal(Function resultFunc, Function srcFunc, int ordinal) {
        return resultFunc.getAutoParameterCount() - srcFunc.getAutoParameterCount() + ordinal;
    }

    public void replaceFunctionParameterName(Address originEntryPoint, int ordinal, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException {
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null) {
            Parameter p1 = f1.getParameter(this.getAdjustedResultOrdinal(f1, f2, ordinal));
            Parameter p2 = f2.getParameter(ordinal);
            SourceType source = p2.getSource();
            String fromName = p2.getName();
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                String newName = i == 0 ? fromName : fromName + SYMBOL_CONFLICT_SUFFIX + i;
                try {
                    if (p1.isAutoParameter()) {
                        String msg = "Auto-parameter name may not be modified, " + p1.getFunction().getName(true) + ":" + p1.getName();
                        Msg.error((Object)this, (Object)msg);
                        this.errorMsg.append(msg + "\n");
                    } else {
                        p1.setName(newName, source);
                        if (i > 0) {
                            this.infoMsg.append("Parameter '" + fromName + "' was merged as '" + newName + "' in function " + f1.getName() + ".\n");
                        }
                    }
                    return;
                }
                catch (DuplicateNameException e) {
                    continue;
                }
            }
            p1.setName(fromName, source);
        }
    }

    public void replaceFunctionParameterDataType(Address originEntryPoint, int ordinal, TaskMonitor monitor) {
        block9: {
            Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
            Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
            Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
            if (f1 != null && f2 != null) {
                Parameter p1 = f1.getParameter(this.getAdjustedResultOrdinal(f1, f2, ordinal));
                Parameter p2 = f2.getParameter(ordinal);
                try {
                    try {
                        if (f1.hasCustomVariableStorage() && p1.getVariableStorage().isUnassignedStorage()) {
                            p1.setDataType(p2.getDataType(), p2.getVariableStorage(), false, f2.getSignatureSource());
                            break block9;
                        }
                        if (p1.isAutoParameter()) {
                            String msg = "Auto-parameter datatype may not be modified, " + p1.getFunction().getName(true) + ":" + p1.getName();
                            Msg.error((Object)this, (Object)msg);
                            this.errorMsg.append(msg + "\n");
                            break block9;
                        }
                        DataType dt = p2.getDataType();
                        if (!f1.hasCustomVariableStorage()) {
                            dt = p2.getFormalDataType();
                        }
                        p1.setDataType(dt, true, false, SourceType.ANALYSIS);
                    }
                    catch (InvalidInputException e) {
                        DataType dt = p2.getDataType();
                        if (!f1.hasCustomVariableStorage()) {
                            dt = p2.getFormalDataType();
                        }
                        p1.setDataType(dt, VariableStorage.UNASSIGNED_STORAGE, false, SourceType.DEFAULT);
                        String msg = "Parameter storage forced to UNASSIGNED for " + p1.getFunction().getName(true) + ":" + p1.getName() + ":\n    " + e.getMessage();
                        Msg.error((Object)this, (Object)msg);
                        this.errorMsg.append(msg + "\n");
                    }
                }
                catch (InvalidInputException e) {
                    String msg = "Can't replace parameter datatype for " + p1.getFunction().getName(true) + ":" + p1.getName() + ":\n    " + e.getMessage();
                    Msg.error((Object)this, (Object)msg);
                    this.errorMsg.append(msg + "\n");
                }
            }
        }
    }

    public void replaceFunctionParameterComment(Address originEntryPoint, int ordinal, TaskMonitor monitor) {
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null) {
            Parameter p1 = f1.getParameter(this.getAdjustedResultOrdinal(f1, f2, ordinal));
            Parameter p2 = f2.getParameter(ordinal);
            if (p1.isAutoParameter()) {
                String msg = "Auto-parameter comment may not be modified, " + p1.getFunction().getName(true) + ":" + p1.getName();
                Msg.error((Object)this, (Object)msg);
                this.errorMsg.append(msg + "\n");
            } else {
                p1.setComment(p2.getComment());
            }
        }
    }

    public void replaceFunctionVariable(Address originEntryPoint, Variable var, TaskMonitor monitor) {
        if (var instanceof Parameter) {
            throw new IllegalArgumentException("replaceFunctionVariable does not support parameters");
        }
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null) {
            Variable toVar = this.findVariable(var, f1.getLocalVariables());
            Variable fromVar = this.findVariable(var, f2.getLocalVariables());
            if (toVar != null) {
                f1.removeVariable(toVar);
            }
            if (fromVar != null) {
                try {
                    SourceType source = fromVar.getSource();
                    VariableUtilities.checkVariableConflict((Function)f1, (Variable)fromVar, (VariableStorage)fromVar.getVariableStorage(), (boolean)true);
                    f1.addLocalVariable(fromVar, source);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    this.errorMsg.append("DuplicateNameException replacing function variable: " + e.getMessage() + "\n");
                }
                catch (InvalidInputException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    this.errorMsg.append("InvalidInputException replacing function variable: " + e.getMessage() + "\n");
                }
            }
        }
    }

    public void replaceVariables(Address originEntryPoint, List<Variable> varList, TaskMonitor monitor) throws CancelledException {
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 == null || f2 == null) {
            return;
        }
        boolean replaceParams = false;
        for (Variable var : varList) {
            monitor.checkCanceled();
            if (!(var instanceof Parameter)) continue;
            replaceParams = true;
            break;
        }
        if (replaceParams) {
            this.replaceFunctionParameters(originEntryPoint, monitor);
        }
        for (Variable var : varList) {
            monitor.checkCanceled();
            if (var instanceof Parameter) continue;
            this.replaceVariable(f2, var, f1);
        }
    }

    private Variable findVariable(Variable var, Variable[] variables) {
        int index = Arrays.binarySearch(variables, var);
        if (index >= 0) {
            return variables[index];
        }
        return null;
    }

    public void replaceFunctionVariableName(Address originEntryPoint, Variable var, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException {
        if (var instanceof Parameter) {
            this.replaceFunctionParameterName(originEntryPoint, ((Parameter)var).getOrdinal(), monitor);
            return;
        }
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null) {
            String fromName;
            Variable toVar = this.findVariable(var, f1.getLocalVariables());
            Variable fromVar = this.findVariable(var, f2.getLocalVariables());
            SourceType source = fromVar != null ? fromVar.getSource() : (toVar != null ? toVar.getSource() : var.getSource());
            String string = fromName = fromVar != null ? fromVar.getName() : null;
            if (toVar != null) {
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    String newName = i == 0 ? fromName : fromName + SYMBOL_CONFLICT_SUFFIX + i;
                    try {
                        toVar.setName(newName, source);
                        if (i > 0) {
                            this.infoMsg.append("Variable '" + fromName + "' was merged as '" + newName + "' in function " + f1.getName() + ".\n");
                        }
                        return;
                    }
                    catch (DuplicateNameException e) {
                        continue;
                    }
                }
                toVar.setName(fromName, source);
            }
        }
    }

    public void replaceFunctionVariableDataType(Address originEntryPoint, Variable var, TaskMonitor monitor) {
        if (var instanceof Parameter) {
            this.replaceFunctionParameterDataType(originEntryPoint, ((Parameter)var).getOrdinal(), monitor);
            return;
        }
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null) {
            DataType fromDataType;
            Variable toVar = this.findVariable(var, f1.getLocalVariables());
            Variable fromVar = this.findVariable(var, f2.getLocalVariables());
            DataType dataType = fromDataType = fromVar != null ? fromVar.getDataType() : null;
            if (toVar != null) {
                try {
                    toVar.setDataType(fromDataType, SourceType.ANALYSIS);
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
        }
    }

    public void replaceFunctionVariableComment(Address originEntryPoint, Variable var, TaskMonitor monitor) {
        if (var instanceof Parameter) {
            this.replaceFunctionParameterComment(originEntryPoint, ((Parameter)var).getOrdinal(), monitor);
            return;
        }
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function f1 = this.resultProgram.getFunctionManager().getFunctionAt(resultEntryPoint);
        Function f2 = this.originProgram.getFunctionManager().getFunctionAt(originEntryPoint);
        if (f1 != null && f2 != null) {
            String fromComment;
            Variable toVar = this.findVariable(var, f1.getLocalVariables());
            Variable fromVar = this.findVariable(var, f2.getLocalVariables());
            String string = fromComment = fromVar != null ? fromVar.getComment() : null;
            if (toVar != null) {
                toVar.setComment(fromComment);
            }
        }
    }

    void mergeBookmarks(AddressSetView originAddressSet, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't merge bookmarks.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Applying Bookmarks...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        AddressIterator originIter = originAddressSet.getAddresses(true);
        long count = 0L;
        while (originIter.hasNext() && !monitor.isCancelled()) {
            monitor.checkCanceled();
            Address originAddress = originIter.next();
            if (count == 129L) {
                monitor.setMessage("Applying Bookmarks...   " + originAddress.toString(true));
                count = 0L;
            }
            this.mergeBookmarksAtAddress(originAddress);
            ++count;
        }
    }

    private void mergeBookmarksAtAddress(Address originAddress) {
        if (originAddress != null) {
            Bookmark[] marks;
            Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
            BookmarkManager bm1 = this.resultProgram.getBookmarkManager();
            BookmarkManager bm2 = this.originProgram.getBookmarkManager();
            try {
                bm1.removeBookmarks((AddressSetView)new AddressSet(resultAddress, resultAddress), TaskMonitorAdapter.DUMMY_MONITOR);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            for (Bookmark mark : marks = bm2.getBookmarks(originAddress)) {
                bm1.setBookmark(resultAddress, mark.getTypeString(), mark.getCategory(), mark.getComment());
            }
        }
    }

    public void mergeBookmark(Address originAddress, String type, String category, TaskMonitor monitor) throws CancelledException {
        if (originAddress != null) {
            Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
            BookmarkManager bm1 = this.resultProgram.getBookmarkManager();
            BookmarkManager bm2 = this.originProgram.getBookmarkManager();
            if (type.equals("Note")) {
                Bookmark[] books2 = bm2.getBookmarks(originAddress, type);
                if (books2.length == 0) {
                    bm1.removeBookmarks((AddressSetView)new AddressSet(resultAddress), type, monitor);
                } else if (books2.length == 1) {
                    bm1.setBookmark(resultAddress, type, books2[0].getCategory(), books2[0].getComment());
                } else if (books2.length > 1) {
                    throw new AssertException("Error in program '" + this.resultProgram.getName() + "'- Shouldn't be multiple notes at a single address. Address=" + originAddress.toString());
                }
            } else {
                Bookmark book1 = bm1.getBookmark(resultAddress, type, category);
                Bookmark book2 = bm2.getBookmark(originAddress, type, category);
                if (book2 != null) {
                    bm1.setBookmark(resultAddress, type, category, book2.getComment());
                } else if (book1 != null) {
                    bm1.removeBookmark(book1);
                }
            }
        }
    }

    public void mergeProperties(AddressSetView originAddressSet, TaskMonitor monitor) throws CancelledException, UnsupportedOperationException {
        if (!this.originToResultTranslator.isOneForOneTranslator()) {
            String message = this.originToResultTranslator.getClass().getName() + " is not a one for one translator and can't merge properties.";
            throw new UnsupportedOperationException(message);
        }
        monitor.setMessage("Applying Properties...");
        if (originAddressSet.isEmpty()) {
            return;
        }
        AddressIterator originIter = originAddressSet.getAddresses(true);
        long count = 0L;
        while (originIter.hasNext() && !monitor.isCancelled()) {
            monitor.checkCanceled();
            Address originAddress = originIter.next();
            if (count == 129L) {
                monitor.setMessage("Applying Properties...   " + originAddress.toString(true));
                count = 0L;
            }
            this.mergePropertiesAtAddress(originAddress);
            ++count;
        }
    }

    private void mergePropertiesAtAddress(Address originAddress) {
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        this.resultCu = this.resultListing.getCodeUnitAt(resultAddress);
        if (this.resultCu != null) {
            Iterator propNames = this.resultCu.propertyNames();
            while (propNames.hasNext()) {
                this.resultCu.removeProperty((String)propNames.next());
            }
            CodeUnit origCu = this.originListing.getCodeUnitAt(originAddress);
            if (origCu != null) {
                propNames = origCu.propertyNames();
                while (propNames.hasNext()) {
                    this.propertyName = (String)propNames.next();
                    if (this.propertyName.equals("Bookmarks") || this.originListing.getPropertyMap(this.propertyName) instanceof UnsupportedMapDB) continue;
                    origCu.visitProperty((PropertyVisitor)this, this.propertyName);
                }
            }
        }
    }

    public void mergeUserProperty(String userPropertyName, Address originAddress) {
        Address resultAddress = this.originToResultTranslator.getAddress(originAddress);
        PropertyMapManager resultPmm = this.resultProgram.getUsrPropertyManager();
        PropertyMapManager originPmm = this.originProgram.getUsrPropertyManager();
        PropertyMap resultOpm = resultPmm.getPropertyMap(userPropertyName);
        PropertyMap originOpm = originPmm.getPropertyMap(userPropertyName);
        Object resultObject = null;
        Object originObject = null;
        if (resultOpm != null) {
            resultObject = this.getProperty(resultOpm, resultAddress);
        }
        if (originOpm != null) {
            originObject = this.getProperty(originOpm, originAddress);
        }
        if (!SystemUtilities.isEqual((Object)resultObject, originObject)) {
            if (resultObject != null && resultOpm != null) {
                resultOpm.remove(resultAddress);
            }
            if (originObject != null) {
                if (resultOpm == null) {
                    try {
                        resultOpm = resultPmm.createObjectPropertyMap(userPropertyName, Saveable.class);
                    }
                    catch (DuplicateNameException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setProperty(resultOpm, resultAddress, originObject);
            }
        }
    }

    private Object getProperty(PropertyMap map, Address address) {
        if (map instanceof VoidPropertyMap) {
            return ((VoidPropertyMap)map).getNextPropertyAddress(address);
        }
        if (map instanceof ObjectPropertyMap) {
            return ((ObjectPropertyMap)map).getObject(address);
        }
        if (map instanceof LongPropertyMap) {
            try {
                return new Long(((LongPropertyMap)map).getLong(address));
            }
            catch (NoValueException e) {
                return null;
            }
        }
        if (map instanceof IntPropertyMap) {
            try {
                return new Integer(((IntPropertyMap)map).getInt(address));
            }
            catch (NoValueException e) {
                return null;
            }
        }
        if (map instanceof StringPropertyMap) {
            return ((StringPropertyMap)map).getString(address);
        }
        return null;
    }

    private void setProperty(PropertyMap map, Address address, Object property) {
        if (map instanceof VoidPropertyMap) {
            ((VoidPropertyMap)map).add(address);
        } else if (map instanceof ObjectPropertyMap) {
            ((ObjectPropertyMap)map).add(address, (Saveable)property);
        } else if (map instanceof LongPropertyMap) {
            ((LongPropertyMap)map).add(address, ((Long)property).longValue());
        } else if (map instanceof IntPropertyMap) {
            ((IntPropertyMap)map).add(address, ((Integer)property).intValue());
        } else if (map instanceof StringPropertyMap) {
            ((StringPropertyMap)map).add(address, (String)property);
        }
    }

    public void visit() {
        this.resultCu.setProperty(this.propertyName);
    }

    public void visit(String value) {
        this.resultCu.setProperty(this.propertyName, value);
    }

    public void visit(Object value) {
        String message = "Could Not Merge Property.\nCan't merge property, \"" + this.propertyName + "\", with value of " + value;
        this.errorMsg.append(message);
    }

    public void visit(Saveable value) {
        this.resultCu.setProperty(this.propertyName, value);
    }

    public void visit(int value) {
        this.resultCu.setProperty(this.propertyName, value);
    }

    class FunctionAddressIterator
    implements AddressIterator {
        FunctionIterator functionIterator;

        FunctionAddressIterator(FunctionIterator funcIter) {
            this.functionIterator = funcIter;
        }

        public Address next() {
            return ((Function)this.functionIterator.next()).getEntryPoint();
        }

        public boolean hasNext() {
            return this.functionIterator.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Address> iterator() {
            return this;
        }
    }

    private class DupEquate {
        Equate equate;
        String preferredName;

        DupEquate(Equate equate, String preferredName) {
            this.equate = equate;
            this.preferredName = preferredName;
        }
    }
}

