/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbThread;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbInferiorImpl;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.cmd.AbstractGdbCommand;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GdbListThreadsCommand
extends AbstractGdbCommand<Map<Integer, GdbThread>> {
    protected final GdbInferiorImpl inferior;

    public GdbListThreadsCommand(GdbManagerImpl manager, GdbInferiorImpl inferior) {
        super(manager);
        this.inferior = inferior;
    }

    @Override
    public String encode() {
        return "-list-thread-groups i" + this.inferior.getId();
    }

    @Override
    public Map<Integer, GdbThread> complete(GdbPendingCommand<?> pending) {
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        List<Integer> ids = done.assumeThreadIds();
        Map<Integer, GdbThread> infThreads = this.inferior.getKnownThreads();
        Set<Integer> cur = infThreads.keySet();
        for (int id : ids) {
            if (cur.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Was missing thread: " + id));
            new GdbThreadImpl(this.manager, this.inferior, id).add();
        }
        for (int id : new ArrayList<Integer>(cur)) {
            if (ids.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Had extra thread: " + id));
            this.inferior.removeThread(id);
            this.manager.removeThread(id);
        }
        return infThreads;
    }
}

