/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction35ms
extends Instruction
implements FiveRegisterInstruction,
OdexedInvokeVirtual {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private byte regA;
    private byte regD;
    private byte regE;
    private byte regF;
    private byte regG;
    private short vtableIndex;

    public Instruction35ms(Opcode opcode, int regCount, byte regD, byte regE, byte regF, byte regG, byte regA, int vtableIndex) {
        super(opcode);
        if (regCount > 5) {
            throw new RuntimeException("regCount cannot be greater than 5");
        }
        if (regD >= 16 || regE >= 16 || regF >= 16 || regG >= 16 || regA >= 16) {
            throw new RuntimeException("All register args must fit in 4 bits");
        }
        if (vtableIndex >= 65536) {
            throw new RuntimeException("The method index must be less than 65536");
        }
        this.regCount = (byte)regCount;
        this.regA = regA;
        this.regD = regD;
        this.regE = regE;
        this.regF = regF;
        this.regG = regG;
        this.vtableIndex = (short)vtableIndex;
    }

    private Instruction35ms(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regCount = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regD = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 4]);
        this.regE = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 4]);
        this.regF = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 5]);
        this.regG = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 5]);
        this.vtableIndex = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regCount << 4 | this.regA);
        out.writeShort(this.vtableIndex);
        out.writeByte(this.regE << 4 | this.regD);
        out.writeByte(this.regG << 4 | this.regF);
    }

    @Override
    public Format getFormat() {
        return Format.Format35ms;
    }

    @Override
    public int getRegCount() {
        return this.regCount;
    }

    @Override
    public byte getRegisterA() {
        return this.regA;
    }

    @Override
    public byte getRegisterD() {
        return this.regD;
    }

    @Override
    public byte getRegisterE() {
        return this.regE;
    }

    @Override
    public byte getRegisterF() {
        return this.regF;
    }

    @Override
    public byte getRegisterG() {
        return this.regG;
    }

    @Override
    public int getVtableIndex() {
        return this.vtableIndex & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction35ms(opcode, buffer, bufferIndex);
        }
    }
}

