/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.StringDataItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;

class ItemFactory {
    ItemFactory() {
    }

    protected static Item makeItem(ItemType itemType, DexFile dexFile) {
        switch (itemType) {
            case TYPE_STRING_ID_ITEM: {
                return new StringIdItem(dexFile);
            }
            case TYPE_TYPE_ID_ITEM: {
                return new TypeIdItem(dexFile);
            }
            case TYPE_PROTO_ID_ITEM: {
                return new ProtoIdItem(dexFile);
            }
            case TYPE_FIELD_ID_ITEM: {
                return new FieldIdItem(dexFile);
            }
            case TYPE_METHOD_ID_ITEM: {
                return new MethodIdItem(dexFile);
            }
            case TYPE_CLASS_DEF_ITEM: {
                return new ClassDefItem(dexFile);
            }
            case TYPE_TYPE_LIST: {
                return new TypeListItem(dexFile);
            }
            case TYPE_ANNOTATION_SET_REF_LIST: {
                return new AnnotationSetRefList(dexFile);
            }
            case TYPE_ANNOTATION_SET_ITEM: {
                return new AnnotationSetItem(dexFile);
            }
            case TYPE_CLASS_DATA_ITEM: {
                return new ClassDataItem(dexFile);
            }
            case TYPE_CODE_ITEM: {
                return new CodeItem(dexFile);
            }
            case TYPE_STRING_DATA_ITEM: {
                return new StringDataItem(dexFile);
            }
            case TYPE_DEBUG_INFO_ITEM: {
                return new DebugInfoItem(dexFile);
            }
            case TYPE_ANNOTATION_ITEM: {
                return new AnnotationItem(dexFile);
            }
            case TYPE_ENCODED_ARRAY_ITEM: {
                return new EncodedArrayItem(dexFile);
            }
            case TYPE_ANNOTATIONS_DIRECTORY_ITEM: {
                return new AnnotationDirectoryItem(dexFile);
            }
        }
        assert (false);
        return null;
    }
}

