/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.ASTGraphTask;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;

public class GraphASTControlFlowAction
extends AbstractDecompilerAction {
    public GraphASTControlFlowAction() {
        super("Graph AST Control Flow");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ToolBarGraph"));
        this.setMenuBarData(new MenuData(new String[]{"Graph AST Control Flow"}, "graph"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return context.getFunction() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        PluginTool tool = context.getTool();
        GraphDisplayBroker service = (GraphDisplayBroker)tool.getService(GraphDisplayBroker.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"AST Graph Failed", (Object)"Graph consumer not found: Please add a graph consumer provider to your tool");
            return;
        }
        ToolOptions options = tool.getOptions("Graph");
        boolean reuseGraph = options.getBoolean("Reuse Graph", false);
        int codeLimitPerBlock = options.getInt("Max Code Lines Displayed", 10);
        HighFunction highFunction = context.getHighFunction();
        Address locationAddr = context.getLocation().getAddress();
        ASTGraphTask task = new ASTGraphTask(service, !reuseGraph, codeLimitPerBlock, locationAddr, highFunction, ASTGraphTask.AstGraphSubType.CONTROL_FLOW_GRAPH, tool);
        new TaskLauncher((Task)task, (Component)tool.getToolFrame());
    }
}

