/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.sugiyama.AccumulatorTreeUtil;
import org.jungrapht.visualization.layout.algorithms.sugiyama.AllLevelCross;
import org.jungrapht.visualization.layout.algorithms.sugiyama.ArticulatedEdge;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Comparators;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GraphLayers;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GreedyCycleRemoval;
import org.jungrapht.visualization.layout.algorithms.sugiyama.HorizontalCoordinateAssignment;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Synthetics;
import org.jungrapht.visualization.layout.algorithms.sugiyama.TransformedGraphSupplier;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Unaligned;
import org.jungrapht.visualization.layout.algorithms.sugiyama.VertexMetadata;
import org.jungrapht.visualization.layout.algorithms.util.InsertionSortCounter;
import org.jungrapht.visualization.layout.algorithms.util.LayeredRunnable;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.util.PropertyLoader;
import org.jungrapht.visualization.layout.util.synthetics.Synthetic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SugiyamaRunnable<V, E>
implements LayeredRunnable<E> {
    private static final Logger log = LoggerFactory.getLogger(SugiyamaRunnable.class);
    protected final LayoutModel<V> layoutModel;
    protected Function<V, Rectangle> vertexShapeFunction;
    protected Graph<V, E> graph;
    protected Graph<LV<V>, LE<V, E>> svGraph;
    protected NeighborCache<LV<V>, LE<V, E>> neighborCache;
    boolean stopit = false;
    protected Predicate<V> vertexPredicate;
    protected Predicate<E> edgePredicate;
    protected Comparator<V> vertexComparator;
    protected Comparator<E> edgeComparator;
    protected boolean straightenEdges;
    protected boolean postStraighten;
    protected boolean transpose;
    protected int transposeLimit;
    protected int maxLevelCross;
    protected Layering layering;
    protected Map<LV<V>, VertexMetadata<V>> vertexMetadataMap = new HashMap<LV<V>, VertexMetadata<V>>();
    protected Map<E, List<Point>> edgePointMap = new HashMap<E, List<Point>>();
    protected boolean multiComponent;
    protected boolean cancelled;
    Comparator<LE<V, E>> biLevelEdgeComparator = Comparators.biLevelEdgeComparator();
    Function<LV<V>, int[]> upperNeighborIndicesMethod = this::upperNeighborIndices;
    Function<LV<V>, int[]> lowerNeighborIndicesMethod = this::lowerNeighborIndices;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    protected SugiyamaRunnable(Builder<V, E, ?, ?> builder) {
        this(builder.layoutModel, builder.vertexShapeFunction, builder.vertexPredicate, builder.edgePredicate, builder.vertexComparator, builder.edgeComparator, builder.straightenEdges, builder.postStraighten, builder.transpose, builder.transposeLimit, builder.maxLevelCross, builder.layering, builder.multiComponent);
    }

    private SugiyamaRunnable(LayoutModel<V> layoutModel, Function<V, Rectangle> vertexShapeFunction, Predicate<V> vertexPredicate, Predicate<E> edgePredicate, Comparator<V> vertexComparator, Comparator<E> edgeComparator, boolean straightenEdges, boolean postStraighten, boolean transpose, int transposeLimit, int maxLevelCross, Layering layering, boolean multiComponent) {
        this.layoutModel = layoutModel;
        this.vertexShapeFunction = vertexShapeFunction;
        this.vertexComparator = vertexComparator;
        this.vertexPredicate = vertexPredicate;
        this.edgeComparator = edgeComparator;
        this.edgePredicate = edgePredicate;
        this.straightenEdges = straightenEdges;
        this.postStraighten = postStraighten;
        this.transpose = transpose;
        this.transposeLimit = transposeLimit;
        this.maxLevelCross = maxLevelCross;
        if (layering == null) {
            layering = Layering.TOP_DOWN;
        }
        this.layering = layering;
        this.multiComponent = multiComponent;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void run() {
        int i;
        List<List<LV<V>>> layers;
        this.graph = this.layoutModel.getGraph();
        if (this.graph.vertexSet().isEmpty()) {
            return;
        }
        if (this.graph.vertexSet().size() == 1) {
            Object v2 = this.graph.vertexSet().stream().findFirst().get();
            this.layoutModel.setSize(50, this.layoutModel.getHeight());
            this.layoutModel.set(v2, this.layoutModel.getWidth() / 2, this.layoutModel.getHeight() / 2);
            return;
        }
        long startTime = System.currentTimeMillis();
        TransformedGraphSupplier<V, E> transformedGraphSupplier = new TransformedGraphSupplier<V, E>(this.graph);
        this.svGraph = transformedGraphSupplier.get();
        this.neighborCache = new NeighborCache(this.svGraph);
        long transformTime = System.currentTimeMillis();
        log.trace("transform Graph took {}", (Object)(transformTime - startTime));
        GreedyCycleRemoval<LV<V>, LE<V, E>> greedyCycleRemoval = new GreedyCycleRemoval<LV<V>, LE<V, E>>(this.svGraph);
        Collection<LE<V, E>> feedbackArcs = greedyCycleRemoval.getFeedbackArcs();
        for (LE<V, E> se : feedbackArcs) {
            this.svGraph.removeEdge(se);
            LE newEdge = LE.of(se.getEdge(), se.getTarget(), se.getSource());
            this.svGraph.addEdge(newEdge.getSource(), newEdge.getTarget(), newEdge);
        }
        long cycles = System.currentTimeMillis();
        log.trace("remove cycles took {}", (Object)(cycles - transformTime));
        if (this.cancelled || Thread.currentThread().isInterrupted()) {
            log.debug("interrupted before layering, cancelled: {}", (Object)this.cancelled);
            return;
        }
        Comparator svComparator = (e1, e2) -> this.edgeComparator.compare(e1.getEdge(), e2.getEdge());
        switch (this.layering) {
            case NETWORK_SIMPLEX: {
                layers = GraphLayers.networkSimplex(this.svGraph);
                break;
            }
            case LONGEST_PATH: {
                if (this.edgeComparator != Layered.noopComparator) {
                    layers = GraphLayers.longestPath(this.svGraph, svComparator);
                    break;
                }
                layers = GraphLayers.longestPath(this.svGraph);
                break;
            }
            case COFFMAN_GRAHAM: {
                layers = GraphLayers.coffmanGraham(this.svGraph, 10);
                break;
            }
            default: {
                layers = GraphLayers.assign(this.svGraph);
            }
        }
        long assignLayersTime = System.currentTimeMillis();
        log.trace("assign layers took {} ", (Object)(assignLayersTime - cycles));
        GraphLayers.checkLayers(layers);
        Synthetics synthetics = new Synthetics(this.svGraph);
        ArrayList edges = new ArrayList(this.svGraph.edgeSet());
        LV<V>[][] layersArray = synthetics.createVirtualVerticesAndEdges(edges, layers);
        GraphLayers.checkLayers(layersArray);
        LinkedHashMap<Integer, List<LE<V, E>>> edgesKeyedOnTarget = new LinkedHashMap<Integer, List<LE<V, E>>>();
        edges.forEach(e -> {
            int targetRank = e.getTarget().getRank();
            if (edgesKeyedOnTarget.containsKey(targetRank)) {
                ((List)edgesKeyedOnTarget.get(targetRank)).add(e);
            } else {
                ArrayList<LE> list = new ArrayList<LE>();
                list.add((LE)e);
                edgesKeyedOnTarget.put(targetRank, list);
            }
        });
        LinkedHashMap<Integer, List<LE<V, E>>> edgesKeyedOnSource = new LinkedHashMap<Integer, List<LE<V, E>>>();
        edges.forEach(e -> {
            int sourceRank = e.getSource().getRank();
            if (edgesKeyedOnSource.containsKey(sourceRank)) {
                ((List)edgesKeyedOnSource.get(sourceRank)).add(e);
            } else {
                ArrayList<LE> list = new ArrayList<LE>();
                list.add((LE)e);
                edgesKeyedOnSource.put(sourceRank, list);
            }
        });
        long syntheticsTime = System.currentTimeMillis();
        log.trace("synthetics took {}", (Object)(syntheticsTime - assignLayersTime));
        Object vertexMetadata = null;
        LV<V>[][] best = null;
        int lowestCrossCount = Integer.MAX_VALUE;
        for (i = 0; i < this.maxLevelCross; ++i) {
            if (this.cancelled || Thread.currentThread().isInterrupted()) {
                log.debug("interrupted in level cross, cancelled: {}", (Object)this.cancelled);
                return;
            }
            if (i % 2 == 0) {
                this.medianDownwards(layersArray, this.svGraph);
                if (this.transpose) {
                    this.transposeDownwards(layersArray, edgesKeyedOnTarget);
                }
            } else {
                this.medianUpwards(layersArray, this.svGraph);
                if (this.transpose) {
                    this.transposeUpwards(layersArray, edgesKeyedOnSource);
                }
            }
            AllLevelCross<V, E> allLevelCross = new AllLevelCross<V, E>(this.svGraph, layersArray);
            int allLevelCrossCount = allLevelCross.allLevelCross();
            log.trace(" cross count: {}", (Object)allLevelCrossCount);
            GraphLayers.checkLayers(layersArray);
            if (allLevelCrossCount >= lowestCrossCount) continue;
            GraphLayers.checkLayers(layersArray);
            best = this.copy(layersArray);
            this.vertexMetadataMap = this.save(layersArray);
            GraphLayers.checkLayers(layersArray);
            lowestCrossCount = allLevelCrossCount;
        }
        log.trace("lowest cross count: {}", (Object)lowestCrossCount);
        this.restore(layersArray, this.vertexMetadataMap);
        Arrays.stream(layersArray).forEach(layer -> Arrays.sort(layer, Comparator.comparingInt(LV::getIndex)));
        if (log.isTraceEnabled()) {
            log.trace("best:{}", best);
            log.trace("layersArray:{}", layersArray);
        }
        for (i = 0; i < best.length; ++i) {
            void layer2 = best[i];
            for (int j = 0; j < ((void)layer2).length; ++j) {
                void v3 = layer2[j];
                if (v3.getVertex() == layersArray[i][j].getVertex()) continue;
                log.error("not equal");
            }
        }
        long crossCountTests = System.currentTimeMillis();
        log.trace("cross counts took {}", (Object)(crossCountTests - syntheticsTime));
        GraphLayers.checkLayers(layersArray);
        Rectangle avgVertexBounds = SugiyamaRunnable.avgVertexBounds(layersArray, this.vertexShapeFunction);
        int horizontalOffset = (int)Math.max(avgVertexBounds.width, (double)Integer.getInteger("jungrapht.mincross.horizontalOffset", 50).intValue());
        int verticalOffset = (int)Math.max(avgVertexBounds.height, (double)Integer.getInteger("jungrapht.mincross.verticalOffset", 50).intValue());
        GraphLayers.checkLayers(layersArray);
        if (this.cancelled || Thread.currentThread().isInterrupted()) {
            log.debug("interrupted before compaction, cancelled: {}", (Object)this.cancelled);
            return;
        }
        if (this.straightenEdges) {
            HorizontalCoordinateAssignment<V, E> horizontalCoordinateAssignment = new HorizontalCoordinateAssignment<V, E>(layersArray, this.svGraph, new HashSet(), horizontalOffset, verticalOffset);
            horizontalCoordinateAssignment.horizontalCoordinateAssignment();
            GraphLayers.checkLayers(layersArray);
        } else {
            Unaligned.centerPoints(layersArray, this.vertexShapeFunction, horizontalOffset, verticalOffset);
        }
        HashMap<Integer, Integer> rowWidthMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> rowMaxHeightMap = new HashMap<Integer, Integer>();
        int layerIndex = 0;
        int totalHeight = 0;
        int totalWidth = 0;
        for (int i2 = 0; i2 < layersArray.length; ++i2) {
            int width = horizontalOffset;
            int maxHeight = 0;
            for (int j = 0; j < layersArray[i2].length; ++j) {
                LV<V> v4 = layersArray[i2][j];
                if (!(v4 instanceof Synthetic)) {
                    Rectangle bounds = this.vertexShapeFunction.apply(v4.getVertex());
                    width = (int)((double)width + (bounds.width + (double)horizontalOffset));
                    maxHeight = Math.max(maxHeight, (int)bounds.height);
                    continue;
                }
                width += horizontalOffset;
            }
            rowWidthMap.put(layerIndex, width);
            rowMaxHeightMap.put(layerIndex, maxHeight);
            ++layerIndex;
        }
        int widestRowWidth = rowWidthMap.values().stream().mapToInt(v -> v).max().getAsInt();
        int x = horizontalOffset;
        int y = verticalOffset;
        layerIndex = 0;
        log.trace("layerMaxHeights {}", rowMaxHeightMap);
        for (int i3 = 0; i3 < layersArray.length; ++i3) {
            int previousVertexWidth = 0;
            x += (widestRowWidth - (Integer)rowWidthMap.get(layerIndex)) / 2;
            y += (Integer)rowMaxHeightMap.get(layerIndex) / 2;
            if (layerIndex > 0) {
                y += (Integer)rowMaxHeightMap.get(layerIndex - 1) / 2;
            }
            int rowWidth = 0;
            for (int j = 0; j < layersArray[i3].length; ++j) {
                LV<V> LV2 = layersArray[i3][j];
                int vertexWidth = 0;
                if (!(LV2 instanceof Synthetic)) {
                    vertexWidth = (int)this.vertexShapeFunction.apply(LV2.getVertex()).width;
                }
                rowWidth = (x += previousVertexWidth / 2 + vertexWidth / 2 + horizontalOffset) + vertexWidth / 2;
                log.trace("layerIndex {} y is {}", (Object)layerIndex, (Object)y);
                previousVertexWidth = vertexWidth;
            }
            totalWidth = Math.max(totalWidth, rowWidth);
            x = horizontalOffset;
            totalHeight = (y += verticalOffset) + (Integer)rowMaxHeightMap.get(layerIndex) / 2;
            ++layerIndex;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = -1;
        int maxY = -1;
        for (Point p : Arrays.stream(layersArray).flatMap(Arrays::stream).map(LV::getPoint).collect(Collectors.toList())) {
            minX = Math.min((int)p.x, minX);
            maxX = Math.max((int)p.x, maxX);
            minY = Math.min((int)p.y, minY);
            maxY = Math.max((int)p.y, maxY);
        }
        int pointRangeWidth = (maxX += horizontalOffset) - minX;
        int pointRangeHeight = (maxY += verticalOffset) - minY;
        int offsetX = 0;
        int offsetY = 0;
        if (minX < 0) {
            offsetX += -minX + horizontalOffset;
        }
        if (minY < 0) {
            offsetY += -minY + verticalOffset;
        }
        pointRangeWidth = (int)((double)pointRangeWidth * 1.1);
        pointRangeHeight = (int)((double)pointRangeHeight * 1.1);
        int maxDimension = Math.max(totalWidth, totalHeight);
        this.layoutModel.setSize(this.multiComponent ? totalWidth : Math.max(maxDimension, this.layoutModel.getWidth()), Math.max(maxDimension, this.layoutModel.getHeight()));
        long pointsSetTime = System.currentTimeMillis();
        double scalex = (double)this.layoutModel.getWidth() / (double)pointRangeWidth;
        double scaley = (double)this.layoutModel.getHeight() / (double)pointRangeHeight;
        for (LV v5 : Arrays.stream(layersArray).flatMap(Arrays::stream).collect(Collectors.toList())) {
            Point p = v5.getPoint();
            Point point = Point.of(((double)offsetX + p.x) * scalex, ((double)offsetY + p.y) * scaley);
            v5.setPoint(point);
        }
        if (this.postStraighten) {
            synthetics.alignArticulatedEdges();
        }
        List<ArticulatedEdge<V, E>> articulatedEdges = synthetics.makeArticulatedEdges();
        HashSet feedbackEdges = new HashSet();
        feedbackArcs.forEach(a -> feedbackEdges.add(a.getEdge()));
        articulatedEdges.stream().filter(ae -> feedbackEdges.contains(ae.edge)).forEach(ae -> {
            this.svGraph.removeEdge(ae);
            ArticulatedEdge reversed = ae.reversed();
            this.svGraph.addEdge(reversed.getSource(), reversed.getTarget(), reversed);
        });
        for (ArticulatedEdge articulatedEdge : articulatedEdges) {
            ArrayList<Point> points = new ArrayList<Point>();
            if (feedbackEdges.contains(articulatedEdge.edge)) {
                points.add(articulatedEdge.getTarget().getPoint());
                points.addAll(articulatedEdge.reversed().getIntermediatePoints());
                points.add(articulatedEdge.getSource().getPoint());
            } else {
                points.add(articulatedEdge.getSource().getPoint());
                points.addAll(articulatedEdge.getIntermediatePoints());
                points.add(articulatedEdge.getTarget().getPoint());
            }
            this.edgePointMap.put(articulatedEdge.edge, points);
        }
        long articulatedEdgeTime = System.currentTimeMillis();
        log.trace("articulated edges took {}", (Object)(articulatedEdgeTime - pointsSetTime));
        if (this.cancelled) {
            log.debug("interrupted before setting layoutModel from svGraph, cancelled: {}", (Object)this.cancelled);
            return;
        }
        this.svGraph.vertexSet().forEach(v -> this.layoutModel.set(v.getVertex(), v.getPoint()));
    }

    protected void transposeDownwards(LV<V>[][] ranks, Map<Integer, List<LE<V, E>>> reducedEdgeMap) {
        GraphLayers.checkLayers(ranks);
        boolean improved = true;
        int sanityCheck = 0;
        while (improved) {
            improved = false;
            block1: for (int i = 0; i < ranks.length; ++i) {
                LV<V>[] rank = ranks[i];
                for (int j = 0; j < rank.length - 1; ++j) {
                    List biLayerEdges = reducedEdgeMap.getOrDefault(i, Collections.emptyList());
                    int vw = AccumulatorTreeUtil.crossingCount(biLayerEdges);
                    if (log.isTraceEnabled()) {
                        int vw3;
                        int vw2 = this.crossingCount(biLayerEdges);
                        if (vw != vw2) {
                            log.error("{} != {}", (Object)vw, (Object)vw2);
                        }
                        if (vw != (vw3 = AccumulatorTreeUtil.crossingWeight(biLayerEdges, idx -> 1))) {
                            log.error("{} != {}", (Object)vw, (Object)vw3);
                        }
                    }
                    if (vw == 0) continue block1;
                    this.swap(rank, j, j + 1);
                    int wv = AccumulatorTreeUtil.crossingCount(biLayerEdges);
                    if (log.isTraceEnabled()) {
                        int wv3;
                        int wv2 = this.crossingCount(biLayerEdges);
                        if (wv != wv2) {
                            log.error("{} != {}", (Object)wv, (Object)wv2);
                        }
                        if (wv != (wv3 = AccumulatorTreeUtil.crossingWeight(biLayerEdges, idx -> 1))) {
                            log.error("{} != {}", (Object)wv, (Object)wv3);
                        }
                    }
                    this.swap(rank, j, j + 1);
                    if (vw <= wv) continue;
                    improved = true;
                    this.swap(rank, j, j + 1);
                }
            }
            if (++sanityCheck <= this.transposeLimit) continue;
        }
        GraphLayers.checkLayers(ranks);
    }

    protected void transposeUpwards(LV<V>[][] ranks, Map<Integer, List<LE<V, E>>> reducedEdgeMap) {
        GraphLayers.checkLayers(ranks);
        boolean improved = true;
        int sanityLimit = Integer.getInteger("jungrapht.mincross.transposeLimit", 10);
        int sanityCheck = 0;
        while (improved) {
            improved = false;
            block1: for (int i = ranks.length - 1; i >= 0; --i) {
                LV<V>[] rank = ranks[i];
                for (int j = 0; j < rank.length - 1; ++j) {
                    List biLayerEdges = reducedEdgeMap.getOrDefault(i, Collections.emptyList());
                    int vw = AccumulatorTreeUtil.crossingCount(biLayerEdges);
                    if (log.isTraceEnabled()) {
                        int vw3;
                        int vw2 = this.crossingCount(biLayerEdges);
                        if (vw != vw2) {
                            log.error("{} != {}", (Object)vw, (Object)vw2);
                        }
                        if (vw != (vw3 = AccumulatorTreeUtil.crossingWeight(biLayerEdges, idx -> 1))) {
                            log.error("{} != {}", (Object)vw, (Object)vw3);
                        }
                    }
                    if (vw == 0) continue block1;
                    this.swap(rank, j, j + 1);
                    int wv = AccumulatorTreeUtil.crossingCount(biLayerEdges);
                    if (log.isTraceEnabled()) {
                        int wv3;
                        int wv2 = this.crossingCount(biLayerEdges);
                        if (wv != wv2) {
                            log.error("{} != {}", (Object)wv, (Object)wv2);
                        }
                        if (wv != (wv3 = AccumulatorTreeUtil.crossingWeight(biLayerEdges, idx -> 1))) {
                            log.error("{} != {}", (Object)wv, (Object)wv3);
                        }
                    }
                    this.swap(rank, j, j + 1);
                    if (vw <= wv) continue;
                    improved = true;
                    this.swap(rank, j, j + 1);
                }
            }
            if (++sanityCheck <= sanityLimit) continue;
        }
        GraphLayers.checkLayers(ranks);
    }

    @Override
    public Map<E, List<Point>> getEdgePointMap() {
        return this.edgePointMap;
    }

    private void swap(LV<V>[] array, int i, int j) {
        LV<V> temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        array[i].setIndex(i);
        array[j].setIndex(j);
    }

    private int crossingCount(List<LE<V, E>> edges) {
        edges.sort(this.biLevelEdgeComparator);
        ArrayList<Integer> targetIndices = new ArrayList<Integer>();
        for (LE<V, LE<V, E>> lE : edges) {
            targetIndices.add(lE.getTarget().getIndex());
        }
        return InsertionSortCounter.insertionSortCounter(targetIndices);
    }

    private int crossingCountSwapped(int i, int j, LV<V>[] layer, List<LE<V, E>> edges) {
        this.swap(layer, i, j);
        edges.sort(this.biLevelEdgeComparator);
        ArrayList<Integer> targetIndices = new ArrayList<Integer>();
        for (LE<V, LE<V, E>> lE : edges) {
            targetIndices.add(lE.getTarget().getIndex());
        }
        this.swap(layer, i, j);
        return InsertionSortCounter.insertionSortCounter(targetIndices);
    }

    void median(LV<V>[][] layers, int i, Graph<LV<V>, LE<V, E>> svGraph) {
        if (i % 2 == 0) {
            for (int r = 0; r < layers.length; ++r) {
                for (LV<V> v : layers[r]) {
                    double median = this.medianValue(v, this.upperNeighborIndicesMethod, svGraph);
                    v.setMeasure(median);
                }
                this.medianSortAndFixMetadata(layers[r]);
                GraphLayers.checkLayers(layers);
            }
        } else {
            for (int r = layers.length - 1; r >= 0; --r) {
                for (LV<V> v : layers[r]) {
                    double median = this.medianValue(v, this.lowerNeighborIndicesMethod, svGraph);
                    v.setMeasure(median);
                }
                this.medianSortAndFixMetadata(layers[r]);
                GraphLayers.checkLayers(layers);
            }
        }
    }

    protected void medianDownwards(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph) {
        for (int r = 0; r < layers.length; ++r) {
            for (LV<V> v : layers[r]) {
                double median = this.medianValue(v, this.upperNeighborIndicesMethod, svGraph);
                v.setMeasure(median);
            }
            this.medianSortAndFixMetadata(layers[r]);
            GraphLayers.checkLayers(layers);
        }
    }

    protected void medianUpwards(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph) {
        for (int r = layers.length - 1; r >= 0; --r) {
            for (LV<V> v : layers[r]) {
                double median = this.medianValue(v, this.lowerNeighborIndicesMethod, svGraph);
                v.setMeasure(median);
            }
            this.medianSortAndFixMetadata(layers[r]);
            GraphLayers.checkLayers(layers);
        }
    }

    void medianSortAndFixMetadata(LV<V>[] layer) {
        Arrays.sort(layer, Comparator.comparing(LV::getMeasure));
        this.fixMetadata(layer);
    }

    private void fixMetadata(LV<V>[] layer) {
        for (int idx = 0; idx < layer.length; ++idx) {
            layer[idx].setIndex(idx);
        }
    }

    int[] upperNeighborIndices(LV<V> vertex) {
        return this.neighborCache.predecessorsOf(vertex).stream().mapToInt(LV::getIndex).sorted().toArray();
    }

    int[] lowerNeighborIndices(LV<V> vertex) {
        return this.neighborCache.successorsOf(vertex).stream().mapToInt(LV::getIndex).sorted().toArray();
    }

    int[] adjPosition(LV<V> v, Function<LV<V>, int[]> neighborFunction, Graph<LV<V>, LE<V, E>> svGraph) {
        return neighborFunction.apply(v);
    }

    double medianValue(LV<V> v, Function<LV<V>, int[]> neighborFunction, Graph<LV<V>, LE<V, E>> svGraph) {
        int[] P = this.adjPosition(v, neighborFunction, svGraph);
        int m = P.length / 2;
        if (P.length == 0) {
            return -1.0;
        }
        if (P.length % 2 == 1) {
            return P[m];
        }
        if (P.length == 2) {
            return (P[0] + P[1]) / 2;
        }
        double left = P[m - 1] - P[0];
        double right = P[P.length - 1] - P[m];
        return ((double)P[m - 1] * right + (double)P[m] * left) / (left + right);
    }

    double medianValue(int[] P) {
        int m = P.length / 2;
        if (P.length == 0) {
            return -1.0;
        }
        if (P.length % 2 == 1) {
            return P[m];
        }
        if (P.length == 2) {
            return (P[0] + P[1]) / 2;
        }
        double left = P[m - 1] - P[0];
        double right = P[P.length - 1] - P[m];
        return ((double)P[m - 1] * right + (double)P[m] * left) / (left + right);
    }

    protected LV<V>[][] copy(LV<V>[][] in) {
        LV[][] copy = new LV[in.length][];
        for (int i = 0; i < in.length; ++i) {
            copy[i] = new LV[in[i].length];
            for (int j = 0; j < in[i].length; ++j) {
                copy[i][j] = in[i][j].copy();
            }
        }
        return copy;
    }

    protected Map<LV<V>, VertexMetadata<V>> save(LV<V>[][] in) {
        HashMap<LV<VertexMetadata>, VertexMetadata<VertexMetadata>> vertexMetadataMap = new HashMap<LV<VertexMetadata>, VertexMetadata<VertexMetadata>>();
        VertexMetadata[][] saved = new VertexMetadata[in.length][];
        for (int i = 0; i < in.length; ++i) {
            saved[i] = new VertexMetadata[in[i].length];
            for (int j = 0; j < in[i].length; ++j) {
                saved[i][j] = VertexMetadata.of(in[i][j]);
                vertexMetadataMap.put(in[i][j], saved[i][j]);
            }
        }
        return vertexMetadataMap;
    }

    protected LV<V>[][] restore(LV<V>[][] layers, Map<LV<V>, VertexMetadata<V>> vertexMetadataMap) {
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].length; ++j) {
                VertexMetadata<V> vertexMetadata = vertexMetadataMap.get(layers[i][j]);
                vertexMetadata.applyTo(layers[i][j]);
            }
        }
        return layers;
    }

    private static <V> Rectangle maxVertexBounds(List<List<LV<V>>> layers, Function<V, Rectangle> vertexShapeFunction) {
        Rectangle maxVertexBounds = Rectangle.IDENTITY;
        for (List<LV<V>> list : layers) {
            for (LV<V> v : list) {
                if (v instanceof Synthetic) continue;
                Rectangle bounds = vertexShapeFunction.apply(v.getVertex());
                int width = (int)Math.max(bounds.width, maxVertexBounds.width);
                int height = (int)Math.max(bounds.height, maxVertexBounds.height);
                maxVertexBounds = Rectangle.of(0, 0, width, height);
            }
        }
        return maxVertexBounds;
    }

    private static <V> Rectangle avgVertexBounds(LV<V>[][] layers, Function<V, Rectangle> vertexShapeFunction) {
        LongSummaryStatistics w = new LongSummaryStatistics();
        LongSummaryStatistics h = new LongSummaryStatistics();
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].length; ++j) {
                if (layers[i][j] instanceof Synthetic) continue;
                Rectangle bounds = vertexShapeFunction.apply(layers[i][j].getVertex());
                w.accept((int)bounds.width);
                h.accept((int)bounds.height);
            }
        }
        return Rectangle.of(0, 0, (int)w.getAverage(), (int)h.getAverage());
    }

    static {
        PropertyLoader.load();
    }

    public static class Builder<V, E, T extends SugiyamaRunnable<V, E>, B extends Builder<V, E, T, B>> {
        protected LayoutModel<V> layoutModel;
        protected Function<V, Rectangle> vertexShapeFunction;
        protected Predicate<V> vertexPredicate;
        protected Predicate<E> edgePredicate;
        protected Comparator<V> vertexComparator = (v1, v2) -> 0;
        protected Comparator<E> edgeComparator = (e1, e2) -> 0;
        protected boolean straightenEdges;
        protected boolean postStraighten;
        protected boolean transpose;
        protected int transposeLimit;
        protected int maxLevelCross;
        protected Layering layering = Layering.TOP_DOWN;
        protected boolean multiComponent;

        protected B self() {
            return (B)this;
        }

        public B vertexPredicate(Predicate<V> vertexPredicate) {
            this.vertexPredicate = vertexPredicate;
            return this.self();
        }

        public B edgePredicate(Predicate<E> edgePredicate) {
            this.edgePredicate = edgePredicate;
            return this.self();
        }

        public B vertexComparator(Comparator<V> vertexComparator) {
            this.vertexComparator = vertexComparator;
            return this.self();
        }

        public B edgeComparator(Comparator<E> edgeComparator) {
            this.edgeComparator = edgeComparator;
            return this.self();
        }

        public B layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            return this.self();
        }

        public B vertexShapeFunction(Function<V, Rectangle> vertexShapeFunction) {
            this.vertexShapeFunction = vertexShapeFunction;
            return this.self();
        }

        public B straightenEdges(boolean straightenEdges) {
            this.straightenEdges = straightenEdges;
            return this.self();
        }

        public B postStraighten(boolean postStraighten) {
            this.postStraighten = postStraighten;
            return this.self();
        }

        public B transpose(boolean transpose) {
            this.transpose = transpose;
            return this.self();
        }

        public B transposeLimit(int transposeLimit) {
            this.transposeLimit = transposeLimit;
            return this.self();
        }

        public B maxLevelCross(int maxLevelCross) {
            this.maxLevelCross = maxLevelCross;
            return this.self();
        }

        public B layering(Layering layering) {
            this.layering = layering;
            return this.self();
        }

        public B multiComponent(boolean multiComponent) {
            this.multiComponent = multiComponent;
            return this.self();
        }

        public T build() {
            return (T)new SugiyamaRunnable(this);
        }

        static {
            PropertyLoader.load();
        }
    }
}

