/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugProcessInfo;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgProcessCreatedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.comm.util.BitmaskSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DbgLaunchProcessCommand
extends AbstractDbgCommand<DbgThread> {
    private DbgProcessCreatedEvent created = null;
    private boolean completed = false;
    private List<String> args;

    public DbgLaunchProcessCommand(DbgManagerImpl manager, List<String> args) {
        super(manager);
        this.args = args;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof DbgProcessCreatedEvent) {
            this.created = (DbgProcessCreatedEvent)evt;
        }
        return this.completed && this.created != null;
    }

    @Override
    public DbgThread complete(DbgPendingCommand<?> pending) {
        DebugProcessInfo info = (DebugProcessInfo)this.created.getInfo();
        DebugThreadInfo tinfo = info.initialThreadInfo;
        DebugSystemObjects so = this.manager.getSystemObjects();
        DebugThreadId tid = so.getThreadIdByHandle(tinfo.handle);
        return this.manager.getThread(tid);
    }

    @Override
    public void invoke() {
        DebugClient dbgeng = this.manager.getClient();
        ArrayList<String> newArgs = new ArrayList<String>();
        Iterator<String> iterator = this.args.iterator();
        while (iterator.hasNext()) {
            String arg;
            String na = arg = iterator.next();
            if (arg.startsWith("/")) {
                na = na.substring(1);
            }
            na = na.replace("/", "\\");
            newArgs.add(na);
        }
        dbgeng.createProcess(dbgeng.getLocalServer(), StringUtils.join(newArgs, (String)" "), (BitmaskSet<DebugClient.DebugCreateFlags>)BitmaskSet.of((Enum[])new DebugClient.DebugCreateFlags[]{DebugClient.DebugCreateFlags.DEBUG_PROCESS}));
        this.manager.waitForEventEx();
    }
}

