/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugDataSpaces;
import agent.dbgeng.dbgeng.DebugModule;
import agent.dbgeng.manager.DbgModuleMemory;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgModuleMemoryImpl;
import com.sun.jna.platform.win32.COM.COMException;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DbgListMemoryRegionsCommand
extends AbstractDbgCommand<List<DbgModuleMemory>> {
    private List<DbgModuleMemory> memoryRegions = new ArrayList<DbgModuleMemory>();

    public DbgListMemoryRegionsCommand(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public List<DbgModuleMemory> complete(DbgPendingCommand<?> pending) {
        Map<Long, DbgModuleMemory> memory = this.manager.getKnownMemoryRegions();
        for (DbgModuleMemory dbgModuleMemory : this.memoryRegions) {
            if (memory.containsValue(dbgModuleMemory)) continue;
            if (!memory.isEmpty()) {
                Msg.warn((Object)this, (Object)("Resync: Was missing memory: " + dbgModuleMemory.getId()));
            }
            this.manager.addMemory(dbgModuleMemory);
        }
        for (Map.Entry entry : memory.entrySet()) {
            if (this.memoryRegions.contains(entry.getValue())) continue;
            this.manager.removeMemory((Long)entry.getKey());
        }
        return this.memoryRegions;
    }

    @Override
    public void invoke() {
        DebugDataSpaces dataSpaces = this.manager.getDataSpaces();
        for (DebugDataSpaces.DebugMemoryBasicInformation info : dataSpaces.iterateVirtual(0L)) {
            if (info.state == DebugDataSpaces.PageState.FREE) continue;
            Object type = "[" + info.type + "]";
            if (info.type == DebugDataSpaces.PageType.IMAGE) {
                try {
                    DebugModule mod = this.manager.getSymbols().getModuleByOffset(info.baseAddress, 0);
                    if (mod != null) {
                        type = mod.getName(DebugModule.DebugModuleName.IMAGE);
                    }
                }
                catch (COMException e) {
                    type = "[IMAGE UNKNOWN]";
                }
            } else if (info.type == DebugDataSpaces.PageType.MAPPED) {
                // empty if block
            }
            long vmaStart = info.baseAddress;
            long vmaEnd = info.baseAddress + info.regionSize;
            boolean isRead = false;
            boolean isWrite = false;
            boolean isExec = false;
            ArrayList<String> ap = new ArrayList<String>();
            for (DebugDataSpaces.PageProtection pageProtection : info.allocationProtect) {
                ap.add(pageProtection.toString());
                isRead |= pageProtection.isRead();
                isWrite |= pageProtection.isWrite();
                isExec |= pageProtection.isExecute();
            }
            ArrayList<String> ip = new ArrayList<String>();
            for (DebugDataSpaces.PageProtection protect3 : info.protect) {
                ip.add(protect3.toString());
                isRead |= protect3.isRead();
                isWrite |= protect3.isWrite();
                isExec |= protect3.isExecute();
            }
            DbgModuleMemoryImpl dbgModuleMemoryImpl = new DbgModuleMemoryImpl(Long.toHexString(vmaStart), vmaStart, vmaEnd, info.allocationBase, ap, ip, info.state, (String)type, isRead, isWrite, isExec);
            this.memoryRegions.add(dbgModuleMemoryImpl);
        }
    }
}

