/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

import ghidra.framework.Application;
import ghidra.framework.OSFileNotFoundException;
import ghidra.framework.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class GnuDemanglerNativeProcess {
    public static final String DEMANGLER_GNU = "demangler_gnu_v2_33_1";
    private static final String DEFAULT_NATIVE_OPTIONS = "";
    private static final Map<String, GnuDemanglerNativeProcess> processesByName = new HashMap<String, GnuDemanglerNativeProcess>();
    private String applicationName;
    private String options;
    private boolean isDisposed;
    private Process process;
    private BufferedReader reader;
    private PrintWriter writer;

    public static synchronized GnuDemanglerNativeProcess getDemanglerNativeProcess() throws IOException {
        return GnuDemanglerNativeProcess.getDemanglerNativeProcess(DEMANGLER_GNU);
    }

    public static synchronized GnuDemanglerNativeProcess getDemanglerNativeProcess(String name) throws IOException {
        return GnuDemanglerNativeProcess.getDemanglerNativeProcess(name, DEFAULT_NATIVE_OPTIONS);
    }

    public static synchronized GnuDemanglerNativeProcess getDemanglerNativeProcess(String name, String nativeOptions) throws IOException {
        String key;
        GnuDemanglerNativeProcess nativeProcess;
        String options = nativeOptions;
        if (StringUtils.isBlank((CharSequence)options)) {
            options = DEFAULT_NATIVE_OPTIONS;
        }
        if ((nativeProcess = processesByName.get(key = GnuDemanglerNativeProcess.getKey(name, options))) == null) {
            nativeProcess = new GnuDemanglerNativeProcess(name, options);
        }
        return nativeProcess;
    }

    private static String getKey(String name, String options) {
        return name + " " + options;
    }

    private GnuDemanglerNativeProcess(String applicationName, String options) throws IOException {
        this.applicationName = applicationName;
        this.options = options;
        this.createProcess();
    }

    public synchronized String demangle(String mangled) throws IOException {
        if (this.isDisposed) {
            throw new IOException("Demangled process has been terminated.");
        }
        return this.demangle(mangled, true);
    }

    private String demangle(String mangled, boolean restart) throws IOException {
        try {
            return this.doDemangle(mangled);
        }
        catch (IOException e) {
            this.dispose();
            if (!restart) {
                throw new IOException("Demangler process is not running.", e);
            }
            this.createProcess();
            return this.demangle(mangled, false);
        }
    }

    private String doDemangle(String mangled) throws IOException {
        this.writer.println(mangled);
        this.writer.flush();
        return this.reader.readLine();
    }

    public void dispose() {
        String key = GnuDemanglerNativeProcess.getKey(this.applicationName, this.options);
        processesByName.remove(key);
        try {
            if (this.process != null) {
                this.process.destroy();
            }
            this.process = null;
            this.reader = null;
            this.writer = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.isDisposed = true;
        }
    }

    private void createProcess() throws IOException {
        String[] command = this.buildCommand();
        this.process = Runtime.getRuntime().exec(command);
        InputStream in = this.process.getInputStream();
        OutputStream out = this.process.getOutputStream();
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.writer = new PrintWriter(out);
        this.checkForError(command);
        this.isDisposed = false;
        String key = GnuDemanglerNativeProcess.getKey(this.applicationName, this.options);
        processesByName.put(key, this);
    }

    private String[] buildCommand() throws OSFileNotFoundException {
        String executableName = this.applicationName + Platform.CURRENT_PLATFORM.getExecutableExtension();
        File commandPath = Application.getOSFile((String)executableName);
        Object[] command = new String[]{commandPath.getAbsolutePath()};
        if (!StringUtils.isBlank((CharSequence)this.options)) {
            Object[] optionsArray = this.options.split("\\s");
            command = (String[])ArrayUtils.addAll((Object[])command, (Object[])optionsArray);
        }
        return command;
    }

    private void checkForError(String[] command) throws IOException {
        String baseName;
        String testResult = this.doDemangle("test");
        if (!StringUtils.isBlank((CharSequence)testResult)) {
            return;
        }
        InputStream err = this.process.getErrorStream();
        String error = null;
        try {
            List errorLines = IOUtils.readLines((InputStream)err, (Charset)Charset.defaultCharset());
            error = StringUtils.join((Iterable)errorLines, (char)'\n');
        }
        catch (IOException e) {
            throw new IOException("Unable to read process error stream: ", e);
        }
        if (StringUtils.isBlank((CharSequence)error)) {
            return;
        }
        String executable = command[0];
        command[0] = baseName = FilenameUtils.getBaseName((String)executable);
        error = error.replace(executable, DEFAULT_NATIVE_OPTIONS);
        throw new IOException("Error starting demangler with command: '" + Arrays.toString(command) + "' " + error);
    }
}

