/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.DBTraceCacheForContainingQueries;
import ghidra.trace.database.DBTraceCacheForSequenceQueries;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.context.DBTraceRegisterContextSpace;
import ghidra.trace.database.listing.AbstractDBTraceCodeUnit;
import ghidra.trace.database.listing.AbstractSingleDBTraceCodeUnitsView;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceCodeUnitAdapter;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapAddressSetView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public abstract class AbstractBaseDBTraceDefinedUnitsView<T extends AbstractDBTraceCodeUnit<T>>
extends AbstractSingleDBTraceCodeUnitsView<T> {
    protected static final int CACHE_MAX_REGIONS = 1000;
    protected static final int CACHE_ADDRESS_BREADTH = 10000;
    protected static final int CACHE_MAX_POINTS = 10000;
    protected final DBTraceAddressSnapRangePropertyMapSpace<T, T> mapSpace;
    protected final CacheForGetUnitContainingQueries cacheForContaining = new CacheForGetUnitContainingQueries();
    protected final CacheForGetUnitSequenceQueries cacheForSequence = new CacheForGetUnitSequenceQueries();

    public AbstractBaseDBTraceDefinedUnitsView(DBTraceCodeSpace space, DBTraceAddressSnapRangePropertyMapSpace<T, T> mapSpace) {
        super(space);
        this.mapSpace = mapSpace;
    }

    @Override
    public int size() {
        return this.mapSpace.size();
    }

    @Override
    public boolean containsAddress(long snap, Address address) {
        return !this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).isEmpty();
    }

    protected Set<TraceAddressSnapRange> subtractFrom(Range<Long> span, AddressRange range, Set<TraceAddressSnapRange> cur, Set<TraceAddressSnapRange> set1, Set<TraceAddressSnapRange> set2) {
        Set<TraceAddressSnapRange> prevLeftOver = cur;
        Set<TraceAddressSnapRange> nextLeftOver = cur == set1 ? set2 : set1;
        for (TraceAddressSnapRange tasr : this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).keys()) {
            for (TraceAddressSnapRange lo : prevLeftOver) {
                if (tasr.encloses(lo)) continue;
                if (!lo.intersects(tasr)) {
                    nextLeftOver.add(lo);
                    continue;
                }
                TraceAddressSnapRange intersection = (TraceAddressSnapRange)lo.intersection(tasr);
                if (lo.getX1().compareTo((Object)intersection.getX1()) < 0) {
                    nextLeftOver.add(new ImmutableTraceAddressSnapRange(lo.getX1(), intersection.getX1().previous(), lo.getLifespan()));
                }
                if (lo.getX2().compareTo((Object)intersection.getX2()) > 0) {
                    nextLeftOver.add(new ImmutableTraceAddressSnapRange(intersection.getX2().next(), lo.getX2(), lo.getLifespan()));
                }
                if (lo.getY1().compareTo(intersection.getY1()) < 0) {
                    nextLeftOver.add(new ImmutableTraceAddressSnapRange(intersection.getRange(), (Range<Long>)Range.closed((Comparable)lo.getY1(), (Comparable)Long.valueOf(intersection.getY1() - 1L))));
                }
                if (lo.getY2().compareTo(intersection.getY2()) <= 0) continue;
                nextLeftOver.add(new ImmutableTraceAddressSnapRange(intersection.getRange(), (Range<Long>)Range.closed((Comparable)Long.valueOf(intersection.getY2() + 1L), (Comparable)lo.getY2())));
            }
            if (nextLeftOver.isEmpty()) {
                return nextLeftOver;
            }
            Set<TraceAddressSnapRange> clear = prevLeftOver;
            clear.clear();
            prevLeftOver = nextLeftOver;
            nextLeftOver = clear;
        }
        return prevLeftOver;
    }

    @Override
    public boolean coversRange(Range<Long> span, AddressRange range) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            HashSet<TraceAddressSnapRange> set1 = new HashSet<TraceAddressSnapRange>();
            HashSet<TraceAddressSnapRange> set2 = new HashSet<TraceAddressSnapRange>();
            set1.add(new ImmutableTraceAddressSnapRange(range, span));
            Set<TraceAddressSnapRange> cur = this.subtractFrom(span, range, set1, set1, set2);
            boolean bl = cur.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean intersectsRange(Range<Long> lifespan, AddressRange range) {
        return !this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, lifespan)).isEmpty();
    }

    @Override
    public T getFloor(long snap, Address max) {
        return (T)((AbstractDBTraceCodeUnit)this.cacheForSequence.getFloor(snap, max));
    }

    @Override
    public T getContaining(long snap, Address address) {
        return (T)((AbstractDBTraceCodeUnit)this.cacheForContaining.getContaining(new DBTraceCacheForContainingQueries.GetKey(snap, address)));
    }

    @Override
    public T getAt(long snap, Address address) {
        DBTraceCodeUnitAdapter unit = this.getContaining(snap, address);
        if (unit == null) {
            return null;
        }
        if (!((AbstractDBTraceCodeUnit)unit).getAddress().equals((Object)address)) {
            return null;
        }
        return (T)unit;
    }

    @Override
    public T getCeiling(long snap, Address min) {
        return (T)((AbstractDBTraceCodeUnit)this.cacheForSequence.getCeiling(snap, min));
    }

    @Override
    public Iterable<? extends T> get(long snap, Address min, Address max, boolean forward) {
        Address spaceMax = this.space.space.getMaxAddress();
        Rectangle2DDirection direction = forward ? Rectangle2DDirection.LEFTMOST : Rectangle2DDirection.RIGHTMOST;
        return () -> this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(min, max, snap, snap)).reduce((Object)((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.enclosed(min, spaceMax, Long.MIN_VALUE, Long.MAX_VALUE).starting(direction))).orderedValues().iterator();
    }

    @Override
    public Iterable<? extends T> getIntersecting(TraceAddressSnapRange tasr) {
        return Collections.unmodifiableCollection(this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(tasr)).values());
    }

    @Override
    public AddressSetView getAddressSetView(long snap, AddressRange within) {
        return new DBTraceAddressSnapRangePropertyMapAddressSetView<AbstractDBTraceCodeUnit>(within.getAddressSpace(), this.space.lock, this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(within.getMinAddress(), within.getMaxAddress(), snap, snap)), t -> true);
    }

    protected void clearContext(Range<Long> span, AddressRange range) {
        DBTraceRegisterContextSpace ctxSpace = (DBTraceRegisterContextSpace)this.space.trace.getRegisterContextManager().get(this.space, false);
        if (ctxSpace == null) {
            return;
        }
        ctxSpace.clear(span, range);
    }

    public void clear(Range<Long> span, AddressRange range, boolean clearContext, TaskMonitor monitor) throws CancelledException {
        long startSnap = DBTraceUtils.lowerEndpoint(span);
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.cacheForContaining.invalidate();
            this.cacheForSequence.invalidate();
            for (AbstractDBTraceCodeUnit unit : this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values()) {
                monitor.checkCanceled();
                if (unit.getStartSnap() < startSnap) {
                    Range<Long> oldSpan = unit.getLifespan();
                    if (clearContext) {
                        this.clearContext(DBTraceUtils.toRange(DBTraceUtils.lowerEndpoint(span), DBTraceUtils.upperEndpoint(oldSpan)), unit.getRange());
                    }
                    unit.setEndSnap(startSnap - 1L);
                    continue;
                }
                if (clearContext) {
                    this.clearContext(unit.getLifespan(), unit.getRange());
                }
                unit.delete();
            }
        }
    }

    protected void unitRemoved(T unit) {
        this.cacheForContaining.notifyEntryRemoved(((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getLifespan(), ((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getRange(), unit);
        this.cacheForSequence.notifyEntryRemoved(((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getLifespan(), ((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getRange(), unit);
        this.space.undefinedData.invalidateCache();
        this.space.trace.setChanged(new TraceChangeRecord<TraceAddressSnapRange, Object>((TraceChangeType<TraceAddressSnapRange, Object>)Trace.TraceCodeChangeType.REMOVED, this.space, ((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getBounds(), unit, null));
    }

    protected void unitSpanChanged(Range<Long> oldSpan, T unit) {
        this.cacheForContaining.notifyEntryShapeChanged(((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getLifespan(), ((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getRange(), unit);
        this.cacheForSequence.notifyEntryShapeChanged(((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getLifespan(), ((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getRange(), unit);
        this.space.undefinedData.invalidateCache();
        this.space.trace.setChanged(new TraceChangeRecord<TraceCodeUnit, Range<Long>>((TraceChangeType<TraceCodeUnit, Range<Long>>)Trace.TraceCodeChangeType.LIFESPAN_CHANGED, this.space, (TraceCodeUnit)unit, oldSpan, ((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)unit).getLifespan()));
    }

    protected Range<Long> truncateSoonestDefined(Range<Long> span, AddressRange range) throws CodeUnitInsertionException {
        AbstractDBTraceCodeUnit truncateBy = (AbstractDBTraceCodeUnit)this.mapSpace.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span).starting(Rectangle2DDirection.BOTTOMMOST)).firstValue();
        if (truncateBy == null) {
            return span;
        }
        if (truncateBy.getStartSnap() <= DBTraceUtils.lowerEndpoint(span)) {
            throw new CodeUnitInsertionException("Code units cannot overlap");
        }
        return DBTraceUtils.toRange(DBTraceUtils.lowerEndpoint(span), truncateBy.getStartSnap() - 1L);
    }

    public void invalidateCache() {
        this.cacheForContaining.invalidate();
        this.cacheForSequence.invalidate();
    }

    protected class CacheForGetUnitSequenceQueries
    extends DBTraceCacheForSequenceQueries<T> {
        public CacheForGetUnitSequenceQueries() {
            super(1000, 10000);
        }

        @Override
        protected void loadCachedRegion(DBTraceCacheForSequenceQueries.CachedRegion region) {
            region.load(new ArrayList(AbstractBaseDBTraceDefinedUnitsView.this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(region.min, region.max, region.snap, region.snap)).entries()));
        }

        @Override
        protected Map.Entry<TraceAddressSnapRange, T> doFloorEntry(long snap, Address max) {
            Address spaceMin = AbstractBaseDBTraceDefinedUnitsView.this.space.space.getMinAddress();
            return AbstractBaseDBTraceDefinedUnitsView.this.mapSpace.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(spaceMin, max, snap, snap).starting(Rectangle2DDirection.RIGHTMOST)).firstEntry();
        }

        @Override
        protected Map.Entry<TraceAddressSnapRange, T> doCeilingEntry(long snap, Address min) {
            Address spaceMax = AbstractBaseDBTraceDefinedUnitsView.this.space.space.getMaxAddress();
            return AbstractBaseDBTraceDefinedUnitsView.this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(min, spaceMax, snap, snap)).reduce((Object)((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.enclosed(min, spaceMax, Long.MIN_VALUE, Long.MAX_VALUE).starting(Rectangle2DDirection.LEFTMOST))).firstEntry();
        }
    }

    protected class CacheForGetUnitContainingQueries
    extends DBTraceCacheForContainingQueries<DBTraceCacheForContainingQueries.GetKey, T, T> {
        public CacheForGetUnitContainingQueries() {
            super(1000, 10000, 10000);
        }

        @Override
        protected void loadRangeCache(TraceAddressSnapRange range) {
            this.rangeCache.addAll(AbstractBaseDBTraceDefinedUnitsView.this.mapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range)).entries());
        }

        @Override
        protected T doGetContaining(DBTraceCacheForContainingQueries.GetKey key) {
            this.ensureInCachedRange(key.snap, key.addr);
            return (AbstractDBTraceCodeUnit)this.getFirstInRangeCacheContaining(key);
        }
    }
}

