/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.listing.AbstractBaseDBTraceCodeUnitsView;
import ghidra.trace.database.listing.AbstractSingleDBTraceCodeUnitsView;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceCodeUnitAdapter;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.util.LockHold;
import ghidra.util.MergeSortingIterator;
import ghidra.util.UnionAddressSetView;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;

public abstract class AbstractComposedDBTraceCodeUnitsView<T extends DBTraceCodeUnitAdapter, P extends AbstractSingleDBTraceCodeUnitsView<? extends T>>
extends AbstractBaseDBTraceCodeUnitsView<T> {
    protected final Collection<P> parts;

    protected static int compareForward(TraceCodeUnit a, TraceCodeUnit b) {
        return a.getMinAddress().compareTo((Object)b.getMinAddress());
    }

    protected static int compareBackward(TraceCodeUnit a, TraceCodeUnit b) {
        return b.getMaxAddress().compareTo((Object)a.getMaxAddress());
    }

    public AbstractComposedDBTraceCodeUnitsView(DBTraceCodeSpace space, Collection<P> parts) {
        super(space);
        this.parts = parts;
    }

    @Override
    public int size() {
        int sum = 0;
        for (AbstractSingleDBTraceCodeUnitsView p : this.parts) {
            sum += p.size();
        }
        return sum;
    }

    @Override
    public Iterable<? extends T> get(long snap, Address min, Address max, boolean forward) {
        Collection itCol = Collections2.transform(this.parts, p -> p.get(snap, min, max, forward).iterator());
        return () -> new MergeSortingIterator((Iterable)itCol, forward ? AbstractComposedDBTraceCodeUnitsView::compareForward : AbstractComposedDBTraceCodeUnitsView::compareBackward);
    }

    @Override
    public Iterable<? extends T> getIntersecting(TraceAddressSnapRange tasr) {
        Collection itCol = Collections2.transform(this.parts, p -> p.getIntersecting(tasr).iterator());
        return () -> Iterators.concat(itCol.iterator());
    }

    @Override
    public T getFloor(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Object best = null;
            for (AbstractSingleDBTraceCodeUnitsView p : this.parts) {
                Object candidate = p.getFloor(snap, address);
                if (candidate == null) continue;
                if (candidate.getMaxAddress().compareTo((Object)address) >= 0) {
                    Object t = candidate;
                    return t;
                }
                if (best != null && candidate.getMaxAddress().compareTo((Object)best.getMaxAddress()) <= 0) continue;
                best = candidate;
            }
            Iterator<P> iterator = best;
            return (T)iterator;
        }
    }

    @Override
    public T getContaining(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            for (AbstractSingleDBTraceCodeUnitsView p : this.parts) {
                Object candidate = p.getContaining(snap, address);
                if (candidate == null) continue;
                Object t = candidate;
                return t;
            }
            Iterator<P> iterator = null;
            return (T)iterator;
        }
    }

    @Override
    public T getAt(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            for (AbstractSingleDBTraceCodeUnitsView p : this.parts) {
                Object candidate = p.getAt(snap, address);
                if (candidate == null) continue;
                Object t = candidate;
                return t;
            }
            Iterator<P> iterator = null;
            return (T)iterator;
        }
    }

    @Override
    public T getCeiling(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            DBTraceCodeUnitAdapter best = null;
            for (AbstractSingleDBTraceCodeUnitsView p : this.parts) {
                Object candidate = p.getCeiling(snap, address);
                if (candidate == null) continue;
                if (candidate.getAddress().equals((Object)address)) {
                    Object t = candidate;
                    return t;
                }
                if (best != null && candidate.getMinAddress().compareTo((Object)best.getMinAddress()) >= 0) continue;
                best = (DBTraceCodeUnitAdapter)candidate;
            }
            Iterator<P> iterator = best;
            return (T)iterator;
        }
    }

    @Override
    public AddressSetView getAddressSetView(long snap, AddressRange within) {
        return new UnionAddressSetView(Collections2.transform(this.parts, p -> p.getAddressSetView(snap, within)));
    }

    @Override
    public boolean containsAddress(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            for (AbstractSingleDBTraceCodeUnitsView p : this.parts) {
                if (!p.containsAddress(snap, address)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

