/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.listing.AbstractBaseDBTraceCodeUnitsMemoryView;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceInstruction;
import ghidra.trace.database.listing.DBTraceInstructionsView;
import ghidra.trace.model.listing.TraceInstructionsView;
import ghidra.util.LockHold;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class DBTraceInstructionsMemoryView
extends AbstractBaseDBTraceCodeUnitsMemoryView<DBTraceInstruction, DBTraceInstructionsView>
implements TraceInstructionsView {
    public DBTraceInstructionsMemoryView(DBTraceCodeManager manager) {
        super(manager);
    }

    @Override
    protected DBTraceInstructionsView getView(DBTraceCodeSpace space) {
        return space.instructions;
    }

    @Override
    public void clear(Range<Long> span, AddressRange range, boolean clearContext, TaskMonitor monitor) throws CancelledException {
        this.delegateDeleteV(range.getAddressSpace(), m -> m.clear(span, range, clearContext, monitor));
    }

    @Override
    public DBTraceInstruction create(Range<Long> lifespan, Address address, InstructionPrototype prototype, ProcessorContextView context) throws CodeUnitInsertionException {
        return this.delegateWrite(address.getAddressSpace(), m -> m.create((Range)lifespan, address, prototype, context));
    }

    @Override
    public AddressSetView addInstructionSet(Range<Long> lifespan, InstructionSet instructionSet, boolean overwrite) {
        InstructionSet mappedSet = this.manager.getTrace().getLanguageManager().mapGuestInstructionAddressesToHost(instructionSet);
        HashMap<AddressSpace, InstructionSet> breakDown = new HashMap<AddressSpace, InstructionSet>();
        for (InstructionBlock block : mappedSet) {
            InstructionSet setPerSpace = breakDown.computeIfAbsent(block.getStartAddress().getAddressSpace(), s -> new InstructionSet(this.manager.getBaseLanguage().getAddressFactory()));
            setPerSpace.addBlock(block);
        }
        AddressSet result = new AddressSet();
        try (LockHold hold = LockHold.lock((Lock)this.manager.writeLock());){
            for (Map.Entry entry : breakDown.entrySet()) {
                DBTraceInstructionsView instructionsView = (DBTraceInstructionsView)this.getForSpace((AddressSpace)entry.getKey(), true);
                result.add(instructionsView.addInstructionSet(lifespan, (InstructionSet)entry.getValue(), overwrite));
            }
            AddressSet addressSet = result;
            return addressSet;
        }
    }
}

