/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.space;

import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.util.TraceAddressSpace;

public interface DBTraceSpaceKey
extends TraceAddressSpace {
    public static DBTraceSpaceKey create(AddressSpace space, DBTraceThread thread, int frameLevel) {
        return new DefaultDBTraceSpaceKey(thread, space, frameLevel);
    }

    @Override
    public DBTraceThread getThread();

    public static class DefaultDBTraceSpaceKey
    implements DBTraceSpaceKey {
        private final DBTraceThread thread;
        private final AddressSpace space;
        private final int frameLevel;

        private DefaultDBTraceSpaceKey(DBTraceThread thread, AddressSpace space, int frameLevel) {
            this.thread = thread;
            this.space = space;
            this.frameLevel = frameLevel;
        }

        @Override
        public AddressSpace getAddressSpace() {
            return this.space;
        }

        @Override
        public DBTraceThread getThread() {
            return this.thread;
        }

        @Override
        public int getFrameLevel() {
            return this.frameLevel;
        }
    }
}

