/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Collections2;
import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.DBTraceCacheForContainingQueries;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.space.DBTraceSpaceKey;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeView;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class AbstractDBTraceSymbolSingleTypeWithLocationView<T extends AbstractDBTraceSymbol>
extends AbstractDBTraceSymbolSingleTypeView<T> {
    protected static final int CACHE_SNAP_BREADTH = 2;
    protected static final int CACHE_ADDRESS_BREADTH = 30;
    protected static final int CACHE_MAX_POINTS = 1000;
    protected final CacheForGetSymbolsAtQueries cacheForAt = new CacheForGetSymbolsAtQueries();

    public AbstractDBTraceSymbolSingleTypeWithLocationView(DBTraceSymbolManager manager, byte typeID, DBCachedObjectStore<T> store) {
        super(manager, typeID, store);
    }

    public T getChildWithNameAt(String name, long snap, TraceThread thread, Address address, TraceNamespaceSymbol parent) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            DBTraceNamespaceSymbol dbnsParent = this.manager.assertIsMine(parent);
            for (AbstractDBTraceSymbol symbol : this.getIntersecting((Range<Long>)Range.closed((Comparable)Long.valueOf(snap), (Comparable)Long.valueOf(snap)), thread, (AddressRange)new AddressRangeImpl(address, address), false, true)) {
                if (symbol.parentID != dbnsParent.getID() || !name.equals(symbol.name)) continue;
                AbstractDBTraceSymbol abstractDBTraceSymbol = symbol;
                return (T)abstractDBTraceSymbol;
            }
            Iterator<T> iterator = null;
            return (T)iterator;
        }
    }

    public Collection<? extends T> getAt(long snap, TraceThread thread, Address address, boolean includeDynamicSymbols) {
        try (LockHold hold = this.getManager().getTrace().lockRead();){
            Collection collection = (Collection)this.cacheForAt.getContaining(new GetSymbolsKey(thread, snap, address, includeDynamicSymbols));
            return collection;
        }
    }

    public Collection<? extends T> getIntersecting(Range<Long> span, TraceThread thread, AddressRange range, boolean includeDynamicSymbols) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            DBTraceThread dbThread = thread == null ? null : this.manager.trace.getThreadManager().assertIsMine(thread);
            this.manager.assertValidThreadAddress(dbThread, range.getMinAddress());
            DBTraceAddressSnapRangePropertyMapSpace space = (DBTraceAddressSnapRangePropertyMapSpace)this.manager.idMap.get(DBTraceSpaceKey.create(range.getAddressSpace(), dbThread, 0), false);
            if (space == null) {
                List list = Collections.emptyList();
                return list;
            }
            Collection sids = space.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).values();
            Collection matchingTid = Collections2.filter((Collection)sids, s -> DBTraceSymbolManager.unpackTypeID(s) == this.typeID);
            Collection collection = Collections2.transform((Collection)matchingTid, s -> (AbstractDBTraceSymbol)this.store.getObjectAt(DBTraceSymbolManager.unpackKey(s)));
            return collection;
        }
    }

    public Collection<? extends T> getIntersecting(Range<Long> span, TraceThread thread, AddressRange range, boolean includeDynamicSymbols, boolean forward) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            DBTraceThread dbThread = thread == null ? null : this.manager.trace.getThreadManager().assertIsMine(thread);
            this.manager.assertValidThreadAddress(dbThread, range.getMinAddress());
            DBTraceAddressSnapRangePropertyMapSpace space = (DBTraceAddressSnapRangePropertyMapSpace)this.manager.idMap.get(DBTraceSpaceKey.create(range.getAddressSpace(), dbThread, 0), false);
            if (space == null) {
                List list = Collections.emptyList();
                return list;
            }
            Collection sids = space.reduce((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span).starting(forward ? Rectangle2DDirection.LEFTMOST : Rectangle2DDirection.RIGHTMOST)).orderedValues();
            Collection matchingTid = Collections2.filter((Collection)sids, s -> DBTraceSymbolManager.unpackTypeID(s) == this.typeID);
            Collection collection = Collections2.transform((Collection)matchingTid, s -> (AbstractDBTraceSymbol)this.store.getObjectAt(DBTraceSymbolManager.unpackKey(s)));
            return collection;
        }
    }

    @Override
    public void invalidateCache() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            super.invalidateCache();
            this.cacheForAt.invalidate();
        }
    }

    protected class CacheForGetSymbolsAtQueries
    extends DBTraceCacheForContainingQueries<GetSymbolsKey, Collection<? extends T>, T> {
        public CacheForGetSymbolsAtQueries() {
            super(2, 30, 1000);
        }

        @Override
        protected void loadRangeCache(TraceAddressSnapRange range) {
            Object[] entries;
            this.rangeCache.clear();
            DBTraceSpaceBased idSpace = AbstractDBTraceSymbolSingleTypeWithLocationView.this.manager.idMap.getForSpace(range.getRange().getAddressSpace(), false);
            if (idSpace == null) {
                return;
            }
            for (Object obj : entries = ((DBTraceAddressSnapRangePropertyMapSpace)idSpace).reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range)).entries().toArray()) {
                Map.Entry ent = (Map.Entry)obj;
                long id = (Long)ent.getValue();
                if (DBTraceSymbolManager.unpackTypeID(id) != AbstractDBTraceSymbolSingleTypeWithLocationView.this.typeID) continue;
                this.rangeCache.add(new ImmutablePair((Object)((TraceAddressSnapRange)ent.getKey()), (Object)((AbstractDBTraceSymbol)AbstractDBTraceSymbolSingleTypeWithLocationView.this.store.getObjectAt(DBTraceSymbolManager.unpackKey(id)))));
            }
            this.rangeCache.sort(Comparator.comparing(Map.Entry::getValue, TraceSymbolManager.PRIMALITY_COMPARATOR));
        }

        @Override
        protected Collection<? extends T> doGetContaining(GetSymbolsKey key) {
            if (key.thread != null) {
                ArrayList result = new ArrayList(AbstractDBTraceSymbolSingleTypeWithLocationView.this.getIntersecting((Range<Long>)Range.singleton((Comparable)Long.valueOf(key.snap)), key.thread, (AddressRange)new AddressRangeImpl(key.addr, key.addr), key.includeDynamic, true));
                result.sort(TraceSymbolManager.PRIMALITY_COMPARATOR);
                return result;
            }
            this.ensureInCachedRange(key.snap, key.addr);
            return this.getAllInRangeCacheContaining(key);
        }
    }

    protected static class GetSymbolsKey
    extends DBTraceCacheForContainingQueries.GetKey {
        public final TraceThread thread;
        protected final boolean includeDynamic;

        public GetSymbolsKey(TraceThread thread, long snap, Address addr, boolean includeDynamic) {
            super(snap, addr);
            this.thread = thread;
            this.includeDynamic = includeDynamic;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof GetSymbolsKey)) {
                return false;
            }
            GetSymbolsKey that = (GetSymbolsKey)obj;
            if (this.includeDynamic != that.includeDynamic) {
                return false;
            }
            if (this.thread != that.thread) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result *= 31;
            result += System.identityHashCode(this.thread);
            result *= 31;
            return result += Boolean.hashCode(this.includeDynamic);
        }
    }
}

