/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.memory.TraceMemoryRegisterSpace;
import ghidra.trace.model.memory.TraceMemoryState;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.ArrayUtils;

public enum TraceRegisterUtils {


    public static AddressRange rangeForRegister(Register register) {
        Address address = register.getAddress();
        return new AddressRangeImpl(address, address.add((long)(register.getNumBytes() - 1)));
    }

    public static byte[] padOrTruncate(byte[] arr, int length) {
        if (arr.length == length) {
            return arr;
        }
        if (arr.length < length) {
            byte[] dup = new byte[length];
            System.arraycopy(arr, 0, dup, length - arr.length, arr.length);
            return dup;
        }
        return Arrays.copyOfRange(arr, arr.length - length, arr.length);
    }

    public static ByteBuffer bufferForValue(Register reg, RegisterValue value) {
        byte[] bytes = (byte[])value.toBytes().clone();
        int start = bytes.length / 2;
        if (!reg.isBigEndian() && !reg.isProcessorContext()) {
            ArrayUtils.reverse((byte[])bytes, (int)start, (int)bytes.length);
        }
        int offset = TraceRegisterUtils.computeMaskOffset(reg);
        return ByteBuffer.wrap(bytes, start + offset, reg.getNumBytes());
    }

    public static int computeMaskOffset(Register reg) {
        if (reg.isBaseRegister()) {
            return 0;
        }
        return reg.getOffset() - reg.getBaseRegister().getOffset();
    }

    public static int computeMaskOffset(RegisterValue value) {
        return TraceRegisterUtils.computeMaskOffset(value.getRegister());
    }

    public static TraceData seekComponent(TraceData data, AddressRange range) {
        if (data == null) {
            return null;
        }
        DataType type = data.getDataType();
        if (!(type instanceof Structure)) {
            return null;
        }
        int offset = (int)range.getMinAddress().subtract(data.getMinAddress());
        TraceData component = data.getComponentAt(offset);
        if (component == null) {
            return null;
        }
        int cmpMax = range.getMaxAddress().compareTo((Object)component.getMaxAddress());
        if (cmpMax > 0) {
            return null;
        }
        if (cmpMax == 0 && component.getMinAddress().equals((Object)range.getMinAddress())) {
            return component;
        }
        return TraceRegisterUtils.seekComponent(component, range);
    }

    public static TraceData seekComponent(TraceData data, Register reg) {
        return TraceRegisterUtils.seekComponent(data, TraceRegisterUtils.rangeForRegister(reg));
    }

    public static Object getValueHackPointer(TraceData data) {
        if (data.getValueClass() != Address.class) {
            return data.getValue();
        }
        if (!data.getAddress().getAddressSpace().isRegisterSpace()) {
            return data.getValue();
        }
        return PointerDataType.getAddressValue((MemBuffer)data, (int)data.getLength(), (AddressSpace)data.getTrace().getBaseAddressFactory().getDefaultAddressSpace());
    }

    public static String getValueRepresentationHackPointer(TraceData data) {
        if (data.getValueClass() != Address.class) {
            return data.getDefaultValueRepresentation();
        }
        Address addr = (Address)TraceRegisterUtils.getValueHackPointer(data);
        if (addr == null) {
            return "NaP";
        }
        return addr.toString();
    }

    public static RegisterValue combineWithTraceBaseRegisterValue(RegisterValue rv, long snap, TraceMemoryRegisterSpace regs, boolean requireKnown) {
        Register reg = rv.getRegister();
        if (reg.isBaseRegister()) {
            return rv;
        }
        if (regs == null) {
            if (requireKnown) {
                throw new IllegalStateException("Must fetch base register before setting a child");
            }
            return rv.getBaseRegisterValue();
        }
        if (requireKnown && TraceMemoryState.KNOWN != regs.getState(snap, reg.getBaseRegister())) {
            throw new IllegalStateException("Must fetch base register before setting a child");
        }
        return regs.getValue(snap, reg.getBaseRegister()).combineValues(rv);
    }

    public static RegisterValue getRegisterValue(Register reg, BiConsumer<Address, ByteBuffer> readAction) {
        int byteLength = reg.getNumBytes();
        byte[] mask = reg.getBaseMask();
        ByteBuffer buf = ByteBuffer.allocate(mask.length * 2);
        buf.put(mask);
        int maskOffset = TraceRegisterUtils.computeMaskOffset(reg);
        int startVal = buf.position() + maskOffset;
        buf.position(startVal);
        buf.limit(buf.position() + byteLength);
        readAction.accept(reg.getAddress(), buf);
        byte[] arr = buf.array();
        if (!reg.isBigEndian() && !reg.isProcessorContext()) {
            ArrayUtils.reverse((byte[])arr, (int)mask.length, (int)buf.capacity());
        }
        return new RegisterValue(reg, arr);
    }

    public static boolean isByteBound(Register register) {
        return register.getLeastSignificantBit() % 8 == 0 && register.getBitLength() % 8 == 0;
    }

    public static void requireByteBound(Register register) {
        if (!TraceRegisterUtils.isByteBound(register)) {
            throw new IllegalArgumentException("Cannot work with sub-byte registers. Consider a parent, instead.");
        }
    }
}

