/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ArtMethod
implements StructConverter {
    private final int pointerSize;
    private final String artVersion;
    private int declaring_class_;
    private int access_flags_;
    private int dex_code_item_offset_;
    private int dex_method_index_;
    private short method_index_;
    private short hotness_count_;
    private short imt_index_;
    private short padding_;
    private long dex_cache_resolved_methods_;
    private long dex_cache_resolved_types_;
    private long entry_point_from_interpreter_;
    private long entry_point_from_jni_;
    private long data_;
    private long unknown1_;
    private long entry_point_from_quick_compiled_code_;
    private int unknown2_;

    public ArtMethod(BinaryReader reader, int pointerSize, String artVersion) throws IOException {
        this.pointerSize = pointerSize;
        this.artVersion = artVersion;
        if ("017".equals(artVersion)) {
            if (pointerSize == 4) {
                this.declaring_class_ = reader.readNextInt();
                this.dex_cache_resolved_methods_ = Integer.toUnsignedLong(reader.readNextInt());
                this.dex_cache_resolved_types_ = Integer.toUnsignedLong(reader.readNextInt());
                this.access_flags_ = reader.readNextInt();
                this.dex_code_item_offset_ = reader.readNextInt();
                this.dex_method_index_ = reader.readNextInt();
                this.method_index_ = reader.readNextShort();
                this.padding_ = reader.readNextShort();
                this.entry_point_from_interpreter_ = Integer.toUnsignedLong(reader.readNextInt());
                this.entry_point_from_jni_ = Integer.toUnsignedLong(reader.readNextInt());
                this.entry_point_from_quick_compiled_code_ = Integer.toUnsignedLong(reader.readNextInt());
            } else if (pointerSize == 8) {
                throw new IOException("Unsupported 64-bit ART method format: " + artVersion);
            }
        } else if ("029".equals(artVersion) || "030".equals(artVersion)) {
            if (pointerSize == 4) {
                this.declaring_class_ = reader.readNextInt();
                this.access_flags_ = reader.readNextInt();
                this.dex_code_item_offset_ = reader.readNextInt();
                this.dex_method_index_ = reader.readNextInt();
                this.method_index_ = reader.readNextShort();
                this.hotness_count_ = reader.readNextShort();
                this.dex_cache_resolved_methods_ = Integer.toUnsignedLong(reader.readNextInt());
                this.dex_cache_resolved_types_ = Integer.toUnsignedLong(reader.readNextInt());
                this.entry_point_from_jni_ = Integer.toUnsignedLong(reader.readNextInt());
                this.entry_point_from_quick_compiled_code_ = Integer.toUnsignedLong(reader.readNextInt());
            } else if (pointerSize == 8) {
                this.declaring_class_ = reader.readNextInt();
                this.access_flags_ = reader.readNextInt();
                this.dex_code_item_offset_ = reader.readNextInt();
                this.dex_method_index_ = reader.readNextInt();
                this.method_index_ = reader.readNextShort();
                this.hotness_count_ = reader.readNextShort();
                this.imt_index_ = reader.readNextShort();
                this.padding_ = reader.readNextShort();
                this.dex_cache_resolved_methods_ = reader.readNextLong();
                this.dex_cache_resolved_types_ = reader.readNextLong();
                this.entry_point_from_jni_ = reader.readNextLong();
                this.entry_point_from_quick_compiled_code_ = reader.readNextLong();
            }
        } else if ("043".equals(artVersion) || "044".equals(artVersion) || "046".equals(artVersion)) {
            if (pointerSize == 4) {
                this.declaring_class_ = reader.readNextInt();
                this.access_flags_ = reader.readNextInt();
                this.dex_code_item_offset_ = reader.readNextInt();
                this.dex_method_index_ = reader.readNextInt();
                this.method_index_ = reader.readNextShort();
                this.hotness_count_ = reader.readNextShort();
                this.data_ = reader.readNextLong();
                this.entry_point_from_quick_compiled_code_ = Integer.toUnsignedLong(reader.readNextInt());
            } else if (pointerSize == 8) {
                this.declaring_class_ = reader.readNextInt();
                this.access_flags_ = reader.readNextInt();
                this.dex_code_item_offset_ = reader.readNextInt();
                this.dex_method_index_ = reader.readNextInt();
                this.method_index_ = reader.readNextShort();
                this.hotness_count_ = reader.readNextShort();
                this.imt_index_ = reader.readNextShort();
                this.padding_ = reader.readNextShort();
                this.data_ = reader.readNextLong();
                this.unknown1_ = reader.readNextLong();
                this.entry_point_from_quick_compiled_code_ = reader.readNextLong();
            }
        } else if ("056".equals(artVersion)) {
            this.declaring_class_ = reader.readNextInt();
            this.access_flags_ = reader.readNextInt();
            this.dex_code_item_offset_ = reader.readNextInt();
            this.dex_method_index_ = reader.readNextInt();
            this.method_index_ = reader.readNextShort();
            this.hotness_count_ = reader.readNextShort();
            this.imt_index_ = reader.readNextShort();
            this.padding_ = reader.readNextShort();
            if (pointerSize == 4) {
                this.data_ = Integer.toUnsignedLong(reader.readNextInt());
            } else if (pointerSize == 8) {
                this.data_ = reader.readNextLong();
                this.entry_point_from_quick_compiled_code_ = reader.readNextLong();
            }
        } else if ("074".equals(artVersion)) {
            this.declaring_class_ = reader.readNextInt();
            this.access_flags_ = reader.readNextInt();
            this.dex_code_item_offset_ = reader.readNextInt();
            this.dex_method_index_ = reader.readNextInt();
            this.method_index_ = reader.readNextShort();
            this.hotness_count_ = reader.readNextShort();
            this.imt_index_ = reader.readNextShort();
            this.padding_ = reader.readNextShort();
            if (pointerSize == 4) {
                this.data_ = Integer.toUnsignedLong(reader.readNextInt());
            } else if (pointerSize == 8) {
                this.data_ = reader.readNextLong();
                this.entry_point_from_quick_compiled_code_ = reader.readNextLong();
            }
        } else if ("085".equals(artVersion)) {
            this.declaring_class_ = reader.readNextInt();
            this.access_flags_ = reader.readNextInt();
            this.dex_code_item_offset_ = reader.readNextInt();
            this.dex_method_index_ = reader.readNextInt();
            this.method_index_ = reader.readNextShort();
            this.hotness_count_ = reader.readNextShort();
            this.imt_index_ = reader.readNextShort();
            this.padding_ = reader.readNextShort();
            if (pointerSize == 4) {
                this.data_ = Integer.toUnsignedLong(reader.readNextInt());
            } else if (pointerSize == 8) {
                this.data_ = reader.readNextLong();
                this.entry_point_from_quick_compiled_code_ = reader.readNextLong();
            }
        } else {
            throw new IOException("Unsupported ART method format: " + artVersion);
        }
    }

    public int getDeclaringClass() {
        return this.declaring_class_;
    }

    public int getAccessFlags() {
        return this.access_flags_;
    }

    public int getDexCodeItemOffset() {
        return this.dex_code_item_offset_;
    }

    public int getDexMethodIndex() {
        return this.dex_method_index_;
    }

    public short getMethodIndex() {
        return this.method_index_;
    }

    public short getHotnessCount() {
        return this.hotness_count_;
    }

    public short getImtIndex() {
        return this.imt_index_;
    }

    public short getPadding() {
        return this.padding_;
    }

    public long getData() {
        return this.data_;
    }

    public long getEntryPointFromInterpreter() {
        return this.entry_point_from_interpreter_;
    }

    public long getEntryPointFromQuickCompiledCode() {
        return this.entry_point_from_quick_compiled_code_;
    }

    public long getDexCacheResolvedMethods() {
        return this.dex_cache_resolved_methods_;
    }

    public long getDexCacheResolvedTypes() {
        return this.dex_cache_resolved_types_;
    }

    public long getEntryPointFromJNI() {
        return this.entry_point_from_jni_;
    }

    public long getUnknown1() {
        return this.unknown1_;
    }

    public int getUnknown2() {
        return this.unknown2_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        Pointer32DataType ptr32 = new Pointer32DataType();
        Pointer64DataType ptr64 = new Pointer64DataType();
        StructureDataType struct = new StructureDataType(ArtMethod.class.getSimpleName(), 0);
        struct.setCategoryPath(new CategoryPath("/art"));
        if ("017".equals(this.artVersion)) {
            if (this.pointerSize == 4) {
                struct.add(DWORD, "declaring_class_", null);
                struct.add(DWORD, "dex_cache_resolved_methods_", null);
                struct.add(DWORD, "dex_cache_resolved_types_", null);
                struct.add(DWORD, "access_flags_", null);
                struct.add(DWORD, "dex_code_item_offset_", null);
                struct.add(DWORD, "dex_method_index_", null);
                struct.add(WORD, "method_index_", null);
                struct.add(WORD, "padding_", null);
                struct.add(DWORD, "entry_point_from_interpreter_", null);
                struct.add(DWORD, "entry_point_from_jni_", null);
                struct.add(DWORD, "entry_point_from_quick_compiled_code_", null);
            } else if (this.pointerSize == 8) {
                throw new IOException("Unsupported 64-bit ART method format: " + this.artVersion);
            }
        } else if ("029".equals(this.artVersion) || "030".equals(this.artVersion)) {
            if (this.pointerSize == 4) {
                struct.add((DataType)ptr32, "declaring_class_", null);
                struct.add(DWORD, "access_flags_", null);
                struct.add(DWORD, "dex_code_item_offset_", null);
                struct.add(DWORD, "dex_method_index_", null);
                struct.add(WORD, "method_index_", null);
                struct.add(WORD, "hotness_count_", null);
                struct.add(DWORD, "dex_cache_resolved_methods_", null);
                struct.add(DWORD, "dex_cache_resolved_types_", null);
                struct.add((DataType)ptr32, "entry_point_from_jni_", null);
                struct.add((DataType)ptr32, "entry_point_from_quick_compiled_code_", null);
            } else if (this.pointerSize == 8) {
                struct.add((DataType)ptr32, "declaring_class_", null);
                struct.add(DWORD, "access_flags_", null);
                struct.add(DWORD, "dex_code_item_offset_", null);
                struct.add(DWORD, "dex_method_index_", null);
                struct.add(WORD, "method_index_", null);
                struct.add(WORD, "hotness_count_", null);
                struct.add(WORD, "imt_index_", null);
                struct.add(WORD, "padding", null);
                struct.add(QWORD, "dex_cache_resolved_methods_", null);
                struct.add(QWORD, "dex_cache_resolved_types_", null);
                struct.add((DataType)ptr64, "entry_point_from_jni_", null);
                struct.add((DataType)ptr64, "entry_point_from_quick_compiled_code_", null);
            }
        } else if ("043".equals(this.artVersion) || "044".equals(this.artVersion) || "046".equals(this.artVersion)) {
            if (this.pointerSize == 4) {
                struct.add((DataType)ptr32, "declaring_class_", null);
                struct.add(DWORD, "access_flags_", null);
                struct.add(DWORD, "dex_code_item_offset_", null);
                struct.add(DWORD, "dex_method_index_", null);
                struct.add(WORD, "method_index_", null);
                struct.add(WORD, "hotness_count_", null);
                struct.add(QWORD, "data", null);
                struct.add((DataType)ptr32, "entry_point_from_quick_compiled_code_", null);
            } else if (this.pointerSize == 8) {
                struct.add((DataType)ptr32, "declaring_class_", null);
                struct.add(DWORD, "access_flags_", null);
                struct.add(DWORD, "dex_code_item_offset_", null);
                struct.add(DWORD, "dex_method_index_", null);
                struct.add(WORD, "method_index_", null);
                struct.add(WORD, "hotness_count_", null);
                struct.add(WORD, "imt_index_", null);
                struct.add(WORD, "padding", null);
                struct.add(QWORD, "data", null);
                struct.add(QWORD, "unknown1_", null);
                struct.add((DataType)ptr64, "entry_point_from_quick_compiled_code_", null);
            }
        } else if ("056".equals(this.artVersion)) {
            struct.add((DataType)ptr32, "declaring_class_", null);
            struct.add(DWORD, "access_flags_", null);
            struct.add(DWORD, "dex_code_item_offset_", null);
            struct.add(DWORD, "dex_method_index_", null);
            struct.add(WORD, "method_index_", null);
            struct.add(WORD, "hotness_count_", null);
            struct.add(WORD, "imt_index_", null);
            struct.add(WORD, "padding", null);
            if (this.pointerSize == 4) {
                struct.add(DWORD, "data", null);
            } else if (this.pointerSize == 8) {
                struct.add(QWORD, "data", null);
                struct.add(QWORD, "entry_point_from_quick_compiled_code_", null);
            }
        } else if ("074".equals(this.artVersion)) {
            struct.add((DataType)ptr32, "declaring_class_", null);
            struct.add(DWORD, "access_flags_", null);
            struct.add(DWORD, "dex_code_item_offset_", null);
            struct.add(DWORD, "dex_method_index_", null);
            struct.add(WORD, "method_index_", null);
            struct.add(WORD, "hotness_count_", null);
            struct.add(WORD, "imt_index_", null);
            struct.add(WORD, "padding", null);
            if (this.pointerSize == 4) {
                struct.add(DWORD, "data", null);
            } else if (this.pointerSize == 8) {
                struct.add(QWORD, "data", null);
                struct.add((DataType)ptr64, "entry_point_from_quick_compiled_code_", null);
            }
        } else if ("085".equals(this.artVersion)) {
            struct.add((DataType)ptr32, "declaring_class_", null);
            struct.add(DWORD, "access_flags_", null);
            struct.add(DWORD, "dex_code_item_offset_", null);
            struct.add(DWORD, "dex_method_index_", null);
            struct.add(WORD, "method_index_", null);
            struct.add(WORD, "hotness_count_", null);
            struct.add(WORD, "imt_index_", null);
            struct.add(WORD, "padding", null);
            if (this.pointerSize == 4) {
                struct.add(DWORD, "data", null);
            } else if (this.pointerSize == 8) {
                struct.add(QWORD, "data", null);
                struct.add(QWORD, "entry_point_from_quick_compiled_code_", null);
            }
        } else {
            throw new IOException("Unsupported ART method format: " + this.artVersion);
        }
        return struct;
    }
}

