/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.android.bootimg.BootImageHeader;
import ghidra.file.formats.android.bootimg.BootImageHeaderFactory;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@FileSystemInfo(type="androidbootimg", description="Android Boot and Recovery Images", factory=GFileSystemBaseFactory.class)
public class BootImageFileSystem
extends GFileSystemBase {
    private BootImageHeader header;
    private GFileImpl kernelFile;
    private GFileImpl ramdiskFile;
    private GFileImpl secondStageFile;
    private List<GFileImpl> fileList = new ArrayList<GFileImpl>();

    public BootImageFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, 8L);
        return Arrays.equals(bytes, "ANDROID!".getBytes());
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        this.header = BootImageHeaderFactory.getBootImageHeader(this.provider, true);
        if (!this.header.getMagic().equals("ANDROID!")) {
            throw new IOException("Invalid Android boot image file!");
        }
        if (this.header.getKernelSize() > 0) {
            this.kernelFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"kernel", (boolean)false, (long)this.header.getKernelSize(), null);
            this.fileList.add(this.kernelFile);
        }
        if (this.header.getRamdiskSize() > 0) {
            this.ramdiskFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"ramdisk", (boolean)false, (long)this.header.getRamdiskSize(), null);
            this.fileList.add(this.ramdiskFile);
        }
        if (this.header.getSecondSize() > 0) {
            this.secondStageFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"second stage", (boolean)false, (long)this.header.getSecondSize(), null);
            this.fileList.add(this.secondStageFile);
        }
    }

    public void close() throws IOException {
        this.kernelFile = null;
        this.ramdiskFile = null;
        this.secondStageFile = null;
        this.header = null;
        super.close();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return directory == null || directory.equals(this.root) ? new ArrayList<GFileImpl>(this.fileList) : Collections.emptyList();
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        if (file == this.kernelFile) {
            return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.COMMENT_ATTR, (Object)"This is the actual KERNEL for the android device. You can analyze this file.")});
        }
        if (file == this.ramdiskFile) {
            return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.COMMENT_ATTR, (Object)"This is a ramdisk, it is a GZIP file containing a CPIO archive.")});
        }
        if (file == this.secondStageFile) {
            return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.COMMENT_ATTR, (Object)"This is a second stage loader file. It appears unused at this time.")});
        }
        return null;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        long size;
        long offset;
        if (file == this.kernelFile) {
            offset = this.header.getKernelOffset();
            size = this.header.getKernelSize();
        } else if (file == this.ramdiskFile) {
            offset = this.header.getRamdiskOffset();
            size = this.header.getRamdiskSize();
        } else if (file == this.secondStageFile) {
            offset = this.header.getSecondOffset();
            size = this.header.getSecondSize();
        } else {
            return null;
        }
        return new ByteProviderWrapper(this.provider, offset, size, file.getFSRL());
    }
}

