/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.bootimg.VendorBootImageHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class VendorBootImageHeaderV3
extends VendorBootImageHeader {
    private String magic;
    private int header_version;
    private int page_size;
    private int kernel_addr;
    private int ramdisk_addr;
    private int vendor_ramdisk_size;
    private String cmdline;
    private int tags_addr;
    private String name;
    private int header_size;
    private int dtb_size;
    private long dtb_addr;

    public VendorBootImageHeaderV3(BinaryReader reader) throws IOException {
        this.magic = reader.readNextAsciiString(8);
        this.header_version = reader.readNextInt();
        this.page_size = reader.readNextInt();
        this.kernel_addr = reader.readNextInt();
        this.ramdisk_addr = reader.readNextInt();
        this.vendor_ramdisk_size = reader.readNextInt();
        this.cmdline = reader.readNextAsciiString(2048);
        this.tags_addr = reader.readNextInt();
        this.name = reader.readNextAsciiString(16);
        this.header_size = reader.readNextInt();
        this.dtb_size = reader.readNextInt();
        this.dtb_addr = reader.readNextLong();
    }

    @Override
    public String getMagic() {
        return this.magic;
    }

    public int getHeaderVersion() {
        return this.header_version;
    }

    public int getPageSize() {
        return this.page_size;
    }

    public int getKernelAddress() {
        return this.kernel_addr;
    }

    public int getRamdiskAddress() {
        return this.ramdisk_addr;
    }

    @Override
    public int getVendorRamdiskSize() {
        return this.vendor_ramdisk_size;
    }

    @Override
    public long getVendorRamdiskOffset() {
        return this.page_size;
    }

    public String getCmdline() {
        return this.cmdline;
    }

    public int getTagsAddress() {
        return this.tags_addr;
    }

    public String getName() {
        return this.name;
    }

    public int getHeaderSize() {
        return this.header_size;
    }

    @Override
    public int getDtbSize() {
        return this.dtb_size;
    }

    public long getDtbAddress() {
        return this.dtb_addr;
    }

    @Override
    public long getDtbOffset() {
        int o = (2112 + this.page_size - 1) / this.page_size;
        int p = (this.vendor_ramdisk_size + this.page_size - 1) / this.page_size;
        return (o + p) * this.page_size;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("vendor_boot_img_hdr_v3", 0);
        structure.add(UTF8, 8, "magic", null);
        structure.add(DWORD, "header_version", null);
        structure.add(DWORD, "page_size", null);
        structure.add(DWORD, "kernel_addr", null);
        structure.add(DWORD, "ramdisk_addr", null);
        structure.add(DWORD, "vendor_ramdisk_size", null);
        structure.add(UTF8, 2048, "cmdline", null);
        structure.add(DWORD, "tags_addr", null);
        structure.add(UTF8, 16, "name", null);
        structure.add(DWORD, "header_size", null);
        structure.add(DWORD, "dtb_size", null);
        structure.add(QWORD, "dtb_addr", null);
        return structure;
    }
}

