/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatclass;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.oat.UnsupportedOatVersionException;
import ghidra.file.formats.android.oat.oatclass.OatClass;
import ghidra.file.formats.android.oat.oatclass.OatClass_Android10;
import ghidra.file.formats.android.oat.oatclass.OatClass_Android11;
import ghidra.file.formats.android.oat.oatclass.OatClass_Android12;
import ghidra.file.formats.android.oat.oatclass.OatClass_KitKat;
import ghidra.file.formats.android.oat.oatclass.OatClass_Lollipop;
import ghidra.file.formats.android.oat.oatclass.OatClass_Marshmallow;
import ghidra.file.formats.android.oat.oatclass.OatClass_Nougat;
import ghidra.file.formats.android.oat.oatclass.OatClass_Oreo;
import ghidra.file.formats.android.oat.oatclass.OatClass_OreoM2;
import ghidra.file.formats.android.oat.oatclass.OatClass_Pie;
import java.io.IOException;

public class OatClassFactory {
    public static OatClass getOatClass(BinaryReader reader, ClassDataItem classDataItem, String oatVersion) throws IOException, UnsupportedOatVersionException {
        switch (oatVersion) {
            case "007": {
                return new OatClass_KitKat(reader, classDataItem, oatVersion);
            }
            case "039": 
            case "045": 
            case "051": {
                return new OatClass_Lollipop(reader, classDataItem, oatVersion);
            }
            case "064": {
                return new OatClass_Marshmallow(reader, classDataItem, oatVersion);
            }
            case "079": 
            case "088": {
                return new OatClass_Nougat(reader, classDataItem, oatVersion);
            }
            case "124": {
                return new OatClass_Oreo(reader, classDataItem, oatVersion);
            }
            case "131": {
                return new OatClass_OreoM2(reader, classDataItem, oatVersion);
            }
            case "138": {
                return new OatClass_Pie(reader, classDataItem, oatVersion);
            }
            case "170": {
                return new OatClass_Android10(reader, classDataItem, oatVersion);
            }
            case "183": {
                return new OatClass_Android11(reader, classDataItem, oatVersion);
            }
            case "195": {
                return new OatClass_Android12(reader, classDataItem, oatVersion);
            }
        }
        throw new UnsupportedOatVersionException("OatClass not supported for OAT Version: " + oatVersion);
    }
}

