/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.iso9660.ISO9660Constants;
import ghidra.file.formats.iso9660.ISO9660FileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;

public class ISO9660FileSystemFactory
implements GFileSystemFactoryByteProvider<ISO9660FileSystem>,
GFileSystemProbeByteProvider {
    private static final long[] SIGNATURE_PROBE_OFFSETS = new long[]{32768L, 34816L, 36864L};

    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        for (long probeOffset : SIGNATURE_PROBE_OFFSETS) {
            if (!this.isMagicSignatureAt(byteProvider, probeOffset + 1L)) continue;
            return true;
        }
        return false;
    }

    private boolean isMagicSignatureAt(ByteProvider provider, long offset) throws IOException {
        int magicLen = ISO9660Constants.MAGIC_BYTES.length;
        long providerLen = provider.length();
        return providerLen > offset + (long)magicLen && Arrays.equals(provider.readBytes(offset, (long)magicLen), ISO9660Constants.MAGIC_BYTES);
    }

    public ISO9660FileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        ISO9660FileSystem fs = new ISO9660FileSystem(targetFSRL, fsService);
        try {
            fs.mount(byteProvider, monitor);
            return fs;
        }
        catch (IOException ioe) {
            fs.close();
            throw ioe;
        }
    }
}

