/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.actions.AutoVersionTrackingTask;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import javax.swing.Icon;
import resources.ResourceManager;

public class AutoVersionTrackingAction
extends DockingAction {
    public static Icon AUTO_VT_ICON = ResourceManager.loadImage((String)"images/wizard.png");
    private final VTController controller;

    public AutoVersionTrackingAction(VTController controller) {
        super("Automatic Version Tracking", VTPlugin.OWNER);
        this.controller = controller;
        String[] menuPath = new String[]{"&File", "Automatic Version Tracking"};
        this.setMenuBarData(new MenuData(menuPath, AUTO_VT_ICON, "AAA"));
        this.setToolBarData(new ToolBarData(AUTO_VT_ICON, "View"));
        this.setDescription(HTMLUtilities.toWrappedHTML((String)"Runs several correlators and applies good matches.\n(For more details see the help page.)"));
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Automatic_Version_Tracking"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        VTSession session = this.controller.getSession();
        return session != null;
    }

    public void actionPerformed(ActionContext context) {
        VTSession session = this.controller.getSession();
        AutoVersionTrackingTask task = new AutoVersionTrackingTask(this.controller, session, 0.95, 10.0);
        TaskLauncher.launch((Task)task);
    }
}

