/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.gadp.client.DelegateGadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpValueUtils;
import ghidra.dbg.gadp.client.annot.GadpEventHandler;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.memory.MemoryReader;
import ghidra.dbg.memory.MemoryWriter;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.concurrent.CompletableFuture;

public interface GadpClientTargetMemory
extends GadpClientTargetObject,
TargetMemory {
    @Internal
    default public MemoryReader getRawReader(AddressSpace space) {
        return (addr, length) -> this.rawReadMemory(space, addr, length);
    }

    @Internal
    default public CompletableFuture<byte[]> rawReadMemory(AddressSpace space, long addr, int length) {
        AddressRangeImpl range;
        this.getDelegate().assertValid();
        Address min = space.getAddress(addr);
        try {
            range = new AddressRangeImpl(min, (long)length);
        }
        catch (AddressOverflowException e) {
            throw new IllegalArgumentException("addr=" + addr + ",len=" + length);
        }
        return this.getModel().sendChecked((Message.Builder)Gadp.MemoryReadRequest.newBuilder().setPath(GadpValueUtils.makePath(this.getPath())).setRange(GadpValueUtils.makeRange((AddressRange)range)), Gadp.MemoryReadReply.getDefaultInstance()).thenApply(rep -> rep.getContent().toByteArray());
    }

    default public CompletableFuture<byte[]> readMemory(Address address, int length) {
        return this.getDelegate().getMemoryCache(address.getAddressSpace()).readMemory(address.getOffset(), length);
    }

    @Internal
    default public MemoryWriter getRawWriter(AddressSpace space) {
        return (addr, data) -> this.rawWriteMemory(space, addr, data);
    }

    @Internal
    default public CompletableFuture<Void> rawWriteMemory(AddressSpace space, long addr, byte[] data) {
        this.getDelegate().assertValid();
        Address min = space.getAddress(addr);
        return this.getModel().sendChecked((Message.Builder)Gadp.MemoryWriteRequest.newBuilder().setPath(GadpValueUtils.makePath(this.getPath())).setStart(GadpValueUtils.makeAddress(min)).setContent(ByteString.copyFrom((byte[])data)), Gadp.MemoryWriteReply.getDefaultInstance()).thenApply(rep -> null);
    }

    default public CompletableFuture<Void> writeMemory(Address address, byte[] data) {
        return this.getDelegate().getMemoryCache(address.getAddressSpace()).writeMemory(address.getOffset(), data);
    }

    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.MEMORY_UPDATE_EVENT)
    default public void handleMemoryUpdateEvent(Gadp.EventNotification notification) {
        Gadp.MemoryUpdateEvent evt = notification.getMemoryUpdateEvent();
        Address address = GadpValueUtils.getAddress((DebuggerObjectModel)this.getModel(), evt.getAddress());
        byte[] data = evt.getContent().toByteArray();
        DelegateGadpClientTargetObject delegate = this.getDelegate();
        delegate.getMemoryCache(address.getAddressSpace()).updateMemory(address.getOffset(), data);
        ((DebuggerModelListener)delegate.getListeners().fire).memoryUpdated((TargetObject)this, address, data);
    }

    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.MEMORY_ERROR_EVENT)
    default public void handleMemoryErrorEvent(Gadp.EventNotification notification) {
        Gadp.MemoryErrorEvent evt = notification.getMemoryErrorEvent();
        AddressRange range = GadpValueUtils.getAddressRange((DebuggerObjectModel)this.getModel(), evt.getRange());
        String message = evt.getMessage();
        ((DebuggerModelListener)this.getDelegate().getListeners().fire).memoryReadError((TargetObject)this, range, new DebuggerMemoryAccessException(message));
    }
}

