/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.configuration;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import ua.nanit.limbo.configuration.SocketAddressSerializer;
import ua.nanit.limbo.server.data.BossBar;
import ua.nanit.limbo.server.data.InfoForwarding;
import ua.nanit.limbo.server.data.PingData;
import ua.nanit.limbo.server.data.Title;
import ua.nanit.limbo.util.Colors;

public final class LimboConfig {
    private final Path root;
    private SocketAddress address;
    private int maxPlayers;
    private PingData pingData;
    private String dimensionType;
    private int gameMode;
    private boolean useBrandName;
    private boolean useJoinMessage;
    private boolean useBossBar;
    private boolean useTitle;
    private boolean usePlayerList;
    private boolean useHeaderAndFooter;
    private String brandName;
    private String joinMessage;
    private BossBar bossBar;
    private Title title;
    private String playerListUsername;
    private String playerListHeader;
    private String playerListFooter;
    private InfoForwarding infoForwarding;
    private long readTimeout;
    private int debugLevel;
    private boolean useEpoll;
    private int bossGroupSize;
    private int workerGroupSize;
    private boolean useTrafficLimits;
    private int maxPacketSize;
    private double interval;
    private double maxPacketRate;

    public LimboConfig(Path root) {
        this.root = root;
    }

    public void load() throws Exception {
        ConfigurationOptions options = ConfigurationOptions.defaults().serializers(this.getSerializers());
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().source(this::getReader)).defaultOptions(options)).build();
        Object conf = loader.load();
        this.address = conf.node("bind").get(SocketAddress.class);
        this.maxPlayers = conf.node("maxPlayers").getInt();
        this.pingData = conf.node("ping").get(PingData.class);
        this.dimensionType = conf.node("dimension").getString("the_end");
        if (this.dimensionType.equalsIgnoreCase("nether")) {
            this.dimensionType = "the_nether";
        }
        if (this.dimensionType.equalsIgnoreCase("end")) {
            this.dimensionType = "the_end";
        }
        this.gameMode = conf.node("gameMode").getInt();
        this.useBrandName = conf.node("brandName", "enable").getBoolean();
        this.useJoinMessage = conf.node("joinMessage", "enable").getBoolean();
        this.useBossBar = conf.node("bossBar", "enable").getBoolean();
        this.useTitle = conf.node("title", "enable").getBoolean();
        this.usePlayerList = conf.node("playerList", "enable").getBoolean();
        this.playerListUsername = conf.node("playerList", "username").getString();
        this.useHeaderAndFooter = conf.node("headerAndFooter", "enable").getBoolean();
        if (this.useBrandName) {
            this.brandName = conf.node("brandName", "content").getString();
        }
        if (this.useJoinMessage) {
            this.joinMessage = Colors.of(conf.node("joinMessage", "text").getString(""));
        }
        if (this.useBossBar) {
            this.bossBar = conf.node("bossBar").get(BossBar.class);
        }
        if (this.useTitle) {
            this.title = conf.node("title").get(Title.class);
        }
        if (this.useHeaderAndFooter) {
            this.playerListHeader = Colors.of(conf.node("headerAndFooter", "header").getString());
            this.playerListFooter = Colors.of(conf.node("headerAndFooter", "footer").getString());
        }
        this.infoForwarding = conf.node("infoForwarding").get(InfoForwarding.class);
        this.readTimeout = conf.node("readTimeout").getLong();
        this.debugLevel = conf.node("debugLevel").getInt();
        this.useEpoll = conf.node("netty", "useEpoll").getBoolean(true);
        this.bossGroupSize = conf.node("netty", "threads", "bossGroup").getInt(1);
        this.workerGroupSize = conf.node("netty", "threads", "workerGroup").getInt(4);
        this.useTrafficLimits = conf.node("traffic", "enable").getBoolean(false);
        this.maxPacketSize = conf.node("traffic", "maxPacketSize").getInt(-1);
        this.interval = conf.node("traffic", "interval").getDouble(-1.0);
        this.maxPacketRate = conf.node("traffic", "maxPacketRate").getDouble(-1.0);
    }

    private BufferedReader getReader() throws IOException {
        String name = "settings.yml";
        Path filePath = Paths.get(this.root.toString(), name);
        if (!Files.exists(filePath, new LinkOption[0])) {
            InputStream stream = this.getClass().getResourceAsStream("/" + name);
            if (stream == null) {
                throw new FileNotFoundException("Cannot find settings resource file");
            }
            Files.copy(stream, filePath, new CopyOption[0]);
        }
        return Files.newBufferedReader(filePath);
    }

    private TypeSerializerCollection getSerializers() {
        return TypeSerializerCollection.builder().register(SocketAddress.class, new SocketAddressSerializer()).register(InfoForwarding.class, new InfoForwarding.Serializer()).register(PingData.class, new PingData.Serializer()).register(BossBar.class, new BossBar.Serializer()).register(Title.class, new Title.Serializer()).build();
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public PingData getPingData() {
        return this.pingData;
    }

    public String getDimensionType() {
        return this.dimensionType;
    }

    public int getGameMode() {
        return this.gameMode;
    }

    public InfoForwarding getInfoForwarding() {
        return this.infoForwarding;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public boolean isUseBrandName() {
        return this.useBrandName;
    }

    public boolean isUseJoinMessage() {
        return this.useJoinMessage;
    }

    public boolean isUseBossBar() {
        return this.useBossBar;
    }

    public boolean isUseTitle() {
        return this.useTitle;
    }

    public boolean isUsePlayerList() {
        return this.usePlayerList;
    }

    public boolean isUseHeaderAndFooter() {
        return this.useHeaderAndFooter;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getJoinMessage() {
        return this.joinMessage;
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    public Title getTitle() {
        return this.title;
    }

    public String getPlayerListUsername() {
        return this.playerListUsername;
    }

    public String getPlayerListHeader() {
        return this.playerListHeader;
    }

    public String getPlayerListFooter() {
        return this.playerListFooter;
    }

    public boolean isUseEpoll() {
        return this.useEpoll;
    }

    public int getBossGroupSize() {
        return this.bossGroupSize;
    }

    public int getWorkerGroupSize() {
        return this.workerGroupSize;
    }

    public boolean isUseTrafficLimits() {
        return this.useTrafficLimits;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public double getInterval() {
        return this.interval;
    }

    public double getMaxPacketRate() {
        return this.maxPacketRate;
    }
}

