/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import ua.nanit.limbo.connection.ClientConnection;
import ua.nanit.limbo.connection.pipeline.ChannelTrafficHandler;
import ua.nanit.limbo.connection.pipeline.PacketDecoder;
import ua.nanit.limbo.connection.pipeline.PacketEncoder;
import ua.nanit.limbo.connection.pipeline.VarIntFrameDecoder;
import ua.nanit.limbo.connection.pipeline.VarIntLengthEncoder;
import ua.nanit.limbo.server.LimboServer;

public class ClientChannelInitializer
extends ChannelInitializer<Channel> {
    private final LimboServer server;

    public ClientChannelInitializer(LimboServer server) {
        this.server = server;
    }

    @Override
    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        PacketDecoder decoder = new PacketDecoder();
        PacketEncoder encoder = new PacketEncoder();
        ClientConnection connection = new ClientConnection(channel, this.server, decoder, encoder);
        pipeline.addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(this.server.getConfig().getReadTimeout(), TimeUnit.MILLISECONDS));
        pipeline.addLast("frame_decoder", (ChannelHandler)new VarIntFrameDecoder());
        pipeline.addLast("frame_encoder", (ChannelHandler)new VarIntLengthEncoder());
        if (this.server.getConfig().isUseTrafficLimits()) {
            pipeline.addLast("traffic_limit", (ChannelHandler)new ChannelTrafficHandler(this.server.getConfig().getMaxPacketSize(), this.server.getConfig().getInterval(), this.server.getConfig().getMaxPacketRate()));
        }
        pipeline.addLast("decoder", (ChannelHandler)decoder);
        pipeline.addLast("encoder", (ChannelHandler)encoder);
        pipeline.addLast("handler", (ChannelHandler)connection);
    }
}

