/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.connection;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.lang.invoke.StringConcatFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import ua.nanit.limbo.connection.GameProfile;
import ua.nanit.limbo.connection.PacketSnapshots;
import ua.nanit.limbo.connection.pipeline.PacketDecoder;
import ua.nanit.limbo.connection.pipeline.PacketEncoder;
import ua.nanit.limbo.protocol.ByteMessage;
import ua.nanit.limbo.protocol.Packet;
import ua.nanit.limbo.protocol.PacketSnapshot;
import ua.nanit.limbo.protocol.packets.login.PacketDisconnect;
import ua.nanit.limbo.protocol.packets.play.PacketKeepAlive;
import ua.nanit.limbo.protocol.registry.State;
import ua.nanit.limbo.protocol.registry.Version;
import ua.nanit.limbo.server.LimboServer;
import ua.nanit.limbo.server.Log;
import ua.nanit.limbo.util.UuidUtil;

public class ClientConnection
extends ChannelInboundHandlerAdapter {
    private final LimboServer server;
    private final Channel channel;
    private final GameProfile gameProfile;
    private final PacketDecoder decoder;
    private final PacketEncoder encoder;
    private State state;
    private Version clientVersion;
    private SocketAddress address;
    private int velocityLoginMessageId = -1;

    public ClientConnection(Channel channel, LimboServer server, PacketDecoder decoder, PacketEncoder encoder) {
        this.server = server;
        this.channel = channel;
        this.decoder = decoder;
        this.encoder = encoder;
        this.address = channel.remoteAddress();
        this.gameProfile = new GameProfile();
    }

    public UUID getUuid() {
        return this.gameProfile.getUuid();
    }

    public String getUsername() {
        return this.gameProfile.getUsername();
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public Version getClientVersion() {
        return this.clientVersion;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        if (this.state.equals((Object)State.PLAY) || this.state.equals((Object)State.CONFIGURATION)) {
            this.server.getConnections().removeConnection(this);
        }
        super.channelInactive(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.channel.isActive()) {
            Log.error((Object)"Unhandled exception: ", cause, new Object[0]);
        }
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        this.handlePacket(msg);
    }

    public void handlePacket(Object packet) {
        if (packet instanceof Packet) {
            ((Packet)packet).handle(this, this.server);
        }
    }

    public void fireLoginSuccess() {
        if (this.server.getConfig().getInfoForwarding().isModern() && this.velocityLoginMessageId == -1) {
            this.disconnectLogin("You need to connect with Velocity");
            return;
        }
        this.sendPacket(PacketSnapshots.PACKET_LOGIN_SUCCESS);
        this.server.getConnections().addConnection(this);
        if (this.clientVersion.moreOrEqual(Version.V1_20_2)) {
            this.updateEncoderState(State.CONFIGURATION);
            return;
        }
        this.spawnPlayer();
    }

    public void spawnPlayer() {
        this.updateState(State.PLAY);
        Runnable sendPlayPackets = () -> {
            this.writePacket(PacketSnapshots.PACKET_JOIN_GAME);
            this.writePacket(PacketSnapshots.PACKET_PLAYER_ABILITIES);
            if (this.clientVersion.less(Version.V1_9)) {
                this.writePacket(PacketSnapshots.PACKET_PLAYER_POS_AND_LOOK_LEGACY);
            } else {
                this.writePacket(PacketSnapshots.PACKET_PLAYER_POS_AND_LOOK);
            }
            if (this.clientVersion.moreOrEqual(Version.V1_19_3)) {
                this.writePacket(PacketSnapshots.PACKET_SPAWN_POSITION);
            }
            if (this.server.getConfig().isUsePlayerList() || this.clientVersion.equals((Object)Version.V1_16_4)) {
                this.writePacket(PacketSnapshots.PACKET_PLAYER_INFO);
            }
            if (this.clientVersion.moreOrEqual(Version.V1_13)) {
                this.writePacket(PacketSnapshots.PACKET_DECLARE_COMMANDS);
                if (PacketSnapshots.PACKET_PLUGIN_MESSAGE != null) {
                    this.writePacket(PacketSnapshots.PACKET_PLUGIN_MESSAGE);
                }
            }
            if (PacketSnapshots.PACKET_BOSS_BAR != null && this.clientVersion.moreOrEqual(Version.V1_9)) {
                this.writePacket(PacketSnapshots.PACKET_BOSS_BAR);
            }
            if (PacketSnapshots.PACKET_JOIN_MESSAGE != null) {
                this.writePacket(PacketSnapshots.PACKET_JOIN_MESSAGE);
            }
            if (PacketSnapshots.PACKET_TITLE_TITLE != null && this.clientVersion.moreOrEqual(Version.V1_8)) {
                this.writeTitle();
            }
            if (PacketSnapshots.PACKET_HEADER_AND_FOOTER != null && this.clientVersion.moreOrEqual(Version.V1_8)) {
                this.writePacket(PacketSnapshots.PACKET_HEADER_AND_FOOTER);
            }
            if (this.clientVersion.moreOrEqual(Version.V1_20_3)) {
                this.writePacket(PacketSnapshots.PACKET_START_WAITING_CHUNKS);
                this.writePackets(PacketSnapshots.PACKETS_EMPTY_CHUNKS);
            }
            this.sendKeepAlive();
        };
        if (this.clientVersion.lessOrEqual(Version.V1_7_6)) {
            this.channel.eventLoop().schedule(sendPlayPackets, 100L, TimeUnit.MILLISECONDS);
        } else {
            sendPlayPackets.run();
        }
    }

    public void onLoginAcknowledgedReceived() {
        this.updateState(State.CONFIGURATION);
        if (PacketSnapshots.PACKET_PLUGIN_MESSAGE != null) {
            this.writePacket(PacketSnapshots.PACKET_PLUGIN_MESSAGE);
        }
        if (this.clientVersion.moreOrEqual(Version.V1_20_5)) {
            this.writePacket(PacketSnapshots.PACKET_KNOWN_PACKS);
            if (this.clientVersion.moreOrEqual(Version.V1_21_5)) {
                this.writePackets(PacketSnapshots.PACKETS_REGISTRY_DATA_1_21_5);
            } else if (this.clientVersion.moreOrEqual(Version.V1_21_4)) {
                this.writePackets(PacketSnapshots.PACKETS_REGISTRY_DATA_1_21_4);
            } else if (this.clientVersion.moreOrEqual(Version.V1_21_2)) {
                this.writePackets(PacketSnapshots.PACKETS_REGISTRY_DATA_1_21_2);
            } else if (this.clientVersion.moreOrEqual(Version.V1_21)) {
                this.writePackets(PacketSnapshots.PACKETS_REGISTRY_DATA_1_21);
            } else if (this.clientVersion.moreOrEqual(Version.V1_20_5)) {
                this.writePackets(PacketSnapshots.PACKETS_REGISTRY_DATA_1_20_5);
            }
            if (this.clientVersion.moreOrEqual(Version.V1_21_5)) {
                this.writePacket(PacketSnapshots.PACKET_UPDATE_TAGS_1_21_5);
            } else {
                this.writePacket(PacketSnapshots.PACKET_UPDATE_TAGS_1_20_5);
            }
        } else {
            this.writePacket(PacketSnapshots.PACKET_REGISTRY_DATA);
        }
        this.sendPacket(PacketSnapshots.PACKET_FINISH_CONFIGURATION);
    }

    private void writePackets(List<PacketSnapshot> packets) {
        for (PacketSnapshot packet : packets) {
            this.writePacket(packet);
        }
    }

    public void disconnectLogin(String reason) {
        if (this.isConnected() && this.state == State.LOGIN) {
            PacketDisconnect disconnect = new PacketDisconnect();
            disconnect.setReason(reason);
            this.sendPacketAndClose(disconnect);
        }
    }

    public void writeTitle() {
        if (this.clientVersion.moreOrEqual(Version.V1_17)) {
            this.writePacket(PacketSnapshots.PACKET_TITLE_TITLE);
            this.writePacket(PacketSnapshots.PACKET_TITLE_SUBTITLE);
            this.writePacket(PacketSnapshots.PACKET_TITLE_TIMES);
        } else {
            this.writePacket(PacketSnapshots.PACKET_TITLE_LEGACY_TITLE);
            this.writePacket(PacketSnapshots.PACKET_TITLE_LEGACY_SUBTITLE);
            this.writePacket(PacketSnapshots.PACKET_TITLE_LEGACY_TIMES);
        }
    }

    public void sendKeepAlive() {
        if (this.state.equals((Object)State.PLAY)) {
            PacketKeepAlive keepAlive = new PacketKeepAlive();
            keepAlive.setId(ThreadLocalRandom.current().nextLong());
            this.sendPacket(keepAlive);
        }
    }

    public void sendPacket(Object packet) {
        if (this.isConnected()) {
            this.channel.writeAndFlush(packet, this.channel.voidPromise());
        }
    }

    public void sendPacketAndClose(Object packet) {
        if (this.isConnected()) {
            this.channel.writeAndFlush(packet).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void writePacket(Object packet) {
        if (this.isConnected()) {
            this.channel.write(packet, this.channel.voidPromise());
        }
    }

    public boolean isConnected() {
        return this.channel.isActive();
    }

    public void updateState(State state) {
        this.state = state;
        this.decoder.updateState(state);
        this.encoder.updateState(state);
    }

    public void updateEncoderState(State state) {
        this.encoder.updateState(state);
    }

    public void updateVersion(Version version) {
        this.clientVersion = version;
        this.decoder.updateVersion(version);
        this.encoder.updateVersion(version);
    }

    public void setAddress(String host) {
        this.address = new InetSocketAddress(host, ((InetSocketAddress)this.address).getPort());
    }

    boolean checkBungeeGuardHandshake(String handshake) {
        JsonArray arr;
        String[] split = handshake.split("\u0000");
        if (split.length != 4) {
            return false;
        }
        String socketAddressHostname = split[1];
        UUID uuid = UuidUtil.fromString(split[2]);
        try {
            arr = JsonParser.array().from(split[3]);
        }
        catch (JsonParserException e) {
            return false;
        }
        String token = null;
        for (Object obj : arr) {
            JsonObject prop;
            if (!(obj instanceof JsonObject) || !(prop = (JsonObject)obj).getString("name").equals("bungeeguard-token")) continue;
            token = prop.getString("value");
            break;
        }
        if (!this.server.getConfig().getInfoForwarding().hasToken(token)) {
            return false;
        }
        this.setAddress(socketAddressHostname);
        this.gameProfile.setUuid(uuid);
        Log.debug("Successfully verified BungeeGuard token", new Object[0]);
        return true;
    }

    int getVelocityLoginMessageId() {
        return this.velocityLoginMessageId;
    }

    void setVelocityLoginMessageId(int velocityLoginMessageId) {
        this.velocityLoginMessageId = velocityLoginMessageId;
    }

    boolean checkVelocityKeyIntegrity(ByteMessage buf) {
        byte[] signature = new byte[32];
        buf.readBytes(signature);
        byte[] data = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), data);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.server.getConfig().getInfoForwarding().getSecretKey(), "HmacSHA256"));
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        int version = buf.readVarInt();
        if (version != 1) {
            throw new IllegalStateException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Unsupported forwarding version \u0001, wanted \u0002", "\u0001"}, (int)version)));
        }
        return true;
    }
}

