/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.connection;

import io.netty.buffer.Unpooled;
import java.util.concurrent.ThreadLocalRandom;
import ua.nanit.limbo.connection.ClientConnection;
import ua.nanit.limbo.protocol.packets.PacketHandshake;
import ua.nanit.limbo.protocol.packets.configuration.PacketFinishConfiguration;
import ua.nanit.limbo.protocol.packets.login.PacketLoginAcknowledged;
import ua.nanit.limbo.protocol.packets.login.PacketLoginPluginRequest;
import ua.nanit.limbo.protocol.packets.login.PacketLoginPluginResponse;
import ua.nanit.limbo.protocol.packets.login.PacketLoginStart;
import ua.nanit.limbo.protocol.packets.status.PacketStatusPing;
import ua.nanit.limbo.protocol.packets.status.PacketStatusRequest;
import ua.nanit.limbo.protocol.packets.status.PacketStatusResponse;
import ua.nanit.limbo.server.LimboServer;
import ua.nanit.limbo.server.Log;
import ua.nanit.limbo.util.UuidUtil;

public class PacketHandler {
    private final LimboServer server;

    public PacketHandler(LimboServer server) {
        this.server = server;
    }

    public void handle(ClientConnection conn, PacketHandshake packet) {
        conn.updateVersion(packet.getVersion());
        conn.updateState(packet.getNextState());
        Log.debug("Pinged from %s [%s]", conn.getAddress(), conn.getClientVersion().toString());
        if (this.server.getConfig().getInfoForwarding().isLegacy()) {
            String[] split = packet.getHost().split("\u0000");
            if (split.length == 3 || split.length == 4) {
                conn.setAddress(split[1]);
                conn.getGameProfile().setUuid(UuidUtil.fromString(split[2]));
            } else {
                conn.disconnectLogin("You've enabled player info forwarding. You need to connect with proxy");
            }
        } else if (this.server.getConfig().getInfoForwarding().isBungeeGuard() && !conn.checkBungeeGuardHandshake(packet.getHost())) {
            conn.disconnectLogin("Invalid BungeeGuard token or handshake format");
        }
    }

    public void handle(ClientConnection conn, PacketStatusRequest packet) {
        conn.sendPacket(new PacketStatusResponse(this.server));
    }

    public void handle(ClientConnection conn, PacketStatusPing packet) {
        conn.sendPacketAndClose(packet);
    }

    public void handle(ClientConnection conn, PacketLoginStart packet) {
        if (this.server.getConfig().getMaxPlayers() > 0 && this.server.getConnections().getCount() >= this.server.getConfig().getMaxPlayers()) {
            conn.disconnectLogin("Too many players connected");
            return;
        }
        if (!conn.getClientVersion().isSupported()) {
            conn.disconnectLogin("Unsupported client version");
            return;
        }
        if (this.server.getConfig().getInfoForwarding().isModern()) {
            int loginId = ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
            PacketLoginPluginRequest request = new PacketLoginPluginRequest();
            request.setMessageId(loginId);
            request.setChannel("velocity:player_info");
            request.setData(Unpooled.EMPTY_BUFFER);
            conn.setVelocityLoginMessageId(loginId);
            conn.sendPacket(request);
            return;
        }
        if (!this.server.getConfig().getInfoForwarding().isModern()) {
            conn.getGameProfile().setUsername(packet.getUsername());
            conn.getGameProfile().setUuid(UuidUtil.getOfflineModeUuid(packet.getUsername()));
        }
        conn.fireLoginSuccess();
    }

    public void handle(ClientConnection conn, PacketLoginPluginResponse packet) {
        if (this.server.getConfig().getInfoForwarding().isModern() && packet.getMessageId() == conn.getVelocityLoginMessageId()) {
            if (!packet.isSuccessful() || packet.getData() == null) {
                conn.disconnectLogin("You need to connect with Velocity");
                return;
            }
            if (!conn.checkVelocityKeyIntegrity(packet.getData())) {
                conn.disconnectLogin("Can't verify forwarded player info");
                return;
            }
            conn.setAddress(packet.getData().readString());
            conn.getGameProfile().setUuid(packet.getData().readUuid());
            conn.getGameProfile().setUsername(packet.getData().readString());
            conn.fireLoginSuccess();
        }
    }

    public void handle(ClientConnection conn, PacketLoginAcknowledged packet) {
        conn.onLoginAcknowledgedReceived();
    }

    public void handle(ClientConnection conn, PacketFinishConfiguration packet) {
        conn.spawnPlayer();
    }
}

