/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import ua.nanit.limbo.protocol.PacketSnapshot;
import ua.nanit.limbo.protocol.packets.configuration.PacketFinishConfiguration;
import ua.nanit.limbo.protocol.packets.configuration.PacketKnownPacks;
import ua.nanit.limbo.protocol.packets.configuration.PacketRegistryData;
import ua.nanit.limbo.protocol.packets.configuration.PacketUpdateTags;
import ua.nanit.limbo.protocol.packets.login.PacketLoginSuccess;
import ua.nanit.limbo.protocol.packets.play.PacketBossBar;
import ua.nanit.limbo.protocol.packets.play.PacketChatMessage;
import ua.nanit.limbo.protocol.packets.play.PacketDeclareCommands;
import ua.nanit.limbo.protocol.packets.play.PacketEmptyChunk;
import ua.nanit.limbo.protocol.packets.play.PacketGameEvent;
import ua.nanit.limbo.protocol.packets.play.PacketJoinGame;
import ua.nanit.limbo.protocol.packets.play.PacketPlayerAbilities;
import ua.nanit.limbo.protocol.packets.play.PacketPlayerInfo;
import ua.nanit.limbo.protocol.packets.play.PacketPlayerListHeader;
import ua.nanit.limbo.protocol.packets.play.PacketPlayerPositionAndLook;
import ua.nanit.limbo.protocol.packets.play.PacketPluginMessage;
import ua.nanit.limbo.protocol.packets.play.PacketSpawnPosition;
import ua.nanit.limbo.protocol.packets.play.PacketTitleLegacy;
import ua.nanit.limbo.protocol.packets.play.PacketTitleSetSubTitle;
import ua.nanit.limbo.protocol.packets.play.PacketTitleSetTitle;
import ua.nanit.limbo.protocol.packets.play.PacketTitleTimes;
import ua.nanit.limbo.server.LimboServer;
import ua.nanit.limbo.server.data.Title;
import ua.nanit.limbo.util.NbtMessageUtil;
import ua.nanit.limbo.util.UuidUtil;

public final class PacketSnapshots {
    public static PacketSnapshot PACKET_LOGIN_SUCCESS;
    public static PacketSnapshot PACKET_JOIN_GAME;
    public static PacketSnapshot PACKET_SPAWN_POSITION;
    public static PacketSnapshot PACKET_PLUGIN_MESSAGE;
    public static PacketSnapshot PACKET_PLAYER_ABILITIES;
    public static PacketSnapshot PACKET_PLAYER_INFO;
    public static PacketSnapshot PACKET_DECLARE_COMMANDS;
    public static PacketSnapshot PACKET_JOIN_MESSAGE;
    public static PacketSnapshot PACKET_BOSS_BAR;
    public static PacketSnapshot PACKET_HEADER_AND_FOOTER;
    public static PacketSnapshot PACKET_PLAYER_POS_AND_LOOK_LEGACY;
    public static PacketSnapshot PACKET_PLAYER_POS_AND_LOOK;
    public static PacketSnapshot PACKET_TITLE_TITLE;
    public static PacketSnapshot PACKET_TITLE_SUBTITLE;
    public static PacketSnapshot PACKET_TITLE_TIMES;
    public static PacketSnapshot PACKET_TITLE_LEGACY_TITLE;
    public static PacketSnapshot PACKET_TITLE_LEGACY_SUBTITLE;
    public static PacketSnapshot PACKET_TITLE_LEGACY_TIMES;
    public static PacketSnapshot PACKET_REGISTRY_DATA;
    public static PacketSnapshot PACKET_KNOWN_PACKS;
    public static PacketSnapshot PACKET_UPDATE_TAGS_1_20_5;
    public static PacketSnapshot PACKET_UPDATE_TAGS_1_21_5;
    public static List<PacketSnapshot> PACKETS_REGISTRY_DATA_1_20_5;
    public static List<PacketSnapshot> PACKETS_REGISTRY_DATA_1_21;
    public static List<PacketSnapshot> PACKETS_REGISTRY_DATA_1_21_2;
    public static List<PacketSnapshot> PACKETS_REGISTRY_DATA_1_21_4;
    public static List<PacketSnapshot> PACKETS_REGISTRY_DATA_1_21_5;
    public static PacketSnapshot PACKET_FINISH_CONFIGURATION;
    public static List<PacketSnapshot> PACKETS_EMPTY_CHUNKS;
    public static PacketSnapshot PACKET_START_WAITING_CHUNKS;

    private PacketSnapshots() {
    }

    public static void initPackets(LimboServer server) {
        String username = server.getConfig().getPingData().getVersion();
        UUID uuid = UuidUtil.getOfflineModeUuid(username);
        PacketLoginSuccess loginSuccess = new PacketLoginSuccess();
        loginSuccess.setUsername(username);
        loginSuccess.setUuid(uuid);
        PacketJoinGame joinGame = new PacketJoinGame();
        String worldName = "minecraft:" + server.getConfig().getDimensionType().toLowerCase(Locale.ROOT);
        joinGame.setEntityId(0);
        joinGame.setEnableRespawnScreen(true);
        joinGame.setFlat(false);
        joinGame.setGameMode(server.getConfig().getGameMode());
        joinGame.setHardcore(false);
        joinGame.setMaxPlayers(server.getConfig().getMaxPlayers());
        joinGame.setPreviousGameMode(-1);
        joinGame.setReducedDebugInfo(true);
        joinGame.setDebug(false);
        joinGame.setViewDistance(0);
        joinGame.setWorldName(worldName);
        joinGame.setWorldNames(worldName);
        joinGame.setHashedSeed(0L);
        joinGame.setDimensionRegistry(server.getDimensionRegistry());
        PacketPlayerAbilities playerAbilities = new PacketPlayerAbilities();
        playerAbilities.setFlyingSpeed(0.0f);
        playerAbilities.setFlags(2);
        playerAbilities.setFieldOfView(0.1f);
        int teleportId = ThreadLocalRandom.current().nextInt();
        PacketPlayerPositionAndLook positionAndLookLegacy = new PacketPlayerPositionAndLook(0.0, 64.0, 0.0, 0.0f, 0.0f, teleportId);
        PacketPlayerPositionAndLook positionAndLook = new PacketPlayerPositionAndLook(0.0, 400.0, 0.0, 0.0f, 0.0f, teleportId);
        PacketSpawnPosition packetSpawnPosition = new PacketSpawnPosition(0L, 400L, 0L);
        PacketDeclareCommands declareCommands = new PacketDeclareCommands();
        declareCommands.setCommands(Collections.emptyList());
        PacketPlayerInfo info = new PacketPlayerInfo();
        info.setUsername(server.getConfig().getPlayerListUsername());
        info.setGameMode(server.getConfig().getGameMode());
        info.setUuid(uuid);
        PACKET_LOGIN_SUCCESS = PacketSnapshot.of(loginSuccess);
        PACKET_JOIN_GAME = PacketSnapshot.of(joinGame);
        PACKET_PLAYER_POS_AND_LOOK_LEGACY = PacketSnapshot.of(positionAndLookLegacy);
        PACKET_PLAYER_POS_AND_LOOK = PacketSnapshot.of(positionAndLook);
        PACKET_SPAWN_POSITION = PacketSnapshot.of(packetSpawnPosition);
        PACKET_PLAYER_ABILITIES = PacketSnapshot.of(playerAbilities);
        PACKET_PLAYER_INFO = PacketSnapshot.of(info);
        PACKET_DECLARE_COMMANDS = PacketSnapshot.of(declareCommands);
        if (server.getConfig().isUseHeaderAndFooter()) {
            PacketPlayerListHeader header = new PacketPlayerListHeader();
            header.setHeader(NbtMessageUtil.create(server.getConfig().getPlayerListHeader()));
            header.setFooter(NbtMessageUtil.create(server.getConfig().getPlayerListFooter()));
            PACKET_HEADER_AND_FOOTER = PacketSnapshot.of(header);
        }
        if (server.getConfig().isUseBrandName()) {
            PacketPluginMessage pluginMessage = new PacketPluginMessage();
            pluginMessage.setChannel("minecraft:brand");
            pluginMessage.setMessage(server.getConfig().getBrandName());
            PACKET_PLUGIN_MESSAGE = PacketSnapshot.of(pluginMessage);
        }
        if (server.getConfig().isUseJoinMessage()) {
            PacketChatMessage joinMessage = new PacketChatMessage();
            joinMessage.setMessage(NbtMessageUtil.create(server.getConfig().getJoinMessage()));
            joinMessage.setPosition(PacketChatMessage.PositionLegacy.SYSTEM_MESSAGE);
            joinMessage.setSender(UUID.randomUUID());
            PACKET_JOIN_MESSAGE = PacketSnapshot.of(joinMessage);
        }
        if (server.getConfig().isUseBossBar()) {
            PacketBossBar bossBar = new PacketBossBar();
            bossBar.setBossBar(server.getConfig().getBossBar());
            bossBar.setUuid(UUID.randomUUID());
            PACKET_BOSS_BAR = PacketSnapshot.of(bossBar);
        }
        if (server.getConfig().isUseTitle()) {
            Title title = server.getConfig().getTitle();
            PacketTitleSetTitle packetTitle = new PacketTitleSetTitle();
            PacketTitleSetSubTitle packetSubtitle = new PacketTitleSetSubTitle();
            PacketTitleTimes packetTimes = new PacketTitleTimes();
            PacketTitleLegacy legacyTitle = new PacketTitleLegacy();
            PacketTitleLegacy legacySubtitle = new PacketTitleLegacy();
            PacketTitleLegacy legacyTimes = new PacketTitleLegacy();
            packetTitle.setTitle(title.getTitle());
            packetSubtitle.setSubtitle(title.getSubtitle());
            packetTimes.setFadeIn(title.getFadeIn());
            packetTimes.setStay(title.getStay());
            packetTimes.setFadeOut(title.getFadeOut());
            legacyTitle.setTitle(title);
            legacyTitle.setAction(PacketTitleLegacy.Action.SET_TITLE);
            legacySubtitle.setTitle(title);
            legacySubtitle.setAction(PacketTitleLegacy.Action.SET_SUBTITLE);
            legacyTimes.setTitle(title);
            legacyTimes.setAction(PacketTitleLegacy.Action.SET_TIMES_AND_DISPLAY);
            PACKET_TITLE_TITLE = PacketSnapshot.of(packetTitle);
            PACKET_TITLE_SUBTITLE = PacketSnapshot.of(packetSubtitle);
            PACKET_TITLE_TIMES = PacketSnapshot.of(packetTimes);
            PACKET_TITLE_LEGACY_TITLE = PacketSnapshot.of(legacyTitle);
            PACKET_TITLE_LEGACY_SUBTITLE = PacketSnapshot.of(legacySubtitle);
            PACKET_TITLE_LEGACY_TIMES = PacketSnapshot.of(legacyTimes);
        }
        PacketKnownPacks packetKnownPacks = new PacketKnownPacks();
        PACKET_KNOWN_PACKS = PacketSnapshot.of(packetKnownPacks);
        PACKET_UPDATE_TAGS_1_20_5 = PacketSnapshots.createTagData(server.getDimensionRegistry().getTags_1_20_5());
        PACKET_UPDATE_TAGS_1_21_5 = PacketSnapshots.createTagData(server.getDimensionRegistry().getTags_1_21_5());
        PacketRegistryData packetRegistryData = new PacketRegistryData();
        packetRegistryData.setDimensionRegistry(server.getDimensionRegistry());
        PACKET_REGISTRY_DATA = PacketSnapshot.of(packetRegistryData);
        PACKETS_REGISTRY_DATA_1_20_5 = PacketSnapshots.createRegistryData(server, server.getDimensionRegistry().getCodec_1_20_5());
        PACKETS_REGISTRY_DATA_1_21 = PacketSnapshots.createRegistryData(server, server.getDimensionRegistry().getCodec_1_21());
        PACKETS_REGISTRY_DATA_1_21_2 = PacketSnapshots.createRegistryData(server, server.getDimensionRegistry().getCodec_1_21_2());
        PACKETS_REGISTRY_DATA_1_21_4 = PacketSnapshots.createRegistryData(server, server.getDimensionRegistry().getCodec_1_21_4());
        PACKETS_REGISTRY_DATA_1_21_5 = PacketSnapshots.createRegistryData(server, server.getDimensionRegistry().getCodec_1_21_5());
        PACKET_FINISH_CONFIGURATION = PacketSnapshot.of(new PacketFinishConfiguration());
        PacketGameEvent packetGameEvent = new PacketGameEvent();
        packetGameEvent.setType((byte)13);
        packetGameEvent.setValue(0.0f);
        PACKET_START_WAITING_CHUNKS = PacketSnapshot.of(packetGameEvent);
        int chunkXOffset = 0;
        int chunkZOffset = 0;
        int chunkEdgeSize = 1;
        ArrayList<PacketSnapshot> emptyChunks = new ArrayList<PacketSnapshot>();
        for (int chunkX = chunkXOffset - chunkEdgeSize; chunkX <= chunkXOffset + chunkEdgeSize; ++chunkX) {
            for (int chunkZ = chunkZOffset - chunkEdgeSize; chunkZ <= chunkZOffset + chunkEdgeSize; ++chunkZ) {
                PacketEmptyChunk packetEmptyChunk = new PacketEmptyChunk();
                packetEmptyChunk.setX(chunkX);
                packetEmptyChunk.setZ(chunkZ);
                emptyChunks.add(PacketSnapshot.of(packetEmptyChunk));
            }
        }
        PACKETS_EMPTY_CHUNKS = emptyChunks;
    }

    private static PacketSnapshot createTagData(CompoundBinaryTag tags) {
        PacketUpdateTags packetUpdateTags = new PacketUpdateTags();
        packetUpdateTags.setTags(tags);
        return PacketSnapshot.of(packetUpdateTags);
    }

    private static List<PacketSnapshot> createRegistryData(LimboServer server, CompoundBinaryTag dimensionTag) {
        ArrayList<PacketSnapshot> packetRegistries = new ArrayList<PacketSnapshot>();
        for (String registryType : dimensionTag.keySet()) {
            CompoundBinaryTag compoundRegistryType = dimensionTag.getCompound(registryType);
            PacketRegistryData registryData = new PacketRegistryData();
            registryData.setDimensionRegistry(server.getDimensionRegistry());
            ListBinaryTag values = compoundRegistryType.getList("value");
            registryData.setMetadataWriter((message, version) -> {
                message.writeString(registryType);
                message.writeVarInt(values.size());
                for (BinaryTag entry : values) {
                    CompoundBinaryTag entryTag = (CompoundBinaryTag)entry;
                    String name = entryTag.getString("name");
                    CompoundBinaryTag element = entryTag.getCompound("element", null);
                    message.writeString(name);
                    if (element != null) {
                        message.writeBoolean(true);
                        message.writeNamelessCompoundTag(element);
                        continue;
                    }
                    message.writeBoolean(false);
                }
            });
            packetRegistries.add(PacketSnapshot.of(registryData));
        }
        return packetRegistries;
    }
}

