/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.connection.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import ua.nanit.limbo.protocol.ByteMessage;
import ua.nanit.limbo.protocol.Packet;
import ua.nanit.limbo.protocol.registry.State;
import ua.nanit.limbo.protocol.registry.Version;
import ua.nanit.limbo.server.Log;

public class PacketDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private State.PacketRegistry mappings;
    private Version version;

    public PacketDecoder() {
        this.updateVersion(Version.getMin());
        this.updateState(State.HANDSHAKING);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        if (!ctx.channel().isActive() || this.mappings == null) {
            return;
        }
        ByteMessage msg = new ByteMessage(buf);
        int packetId = msg.readVarInt();
        Packet packet = this.mappings.getPacket(packetId);
        if (packet != null) {
            Log.debug("Received packet %s[0x%s] (%d bytes)", packet.toString(), Integer.toHexString(packetId), msg.readableBytes());
            try {
                packet.decode(msg, this.version);
            }
            catch (Exception e) {
                if (Log.isDebug()) {
                    Log.warning((Object)"Cannot decode packet 0x%s", e, Integer.toHexString(packetId));
                }
                Log.warning((Object)"Cannot decode packet 0x%s: %s", Integer.toHexString(packetId), e.getMessage());
            }
            ctx.fireChannelRead(packet);
        } else {
            Log.debug("Undefined incoming packet: 0x" + Integer.toHexString(packetId), new Object[0]);
        }
    }

    public void updateVersion(Version version) {
        this.version = version;
    }

    public void updateState(State state) {
        this.mappings = state.serverBound.getRegistry(this.version);
    }
}

