/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.connection.pipeline;

import io.netty.util.ByteProcessor;

public class VarIntByteDecoder
implements ByteProcessor {
    private int readVarInt;
    private int bytesRead;
    private DecodeResult result = DecodeResult.TOO_SHORT;

    @Override
    public boolean process(byte k) {
        this.readVarInt |= (k & 0x7F) << this.bytesRead++ * 7;
        if (this.bytesRead > 3) {
            this.result = DecodeResult.TOO_BIG;
            return false;
        }
        if ((k & 0x80) != 128) {
            this.result = DecodeResult.SUCCESS;
            return false;
        }
        return true;
    }

    public int getReadVarInt() {
        return this.readVarInt;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public DecodeResult getResult() {
        return this.result;
    }

    public static enum DecodeResult {
        SUCCESS,
        TOO_SHORT,
        TOO_BIG;

    }
}

