/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.protocol;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import ua.nanit.limbo.protocol.ByteMessage;
import ua.nanit.limbo.protocol.PacketOut;
import ua.nanit.limbo.protocol.registry.Version;

public class PacketSnapshot
implements PacketOut {
    private final PacketOut packet;
    private final Map<Version, byte[]> versionMessages = new EnumMap<Version, byte[]>(Version.class);
    private final Map<Version, Version> mappings = new EnumMap<Version, Version>(Version.class);

    public PacketSnapshot(PacketOut packet) {
        this.packet = packet;
    }

    public PacketOut getWrappedPacket() {
        return this.packet;
    }

    public void encode() {
        HashMap<Integer, Version> hashes = new HashMap<Integer, Version>();
        for (Version version : Version.values()) {
            if (version.equals((Object)Version.UNDEFINED)) continue;
            ByteMessage encodedMessage = ByteMessage.create();
            this.packet.encode(encodedMessage, version);
            int hash = encodedMessage.hashCode();
            Version hashed = (Version)((Object)hashes.get(hash));
            if (hashed != null) {
                this.mappings.put(version, hashed);
            } else {
                hashes.put(hash, version);
                this.mappings.put(version, version);
                this.versionMessages.put(version, encodedMessage.toByteArray());
            }
            encodedMessage.release();
        }
    }

    @Override
    public void encode(ByteMessage msg, Version version) {
        Version mapped = this.mappings.get((Object)version);
        byte[] message = this.versionMessages.get((Object)mapped);
        if (message == null) {
            throw new IllegalArgumentException("No mappings for version " + String.valueOf((Object)version));
        }
        msg.writeBytes(message);
    }

    public String toString() {
        return this.packet.getClass().getSimpleName();
    }

    public static PacketSnapshot of(PacketOut packet) {
        PacketSnapshot snapshot = new PacketSnapshot(packet);
        snapshot.encode();
        return snapshot;
    }
}

