/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.protocol.packets;

import ua.nanit.limbo.connection.ClientConnection;
import ua.nanit.limbo.protocol.ByteMessage;
import ua.nanit.limbo.protocol.PacketIn;
import ua.nanit.limbo.protocol.registry.State;
import ua.nanit.limbo.protocol.registry.Version;
import ua.nanit.limbo.server.LimboServer;

public class PacketHandshake
implements PacketIn {
    private Version version;
    private String host;
    private int port;
    private State nextState;

    public Version getVersion() {
        return this.version;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public State getNextState() {
        return this.nextState;
    }

    @Override
    public void decode(ByteMessage msg, Version version) {
        try {
            this.version = Version.of(msg.readVarInt());
        }
        catch (IllegalArgumentException e) {
            this.version = Version.UNDEFINED;
        }
        this.host = msg.readString();
        this.port = msg.readUnsignedShort();
        this.nextState = State.getById(msg.readVarInt());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void handle(ClientConnection conn, LimboServer server) {
        server.getPacketHandler().handle(conn, this);
    }
}

