/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.protocol.packets.play;

import java.util.EnumSet;
import java.util.UUID;
import ua.nanit.limbo.protocol.ByteMessage;
import ua.nanit.limbo.protocol.PacketOut;
import ua.nanit.limbo.protocol.registry.Version;

public class PacketPlayerInfo
implements PacketOut {
    private int gameMode = 3;
    private String username = "";
    private UUID uuid;

    public void setGameMode(int gameMode) {
        this.gameMode = gameMode;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public void encode(ByteMessage msg, Version version) {
        if (version.less(Version.V1_8)) {
            msg.writeString(this.username);
            msg.writeBoolean(true);
            msg.writeShort(0);
        } else {
            if (version.moreOrEqual(Version.V1_19_3)) {
                EnumSet<Action> actions = EnumSet.noneOf(Action.class);
                actions.add(Action.ADD_PLAYER);
                actions.add(Action.UPDATE_LISTED);
                actions.add(Action.UPDATE_GAMEMODE);
                msg.writeEnumSet(actions, Action.class);
                msg.writeVarInt(1);
                msg.writeUuid(this.uuid);
                msg.writeString(this.username);
                msg.writeVarInt(0);
                msg.writeBoolean(true);
                msg.writeVarInt(this.gameMode);
                return;
            }
            msg.writeVarInt(0);
            msg.writeVarInt(1);
            msg.writeUuid(this.uuid);
            msg.writeString(this.username);
            msg.writeVarInt(0);
            msg.writeVarInt(this.gameMode);
            msg.writeVarInt(60);
            msg.writeBoolean(false);
            if (version.moreOrEqual(Version.V1_19)) {
                msg.writeBoolean(false);
            }
        }
    }

    public static enum Action {
        ADD_PLAYER,
        INITIALIZE_CHAT,
        UPDATE_GAMEMODE,
        UPDATE_LISTED,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME;

    }
}

