/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.protocol.packets.play;

import ua.nanit.limbo.protocol.ByteMessage;
import ua.nanit.limbo.protocol.PacketOut;
import ua.nanit.limbo.protocol.registry.Version;

public class PacketPlayerPositionAndLook
implements PacketOut {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private int teleportId;

    public PacketPlayerPositionAndLook() {
    }

    public PacketPlayerPositionAndLook(double x, double y, double z, float yaw, float pitch, int teleportId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.teleportId = teleportId;
    }

    @Override
    public void encode(ByteMessage msg, Version version) {
        if (version.moreOrEqual(Version.V1_21_2)) {
            this.encodeModern(msg, version);
            return;
        }
        this.encodeLegacy(msg, version);
    }

    private void encodeLegacy(ByteMessage msg, Version version) {
        msg.writeDouble(this.x);
        msg.writeDouble(this.y + (double)(version.less(Version.V1_8) ? 1.62f : 0.0f));
        msg.writeDouble(this.z);
        msg.writeFloat(this.yaw);
        msg.writeFloat(this.pitch);
        if (version.moreOrEqual(Version.V1_8)) {
            msg.writeByte(8);
        } else {
            msg.writeBoolean(true);
        }
        if (version.moreOrEqual(Version.V1_9)) {
            msg.writeVarInt(this.teleportId);
        }
        if (version.fromTo(Version.V1_17, Version.V1_19_3)) {
            msg.writeBoolean(false);
        }
    }

    private void encodeModern(ByteMessage msg, Version version) {
        msg.writeVarInt(this.teleportId);
        msg.writeDouble(this.x);
        msg.writeDouble(this.y);
        msg.writeDouble(this.z);
        msg.writeDouble(0.0);
        msg.writeDouble(0.0);
        msg.writeDouble(0.0);
        msg.writeFloat(this.yaw);
        msg.writeFloat(this.pitch);
        msg.writeInt(8);
    }
}

