/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.protocol.packets.play;

import ua.nanit.limbo.protocol.ByteMessage;
import ua.nanit.limbo.protocol.PacketOut;
import ua.nanit.limbo.protocol.packets.play.PacketTitleSetSubTitle;
import ua.nanit.limbo.protocol.packets.play.PacketTitleSetTitle;
import ua.nanit.limbo.protocol.packets.play.PacketTitleTimes;
import ua.nanit.limbo.protocol.registry.Version;
import ua.nanit.limbo.server.data.Title;

public class PacketTitleLegacy
implements PacketOut {
    private Action action;
    private final PacketTitleSetTitle title = new PacketTitleSetTitle();
    private final PacketTitleSetSubTitle subtitle = new PacketTitleSetSubTitle();
    private final PacketTitleTimes times = new PacketTitleTimes();

    public void setAction(Action action) {
        this.action = action;
    }

    public void setTitle(Title title) {
        this.title.setTitle(title.getTitle());
        this.subtitle.setSubtitle(title.getSubtitle());
        this.times.setFadeIn(title.getFadeIn());
        this.times.setStay(title.getStay());
        this.times.setFadeOut(title.getFadeOut());
    }

    @Override
    public void encode(ByteMessage msg, Version version) {
        msg.writeVarInt(this.action.getId(version));
        switch (this.action.ordinal()) {
            case 0: {
                this.title.encode(msg, version);
                break;
            }
            case 1: {
                this.subtitle.encode(msg, version);
                break;
            }
            case 2: {
                this.times.encode(msg, version);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid title action: " + String.valueOf((Object)this.action));
            }
        }
    }

    public static enum Action {
        SET_TITLE(0),
        SET_SUBTITLE(1),
        SET_TIMES_AND_DISPLAY(3, 2);

        private final int id;
        private final int legacyId;

        private Action(int id, int legacyId) {
            this.id = id;
            this.legacyId = legacyId;
        }

        private Action(int id) {
            this(id, id);
        }

        public int getId(Version version) {
            return version.less(Version.V1_11) ? this.legacyId : this.id;
        }
    }
}

