/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.protocol.packets.status;

import ua.nanit.limbo.protocol.ByteMessage;
import ua.nanit.limbo.protocol.PacketOut;
import ua.nanit.limbo.protocol.registry.Version;
import ua.nanit.limbo.server.LimboServer;

public class PacketStatusResponse
implements PacketOut {
    private static final String TEMPLATE = "{ \"version\": { \"name\": \"%s\", \"protocol\": %d }, \"players\": { \"max\": %d, \"online\": %d, \"sample\": [] }, \"description\": %s }";
    private LimboServer server;

    public PacketStatusResponse() {
    }

    public PacketStatusResponse(LimboServer server) {
        this.server = server;
    }

    @Override
    public void encode(ByteMessage msg, Version version) {
        int staticProtocol = this.server.getConfig().getPingData().getProtocol();
        int protocol = staticProtocol > 0 ? staticProtocol : (this.server.getConfig().getInfoForwarding().isNone() ? version.getProtocolNumber() : Version.getMax().getProtocolNumber());
        String ver = this.server.getConfig().getPingData().getVersion();
        String desc = this.server.getConfig().getPingData().getDescription();
        msg.writeString(this.getResponseJson(ver, protocol, this.server.getConfig().getMaxPlayers(), this.server.getConnections().getCount(), desc));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private String getResponseJson(String version, int protocol, int maxPlayers, int online, String description) {
        return String.format(TEMPLATE, version, protocol, maxPlayers, online, description);
    }
}

