/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.protocol.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import ua.nanit.limbo.protocol.Packet;
import ua.nanit.limbo.protocol.packets.PacketHandshake;
import ua.nanit.limbo.protocol.packets.configuration.PacketFinishConfiguration;
import ua.nanit.limbo.protocol.packets.configuration.PacketKnownPacks;
import ua.nanit.limbo.protocol.packets.configuration.PacketRegistryData;
import ua.nanit.limbo.protocol.packets.configuration.PacketUpdateTags;
import ua.nanit.limbo.protocol.packets.login.PacketDisconnect;
import ua.nanit.limbo.protocol.packets.login.PacketLoginAcknowledged;
import ua.nanit.limbo.protocol.packets.login.PacketLoginPluginRequest;
import ua.nanit.limbo.protocol.packets.login.PacketLoginPluginResponse;
import ua.nanit.limbo.protocol.packets.login.PacketLoginStart;
import ua.nanit.limbo.protocol.packets.login.PacketLoginSuccess;
import ua.nanit.limbo.protocol.packets.play.PacketBossBar;
import ua.nanit.limbo.protocol.packets.play.PacketChatMessage;
import ua.nanit.limbo.protocol.packets.play.PacketDeclareCommands;
import ua.nanit.limbo.protocol.packets.play.PacketEmptyChunk;
import ua.nanit.limbo.protocol.packets.play.PacketGameEvent;
import ua.nanit.limbo.protocol.packets.play.PacketJoinGame;
import ua.nanit.limbo.protocol.packets.play.PacketKeepAlive;
import ua.nanit.limbo.protocol.packets.play.PacketPlayerAbilities;
import ua.nanit.limbo.protocol.packets.play.PacketPlayerInfo;
import ua.nanit.limbo.protocol.packets.play.PacketPlayerListHeader;
import ua.nanit.limbo.protocol.packets.play.PacketPlayerPositionAndLook;
import ua.nanit.limbo.protocol.packets.play.PacketPluginMessage;
import ua.nanit.limbo.protocol.packets.play.PacketSpawnPosition;
import ua.nanit.limbo.protocol.packets.play.PacketTitleLegacy;
import ua.nanit.limbo.protocol.packets.play.PacketTitleSetSubTitle;
import ua.nanit.limbo.protocol.packets.play.PacketTitleSetTitle;
import ua.nanit.limbo.protocol.packets.play.PacketTitleTimes;
import ua.nanit.limbo.protocol.packets.status.PacketStatusPing;
import ua.nanit.limbo.protocol.packets.status.PacketStatusRequest;
import ua.nanit.limbo.protocol.packets.status.PacketStatusResponse;
import ua.nanit.limbo.protocol.registry.Version;

public enum State {
    HANDSHAKING(0){
        {
            this.serverBound.register(PacketHandshake::new, State.map(0, Version.getMin(), Version.getMax()));
        }
    }
    ,
    STATUS(1){
        {
            this.serverBound.register(PacketStatusRequest::new, State.map(0, Version.getMin(), Version.getMax()));
            this.serverBound.register(PacketStatusPing::new, State.map(1, Version.getMin(), Version.getMax()));
            this.clientBound.register(PacketStatusResponse::new, State.map(0, Version.getMin(), Version.getMax()));
            this.clientBound.register(PacketStatusPing::new, State.map(1, Version.getMin(), Version.getMax()));
        }
    }
    ,
    LOGIN(2){
        {
            this.serverBound.register(PacketLoginStart::new, State.map(0, Version.getMin(), Version.getMax()));
            this.serverBound.register(PacketLoginPluginResponse::new, State.map(2, Version.getMin(), Version.getMax()));
            this.serverBound.register(PacketLoginAcknowledged::new, State.map(3, Version.V1_20_2, Version.getMax()));
            this.clientBound.register(PacketDisconnect::new, State.map(0, Version.getMin(), Version.getMax()));
            this.clientBound.register(PacketLoginSuccess::new, State.map(2, Version.getMin(), Version.getMax()));
            this.clientBound.register(PacketLoginPluginRequest::new, State.map(4, Version.getMin(), Version.getMax()));
        }
    }
    ,
    CONFIGURATION(3){
        {
            this.clientBound.register(PacketPluginMessage::new, State.map(0, Version.V1_20_2, Version.V1_20_3), State.map(1, Version.V1_20_5, Version.V1_21_5));
            this.clientBound.register(PacketDisconnect::new, State.map(1, Version.V1_20_2, Version.V1_20_3), State.map(2, Version.V1_20_5, Version.V1_21_5));
            this.clientBound.register(PacketFinishConfiguration::new, State.map(2, Version.V1_20_2, Version.V1_20_3), State.map(3, Version.V1_20_5, Version.V1_21_5));
            this.clientBound.register(PacketKeepAlive::new, State.map(3, Version.V1_20_2, Version.V1_20_3), State.map(4, Version.V1_20_5, Version.V1_21_5));
            this.clientBound.register(PacketKnownPacks::new, State.map(14, Version.V1_20_5, Version.V1_21_5));
            this.clientBound.register(PacketUpdateTags::new, State.map(13, Version.V1_20_5, Version.V1_21_5));
            this.clientBound.register(PacketRegistryData::new, State.map(5, Version.V1_20_2, Version.V1_20_3), State.map(7, Version.V1_20_5, Version.V1_21_5));
            this.serverBound.register(PacketPluginMessage::new, State.map(1, Version.V1_20_2, Version.V1_20_3), State.map(2, Version.V1_20_2, Version.V1_21_5));
            this.serverBound.register(PacketFinishConfiguration::new, State.map(2, Version.V1_20_2, Version.V1_20_3), State.map(3, Version.V1_20_5, Version.V1_21_5));
            this.serverBound.register(PacketKeepAlive::new, State.map(3, Version.V1_20_2, Version.V1_20_3), State.map(4, Version.V1_20_5, Version.V1_21_5));
        }
    }
    ,
    PLAY(4){
        {
            this.serverBound.register(PacketKeepAlive::new, State.map(0, Version.V1_7_2, Version.V1_8), State.map(11, Version.V1_9, Version.V1_11_1), State.map(12, Version.V1_12, Version.V1_12), State.map(11, Version.V1_12_1, Version.V1_12_2), State.map(14, Version.V1_13, Version.V1_13_2), State.map(15, Version.V1_14, Version.V1_15_2), State.map(16, Version.V1_16, Version.V1_16_4), State.map(15, Version.V1_17, Version.V1_18_2), State.map(17, Version.V1_19, Version.V1_19), State.map(18, Version.V1_19_1, Version.V1_19_1), State.map(17, Version.V1_19_3, Version.V1_19_3), State.map(18, Version.V1_19_4, Version.V1_20), State.map(20, Version.V1_20_2, Version.V1_20_2), State.map(21, Version.V1_20_3, Version.V1_20_3), State.map(24, Version.V1_20_5, Version.V1_21), State.map(26, Version.V1_21_2, Version.V1_21_5));
            this.clientBound.register(PacketDeclareCommands::new, State.map(17, Version.V1_13, Version.V1_14_4), State.map(18, Version.V1_15, Version.V1_15_2), State.map(17, Version.V1_16, Version.V1_16_1), State.map(16, Version.V1_16_2, Version.V1_16_4), State.map(18, Version.V1_17, Version.V1_18_2), State.map(15, Version.V1_19, Version.V1_19_1), State.map(14, Version.V1_19_3, Version.V1_19_3), State.map(16, Version.V1_19_4, Version.V1_20), State.map(17, Version.V1_20_2, Version.V1_21_4), State.map(16, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketJoinGame::new, State.map(1, Version.V1_7_2, Version.V1_8), State.map(35, Version.V1_9, Version.V1_12_2), State.map(37, Version.V1_13, Version.V1_14_4), State.map(38, Version.V1_15, Version.V1_15_2), State.map(37, Version.V1_16, Version.V1_16_1), State.map(36, Version.V1_16_2, Version.V1_16_4), State.map(38, Version.V1_17, Version.V1_18_2), State.map(35, Version.V1_19, Version.V1_19), State.map(37, Version.V1_19_1, Version.V1_19_1), State.map(36, Version.V1_19_3, Version.V1_19_3), State.map(40, Version.V1_19_4, Version.V1_20), State.map(41, Version.V1_20_2, Version.V1_20_3), State.map(43, Version.V1_20_5, Version.V1_21), State.map(44, Version.V1_21_2, Version.V1_21_4), State.map(43, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketPluginMessage::new, State.map(25, Version.V1_13, Version.V1_13_2), State.map(24, Version.V1_14, Version.V1_14_4), State.map(25, Version.V1_15, Version.V1_15_2), State.map(24, Version.V1_16, Version.V1_16_1), State.map(23, Version.V1_16_2, Version.V1_16_4), State.map(24, Version.V1_17, Version.V1_18_2), State.map(21, Version.V1_19, Version.V1_19), State.map(22, Version.V1_19_1, Version.V1_19_1), State.map(21, Version.V1_19_3, Version.V1_19_3), State.map(23, Version.V1_19_4, Version.V1_20), State.map(24, Version.V1_20_2, Version.V1_20_3), State.map(25, Version.V1_20_5, Version.V1_21_4), State.map(24, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketPlayerAbilities::new, State.map(57, Version.V1_7_2, Version.V1_8), State.map(43, Version.V1_9, Version.V1_12), State.map(44, Version.V1_12_1, Version.V1_12_2), State.map(46, Version.V1_13, Version.V1_13_2), State.map(49, Version.V1_14, Version.V1_14_4), State.map(50, Version.V1_15, Version.V1_15_2), State.map(49, Version.V1_16, Version.V1_16_1), State.map(48, Version.V1_16_2, Version.V1_16_4), State.map(50, Version.V1_17, Version.V1_18_2), State.map(47, Version.V1_19, Version.V1_19), State.map(49, Version.V1_19_1, Version.V1_19_1), State.map(48, Version.V1_19_3, Version.V1_19_3), State.map(52, Version.V1_19_4, Version.V1_20), State.map(54, Version.V1_20_2, Version.V1_20_3), State.map(56, Version.V1_20_5, Version.V1_21), State.map(58, Version.V1_21_2, Version.V1_21_4), State.map(57, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketPlayerPositionAndLook::new, State.map(8, Version.V1_7_2, Version.V1_8), State.map(46, Version.V1_9, Version.V1_12), State.map(47, Version.V1_12_1, Version.V1_12_2), State.map(50, Version.V1_13, Version.V1_13_2), State.map(53, Version.V1_14, Version.V1_14_4), State.map(54, Version.V1_15, Version.V1_15_2), State.map(53, Version.V1_16, Version.V1_16_1), State.map(52, Version.V1_16_2, Version.V1_16_4), State.map(56, Version.V1_17, Version.V1_18_2), State.map(54, Version.V1_19, Version.V1_19), State.map(57, Version.V1_19_1, Version.V1_19_1), State.map(56, Version.V1_19_3, Version.V1_19_3), State.map(60, Version.V1_19_4, Version.V1_20), State.map(62, Version.V1_20_2, Version.V1_20_3), State.map(64, Version.V1_20_5, Version.V1_21), State.map(66, Version.V1_21_2, Version.V1_21_4), State.map(65, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketKeepAlive::new, State.map(0, Version.V1_7_2, Version.V1_8), State.map(31, Version.V1_9, Version.V1_12_2), State.map(33, Version.V1_13, Version.V1_13_2), State.map(32, Version.V1_14, Version.V1_14_4), State.map(33, Version.V1_15, Version.V1_15_2), State.map(32, Version.V1_16, Version.V1_16_1), State.map(31, Version.V1_16_2, Version.V1_16_4), State.map(33, Version.V1_17, Version.V1_18_2), State.map(30, Version.V1_19, Version.V1_19), State.map(32, Version.V1_19_1, Version.V1_19_1), State.map(31, Version.V1_19_3, Version.V1_19_3), State.map(35, Version.V1_19_4, Version.V1_20), State.map(36, Version.V1_20_2, Version.V1_20_3), State.map(38, Version.V1_20_5, Version.V1_21), State.map(39, Version.V1_21_2, Version.V1_21_4), State.map(38, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketChatMessage::new, State.map(2, Version.V1_7_2, Version.V1_8), State.map(15, Version.V1_9, Version.V1_12_2), State.map(14, Version.V1_13, Version.V1_14_4), State.map(15, Version.V1_15, Version.V1_15_2), State.map(14, Version.V1_16, Version.V1_16_4), State.map(15, Version.V1_17, Version.V1_18_2), State.map(95, Version.V1_19, Version.V1_19), State.map(98, Version.V1_19_1, Version.V1_19_1), State.map(96, Version.V1_19_3, Version.V1_19_3), State.map(100, Version.V1_19_4, Version.V1_20), State.map(103, Version.V1_20_2, Version.V1_20_2), State.map(105, Version.V1_20_3, Version.V1_20_3), State.map(108, Version.V1_20_5, Version.V1_21), State.map(115, Version.V1_21_2, Version.V1_21_4), State.map(114, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketBossBar::new, State.map(12, Version.V1_9, Version.V1_14_4), State.map(13, Version.V1_15, Version.V1_15_2), State.map(12, Version.V1_16, Version.V1_16_4), State.map(13, Version.V1_17, Version.V1_18_2), State.map(10, Version.V1_19, Version.V1_19_3), State.map(11, Version.V1_19_4, Version.V1_20), State.map(10, Version.V1_20_2, Version.V1_21_4), State.map(9, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketPlayerInfo::new, State.map(56, Version.V1_7_2, Version.V1_8), State.map(45, Version.V1_9, Version.V1_12), State.map(46, Version.V1_12_1, Version.V1_12_2), State.map(48, Version.V1_13, Version.V1_13_2), State.map(51, Version.V1_14, Version.V1_14_4), State.map(52, Version.V1_15, Version.V1_15_2), State.map(51, Version.V1_16, Version.V1_16_1), State.map(50, Version.V1_16_2, Version.V1_16_4), State.map(54, Version.V1_17, Version.V1_18_2), State.map(52, Version.V1_19, Version.V1_19), State.map(55, Version.V1_19_1, Version.V1_19_1), State.map(54, Version.V1_19_3, Version.V1_19_3), State.map(58, Version.V1_19_4, Version.V1_20), State.map(60, Version.V1_20_2, Version.V1_20_3), State.map(62, Version.V1_20_5, Version.V1_21), State.map(64, Version.V1_21_2, Version.V1_21_4), State.map(63, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketTitleLegacy::new, State.map(69, Version.V1_8, Version.V1_11_1), State.map(71, Version.V1_12, Version.V1_12), State.map(72, Version.V1_12_1, Version.V1_12_2), State.map(75, Version.V1_13, Version.V1_13_2), State.map(79, Version.V1_14, Version.V1_14_4), State.map(80, Version.V1_15, Version.V1_15_2), State.map(79, Version.V1_16, Version.V1_16_4));
            this.clientBound.register(PacketTitleSetTitle::new, State.map(89, Version.V1_17, Version.V1_17_1), State.map(90, Version.V1_18, Version.V1_19), State.map(93, Version.V1_19_1, Version.V1_19_1), State.map(91, Version.V1_19_3, Version.V1_19_3), State.map(95, Version.V1_19_4, Version.V1_20), State.map(97, Version.V1_20_2, Version.V1_20_2), State.map(99, Version.V1_20_3, Version.V1_20_3), State.map(101, Version.V1_20_5, Version.V1_21), State.map(108, Version.V1_21_2, Version.V1_21_4), State.map(107, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketTitleSetSubTitle::new, State.map(87, Version.V1_17, Version.V1_17_1), State.map(88, Version.V1_18, Version.V1_19), State.map(91, Version.V1_19_1, Version.V1_19_1), State.map(89, Version.V1_19_3, Version.V1_19_3), State.map(93, Version.V1_19_4, Version.V1_20), State.map(95, Version.V1_20_2, Version.V1_20_2), State.map(97, Version.V1_20_3, Version.V1_20_3), State.map(99, Version.V1_20_5, Version.V1_21), State.map(106, Version.V1_21_2, Version.V1_21_4), State.map(105, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketTitleTimes::new, State.map(90, Version.V1_17, Version.V1_17_1), State.map(91, Version.V1_18, Version.V1_19), State.map(94, Version.V1_19_1, Version.V1_19_1), State.map(92, Version.V1_19_3, Version.V1_19_3), State.map(96, Version.V1_19_4, Version.V1_20), State.map(98, Version.V1_20_2, Version.V1_20_2), State.map(100, Version.V1_20_3, Version.V1_20_3), State.map(102, Version.V1_20_5, Version.V1_21), State.map(109, Version.V1_21_2, Version.V1_21_4), State.map(108, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketPlayerListHeader::new, State.map(71, Version.V1_8, Version.V1_8), State.map(72, Version.V1_9, Version.V1_9_2), State.map(71, Version.V1_9_4, Version.V1_11_1), State.map(73, Version.V1_12, Version.V1_12), State.map(74, Version.V1_12_1, Version.V1_12_2), State.map(78, Version.V1_13, Version.V1_13_2), State.map(83, Version.V1_14, Version.V1_14_4), State.map(84, Version.V1_15, Version.V1_15_2), State.map(83, Version.V1_16, Version.V1_16_4), State.map(94, Version.V1_17, Version.V1_17_1), State.map(95, Version.V1_18, Version.V1_18_2), State.map(96, Version.V1_19, Version.V1_19), State.map(99, Version.V1_19_1, Version.V1_19_1), State.map(97, Version.V1_19_3, Version.V1_19_3), State.map(101, Version.V1_19_4, Version.V1_20), State.map(104, Version.V1_20_2, Version.V1_20_2), State.map(106, Version.V1_20_3, Version.V1_20_3), State.map(109, Version.V1_20_5, Version.V1_21), State.map(116, Version.V1_21_2, Version.V1_21_4), State.map(115, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketSpawnPosition::new, State.map(76, Version.V1_19_3, Version.V1_19_3), State.map(80, Version.V1_19_4, Version.V1_20), State.map(82, Version.V1_20_2, Version.V1_20_2), State.map(84, Version.V1_20_3, Version.V1_20_3), State.map(86, Version.V1_20_5, Version.V1_21), State.map(91, Version.V1_21_2, Version.V1_21_4), State.map(90, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketGameEvent::new, State.map(32, Version.V1_20_3, Version.V1_20_3), State.map(34, Version.V1_20_5, Version.V1_21), State.map(35, Version.V1_21_2, Version.V1_21_4), State.map(34, Version.V1_21_5, Version.V1_21_5));
            this.clientBound.register(PacketEmptyChunk::new, State.map(37, Version.V1_20_3, Version.V1_20_3), State.map(39, Version.V1_20_5, Version.V1_21), State.map(40, Version.V1_21_2, Version.V1_21_4), State.map(39, Version.V1_21_5, Version.V1_21_5));
        }
    };

    private static final Map<Integer, State> STATE_BY_ID;
    private final int stateId;
    public final ProtocolMappings serverBound = new ProtocolMappings();
    public final ProtocolMappings clientBound = new ProtocolMappings();

    private State(int stateId) {
        this.stateId = stateId;
    }

    public static State getById(int stateId) {
        return STATE_BY_ID.get(stateId);
    }

    private static Mapping map(int packetId, Version from, Version to) {
        return new Mapping(packetId, from, to);
    }

    static {
        STATE_BY_ID = new HashMap<Integer, State>();
        for (State registry : State.values()) {
            STATE_BY_ID.put(registry.stateId, registry);
        }
    }

    public static class ProtocolMappings {
        private final Map<Version, PacketRegistry> registry = new EnumMap<Version, PacketRegistry>(Version.class);

        public PacketRegistry getRegistry(Version version) {
            return this.registry.getOrDefault((Object)version, this.registry.get((Object)Version.getMin()));
        }

        public void register(Supplier<?> packet, Mapping ... mappings) {
            for (Mapping mapping : mappings) {
                for (Version ver : this.getRange(mapping)) {
                    PacketRegistry reg = this.registry.computeIfAbsent(ver, PacketRegistry::new);
                    reg.register(mapping.packetId, packet);
                }
            }
        }

        private Collection<Version> getRange(Mapping mapping) {
            Version curr = mapping.to;
            Version from = mapping.from;
            if (curr == from) {
                return Collections.singletonList(from);
            }
            LinkedList<Version> versions = new LinkedList<Version>();
            while (curr != from) {
                versions.add(curr);
                curr = curr.getPrev();
            }
            versions.add(from);
            return versions;
        }
    }

    private static class Mapping {
        private final int packetId;
        private final Version from;
        private final Version to;

        public Mapping(int packetId, Version from, Version to) {
            this.from = from;
            this.to = to;
            this.packetId = packetId;
        }
    }

    public static class PacketRegistry {
        private final Version version;
        private final Map<Integer, Supplier<?>> packetsById = new HashMap();
        private final Map<Class<?>, Integer> packetIdByClass = new HashMap();

        public PacketRegistry(Version version) {
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }

        public Packet getPacket(int packetId) {
            Supplier<?> supplier = this.packetsById.get(packetId);
            return supplier == null ? null : (Packet)supplier.get();
        }

        public int getPacketId(Class<?> packetClass) {
            return this.packetIdByClass.getOrDefault(packetClass, -1);
        }

        public void register(int packetId, Supplier<?> supplier) {
            this.packetsById.put(packetId, supplier);
            this.packetIdByClass.put(supplier.get().getClass(), packetId);
        }
    }
}

