/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import ua.nanit.limbo.server.Command;
import ua.nanit.limbo.server.LimboServer;
import ua.nanit.limbo.server.Log;
import ua.nanit.limbo.server.commands.CmdConn;
import ua.nanit.limbo.server.commands.CmdHelp;
import ua.nanit.limbo.server.commands.CmdMem;
import ua.nanit.limbo.server.commands.CmdStop;
import ua.nanit.limbo.server.commands.CmdVersion;

public final class CommandManager
extends Thread {
    private final Map<String, Command> commands = new HashMap<String, Command>();

    public Map<String, Command> getCommands() {
        return Collections.unmodifiableMap(this.commands);
    }

    public Command getCommand(String name) {
        return this.commands.get(name.toLowerCase(Locale.ROOT));
    }

    public void register(Command cmd, String ... aliases) {
        for (String alias : aliases) {
            this.commands.put(alias.toLowerCase(Locale.ROOT), cmd);
        }
    }

    @Override
    public void run() {
        Scanner scanner = new Scanner(System.in);
        while (true) {
            String command;
            try {
                command = scanner.nextLine().trim();
            }
            catch (NoSuchElementException e) {
                break;
            }
            Command handler = this.getCommand(command);
            if (handler != null) {
                try {
                    handler.execute();
                }
                catch (Throwable t) {
                    Log.error((Object)"Cannot execute command:", t, new Object[0]);
                }
                continue;
            }
            Log.info("Unknown command. Type \"help\" to get commands list", new Object[0]);
        }
    }

    public void registerAll(LimboServer server) {
        this.register(new CmdHelp(server), "help");
        this.register(new CmdConn(server), "conn");
        this.register(new CmdMem(), "mem");
        this.register(new CmdStop(), "stop");
        this.register(new CmdVersion(), "version", "ver");
    }
}

