/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.server;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ua.nanit.limbo.connection.ClientConnection;
import ua.nanit.limbo.server.Log;

public final class Connections {
    private final Map<UUID, ClientConnection> connections = new ConcurrentHashMap<UUID, ClientConnection>();

    public Collection<ClientConnection> getAllConnections() {
        return Collections.unmodifiableCollection(this.connections.values());
    }

    public int getCount() {
        return this.connections.size();
    }

    public void addConnection(ClientConnection connection) {
        this.connections.put(connection.getUuid(), connection);
        Log.info("Player %s connected (%s) [%s]", new Object[]{connection.getUsername(), connection.getAddress(), connection.getClientVersion()});
    }

    public void removeConnection(ClientConnection connection) {
        this.connections.remove(connection.getUuid());
        Log.info("Player %s disconnected", connection.getUsername());
    }
}

