/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import ua.nanit.limbo.configuration.LimboConfig;
import ua.nanit.limbo.connection.ClientChannelInitializer;
import ua.nanit.limbo.connection.ClientConnection;
import ua.nanit.limbo.connection.PacketHandler;
import ua.nanit.limbo.connection.PacketSnapshots;
import ua.nanit.limbo.server.CommandManager;
import ua.nanit.limbo.server.Connections;
import ua.nanit.limbo.server.Log;
import ua.nanit.limbo.world.DimensionRegistry;

public final class LimboServer {
    private LimboConfig config;
    private PacketHandler packetHandler;
    private Connections connections;
    private DimensionRegistry dimensionRegistry;
    private ScheduledFuture<?> keepAliveTask;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private CommandManager commandManager;

    public LimboConfig getConfig() {
        return this.config;
    }

    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public Connections getConnections() {
        return this.connections;
    }

    public DimensionRegistry getDimensionRegistry() {
        return this.dimensionRegistry;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public void start() throws Exception {
        this.config = new LimboConfig(Paths.get("./", new String[0]));
        this.config.load();
        Log.setLevel(this.config.getDebugLevel());
        Log.info("Starting server...", new Object[0]);
        ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        this.packetHandler = new PacketHandler(this);
        this.dimensionRegistry = new DimensionRegistry(this);
        this.dimensionRegistry.load("minecraft:" + this.config.getDimensionType().toLowerCase(Locale.ROOT));
        this.connections = new Connections();
        PacketSnapshots.initPackets(this);
        this.startBootstrap();
        this.keepAliveTask = this.workerGroup.scheduleAtFixedRate(this::broadcastKeepAlive, 0L, 5L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop, "NanoLimbo shutdown thread"));
        Log.info("Server started on %s", this.config.getAddress());
        this.commandManager = new CommandManager();
        this.commandManager.registerAll(this);
        this.commandManager.start();
        System.gc();
    }

    private void startBootstrap() {
        Class channelClass;
        if (this.config.isUseEpoll() && Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup(this.config.getBossGroupSize());
            this.workerGroup = new EpollEventLoopGroup(this.config.getWorkerGroupSize());
            channelClass = EpollServerSocketChannel.class;
            Log.debug("Using Epoll transport type", new Object[0]);
        } else {
            this.bossGroup = new NioEventLoopGroup(this.config.getBossGroupSize());
            this.workerGroup = new NioEventLoopGroup(this.config.getWorkerGroupSize());
            channelClass = NioServerSocketChannel.class;
            Log.debug("Using Java NIO transport type", new Object[0]);
        }
        ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(channelClass)).childHandler(new ClientChannelInitializer(this)).childOption(ChannelOption.TCP_NODELAY, true).localAddress(this.config.getAddress())).bind();
    }

    private void broadcastKeepAlive() {
        this.connections.getAllConnections().forEach(ClientConnection::sendKeepAlive);
    }

    private void stop() {
        Log.info("Stopping server...", new Object[0]);
        if (this.keepAliveTask != null) {
            this.keepAliveTask.cancel(true);
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        Log.info("Server stopped, Goodbye!", new Object[0]);
    }
}

