/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.server;

import ch.qos.logback.classic.Logger;
import org.slf4j.LoggerFactory;

public final class Log {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger("Limbo");
    private static int debugLevel = Level.INFO.getIndex();

    private Log() {
    }

    public static void info(Object msg, Object ... args) {
        LOGGER.info(String.format(msg.toString(), args));
    }

    public static void debug(Object msg, Object ... args) {
        LOGGER.debug(String.format(msg.toString(), args));
    }

    public static void warning(Object msg, Object ... args) {
        LOGGER.warn(String.format(msg.toString(), args));
    }

    public static void warning(Object msg, Throwable t, Object ... args) {
        LOGGER.warn(String.format(msg.toString(), args), t);
    }

    public static void error(Object msg, Object ... args) {
        LOGGER.error(msg.toString(), args);
    }

    public static void error(Object msg, Throwable t, Object ... args) {
        LOGGER.error(String.format(msg.toString(), args), t);
    }

    public static boolean isDebug() {
        return debugLevel >= Level.DEBUG.getIndex();
    }

    static void setLevel(int level) {
        debugLevel = level;
        Logger logback = Log.getRootLogger();
        if (logback != null) {
            logback.setLevel(Log.convertLevel(level));
        }
    }

    private static Logger getRootLogger() {
        return (Logger)LoggerFactory.getLogger("ROOT");
    }

    private static ch.qos.logback.classic.Level convertLevel(int level) {
        switch (level) {
            case 0: {
                return ch.qos.logback.classic.Level.ERROR;
            }
            case 1: {
                return ch.qos.logback.classic.Level.WARN;
            }
            case 2: {
                return ch.qos.logback.classic.Level.INFO;
            }
            case 3: {
                return ch.qos.logback.classic.Level.DEBUG;
            }
        }
        throw new IllegalStateException("Undefined log level: " + level);
    }

    public static enum Level {
        ERROR("ERROR", 0),
        WARNING("WARNING", 1),
        INFO("INFO", 2),
        DEBUG("DEBUG", 3);

        private final String display;
        private final int index;

        private Level(String display, int index) {
            this.display = display;
            this.index = index;
        }

        public String getDisplay() {
            return this.display;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

