/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.server.data;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class InfoForwarding {
    private Type type;
    private byte[] secretKey;
    private List<String> tokens;

    public Type getType() {
        return this.type;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public boolean hasToken(String token) {
        return this.tokens != null && token != null && this.tokens.contains(token);
    }

    public boolean isNone() {
        return this.type == Type.NONE;
    }

    public boolean isLegacy() {
        return this.type == Type.LEGACY;
    }

    public boolean isModern() {
        return this.type == Type.MODERN;
    }

    public boolean isBungeeGuard() {
        return this.type == Type.BUNGEE_GUARD;
    }

    public static enum Type {
        NONE,
        LEGACY,
        MODERN,
        BUNGEE_GUARD;

    }

    public static class Serializer
    implements TypeSerializer<InfoForwarding> {
        @Override
        public InfoForwarding deserialize(java.lang.reflect.Type type, ConfigurationNode node) throws SerializationException {
            InfoForwarding forwarding = new InfoForwarding();
            try {
                forwarding.type = Type.valueOf(node.node("type").getString("").toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SerializationException("Undefined info forwarding type");
            }
            if (forwarding.type == Type.MODERN) {
                forwarding.secretKey = node.node("secret").getString("").getBytes(StandardCharsets.UTF_8);
            }
            if (forwarding.type == Type.BUNGEE_GUARD) {
                forwarding.tokens = node.node("tokens").getList(String.class);
            }
            return forwarding;
        }

        @Override
        public void serialize(java.lang.reflect.Type type, @Nullable InfoForwarding obj, ConfigurationNode node) throws SerializationException {
        }
    }
}

