/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.server.data;

import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.TypeSerializer;
import ua.nanit.limbo.protocol.NbtMessage;
import ua.nanit.limbo.util.Colors;
import ua.nanit.limbo.util.NbtMessageUtil;

public class Title {
    private NbtMessage title;
    private NbtMessage subtitle;
    private int fadeIn;
    private int stay;
    private int fadeOut;

    public NbtMessage getTitle() {
        return this.title;
    }

    public NbtMessage getSubtitle() {
        return this.subtitle;
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getStay() {
        return this.stay;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public void setTitle(NbtMessage title) {
        this.title = title;
    }

    public void setSubtitle(NbtMessage subtitle) {
        this.subtitle = subtitle;
    }

    public void setFadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
    }

    public void setStay(int stay) {
        this.stay = stay;
    }

    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    public static class Serializer
    implements TypeSerializer<Title> {
        @Override
        public Title deserialize(Type type, ConfigurationNode node) {
            Title title = new Title();
            title.setTitle(NbtMessageUtil.create(Colors.of(node.node("title").getString(""))));
            title.setSubtitle(NbtMessageUtil.create(Colors.of(node.node("subtitle").getString(""))));
            title.setFadeIn(node.node("fadeIn").getInt(10));
            title.setStay(node.node("stay").getInt(100));
            title.setFadeOut(node.node("fadeOut").getInt(10));
            return title;
        }

        @Override
        public void serialize(Type type, @Nullable Title obj, ConfigurationNode node) {
        }
    }
}

